// Viewer3dDoc.cpp : implementation of the CViewer3dDoc class
//

#include "stdafx.h"
#include "Viewer3dApp.h"

#include "Viewer3dDoc.h"
#include "Viewer3dView.h"
#include "OffsetDlg.h"
#include "ResultDialog.h"
#include "User_Cylinder.hxx"

#include "AIS_Trihedron.hxx"
#include "Geom_Axis2Placement.hxx"
/////////////////////////////////////////////////////////////////////////////
// CViewer3dDoc

IMPLEMENT_DYNCREATE(CViewer3dDoc, CDocument)

BEGIN_MESSAGE_MAP(CViewer3dDoc, OCC_3dBaseDoc)
	//{{AFX_MSG_MAP(CViewer3dDoc)
	ON_COMMAND(ID_BOX, OnBox)
	ON_COMMAND(ID_Cylinder, OnCylinder)
	ON_COMMAND(ID_SPHERE, OnSphere)
	ON_COMMAND(ID_ERASEALL, OnRemoveAll)
	ON_COMMAND(ID_OVERLAPPED_BOX, OnOverlappedBox)
	ON_COMMAND(ID_OVERLAPPED_CYLINDER, OnOverlappedCylinder)
	ON_COMMAND(ID_OVERLAPPED_SPHERE, OnOverlappedSphere)
	ON_COMMAND(ID_POLYGON_OFFSETS, OnPolygonOffsets)
	ON_UPDATE_COMMAND_UI(ID_POLYGON_OFFSETS, OnUpdatePolygonOffsets)
	ON_UPDATE_COMMAND_UI(ID_Cylinder, OnUpdateCylinder)
	ON_UPDATE_COMMAND_UI(ID_SPHERE, OnUpdateSphere)
	ON_UPDATE_COMMAND_UI(ID_BOX, OnUpdateBox)
	ON_UPDATE_COMMAND_UI(ID_OVERLAPPED_CYLINDER, OnUpdateOverlappedCylinder)
	ON_UPDATE_COMMAND_UI(ID_OVERLAPPED_SPHERE, OnUpdateOverlappedSphere)
	ON_UPDATE_COMMAND_UI(ID_OVERLAPPED_BOX, OnUpdateOverlappedBox)
	ON_COMMAND(ID_OBJECT_REMOVE, OnObjectRemove)
	ON_COMMAND(ID_OBJECT_ERASE, OnObjectErase)
	ON_COMMAND(ID_OBJECT_DISPLAYALL, OnObjectDisplayall)
	ON_COMMAND(ID_OBJECT_COLORED_MESH, OnObjectColoredMesh)
	ON_UPDATE_COMMAND_UI(ID_OBJECT_COLORED_MESH, OnUpdateObjectColoredMesh)
	ON_UPDATE_COMMAND_UI(ID_OBJECT_SHADING, OnUpdateObjectShading)
	ON_UPDATE_COMMAND_UI(ID_OBJECT_WIREFRAME, OnUpdateObjectWireframe)
	ON_COMMAND(ID_OPTIONS_TRIHEDRON_DYNAMIC_TRIHEDRON, OnOptionsTrihedronDynamicTrihedron)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_TRIHEDRON_DYNAMIC_TRIHEDRON, OnUpdateOptionsTrihedronDynamicTrihedron)
	ON_UPDATE_COMMAND_UI(ID_OPTIONS_TRIHEDRON_STATIC_TRIHEDRON, OnUpdateOptionsTrihedronStaticTrihedron)
	ON_COMMAND(ID_OBJECT_MATERIAL, OnObjectMaterial)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CViewer3dDoc construction/destruction

CViewer3dDoc::CViewer3dDoc()
{
	myCylinder.Nullify();
	mySphere.Nullify();
	myBox.Nullify();
	myOverlappedCylinder.Nullify();
	myOverlappedSphere.Nullify();
	myOverlappedBox.Nullify();
	myOffsetDlg = NULL;
	myStaticTrihedronAxisIsDisplayed = FALSE;
	
	/*
	Handle(AIS_Trihedron) myTrihedron;
	Handle(Geom_Axis2Placement) myTrihedronAxis=new Geom_Axis2Placement(gp::XOY());
	myTrihedron=new AIS_Trihedron(myTrihedronAxis);
	myAISContext->Display(myTrihedron);
	*/
}

CViewer3dDoc::~CViewer3dDoc()
{
}

/////////////////////////////////////////////////////////////////////////////
// CViewer3dDoc diagnostics

#ifdef _DEBUG
void CViewer3dDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CViewer3dDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CViewer3dDoc commands

void CViewer3dDoc::UpdateResultMessageDlg(CString Title, TCollection_AsciiString aMessage)
{
    CString text(aMessage.ToCString());
    myCResultDialog.SetText(text);

    myCResultDialog.SetTitle(Title);
}

void CViewer3dDoc::OnBox() 
{
	if(myBox.IsNull()){
		BRepPrimAPI_MakeBox B(gp_Pnt(0,-400,-100), 200.,150.,100.);


		myBox = new AIS_Shape(B.Shape());

		myAISContext->SetMaterial(myBox,Graphic3d_NOM_PEWTER);    
		myAISContext->SetDisplayMode(myBox,1);

		myAISContext->Display(myBox);	
		TCollection_AsciiString Message("\
BRepPrimAPI_MakeBox Box1(gp_Pnt(0,-400,-100), 200.,150.,100.);\n\
		");
		
		UpdateResultMessageDlg("Create Box",Message);

	}
}

void CViewer3dDoc::OnCylinder() 
{
	if(myCylinder.IsNull()) {
		gp_Ax2 CylAx2(gp_Pnt(0,0,-100), gp_Dir(gp_Vec(gp_Pnt(0,0,-100),gp_Pnt(0,0,100))));

		//BRepPrimAPI_MakeCylinder C(CylAx2, 80.,200.);
		
		myCylinder = new User_Cylinder(CylAx2, 80.,200.);
		
//		myCylinder = new AIS_Shape(C.Shape());
/*
		myCylinder->SetTransparency(0.5);		

		myAISContext->SetColor(myCylinder,Quantity_NOC_WHITE); 
		myAISContext->SetMaterial(myCylinder,Graphic3d_NOM_SHINY_PLASTIC);    
*/
		myAISContext->SetDisplayMode(myCylinder,1);

		myAISContext->Display(myCylinder);

		TCollection_AsciiString Message("\
gp_Ax2 CylAx2(gp_Pnt(0,0,-100), gp_Dir(gp_Vec(gp_Pnt(0,0,-100),gp_Pnt(0,0,100))));\n\
C = new User_Cylinder(CylAx2, 80.,200.);;\n\
		");
		
		UpdateResultMessageDlg("Create Cylinder",Message);

	}
}

void CViewer3dDoc::OnSphere() 
{
	if(mySphere.IsNull()){
		BRepPrimAPI_MakeSphere S(gp_Pnt(0,300,0), 100.);

		mySphere = new AIS_Shape(S.Shape());
		
		myAISContext->SetMaterial(mySphere,Graphic3d_NOM_BRONZE);    
		myAISContext->SetDisplayMode(mySphere,1);

		myAISContext->Display(mySphere);
		TCollection_AsciiString Message("\
BRepPrimAPI_MakeSphere S(gp_Pnt(0,300,0), 100.);\n\
		");
		UpdateResultMessageDlg("Create Sphere",Message);
	}
}

void CViewer3dDoc::OnRemoveAll() 

{
	AIS_ListOfInteractive aListOfObjects;
	myAISContext->ObjectsInside(aListOfObjects,AIS_KOI_Shape);

	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aListOfObjects);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	myAISContext->Remove(myCylinder);


	myCylinder.Nullify();
	mySphere.Nullify();
	myBox.Nullify();
	myOverlappedCylinder.Nullify();
	myOverlappedSphere.Nullify();
	myOverlappedBox.Nullify();
	if(myOffsetDlg && myOffsetDlg->IsWindowVisible())
		myOffsetDlg->UpdateValues();
}

void CViewer3dDoc::OnOverlappedBox() 
{
	OnBox();
	if(myOverlappedBox.IsNull()){
		BRepPrimAPI_MakeBox B(gp_Pnt(0,-400,-100), 200.,150.,100.);

		BRepBuilderAPI_NurbsConvert aNurbsConvert(B.Shape());
		TopoDS_Shape aBoxShape2 = aNurbsConvert.Shape();


		myOverlappedBox = new AIS_Shape(aBoxShape2);

		myAISContext->SetMaterial(myOverlappedBox,Graphic3d_NOM_GOLD);    
		myAISContext->SetDisplayMode(myOverlappedBox,1);

		myAISContext->Display(myOverlappedBox);	
		TCollection_AsciiString Message("\
BRepPrimAPI_MakeBox Box1(gp_Pnt(0,-400,-100), 200.,150.,100.);\n\
\n\
BRepPrimAPI_MakeBox Box2(gp_Pnt(0,-400,-100), 200.,150.,100.);\n\
BRepBuilderAPI_NurbsConvert aNurbsConvert(Box2.Shape());\n\
		");
		UpdateResultMessageDlg("Create overlapped boxes",Message);
		if(myOffsetDlg && myOffsetDlg->IsWindowVisible())
			myOffsetDlg->UpdateValues();


	}
}

void CViewer3dDoc::OnOverlappedCylinder() 
{
	OnCylinder();

	if(myOverlappedCylinder.IsNull()){
		gp_Ax2 CylAx2(gp_Pnt(0,0,-100), gp_Dir(gp_Vec(gp_Pnt(0,0,-100),gp_Pnt(0,0,100))));
		BRepPrimAPI_MakeCylinder C(CylAx2, 80.,200.);

		BRepBuilderAPI_NurbsConvert aNurbsConvert(C.Shape());
		TopoDS_Shape aCylShape2 = aNurbsConvert.Shape();

		myOverlappedCylinder = new AIS_Shape(aCylShape2);

	
		myAISContext->SetMaterial(myOverlappedCylinder,Graphic3d_NOM_GOLD);    
		myAISContext->SetDisplayMode(myOverlappedCylinder,1);

		myAISContext->Display(myOverlappedCylinder);

		TCollection_AsciiString Message("\
gp_Ax2 CylAx2(gp_Pnt(0,0,-100), gp_Dir(gp_Vec(gp_Pnt(0,0,-100),gp_Pnt(0,0,100))));\n\
Cylinder1 = new User_Cylinder(CylAx2, 80.,200.);\n\
\n\
BRepPrimAPI_MakeCylinder Cylinder2(CylAx2, 80.,200.);\n\
BRepBuilderAPI_NurbsConvert aNurbsConvert(Cylinder2.Shape());\n\
		");
		UpdateResultMessageDlg("Create overlapped cylinders",Message);
		if(myOffsetDlg && myOffsetDlg->IsWindowVisible())
			myOffsetDlg->UpdateValues();

	}
}

void CViewer3dDoc::OnOverlappedSphere() 
{
	OnSphere();
	if(myOverlappedSphere.IsNull()){
		BRepPrimAPI_MakeSphere S(gp_Pnt(0,300,0), 100.);

		BRepBuilderAPI_NurbsConvert aNurbsConvert(S.Shape());
		TopoDS_Shape aSphereShape2 = aNurbsConvert.Shape();

		myOverlappedSphere = new AIS_Shape(aSphereShape2);

		myAISContext->SetMaterial(myOverlappedSphere,Graphic3d_NOM_GOLD);    

		myAISContext->SetDisplayMode(myOverlappedSphere,1);

		myAISContext->Display(myOverlappedSphere);

		TCollection_AsciiString Message("\
BRepPrimAPI_MakeSphere Sphere1(gp_Pnt(0,300,0), 100.);\n\
\n\
BRepPrimAPI_MakeSphere Sphere2(gp_Pnt(0,300,0), 100.);\n\
BRepBuilderAPI_NurbsConvert aNurbsConvert(Sphere2.Shape());\n\
		");
		UpdateResultMessageDlg("Create overlapped spheres",Message);
		if(myOffsetDlg && myOffsetDlg->IsWindowVisible())
			myOffsetDlg->UpdateValues();

	}
}

void CViewer3dDoc::OnPolygonOffsets() 
{

	myOffsetDlg = new COffsetDlg(this);
	myOffsetDlg->Create(COffsetDlg::IDD,NULL);
	myAISContext->UpdateCurrentViewer();

}

void CViewer3dDoc::OnUpdatePolygonOffsets(CCmdUI* pCmdUI) 
{
	Standard_Integer aOffsetMode;
	Standard_Real aFactor;
	Standard_Real aCylUnits = 0;
	Standard_Real aSphereUnits = 0;
	Standard_Real aBoxUnits = 0;

	BOOL IsOverlappedCylinderDisplayed = myAISContext->IsDisplayed(myOverlappedCylinder);
	BOOL IsOverlappedSphereDisplayed = myAISContext->IsDisplayed(myOverlappedSphere);
	BOOL IsOverlappedBoxDisplayed = myAISContext->IsDisplayed(myOverlappedBox);
	BOOL IsAnyOverlappedObjectDisplayed = 
		IsOverlappedCylinderDisplayed || IsOverlappedSphereDisplayed || IsOverlappedBoxDisplayed;
	
	if(!myOverlappedCylinder.IsNull() && IsOverlappedCylinderDisplayed){
		myOverlappedCylinder->PolygonOffsets(aOffsetMode,aFactor,aCylUnits);
	}
	
	if(!myOverlappedSphere.IsNull() && IsOverlappedSphereDisplayed){
		myOverlappedSphere->PolygonOffsets(aOffsetMode,aFactor,aSphereUnits);
	}

	if(!myOverlappedBox.IsNull() && IsOverlappedBoxDisplayed){
		myOverlappedBox->PolygonOffsets(aOffsetMode,aFactor,aBoxUnits);
	}

	if(myOffsetDlg && myOffsetDlg->IsWindowVisible())
		pCmdUI->SetCheck(TRUE);
	else
		pCmdUI->SetCheck(FALSE);
	if (IsAnyOverlappedObjectDisplayed)
		if(myOffsetDlg)
			pCmdUI->Enable(!myOffsetDlg->IsWindowVisible());  
		else
			pCmdUI->Enable(TRUE);
	else 
			pCmdUI->Enable(FALSE);
	
	
}

void CViewer3dDoc::OnUpdateCylinder(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(myCylinder.IsNull()); 
		
}

void CViewer3dDoc::OnUpdateSphere(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(mySphere.IsNull()); 
		
}

void CViewer3dDoc::OnUpdateBox(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(myBox.IsNull()); 
		
}

void CViewer3dDoc::OnUpdateOverlappedCylinder(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable   (myOverlappedCylinder.IsNull()
						|| myCylinder.IsNull());
		
}

void CViewer3dDoc::OnUpdateOverlappedSphere(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable   (myOverlappedSphere.IsNull()
						|| mySphere.IsNull());
}

void CViewer3dDoc::OnUpdateOverlappedBox(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable   (myOverlappedBox.IsNull()
						|| myBox.IsNull());
}

void CViewer3dDoc::OnObjectRemove() 

{

	if(myAISContext->IsCurrent(myBox))
		myBox.Nullify();

	if(myAISContext->IsCurrent(myCylinder))
		myCylinder.Nullify();

	if(myAISContext->IsCurrent(mySphere))
		mySphere.Nullify();

	if(myAISContext->IsCurrent(myOverlappedBox))
		myOverlappedBox.Nullify();

	if(myAISContext->IsCurrent(myOverlappedCylinder))
		myOverlappedCylinder.Nullify();

	if(myAISContext->IsCurrent(myOverlappedSphere))
		myOverlappedSphere.Nullify();

	
	for(myAISContext->InitCurrent();myAISContext->MoreCurrent();myAISContext->InitCurrent())
		myAISContext->Remove(myAISContext->Current(),Standard_True);

	if(myOffsetDlg && myOffsetDlg->IsWindowVisible())
		myOffsetDlg->UpdateValues();

}

void CViewer3dDoc::OnObjectErase() 

{
	OCC_3dBaseDoc::OnObjectErase(); 
	if(myOffsetDlg && myOffsetDlg->IsWindowVisible())
		myOffsetDlg->UpdateValues();

}

void CViewer3dDoc::OnObjectDisplayall() 

{
	OCC_3dBaseDoc::OnObjectDisplayall(); 
	if(myOffsetDlg && myOffsetDlg->IsWindowVisible())
		myOffsetDlg->UpdateValues();

}

Handle_User_Cylinder CViewer3dDoc::GetCylinder()
{
	return myCylinder;
}


Handle_AIS_Shape CViewer3dDoc::GetSphere()
{
	return mySphere;
}

Handle_AIS_Shape CViewer3dDoc::GetBox()
{
	return myBox;
}

Handle_AIS_Shape CViewer3dDoc::GetOverlappedCylinder()
{
	return myOverlappedCylinder;
}


Handle_AIS_Shape CViewer3dDoc::GetOverlappedSphere()
{
	return myOverlappedSphere;
}

Handle_AIS_Shape CViewer3dDoc::GetOverlappedBox()
{
	return myOverlappedBox;
}

void CViewer3dDoc::DragEvent(const Standard_Integer  x        ,
				                  const Standard_Integer  y        ,
				                  const Standard_Integer  TheState ,
                                  const Handle(V3d_View)& aView    )
{
	OCC_3dBaseDoc::DragEvent(x,y, TheState,aView);
	if(myOffsetDlg && myOffsetDlg->IsWindowVisible())
		myOffsetDlg->UpdateValues();
}

//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------
void CViewer3dDoc::InputEvent(const Standard_Integer  x     ,
				                   const Standard_Integer  y     ,
                                   const Handle(V3d_View)& aView ) 
{
	OCC_3dBaseDoc::InputEvent(x,y,aView ) ;
	if(myOffsetDlg && myOffsetDlg->IsWindowVisible())
		myOffsetDlg->UpdateValues();
}


//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------
void CViewer3dDoc::ShiftDragEvent(const Standard_Integer  x        ,
									   const Standard_Integer  y        ,
									   const Standard_Integer  TheState ,
                                       const Handle(V3d_View)& aView    ) 
{
    OCC_3dBaseDoc::ShiftDragEvent(x,y,TheState,aView);
	if(myOffsetDlg && myOffsetDlg->IsWindowVisible())
		myOffsetDlg->UpdateValues();
}


//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------

void CViewer3dDoc::ShiftInputEvent(const Standard_Integer  x       ,
									    const Standard_Integer  y       ,
                                        const Handle(V3d_View)& aView   ) 
{
    OCC_3dBaseDoc::ShiftInputEvent(x,y,aView);
	if(myOffsetDlg && myOffsetDlg->IsWindowVisible())
		myOffsetDlg->UpdateValues();

}

void CViewer3dDoc::OnObjectColoredMesh() 
{
  for(myAISContext->InitCurrent();myAISContext->MoreCurrent();myAISContext->NextCurrent())
	  if (myAISContext->Current()->IsKind(STANDARD_TYPE(User_Cylinder))){
		myAISContext->ClearPrs(myAISContext->Current(),6,Standard_False);
			myAISContext->RecomputePrsOnly(myAISContext->Current(),Standard_False);
			myAISContext->SetDisplayMode(myAISContext->Current(),6);
	  }
	
}

void CViewer3dDoc::OnUpdateObjectColoredMesh(CCmdUI* pCmdUI) 
{
  bool CylinderIsCurrentAndDisplayed = false;
  for (myAISContext->InitCurrent();myAISContext->MoreCurrent ();myAISContext->NextCurrent ())
    //if ((myAISContext->IsDisplayed(myAISContext->Current(),1) || myAISContext->IsDisplayed(myAISContext->Current(),0))
	//	&& myAISContext->Current()->IsKind(STANDARD_TYPE(User_Cylinder))) 
	if(myAISContext->Current()->IsKind(STANDARD_TYPE(User_Cylinder)))
		CylinderIsCurrentAndDisplayed=true;
  pCmdUI->Enable (CylinderIsCurrentAndDisplayed);	
	
}

void CViewer3dDoc::OnUpdateObjectWireframe(CCmdUI* pCmdUI) 
{
  bool OneOrMoreInShadingOrColoredMesh = false;
  for (myAISContext->InitCurrent();myAISContext->MoreCurrent ();myAISContext->NextCurrent ())
    if (myAISContext->IsDisplayed(myAISContext->Current(),1) || myAISContext->IsDisplayed(myAISContext->Current(),6)) 
		OneOrMoreInShadingOrColoredMesh=true;
	pCmdUI->Enable (OneOrMoreInShadingOrColoredMesh);	
}


void CViewer3dDoc::OnUpdateObjectShading(CCmdUI* pCmdUI) 
{
  bool OneOrMoreInWireframeOrColoredMesh = false;
  for (myAISContext->InitCurrent();myAISContext->MoreCurrent ();myAISContext->NextCurrent ())
    if (myAISContext->IsDisplayed(myAISContext->Current(),0) || myAISContext->IsDisplayed(myAISContext->Current(),6))
		OneOrMoreInWireframeOrColoredMesh=true;
	pCmdUI->Enable (OneOrMoreInWireframeOrColoredMesh);	
}


void CViewer3dDoc::OnOptionsTrihedronDynamicTrihedron() 
{
	if (myAISContext -> IsDisplayed(myTrihedron))
	{
		myAISContext->Remove(myTrihedron);
	}		
	else
	{
		Handle(Geom_Axis2Placement) myTrihedronAxis=new Geom_Axis2Placement(gp::XOY());
		myTrihedron=new AIS_Trihedron(myTrihedronAxis);
		myAISContext->SetTrihedronSize(200, Standard_True);
		myAISContext->Display(myTrihedron);	
	}		
}

void CViewer3dDoc::OnUpdateOptionsTrihedronDynamicTrihedron(CCmdUI* pCmdUI) 
{
	if (myAISContext->IsDisplayed(myTrihedron))
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);
}

void CViewer3dDoc::SetMyStaticTrihedronAxisIsDisplayed(BOOL IsDisplayed)
{
	myStaticTrihedronAxisIsDisplayed = IsDisplayed;
}

void CViewer3dDoc::OnUpdateOptionsTrihedronStaticTrihedron(CCmdUI* pCmdUI) 
{
	if (myStaticTrihedronAxisIsDisplayed)
		pCmdUI->SetCheck(1);
	else
		pCmdUI->SetCheck(0);
	
}

/*
void CViewer3dDoc::OnUpdateObjectColor(CCmdUI* pCmdUI) 
{
  bool OneOrMoreInShadingOrWireframe = false;
  for (myAISContext->InitCurrent();myAISContext->MoreCurrent ();myAISContext->NextCurrent ())
    if (myAISContext->IsDisplayed(myAISContext->Current(),1)
		|| myAISContext->IsDisplayed(myAISContext->Current(),0)) 
		OneOrMoreInShadingOrWireframe = true;
  pCmdUI->Enable (OneOrMoreInShadingOrWireframe);	
	
}
*/