<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/database.php");
include_once("./functions/logging.php");
include_once("./functions/utils.php");

/*
 * function: mysql_session_open()
 * 
 * Does nothing.
 */
function mysql_session_open($session_path, $session_name)
{
	return TRUE;
}

/*
 * function: mysql_session_close()
 */
function mysql_session_close()
{
	return TRUE;
}

/*
 * function: mysql_session_read()
 * 
 * Reads the session data from the database
 */
function mysql_session_read($SID)
{
	global $CONFIG_VARS;
	
	$query = "SELECT value FROM ".$CONFIG_VARS['session_handler.session_table'].
			" WHERE SID = '$SID' AND ".
			" expiration > ". time();

	$result = run_opendb_query($query, FALSE, 'session_handler');
	if($result && @mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result);
		mysql_free_result($result);

		return $found['value'];
	}
	else
		return "";
}

/*
 * function: mysql_session_write()
 * 
 * This function writes the session data to the database. If that SID 
 * already exists, then the existing data will be updated.
 */
function mysql_session_write($SID, $value)
{
	global $CONFIG_VARS;

	$expiration = time() + get_cfg_var("session.gc_maxlifetime");
	
	$query = "INSERT INTO ".$CONFIG_VARS['session_handler.session_table'].
			" VALUES('$SID', '$expiration', '$value')";

	$result = run_opendb_query($query, FALSE, 'session_handler');
	if($result && @mysql_affected_rows($result))
	{
		return TRUE;
	}
	else //if (! $result)
	{
		$query = "UPDATE ".$CONFIG_VARS['session_handler.session_table'].
		" SET expiration = '$expiration',".
			" value = '$value' WHERE ".
			" SID = '$SID' "; //AND expiration >". time();

		$result = run_opendb_query($query, FALSE, 'session_handler');
		if($result && @mysql_affected_rows($result))
			return TRUE;
		else
			return FALSE;
	}
	
	//else
	return FALSE;
}

/*
 * function: mysql_session_destroy()
 * 
 * Deletes all session information having input SID (only one row)
 */
function mysql_session_destroy($SID)
{
	global $CONFIG_VARS;
	
	$query = "DELETE FROM ".$CONFIG_VARS['session_handler.session_table'].
      " WHERE SID = '$SID'";

	$result = run_opendb_query($query, FALSE, 'session_handler');
	if($result && @mysql_affected_rows($result))
		return TRUE;
	else
		return FALSE;
		
}

/*
 * function: mysql_session_gc()
 * 
 * Deletes all sessions that have expired.
*/
function mysql_session_gc($maxlifetime)
{
	global $CONFIG_VARS;
	
	$query = "DELETE FROM ".$CONFIG_VARS['session_handler.session_table'].
			" WHERE sess_expiration < ".time() - $maxlifetime;
			
	$result = run_opendb_query($query, FALSE, 'session_handler');
	if($result && @mysql_affected_rows($result))
		return TRUE;
	else
		return FALSE;

}

// Attempt to change the ini value if required, but complain if not possible.
if(strtolower(ini_get("session.save_handler")) == "user" || ini_set("session.save_handler", "user"))
{
	session_set_save_handler("mysql_session_open", 
							"mysql_session_close",
							"mysql_session_read",
							"mysql_session_write",
							"mysql_session_destroy",
							"mysql_session_gc");
}
else
{
	opendb_log("session.php:: Cannot set session.save_handler to 'user'");
}
?>