#
# Amazon.sql site plugin definition
#

#
# Cleanup
#
DELETE FROM s_site_plugin WHERE site_type = 'amazon';
DELETE FROM s_site_plugin_conf WHERE site_type = 'amazon';
DELETE FROM s_site_plugin_input_field WHERE site_type = 'amazon';
DELETE FROM s_site_plugin_link WHERE site_type = 'amazon';
DELETE FROM s_site_plugin_s_attribute_type_map WHERE site_type = 'amazon';
DELETE FROM s_site_plugin_s_attribute_type_lookup_map WHERE site_type = 'amazon';

INSERT INTO s_site_plugin (site_type, classname, order_no, title, image, description, external_url, items_per_page, more_info_url)
VALUES('amazon', 'amazon', 1, 'Amazon.com', 'amazon.gif', 'A good source of CD, DVD (Region 1), VHS, Books, Games, etc.', 'http://www.amazon.com', 25, 'http://www.amazon.com/exec/obidos/ASIN/{amazonasin}');

#
# Input Fields
#	
INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('amazon', 'title', 1, '', 'Title Search', 'text', '', '{title}');

INSERT INTO s_site_plugin_input_field (site_type, field, order_no, description, prompt, field_type, default_value, refresh_mask)
VALUES('amazon', 'amazonasin', 2, '', 'ASIN/ISBN Number', 'text', '', '{ifdef(amazonasin,{amazonasin},{if(s_item_type==BOOK,{isbn},\'\')})}');

#
# Links
#
INSERT INTO s_site_plugin_link(site_type, s_item_type_group, s_item_type, order_no, description, url, title_url)
VALUES('amazon', '*', '*', 1, 'More Info', 'http://www.amazon.com/exec/obidos/ASIN/{amazonasin}', 'http://www.amazon.com/exec/obidos/external-search?tag=&index={config_var_value(item_type_to_index_map, {s_item_type})}&keyword={title}');

INSERT INTO s_site_plugin_link(site_type, s_item_type_group, s_item_type, order_no, description, url, title_url)
VALUES('amazon', '*', 'GAME', 2, 'Screenshots', 'http://www.amazon.com/exec/obidos/tg/stores/detail/-/videogames/{amazonasin}/pictures#more-pictures', NULL);

#
# site variable to s_attribute_type mapping
#
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazon', 'title', '*', '*', 'ALT_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazon', 'title', '*', '*', 'S_TITLE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazon', 'genre', 'VIDEO', '*', 'MOVIEGENRE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazon', 'genre', 'AUDIO', '*', 'MUSICGENRE');
	
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazon', 'genre', '*', 'BOOK', 'BOOKGENRE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazon', 'genre', '*', 'GAME', 'GAMEGENRE');
	
INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazon', 'blurb', 'VIDEO', '*', 'MOVIE_PLOT');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazon', 'blurb', 'AUDIO', '*', 'COMMENTS');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazon', 'blurb', '*', 'BOOK', 'COMMENTS');	

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazon', 'listprice', 'VIDEO', '*', 'RET_PRICE');

INSERT INTO s_site_plugin_s_attribute_type_map(site_type, variable, s_item_type_group, s_item_type, s_attribute_type)
VALUES ('amazon', 'listprice', '*', '*', 'COVERPRICE');

#
# site variable to s_attribute_type_lookup mapping
#

INSERT INTO s_site_plugin_s_attribute_type_lookup_map ( site_type, s_attribute_type, value, lookup_attribute_val ) 
VALUES ( 'amazon', 'AGE_RATING', 'Unrated', 'NR' );

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMESYSTEM', 'PlayStation', 'PS1');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMESYSTEM', 'PlayStation2', 'PS2');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMESYSTEM', 'Sega Dreamcast', 'DREAMCAST');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMESYSTEM', 'Nintendo 64', 'N64');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMESYSTEM', 'GameCube', 'GAMECUBE');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMESYSTEM', 'Xbox', 'XBOX');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMESYSTEM', 'Game Boy Color', 'GAMEBOY');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMESYSTEM', 'Game Boy', 'GAMEBOY');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMESYSTEM', 'Game Boy Advance', 'GAMEBOYADVANCE');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMESYSTEM', 'Mac OS', 'MACCDROM');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMESYSTEM', 'Windows', 'PCCDROM');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMERATING', 'early_childhood', 'EC');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMERATING', 'teen', 'T');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMERATING', 'everyone', 'E');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMERATING', 'mature', 'M');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMERATING', 'adults_only', 'AO');

INSERT INTO s_site_plugin_s_attribute_type_lookup_map(site_type, s_attribute_type, value, lookup_attribute_val)
VALUES('amazon', 'GAMERATING', 'rating_pending', 'RP');

#
# Configuration
#
INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazon', 'item_type_to_index_map', '', 'CD', 'music');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazon', 'item_type_to_index_map', '', 'MP3', 'music');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazon', 'item_type_to_index_map', '', 'BOOK', 'books');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazon', 'item_type_to_index_map', '', 'GAME', 'videogames');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazon', 'item_type_to_index_map', '', 'VHS', 'vhs');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazon', 'item_type_to_index_map', '', 'DVD', 'dvd');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazon', 'item_type_to_index_map', '', 'VCD', 'dvd');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazon', 'item_type_to_index_map', '', 'DIVX', 'dvd');

INSERT INTO s_site_plugin_conf (site_type, name, description, keyid, value)
VALUES('amazon', 'item_type_to_index_map', '', 'LD', 'dvd');

####################################################################################################
# Item Type / Attribute Type relationships
####################################################################################################

INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, s_field_type, site_type) VALUES ( 'AMAZONASIN', 'Amazon Standard Item Number', 'Amazon ASIN', 'hidden', 'hidden', NULL, 'amazon');

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DVD', 'AMAZONASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VHS', 'AMAZONASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'VCD', 'AMAZONASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'DIVX', 'AMAZONASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'LD', 'AMAZONASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'GAME', 'AMAZONASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'BOOK', 'AMAZONASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'CD', 'AMAZONASIN', '0', NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, compulsory_ind) VALUES ( 'MP3', 'AMAZONASIN', '0',NULL, NULL); 
