/*      -*- linux-c -*-
 *
 * (C) Copyright IBM Corp. 2004
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  This
 * file and program are licensed under a BSD style license.  See
 * the Copying file included with the OpenHPI distribution for
 * full licensing terms.
 *
 * Author(s):
 *      Steve Sherman <stevees@us.ibm.com> 
 */

/******************************************************************* 
 * WARNING! This file is auto-magically generated by:
 *          ./SaHpi2code.pl. 
 *          Do not change this file manually. Update script instead
 *******************************************************************/

#include <stdio.h>
#include <string.h>

#include <SaHpi.h>
#include <oh_utils.h>

#define BAD_ENUM_VALUE -1

int main(int argc, char **argv) 
{
        char *expected_str;
        char *str;

        /* SaHpiLanguageT - SAHPI_LANG_UNDEF testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_UNDEF;
		SaHpiLanguageT enum_type;
                expected_str = "UNDEF";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_UNDEF != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_AFAR testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_AFAR;
		SaHpiLanguageT enum_type;
                expected_str = "AFAR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_AFAR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_ABKHAZIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_ABKHAZIAN;
		SaHpiLanguageT enum_type;
                expected_str = "ABKHAZIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_ABKHAZIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_AFRIKAANS testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_AFRIKAANS;
		SaHpiLanguageT enum_type;
                expected_str = "AFRIKAANS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_AFRIKAANS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_AMHARIC testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_AMHARIC;
		SaHpiLanguageT enum_type;
                expected_str = "AMHARIC";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_AMHARIC != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_ARABIC testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_ARABIC;
		SaHpiLanguageT enum_type;
                expected_str = "ARABIC";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_ARABIC != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_ASSAMESE testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_ASSAMESE;
		SaHpiLanguageT enum_type;
                expected_str = "ASSAMESE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_ASSAMESE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_AYMARA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_AYMARA;
		SaHpiLanguageT enum_type;
                expected_str = "AYMARA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_AYMARA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_AZERBAIJANI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_AZERBAIJANI;
		SaHpiLanguageT enum_type;
                expected_str = "AZERBAIJANI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_AZERBAIJANI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_BASHKIR testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_BASHKIR;
		SaHpiLanguageT enum_type;
                expected_str = "BASHKIR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_BASHKIR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_BYELORUSSIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_BYELORUSSIAN;
		SaHpiLanguageT enum_type;
                expected_str = "BYELORUSSIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_BYELORUSSIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_BULGARIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_BULGARIAN;
		SaHpiLanguageT enum_type;
                expected_str = "BULGARIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_BULGARIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_BIHARI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_BIHARI;
		SaHpiLanguageT enum_type;
                expected_str = "BIHARI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_BIHARI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_BISLAMA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_BISLAMA;
		SaHpiLanguageT enum_type;
                expected_str = "BISLAMA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_BISLAMA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_BENGALI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_BENGALI;
		SaHpiLanguageT enum_type;
                expected_str = "BENGALI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_BENGALI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_TIBETAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_TIBETAN;
		SaHpiLanguageT enum_type;
                expected_str = "TIBETAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_TIBETAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_BRETON testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_BRETON;
		SaHpiLanguageT enum_type;
                expected_str = "BRETON";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_BRETON != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_CATALAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_CATALAN;
		SaHpiLanguageT enum_type;
                expected_str = "CATALAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_CATALAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_CORSICAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_CORSICAN;
		SaHpiLanguageT enum_type;
                expected_str = "CORSICAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_CORSICAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_CZECH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_CZECH;
		SaHpiLanguageT enum_type;
                expected_str = "CZECH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_CZECH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_WELSH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_WELSH;
		SaHpiLanguageT enum_type;
                expected_str = "WELSH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_WELSH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_DANISH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_DANISH;
		SaHpiLanguageT enum_type;
                expected_str = "DANISH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_DANISH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_GERMAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_GERMAN;
		SaHpiLanguageT enum_type;
                expected_str = "GERMAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_GERMAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_BHUTANI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_BHUTANI;
		SaHpiLanguageT enum_type;
                expected_str = "BHUTANI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_BHUTANI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_GREEK testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_GREEK;
		SaHpiLanguageT enum_type;
                expected_str = "GREEK";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_GREEK != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_ENGLISH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_ENGLISH;
		SaHpiLanguageT enum_type;
                expected_str = "ENGLISH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_ENGLISH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_ESPERANTO testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_ESPERANTO;
		SaHpiLanguageT enum_type;
                expected_str = "ESPERANTO";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_ESPERANTO != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SPANISH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SPANISH;
		SaHpiLanguageT enum_type;
                expected_str = "SPANISH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SPANISH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_ESTONIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_ESTONIAN;
		SaHpiLanguageT enum_type;
                expected_str = "ESTONIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_ESTONIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_BASQUE testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_BASQUE;
		SaHpiLanguageT enum_type;
                expected_str = "BASQUE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_BASQUE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_PERSIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_PERSIAN;
		SaHpiLanguageT enum_type;
                expected_str = "PERSIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_PERSIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_FINNISH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_FINNISH;
		SaHpiLanguageT enum_type;
                expected_str = "FINNISH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_FINNISH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_FIJI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_FIJI;
		SaHpiLanguageT enum_type;
                expected_str = "FIJI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_FIJI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_FAEROESE testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_FAEROESE;
		SaHpiLanguageT enum_type;
                expected_str = "FAEROESE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_FAEROESE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_FRENCH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_FRENCH;
		SaHpiLanguageT enum_type;
                expected_str = "FRENCH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_FRENCH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_FRISIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_FRISIAN;
		SaHpiLanguageT enum_type;
                expected_str = "FRISIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_FRISIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_IRISH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_IRISH;
		SaHpiLanguageT enum_type;
                expected_str = "IRISH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_IRISH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SCOTSGAELIC testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SCOTSGAELIC;
		SaHpiLanguageT enum_type;
                expected_str = "SCOTSGAELIC";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SCOTSGAELIC != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_GALICIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_GALICIAN;
		SaHpiLanguageT enum_type;
                expected_str = "GALICIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_GALICIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_GUARANI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_GUARANI;
		SaHpiLanguageT enum_type;
                expected_str = "GUARANI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_GUARANI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_GUJARATI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_GUJARATI;
		SaHpiLanguageT enum_type;
                expected_str = "GUJARATI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_GUJARATI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_HAUSA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_HAUSA;
		SaHpiLanguageT enum_type;
                expected_str = "HAUSA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_HAUSA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_HINDI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_HINDI;
		SaHpiLanguageT enum_type;
                expected_str = "HINDI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_HINDI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_CROATIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_CROATIAN;
		SaHpiLanguageT enum_type;
                expected_str = "CROATIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_CROATIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_HUNGARIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_HUNGARIAN;
		SaHpiLanguageT enum_type;
                expected_str = "HUNGARIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_HUNGARIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_ARMENIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_ARMENIAN;
		SaHpiLanguageT enum_type;
                expected_str = "ARMENIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_ARMENIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_INTERLINGUA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_INTERLINGUA;
		SaHpiLanguageT enum_type;
                expected_str = "INTERLINGUA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_INTERLINGUA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_INTERLINGUE testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_INTERLINGUE;
		SaHpiLanguageT enum_type;
                expected_str = "INTERLINGUE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_INTERLINGUE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_INUPIAK testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_INUPIAK;
		SaHpiLanguageT enum_type;
                expected_str = "INUPIAK";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_INUPIAK != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_INDONESIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_INDONESIAN;
		SaHpiLanguageT enum_type;
                expected_str = "INDONESIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_INDONESIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_ICELANDIC testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_ICELANDIC;
		SaHpiLanguageT enum_type;
                expected_str = "ICELANDIC";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_ICELANDIC != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_ITALIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_ITALIAN;
		SaHpiLanguageT enum_type;
                expected_str = "ITALIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_ITALIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_HEBREW testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_HEBREW;
		SaHpiLanguageT enum_type;
                expected_str = "HEBREW";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_HEBREW != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_JAPANESE testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_JAPANESE;
		SaHpiLanguageT enum_type;
                expected_str = "JAPANESE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_JAPANESE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_YIDDISH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_YIDDISH;
		SaHpiLanguageT enum_type;
                expected_str = "YIDDISH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_YIDDISH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_JAVANESE testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_JAVANESE;
		SaHpiLanguageT enum_type;
                expected_str = "JAVANESE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_JAVANESE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_GEORGIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_GEORGIAN;
		SaHpiLanguageT enum_type;
                expected_str = "GEORGIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_GEORGIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_KAZAKH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_KAZAKH;
		SaHpiLanguageT enum_type;
                expected_str = "KAZAKH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_KAZAKH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_GREENLANDIC testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_GREENLANDIC;
		SaHpiLanguageT enum_type;
                expected_str = "GREENLANDIC";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_GREENLANDIC != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_CAMBODIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_CAMBODIAN;
		SaHpiLanguageT enum_type;
                expected_str = "CAMBODIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_CAMBODIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_KANNADA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_KANNADA;
		SaHpiLanguageT enum_type;
                expected_str = "KANNADA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_KANNADA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_KOREAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_KOREAN;
		SaHpiLanguageT enum_type;
                expected_str = "KOREAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_KOREAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_KASHMIRI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_KASHMIRI;
		SaHpiLanguageT enum_type;
                expected_str = "KASHMIRI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_KASHMIRI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_KURDISH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_KURDISH;
		SaHpiLanguageT enum_type;
                expected_str = "KURDISH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_KURDISH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_KIRGHIZ testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_KIRGHIZ;
		SaHpiLanguageT enum_type;
                expected_str = "KIRGHIZ";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_KIRGHIZ != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_LATIN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_LATIN;
		SaHpiLanguageT enum_type;
                expected_str = "LATIN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_LATIN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_LINGALA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_LINGALA;
		SaHpiLanguageT enum_type;
                expected_str = "LINGALA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_LINGALA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_LAOTHIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_LAOTHIAN;
		SaHpiLanguageT enum_type;
                expected_str = "LAOTHIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_LAOTHIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_LITHUANIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_LITHUANIAN;
		SaHpiLanguageT enum_type;
                expected_str = "LITHUANIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_LITHUANIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_LATVIANLETTISH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_LATVIANLETTISH;
		SaHpiLanguageT enum_type;
                expected_str = "LATVIANLETTISH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_LATVIANLETTISH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_MALAGASY testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_MALAGASY;
		SaHpiLanguageT enum_type;
                expected_str = "MALAGASY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_MALAGASY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_MAORI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_MAORI;
		SaHpiLanguageT enum_type;
                expected_str = "MAORI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_MAORI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_MACEDONIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_MACEDONIAN;
		SaHpiLanguageT enum_type;
                expected_str = "MACEDONIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_MACEDONIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_MALAYALAM testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_MALAYALAM;
		SaHpiLanguageT enum_type;
                expected_str = "MALAYALAM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_MALAYALAM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_MONGOLIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_MONGOLIAN;
		SaHpiLanguageT enum_type;
                expected_str = "MONGOLIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_MONGOLIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_MOLDAVIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_MOLDAVIAN;
		SaHpiLanguageT enum_type;
                expected_str = "MOLDAVIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_MOLDAVIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_MARATHI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_MARATHI;
		SaHpiLanguageT enum_type;
                expected_str = "MARATHI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_MARATHI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_MALAY testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_MALAY;
		SaHpiLanguageT enum_type;
                expected_str = "MALAY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_MALAY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_MALTESE testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_MALTESE;
		SaHpiLanguageT enum_type;
                expected_str = "MALTESE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_MALTESE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_BURMESE testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_BURMESE;
		SaHpiLanguageT enum_type;
                expected_str = "BURMESE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_BURMESE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_NAURU testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_NAURU;
		SaHpiLanguageT enum_type;
                expected_str = "NAURU";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_NAURU != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_NEPALI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_NEPALI;
		SaHpiLanguageT enum_type;
                expected_str = "NEPALI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_NEPALI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_DUTCH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_DUTCH;
		SaHpiLanguageT enum_type;
                expected_str = "DUTCH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_DUTCH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_NORWEGIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_NORWEGIAN;
		SaHpiLanguageT enum_type;
                expected_str = "NORWEGIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_NORWEGIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_OCCITAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_OCCITAN;
		SaHpiLanguageT enum_type;
                expected_str = "OCCITAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_OCCITAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_AFANOROMO testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_AFANOROMO;
		SaHpiLanguageT enum_type;
                expected_str = "AFANOROMO";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_AFANOROMO != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_ORIYA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_ORIYA;
		SaHpiLanguageT enum_type;
                expected_str = "ORIYA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_ORIYA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_PUNJABI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_PUNJABI;
		SaHpiLanguageT enum_type;
                expected_str = "PUNJABI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_PUNJABI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_POLISH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_POLISH;
		SaHpiLanguageT enum_type;
                expected_str = "POLISH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_POLISH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_PASHTOPUSHTO testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_PASHTOPUSHTO;
		SaHpiLanguageT enum_type;
                expected_str = "PASHTOPUSHTO";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_PASHTOPUSHTO != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_PORTUGUESE testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_PORTUGUESE;
		SaHpiLanguageT enum_type;
                expected_str = "PORTUGUESE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_PORTUGUESE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_QUECHUA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_QUECHUA;
		SaHpiLanguageT enum_type;
                expected_str = "QUECHUA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_QUECHUA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_RHAETOROMANCE testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_RHAETOROMANCE;
		SaHpiLanguageT enum_type;
                expected_str = "RHAETOROMANCE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_RHAETOROMANCE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_KIRUNDI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_KIRUNDI;
		SaHpiLanguageT enum_type;
                expected_str = "KIRUNDI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_KIRUNDI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_ROMANIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_ROMANIAN;
		SaHpiLanguageT enum_type;
                expected_str = "ROMANIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_ROMANIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_RUSSIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_RUSSIAN;
		SaHpiLanguageT enum_type;
                expected_str = "RUSSIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_RUSSIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_KINYARWANDA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_KINYARWANDA;
		SaHpiLanguageT enum_type;
                expected_str = "KINYARWANDA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_KINYARWANDA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SANSKRIT testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SANSKRIT;
		SaHpiLanguageT enum_type;
                expected_str = "SANSKRIT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SANSKRIT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SINDHI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SINDHI;
		SaHpiLanguageT enum_type;
                expected_str = "SINDHI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SINDHI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SANGRO testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SANGRO;
		SaHpiLanguageT enum_type;
                expected_str = "SANGRO";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SANGRO != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SERBOCROATIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SERBOCROATIAN;
		SaHpiLanguageT enum_type;
                expected_str = "SERBOCROATIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SERBOCROATIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SINGHALESE testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SINGHALESE;
		SaHpiLanguageT enum_type;
                expected_str = "SINGHALESE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SINGHALESE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SLOVAK testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SLOVAK;
		SaHpiLanguageT enum_type;
                expected_str = "SLOVAK";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SLOVAK != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SLOVENIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SLOVENIAN;
		SaHpiLanguageT enum_type;
                expected_str = "SLOVENIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SLOVENIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SAMOAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SAMOAN;
		SaHpiLanguageT enum_type;
                expected_str = "SAMOAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SAMOAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SHONA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SHONA;
		SaHpiLanguageT enum_type;
                expected_str = "SHONA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SHONA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SOMALI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SOMALI;
		SaHpiLanguageT enum_type;
                expected_str = "SOMALI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SOMALI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_ALBANIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_ALBANIAN;
		SaHpiLanguageT enum_type;
                expected_str = "ALBANIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_ALBANIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SERBIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SERBIAN;
		SaHpiLanguageT enum_type;
                expected_str = "SERBIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SERBIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SISWATI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SISWATI;
		SaHpiLanguageT enum_type;
                expected_str = "SISWATI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SISWATI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SESOTHO testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SESOTHO;
		SaHpiLanguageT enum_type;
                expected_str = "SESOTHO";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SESOTHO != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SUDANESE testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SUDANESE;
		SaHpiLanguageT enum_type;
                expected_str = "SUDANESE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SUDANESE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SWEDISH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SWEDISH;
		SaHpiLanguageT enum_type;
                expected_str = "SWEDISH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SWEDISH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SWAHILI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SWAHILI;
		SaHpiLanguageT enum_type;
                expected_str = "SWAHILI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SWAHILI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_TAMIL testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_TAMIL;
		SaHpiLanguageT enum_type;
                expected_str = "TAMIL";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_TAMIL != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_TELUGU testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_TELUGU;
		SaHpiLanguageT enum_type;
                expected_str = "TELUGU";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_TELUGU != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_TAJIK testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_TAJIK;
		SaHpiLanguageT enum_type;
                expected_str = "TAJIK";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_TAJIK != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_THAI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_THAI;
		SaHpiLanguageT enum_type;
                expected_str = "THAI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_THAI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_TIGRINYA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_TIGRINYA;
		SaHpiLanguageT enum_type;
                expected_str = "TIGRINYA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_TIGRINYA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_TURKMEN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_TURKMEN;
		SaHpiLanguageT enum_type;
                expected_str = "TURKMEN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_TURKMEN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_TAGALOG testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_TAGALOG;
		SaHpiLanguageT enum_type;
                expected_str = "TAGALOG";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_TAGALOG != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_SETSWANA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_SETSWANA;
		SaHpiLanguageT enum_type;
                expected_str = "SETSWANA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_SETSWANA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_TONGA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_TONGA;
		SaHpiLanguageT enum_type;
                expected_str = "TONGA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_TONGA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_TURKISH testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_TURKISH;
		SaHpiLanguageT enum_type;
                expected_str = "TURKISH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_TURKISH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_TSONGA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_TSONGA;
		SaHpiLanguageT enum_type;
                expected_str = "TSONGA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_TSONGA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_TATAR testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_TATAR;
		SaHpiLanguageT enum_type;
                expected_str = "TATAR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_TATAR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_TWI testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_TWI;
		SaHpiLanguageT enum_type;
                expected_str = "TWI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_TWI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_UKRAINIAN testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_UKRAINIAN;
		SaHpiLanguageT enum_type;
                expected_str = "UKRAINIAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_UKRAINIAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_URDU testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_URDU;
		SaHpiLanguageT enum_type;
                expected_str = "URDU";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_URDU != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_UZBEK testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_UZBEK;
		SaHpiLanguageT enum_type;
                expected_str = "UZBEK";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_UZBEK != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_VIETNAMESE testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_VIETNAMESE;
		SaHpiLanguageT enum_type;
                expected_str = "VIETNAMESE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_VIETNAMESE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_VOLAPUK testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_VOLAPUK;
		SaHpiLanguageT enum_type;
                expected_str = "VOLAPUK";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_VOLAPUK != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_WOLOF testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_WOLOF;
		SaHpiLanguageT enum_type;
                expected_str = "WOLOF";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_WOLOF != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_XHOSA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_XHOSA;
		SaHpiLanguageT enum_type;
                expected_str = "XHOSA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_XHOSA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_YORUBA testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_YORUBA;
		SaHpiLanguageT enum_type;
                expected_str = "YORUBA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_YORUBA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_CHINESE testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_CHINESE;
		SaHpiLanguageT enum_type;
                expected_str = "CHINESE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_CHINESE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - SAHPI_LANG_ZULU testcase */
        {
	        SaHpiLanguageT value = SAHPI_LANG_ZULU;
		SaHpiLanguageT enum_type;
                expected_str = "ZULU";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_language(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_language(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LANG_ZULU != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiLanguageT - Default testcase */
        {
	        SaHpiLanguageT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_language(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiLanguageT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiLanguageT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_language(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiLanguageT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_language(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiTextTypeT - SAHPI_TL_TYPE_UNICODE testcase */
        {
	        SaHpiTextTypeT value = SAHPI_TL_TYPE_UNICODE;
		SaHpiTextTypeT enum_type;
                expected_str = "UNICODE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_texttype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_texttype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_TL_TYPE_UNICODE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiTextTypeT - SAHPI_TL_TYPE_BCDPLUS testcase */
        {
	        SaHpiTextTypeT value = SAHPI_TL_TYPE_BCDPLUS;
		SaHpiTextTypeT enum_type;
                expected_str = "BCDPLUS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_texttype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_texttype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_TL_TYPE_BCDPLUS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiTextTypeT - SAHPI_TL_TYPE_ASCII6 testcase */
        {
	        SaHpiTextTypeT value = SAHPI_TL_TYPE_ASCII6;
		SaHpiTextTypeT enum_type;
                expected_str = "ASCII6";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_texttype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_texttype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_TL_TYPE_ASCII6 != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiTextTypeT - SAHPI_TL_TYPE_TEXT testcase */
        {
	        SaHpiTextTypeT value = SAHPI_TL_TYPE_TEXT;
		SaHpiTextTypeT enum_type;
                expected_str = "TEXT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_texttype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_texttype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_TL_TYPE_TEXT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiTextTypeT - SAHPI_TL_TYPE_BINARY testcase */
        {
	        SaHpiTextTypeT value = SAHPI_TL_TYPE_BINARY;
		SaHpiTextTypeT enum_type;
                expected_str = "BINARY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_texttype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_texttype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_TL_TYPE_BINARY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiTextTypeT - Default testcase */
        {
	        SaHpiTextTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_texttype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiTextTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiTextTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_texttype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiTextTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_texttype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_UNSPECIFIED testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_UNSPECIFIED;
		SaHpiEntityTypeT enum_type;
                expected_str = "UNSPECIFIED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_UNSPECIFIED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_OTHER testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_OTHER;
		SaHpiEntityTypeT enum_type;
                expected_str = "OTHER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_OTHER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_UNKNOWN testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_UNKNOWN;
		SaHpiEntityTypeT enum_type;
                expected_str = "UNKNOWN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_UNKNOWN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_PROCESSOR testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_PROCESSOR;
		SaHpiEntityTypeT enum_type;
                expected_str = "PROCESSOR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_PROCESSOR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_DISK_BAY testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_DISK_BAY;
		SaHpiEntityTypeT enum_type;
                expected_str = "DISK_BAY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_DISK_BAY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_PERIPHERAL_BAY testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_PERIPHERAL_BAY;
		SaHpiEntityTypeT enum_type;
                expected_str = "PERIPHERAL_BAY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_PERIPHERAL_BAY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SYS_MGMNT_MODULE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SYS_MGMNT_MODULE;
		SaHpiEntityTypeT enum_type;
                expected_str = "SYS_MGMNT_MODULE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SYS_MGMNT_MODULE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SYSTEM_BOARD testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SYSTEM_BOARD;
		SaHpiEntityTypeT enum_type;
                expected_str = "SYSTEM_BOARD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SYSTEM_BOARD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_MEMORY_MODULE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_MEMORY_MODULE;
		SaHpiEntityTypeT enum_type;
                expected_str = "MEMORY_MODULE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_MEMORY_MODULE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_PROCESSOR_MODULE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_PROCESSOR_MODULE;
		SaHpiEntityTypeT enum_type;
                expected_str = "PROCESSOR_MODULE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_PROCESSOR_MODULE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_POWER_SUPPLY testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_POWER_SUPPLY;
		SaHpiEntityTypeT enum_type;
                expected_str = "POWER_SUPPLY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_POWER_SUPPLY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_ADD_IN_CARD testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_ADD_IN_CARD;
		SaHpiEntityTypeT enum_type;
                expected_str = "ADD_IN_CARD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_ADD_IN_CARD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_FRONT_PANEL_BOARD testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_FRONT_PANEL_BOARD;
		SaHpiEntityTypeT enum_type;
                expected_str = "FRONT_PANEL_BOARD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_FRONT_PANEL_BOARD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_BACK_PANEL_BOARD testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_BACK_PANEL_BOARD;
		SaHpiEntityTypeT enum_type;
                expected_str = "BACK_PANEL_BOARD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_BACK_PANEL_BOARD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_POWER_SYSTEM_BOARD testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_POWER_SYSTEM_BOARD;
		SaHpiEntityTypeT enum_type;
                expected_str = "POWER_SYSTEM_BOARD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_POWER_SYSTEM_BOARD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_DRIVE_BACKPLANE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_DRIVE_BACKPLANE;
		SaHpiEntityTypeT enum_type;
                expected_str = "DRIVE_BACKPLANE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_DRIVE_BACKPLANE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SYS_EXPANSION_BOARD testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SYS_EXPANSION_BOARD;
		SaHpiEntityTypeT enum_type;
                expected_str = "SYS_EXPANSION_BOARD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SYS_EXPANSION_BOARD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_OTHER_SYSTEM_BOARD testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_OTHER_SYSTEM_BOARD;
		SaHpiEntityTypeT enum_type;
                expected_str = "OTHER_SYSTEM_BOARD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_OTHER_SYSTEM_BOARD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_PROCESSOR_BOARD testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_PROCESSOR_BOARD;
		SaHpiEntityTypeT enum_type;
                expected_str = "PROCESSOR_BOARD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_PROCESSOR_BOARD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_POWER_UNIT testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_POWER_UNIT;
		SaHpiEntityTypeT enum_type;
                expected_str = "POWER_UNIT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_POWER_UNIT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_POWER_MODULE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_POWER_MODULE;
		SaHpiEntityTypeT enum_type;
                expected_str = "POWER_MODULE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_POWER_MODULE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_POWER_MGMNT testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_POWER_MGMNT;
		SaHpiEntityTypeT enum_type;
                expected_str = "POWER_MGMNT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_POWER_MGMNT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_CHASSIS_BACK_PANEL_BOARD testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_CHASSIS_BACK_PANEL_BOARD;
		SaHpiEntityTypeT enum_type;
                expected_str = "CHASSIS_BACK_PANEL_BOARD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_CHASSIS_BACK_PANEL_BOARD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SYSTEM_CHASSIS testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SYSTEM_CHASSIS;
		SaHpiEntityTypeT enum_type;
                expected_str = "SYSTEM_CHASSIS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SYSTEM_CHASSIS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SUB_CHASSIS testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SUB_CHASSIS;
		SaHpiEntityTypeT enum_type;
                expected_str = "SUB_CHASSIS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SUB_CHASSIS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_OTHER_CHASSIS_BOARD testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_OTHER_CHASSIS_BOARD;
		SaHpiEntityTypeT enum_type;
                expected_str = "OTHER_CHASSIS_BOARD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_OTHER_CHASSIS_BOARD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_DISK_DRIVE_BAY testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_DISK_DRIVE_BAY;
		SaHpiEntityTypeT enum_type;
                expected_str = "DISK_DRIVE_BAY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_DISK_DRIVE_BAY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_PERIPHERAL_BAY_2 testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_PERIPHERAL_BAY_2;
		SaHpiEntityTypeT enum_type;
                expected_str = "PERIPHERAL_BAY_2";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_PERIPHERAL_BAY_2 != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_DEVICE_BAY testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_DEVICE_BAY;
		SaHpiEntityTypeT enum_type;
                expected_str = "DEVICE_BAY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_DEVICE_BAY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_COOLING_DEVICE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_COOLING_DEVICE;
		SaHpiEntityTypeT enum_type;
                expected_str = "COOLING_DEVICE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_COOLING_DEVICE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_COOLING_UNIT testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_COOLING_UNIT;
		SaHpiEntityTypeT enum_type;
                expected_str = "COOLING_UNIT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_COOLING_UNIT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_INTERCONNECT testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_INTERCONNECT;
		SaHpiEntityTypeT enum_type;
                expected_str = "INTERCONNECT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_INTERCONNECT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_MEMORY_DEVICE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_MEMORY_DEVICE;
		SaHpiEntityTypeT enum_type;
                expected_str = "MEMORY_DEVICE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_MEMORY_DEVICE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SYS_MGMNT_SOFTWARE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SYS_MGMNT_SOFTWARE;
		SaHpiEntityTypeT enum_type;
                expected_str = "SYS_MGMNT_SOFTWARE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SYS_MGMNT_SOFTWARE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_BIOS testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_BIOS;
		SaHpiEntityTypeT enum_type;
                expected_str = "BIOS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_BIOS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_OPERATING_SYSTEM testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_OPERATING_SYSTEM;
		SaHpiEntityTypeT enum_type;
                expected_str = "OPERATING_SYSTEM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_OPERATING_SYSTEM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SYSTEM_BUS testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SYSTEM_BUS;
		SaHpiEntityTypeT enum_type;
                expected_str = "SYSTEM_BUS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SYSTEM_BUS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_GROUP testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_GROUP;
		SaHpiEntityTypeT enum_type;
                expected_str = "GROUP";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_GROUP != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_REMOTE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_REMOTE;
		SaHpiEntityTypeT enum_type;
                expected_str = "REMOTE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_REMOTE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_EXTERNAL_ENVIRONMENT testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_EXTERNAL_ENVIRONMENT;
		SaHpiEntityTypeT enum_type;
                expected_str = "EXTERNAL_ENVIRONMENT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_EXTERNAL_ENVIRONMENT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_BATTERY testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_BATTERY;
		SaHpiEntityTypeT enum_type;
                expected_str = "BATTERY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_BATTERY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_CHASSIS_SPECIFIC testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_CHASSIS_SPECIFIC;
		SaHpiEntityTypeT enum_type;
                expected_str = "CHASSIS_SPECIFIC";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_CHASSIS_SPECIFIC != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_BOARD_SET_SPECIFIC testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_BOARD_SET_SPECIFIC;
		SaHpiEntityTypeT enum_type;
                expected_str = "BOARD_SET_SPECIFIC";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_BOARD_SET_SPECIFIC != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_OEM_SYSINT_SPECIFIC testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_OEM_SYSINT_SPECIFIC;
		SaHpiEntityTypeT enum_type;
                expected_str = "OEM_SYSINT_SPECIFIC";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_OEM_SYSINT_SPECIFIC != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_ROOT testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_ROOT;
		SaHpiEntityTypeT enum_type;
                expected_str = "ROOT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_ROOT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_RACK testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_RACK;
		SaHpiEntityTypeT enum_type;
                expected_str = "RACK";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_RACK != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SUBRACK testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SUBRACK;
		SaHpiEntityTypeT enum_type;
                expected_str = "SUBRACK";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SUBRACK != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_COMPACTPCI_CHASSIS testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_COMPACTPCI_CHASSIS;
		SaHpiEntityTypeT enum_type;
                expected_str = "COMPACTPCI_CHASSIS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_COMPACTPCI_CHASSIS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_ADVANCEDTCA_CHASSIS testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_ADVANCEDTCA_CHASSIS;
		SaHpiEntityTypeT enum_type;
                expected_str = "ADVANCEDTCA_CHASSIS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_ADVANCEDTCA_CHASSIS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_RACK_MOUNTED_SERVER testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_RACK_MOUNTED_SERVER;
		SaHpiEntityTypeT enum_type;
                expected_str = "RACK_MOUNTED_SERVER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_RACK_MOUNTED_SERVER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SYSTEM_BLADE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SYSTEM_BLADE;
		SaHpiEntityTypeT enum_type;
                expected_str = "SYSTEM_BLADE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SYSTEM_BLADE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SWITCH testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SWITCH;
		SaHpiEntityTypeT enum_type;
                expected_str = "SWITCH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SWITCH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SWITCH_BLADE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SWITCH_BLADE;
		SaHpiEntityTypeT enum_type;
                expected_str = "SWITCH_BLADE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SWITCH_BLADE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SBC_BLADE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SBC_BLADE;
		SaHpiEntityTypeT enum_type;
                expected_str = "SBC_BLADE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SBC_BLADE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_IO_BLADE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_IO_BLADE;
		SaHpiEntityTypeT enum_type;
                expected_str = "IO_BLADE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_IO_BLADE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_DISK_BLADE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_DISK_BLADE;
		SaHpiEntityTypeT enum_type;
                expected_str = "DISK_BLADE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_DISK_BLADE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_DISK_DRIVE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_DISK_DRIVE;
		SaHpiEntityTypeT enum_type;
                expected_str = "DISK_DRIVE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_DISK_DRIVE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_FAN testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_FAN;
		SaHpiEntityTypeT enum_type;
                expected_str = "FAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_FAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_POWER_DISTRIBUTION_UNIT testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_POWER_DISTRIBUTION_UNIT;
		SaHpiEntityTypeT enum_type;
                expected_str = "POWER_DISTRIBUTION_UNIT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_POWER_DISTRIBUTION_UNIT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SPEC_PROC_BLADE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SPEC_PROC_BLADE;
		SaHpiEntityTypeT enum_type;
                expected_str = "SPEC_PROC_BLADE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SPEC_PROC_BLADE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_IO_SUBBOARD testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_IO_SUBBOARD;
		SaHpiEntityTypeT enum_type;
                expected_str = "IO_SUBBOARD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_IO_SUBBOARD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SBC_SUBBOARD testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SBC_SUBBOARD;
		SaHpiEntityTypeT enum_type;
                expected_str = "SBC_SUBBOARD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SBC_SUBBOARD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_ALARM_MANAGER testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_ALARM_MANAGER;
		SaHpiEntityTypeT enum_type;
                expected_str = "ALARM_MANAGER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_ALARM_MANAGER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SHELF_MANAGER testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SHELF_MANAGER;
		SaHpiEntityTypeT enum_type;
                expected_str = "SHELF_MANAGER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SHELF_MANAGER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_DISPLAY_PANEL testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_DISPLAY_PANEL;
		SaHpiEntityTypeT enum_type;
                expected_str = "DISPLAY_PANEL";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_DISPLAY_PANEL != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_SUBBOARD_CARRIER_BLADE testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_SUBBOARD_CARRIER_BLADE;
		SaHpiEntityTypeT enum_type;
                expected_str = "SUBBOARD_CARRIER_BLADE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_SUBBOARD_CARRIER_BLADE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - SAHPI_ENT_PHYSICAL_SLOT testcase */
        {
	        SaHpiEntityTypeT value = SAHPI_ENT_PHYSICAL_SLOT;
		SaHpiEntityTypeT enum_type;
                expected_str = "PHYSICAL_SLOT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_entitytype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENT_PHYSICAL_SLOT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEntityTypeT - Default testcase */
        {
	        SaHpiEntityTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_entitytype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiEntityTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiEntityTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_entitytype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiEntityTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_entitytype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_TEMPERATURE testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_TEMPERATURE;
		SaHpiSensorTypeT enum_type;
                expected_str = "TEMPERATURE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_TEMPERATURE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_VOLTAGE testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_VOLTAGE;
		SaHpiSensorTypeT enum_type;
                expected_str = "VOLTAGE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_VOLTAGE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_CURRENT testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_CURRENT;
		SaHpiSensorTypeT enum_type;
                expected_str = "CURRENT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CURRENT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_FAN testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_FAN;
		SaHpiSensorTypeT enum_type;
                expected_str = "FAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_FAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_PHYSICAL_SECURITY testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_PHYSICAL_SECURITY;
		SaHpiSensorTypeT enum_type;
                expected_str = "PHYSICAL_SECURITY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_PHYSICAL_SECURITY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_PLATFORM_VIOLATION testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_PLATFORM_VIOLATION;
		SaHpiSensorTypeT enum_type;
                expected_str = "PLATFORM_VIOLATION";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_PLATFORM_VIOLATION != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_PROCESSOR testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_PROCESSOR;
		SaHpiSensorTypeT enum_type;
                expected_str = "PROCESSOR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_PROCESSOR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_POWER_SUPPLY testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_POWER_SUPPLY;
		SaHpiSensorTypeT enum_type;
                expected_str = "POWER_SUPPLY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_POWER_SUPPLY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_POWER_UNIT testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_POWER_UNIT;
		SaHpiSensorTypeT enum_type;
                expected_str = "POWER_UNIT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_POWER_UNIT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_COOLING_DEVICE testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_COOLING_DEVICE;
		SaHpiSensorTypeT enum_type;
                expected_str = "COOLING_DEVICE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_COOLING_DEVICE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_OTHER_UNITS_BASED_SENSOR testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_OTHER_UNITS_BASED_SENSOR;
		SaHpiSensorTypeT enum_type;
                expected_str = "OTHER_UNITS_BASED_SENSOR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_OTHER_UNITS_BASED_SENSOR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_MEMORY testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_MEMORY;
		SaHpiSensorTypeT enum_type;
                expected_str = "MEMORY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_MEMORY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_DRIVE_SLOT testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_DRIVE_SLOT;
		SaHpiSensorTypeT enum_type;
                expected_str = "DRIVE_SLOT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_DRIVE_SLOT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_POST_MEMORY_RESIZE testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_POST_MEMORY_RESIZE;
		SaHpiSensorTypeT enum_type;
                expected_str = "POST_MEMORY_RESIZE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_POST_MEMORY_RESIZE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_SYSTEM_FW_PROGRESS testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_SYSTEM_FW_PROGRESS;
		SaHpiSensorTypeT enum_type;
                expected_str = "SYSTEM_FW_PROGRESS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SYSTEM_FW_PROGRESS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_EVENT_LOGGING_DISABLED testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_EVENT_LOGGING_DISABLED;
		SaHpiSensorTypeT enum_type;
                expected_str = "EVENT_LOGGING_DISABLED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EVENT_LOGGING_DISABLED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_RESERVED1 testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_RESERVED1;
		SaHpiSensorTypeT enum_type;
                expected_str = "RESERVED1";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_RESERVED1 != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_SYSTEM_EVENT testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_SYSTEM_EVENT;
		SaHpiSensorTypeT enum_type;
                expected_str = "SYSTEM_EVENT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SYSTEM_EVENT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_CRITICAL_INTERRUPT testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_CRITICAL_INTERRUPT;
		SaHpiSensorTypeT enum_type;
                expected_str = "CRITICAL_INTERRUPT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CRITICAL_INTERRUPT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_BUTTON testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_BUTTON;
		SaHpiSensorTypeT enum_type;
                expected_str = "BUTTON";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_BUTTON != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_MODULE_BOARD testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_MODULE_BOARD;
		SaHpiSensorTypeT enum_type;
                expected_str = "MODULE_BOARD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_MODULE_BOARD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_MICROCONTROLLER_COPROCESSOR testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_MICROCONTROLLER_COPROCESSOR;
		SaHpiSensorTypeT enum_type;
                expected_str = "MICROCONTROLLER_COPROCESSOR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_MICROCONTROLLER_COPROCESSOR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_ADDIN_CARD testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_ADDIN_CARD;
		SaHpiSensorTypeT enum_type;
                expected_str = "ADDIN_CARD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ADDIN_CARD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_CHASSIS testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_CHASSIS;
		SaHpiSensorTypeT enum_type;
                expected_str = "CHASSIS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CHASSIS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_CHIP_SET testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_CHIP_SET;
		SaHpiSensorTypeT enum_type;
                expected_str = "CHIP_SET";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CHIP_SET != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_OTHER_FRU testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_OTHER_FRU;
		SaHpiSensorTypeT enum_type;
                expected_str = "OTHER_FRU";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_OTHER_FRU != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_CABLE_INTERCONNECT testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_CABLE_INTERCONNECT;
		SaHpiSensorTypeT enum_type;
                expected_str = "CABLE_INTERCONNECT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CABLE_INTERCONNECT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_TERMINATOR testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_TERMINATOR;
		SaHpiSensorTypeT enum_type;
                expected_str = "TERMINATOR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_TERMINATOR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_SYSTEM_BOOT_INITIATED testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_SYSTEM_BOOT_INITIATED;
		SaHpiSensorTypeT enum_type;
                expected_str = "SYSTEM_BOOT_INITIATED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SYSTEM_BOOT_INITIATED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_BOOT_ERROR testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_BOOT_ERROR;
		SaHpiSensorTypeT enum_type;
                expected_str = "BOOT_ERROR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_BOOT_ERROR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_OS_BOOT testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_OS_BOOT;
		SaHpiSensorTypeT enum_type;
                expected_str = "OS_BOOT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_OS_BOOT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_OS_CRITICAL_STOP testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_OS_CRITICAL_STOP;
		SaHpiSensorTypeT enum_type;
                expected_str = "OS_CRITICAL_STOP";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_OS_CRITICAL_STOP != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_SLOT_CONNECTOR testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_SLOT_CONNECTOR;
		SaHpiSensorTypeT enum_type;
                expected_str = "SLOT_CONNECTOR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SLOT_CONNECTOR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_SYSTEM_ACPI_POWER_STATE testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_SYSTEM_ACPI_POWER_STATE;
		SaHpiSensorTypeT enum_type;
                expected_str = "SYSTEM_ACPI_POWER_STATE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SYSTEM_ACPI_POWER_STATE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_RESERVED2 testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_RESERVED2;
		SaHpiSensorTypeT enum_type;
                expected_str = "RESERVED2";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_RESERVED2 != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_PLATFORM_ALERT testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_PLATFORM_ALERT;
		SaHpiSensorTypeT enum_type;
                expected_str = "PLATFORM_ALERT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_PLATFORM_ALERT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_ENTITY_PRESENCE testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_ENTITY_PRESENCE;
		SaHpiSensorTypeT enum_type;
                expected_str = "ENTITY_PRESENCE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ENTITY_PRESENCE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_MONITOR_ASIC_IC testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_MONITOR_ASIC_IC;
		SaHpiSensorTypeT enum_type;
                expected_str = "MONITOR_ASIC_IC";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_MONITOR_ASIC_IC != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_LAN testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_LAN;
		SaHpiSensorTypeT enum_type;
                expected_str = "LAN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_LAN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_MANAGEMENT_SUBSYSTEM_HEALTH testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_MANAGEMENT_SUBSYSTEM_HEALTH;
		SaHpiSensorTypeT enum_type;
                expected_str = "MANAGEMENT_SUBSYSTEM_HEALTH";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_MANAGEMENT_SUBSYSTEM_HEALTH != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_BATTERY testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_BATTERY;
		SaHpiSensorTypeT enum_type;
                expected_str = "BATTERY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_BATTERY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_OPERATIONAL testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_OPERATIONAL;
		SaHpiSensorTypeT enum_type;
                expected_str = "OPERATIONAL";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_OPERATIONAL != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - SAHPI_OEM_SENSOR testcase */
        {
	        SaHpiSensorTypeT value = SAHPI_OEM_SENSOR;
		SaHpiSensorTypeT enum_type;
                expected_str = "OEM_SENSOR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_OEM_SENSOR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorTypeT - Default testcase */
        {
	        SaHpiSensorTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_sensortype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiSensorTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiSensorTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_sensortype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiSensorTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_sensortype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiSensorReadingTypeT - SAHPI_SENSOR_READING_TYPE_INT64 testcase */
        {
	        SaHpiSensorReadingTypeT value = SAHPI_SENSOR_READING_TYPE_INT64;
		SaHpiSensorReadingTypeT enum_type;
                expected_str = "INT64";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorreadingtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorreadingtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SENSOR_READING_TYPE_INT64 != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorReadingTypeT - SAHPI_SENSOR_READING_TYPE_UINT64 testcase */
        {
	        SaHpiSensorReadingTypeT value = SAHPI_SENSOR_READING_TYPE_UINT64;
		SaHpiSensorReadingTypeT enum_type;
                expected_str = "UINT64";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorreadingtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorreadingtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SENSOR_READING_TYPE_UINT64 != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorReadingTypeT - SAHPI_SENSOR_READING_TYPE_FLOAT64 testcase */
        {
	        SaHpiSensorReadingTypeT value = SAHPI_SENSOR_READING_TYPE_FLOAT64;
		SaHpiSensorReadingTypeT enum_type;
                expected_str = "FLOAT64";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorreadingtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorreadingtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SENSOR_READING_TYPE_FLOAT64 != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorReadingTypeT - SAHPI_SENSOR_READING_TYPE_BUFFER testcase */
        {
	        SaHpiSensorReadingTypeT value = SAHPI_SENSOR_READING_TYPE_BUFFER;
		SaHpiSensorReadingTypeT enum_type;
                expected_str = "BUFFER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorreadingtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorreadingtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SENSOR_READING_TYPE_BUFFER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorReadingTypeT - Default testcase */
        {
	        SaHpiSensorReadingTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_sensorreadingtype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiSensorReadingTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiSensorReadingTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_sensorreadingtype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiSensorReadingTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_sensorreadingtype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiSensorEventMaskActionT - SAHPI_SENS_ADD_EVENTS_TO_MASKS testcase */
        {
	        SaHpiSensorEventMaskActionT value = SAHPI_SENS_ADD_EVENTS_TO_MASKS;
		SaHpiSensorEventMaskActionT enum_type;
                expected_str = "ADD_EVENTS_TO_MASKS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensoreventmaskaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensoreventmaskaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SENS_ADD_EVENTS_TO_MASKS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorEventMaskActionT - SAHPI_SENS_REMOVE_EVENTS_FROM_MASKS testcase */
        {
	        SaHpiSensorEventMaskActionT value = SAHPI_SENS_REMOVE_EVENTS_FROM_MASKS;
		SaHpiSensorEventMaskActionT enum_type;
                expected_str = "REMOVE_EVENTS_FROM_MASKS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensoreventmaskaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensoreventmaskaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SENS_REMOVE_EVENTS_FROM_MASKS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorEventMaskActionT - Default testcase */
        {
	        SaHpiSensorEventMaskActionT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_sensoreventmaskaction(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiSensorEventMaskActionT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiSensorEventMaskActionT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_sensoreventmaskaction(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiSensorEventMaskActionT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_sensoreventmaskaction(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_UNSPECIFIED testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_UNSPECIFIED;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Unspecified";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_UNSPECIFIED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_DEGREES_C testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_DEGREES_C;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Degrees C";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_DEGREES_C != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_DEGREES_F testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_DEGREES_F;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Degrees F";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_DEGREES_F != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_DEGREES_K testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_DEGREES_K;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Degrees K";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_DEGREES_K != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_VOLTS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_VOLTS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Volts";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_VOLTS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_AMPS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_AMPS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Amps";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_AMPS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_WATTS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_WATTS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Watts";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_WATTS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_JOULES testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_JOULES;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Joules";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_JOULES != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_COULOMBS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_COULOMBS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Coulombs";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_COULOMBS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_VA testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_VA;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Va";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_VA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_NITS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_NITS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Nits";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_NITS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_LUMEN testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_LUMEN;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Lumen";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_LUMEN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_LUX testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_LUX;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Lux";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_LUX != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_CANDELA testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_CANDELA;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Candela";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_CANDELA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_KPA testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_KPA;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Kpa";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_KPA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_PSI testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_PSI;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Psi";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_PSI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_NEWTON testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_NEWTON;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Newton";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_NEWTON != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_CFM testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_CFM;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Cfm";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_CFM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_RPM testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_RPM;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Rpm";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_RPM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_HZ testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_HZ;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Hz";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_HZ != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_MICROSECOND testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_MICROSECOND;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Microsecond";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_MICROSECOND != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_MILLISECOND testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_MILLISECOND;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Millisecond";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_MILLISECOND != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_SECOND testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_SECOND;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Second";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_SECOND != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_MINUTE testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_MINUTE;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Minute";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_MINUTE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_HOUR testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_HOUR;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Hour";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_HOUR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_DAY testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_DAY;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Day";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_DAY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_WEEK testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_WEEK;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Week";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_WEEK != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_MIL testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_MIL;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Mil";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_MIL != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_INCHES testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_INCHES;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Inches";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_INCHES != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_FEET testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_FEET;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Feet";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_FEET != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_CU_IN testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_CU_IN;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Cu In";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_CU_IN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_CU_FEET testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_CU_FEET;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Cu Feet";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_CU_FEET != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_MM testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_MM;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Mm";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_MM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_CM testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_CM;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Cm";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_CM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_M testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_M;
		SaHpiSensorUnitsT enum_type;
                expected_str = "M";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_M != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_CU_CM testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_CU_CM;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Cu Cm";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_CU_CM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_CU_M testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_CU_M;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Cu M";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_CU_M != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_LITERS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_LITERS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Liters";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_LITERS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_FLUID_OUNCE testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_FLUID_OUNCE;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Fluid Ounce";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_FLUID_OUNCE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_RADIANS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_RADIANS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Radians";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_RADIANS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_STERADIANS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_STERADIANS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Steradians";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_STERADIANS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_REVOLUTIONS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_REVOLUTIONS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Revolutions";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_REVOLUTIONS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_CYCLES testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_CYCLES;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Cycles";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_CYCLES != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_GRAVITIES testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_GRAVITIES;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Gravities";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_GRAVITIES != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_OUNCE testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_OUNCE;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Ounce";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_OUNCE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_POUND testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_POUND;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Pound";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_POUND != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_FT_LB testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_FT_LB;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Ft Lb";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_FT_LB != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_OZ_IN testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_OZ_IN;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Oz In";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_OZ_IN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_GAUSS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_GAUSS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Gauss";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_GAUSS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_GILBERTS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_GILBERTS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Gilberts";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_GILBERTS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_HENRY testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_HENRY;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Henry";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_HENRY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_MILLIHENRY testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_MILLIHENRY;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Millihenry";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_MILLIHENRY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_FARAD testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_FARAD;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Farad";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_FARAD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_MICROFARAD testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_MICROFARAD;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Microfarad";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_MICROFARAD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_OHMS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_OHMS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Ohms";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_OHMS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_SIEMENS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_SIEMENS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Siemens";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_SIEMENS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_MOLE testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_MOLE;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Mole";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_MOLE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_BECQUEREL testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_BECQUEREL;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Becquerel";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_BECQUEREL != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_PPM testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_PPM;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Ppm";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_PPM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_RESERVED testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_RESERVED;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Reserved";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_RESERVED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_DECIBELS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_DECIBELS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Decibels";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_DECIBELS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_DBA testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_DBA;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Dba";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_DBA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_DBC testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_DBC;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Dbc";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_DBC != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_GRAY testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_GRAY;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Gray";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_GRAY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_SIEVERT testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_SIEVERT;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Sievert";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_SIEVERT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_COLOR_TEMP_DEG_K testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_COLOR_TEMP_DEG_K;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Color Temp Deg K";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_COLOR_TEMP_DEG_K != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_BIT testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_BIT;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Bit";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_BIT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_KILOBIT testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_KILOBIT;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Kilobit";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_KILOBIT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_MEGABIT testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_MEGABIT;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Megabit";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_MEGABIT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_GIGABIT testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_GIGABIT;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Gigabit";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_GIGABIT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_BYTE testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_BYTE;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Byte";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_BYTE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_KILOBYTE testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_KILOBYTE;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Kilobyte";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_KILOBYTE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_MEGABYTE testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_MEGABYTE;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Megabyte";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_MEGABYTE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_GIGABYTE testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_GIGABYTE;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Gigabyte";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_GIGABYTE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_WORD testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_WORD;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Word";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_WORD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_DWORD testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_DWORD;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Dword";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_DWORD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_QWORD testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_QWORD;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Qword";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_QWORD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_LINE testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_LINE;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Line";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_LINE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_HIT testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_HIT;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Hit";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_HIT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_MISS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_MISS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Miss";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_MISS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_RETRY testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_RETRY;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Retry";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_RETRY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_RESET testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_RESET;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Reset";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_RESET != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_OVERRUN testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_OVERRUN;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Overrun";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_OVERRUN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_UNDERRUN testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_UNDERRUN;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Underrun";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_UNDERRUN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_COLLISION testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_COLLISION;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Collision";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_COLLISION != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_PACKETS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_PACKETS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Packets";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_PACKETS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_MESSAGES testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_MESSAGES;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Messages";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_MESSAGES != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_CHARACTERS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_CHARACTERS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Characters";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_CHARACTERS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_ERRORS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_ERRORS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Errors";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_ERRORS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_CORRECTABLE_ERRORS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_CORRECTABLE_ERRORS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Correctable Errors";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_CORRECTABLE_ERRORS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - SAHPI_SU_UNCORRECTABLE_ERRORS testcase */
        {
	        SaHpiSensorUnitsT value = SAHPI_SU_UNCORRECTABLE_ERRORS;
		SaHpiSensorUnitsT enum_type;
                expected_str = "Uncorrectable Errors";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensorunits(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SU_UNCORRECTABLE_ERRORS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorUnitsT - Default testcase */
        {
	        SaHpiSensorUnitsT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_sensorunits(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiSensorUnitsT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiSensorUnitsT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_sensorunits(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiSensorUnitsT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_sensorunits(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiSensorModUnitUseT - SAHPI_SMUU_NONE testcase */
        {
	        SaHpiSensorModUnitUseT value = SAHPI_SMUU_NONE;
		SaHpiSensorModUnitUseT enum_type;
                expected_str = "NONE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensormodunituse(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensormodunituse(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SMUU_NONE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorModUnitUseT - SAHPI_SMUU_BASIC_OVER_MODIFIER testcase */
        {
	        SaHpiSensorModUnitUseT value = SAHPI_SMUU_BASIC_OVER_MODIFIER;
		SaHpiSensorModUnitUseT enum_type;
                expected_str = "BASIC_OVER_MODIFIER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensormodunituse(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensormodunituse(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SMUU_BASIC_OVER_MODIFIER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorModUnitUseT - SAHPI_SMUU_BASIC_TIMES_MODIFIER testcase */
        {
	        SaHpiSensorModUnitUseT value = SAHPI_SMUU_BASIC_TIMES_MODIFIER;
		SaHpiSensorModUnitUseT enum_type;
                expected_str = "BASIC_TIMES_MODIFIER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensormodunituse(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensormodunituse(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SMUU_BASIC_TIMES_MODIFIER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorModUnitUseT - Default testcase */
        {
	        SaHpiSensorModUnitUseT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_sensormodunituse(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiSensorModUnitUseT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiSensorModUnitUseT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_sensormodunituse(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiSensorModUnitUseT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_sensormodunituse(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiSensorEventCtrlT - SAHPI_SEC_PER_EVENT testcase */
        {
	        SaHpiSensorEventCtrlT value = SAHPI_SEC_PER_EVENT;
		SaHpiSensorEventCtrlT enum_type;
                expected_str = "PER_EVENT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensoreventctrl(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensoreventctrl(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SEC_PER_EVENT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorEventCtrlT - SAHPI_SEC_READ_ONLY_MASKS testcase */
        {
	        SaHpiSensorEventCtrlT value = SAHPI_SEC_READ_ONLY_MASKS;
		SaHpiSensorEventCtrlT enum_type;
                expected_str = "READ_ONLY_MASKS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensoreventctrl(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensoreventctrl(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SEC_READ_ONLY_MASKS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorEventCtrlT - SAHPI_SEC_READ_ONLY testcase */
        {
	        SaHpiSensorEventCtrlT value = SAHPI_SEC_READ_ONLY;
		SaHpiSensorEventCtrlT enum_type;
                expected_str = "READ_ONLY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sensoreventctrl(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sensoreventctrl(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SEC_READ_ONLY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSensorEventCtrlT - Default testcase */
        {
	        SaHpiSensorEventCtrlT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_sensoreventctrl(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiSensorEventCtrlT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiSensorEventCtrlT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_sensoreventctrl(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiSensorEventCtrlT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_sensoreventctrl(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiCtrlTypeT - SAHPI_CTRL_TYPE_DIGITAL testcase */
        {
	        SaHpiCtrlTypeT value = SAHPI_CTRL_TYPE_DIGITAL;
		SaHpiCtrlTypeT enum_type;
                expected_str = "DIGITAL";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrltype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrltype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_TYPE_DIGITAL != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlTypeT - SAHPI_CTRL_TYPE_DISCRETE testcase */
        {
	        SaHpiCtrlTypeT value = SAHPI_CTRL_TYPE_DISCRETE;
		SaHpiCtrlTypeT enum_type;
                expected_str = "DISCRETE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrltype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrltype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_TYPE_DISCRETE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlTypeT - SAHPI_CTRL_TYPE_ANALOG testcase */
        {
	        SaHpiCtrlTypeT value = SAHPI_CTRL_TYPE_ANALOG;
		SaHpiCtrlTypeT enum_type;
                expected_str = "ANALOG";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrltype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrltype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_TYPE_ANALOG != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlTypeT - SAHPI_CTRL_TYPE_STREAM testcase */
        {
	        SaHpiCtrlTypeT value = SAHPI_CTRL_TYPE_STREAM;
		SaHpiCtrlTypeT enum_type;
                expected_str = "STREAM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrltype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrltype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_TYPE_STREAM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlTypeT - SAHPI_CTRL_TYPE_TEXT testcase */
        {
	        SaHpiCtrlTypeT value = SAHPI_CTRL_TYPE_TEXT;
		SaHpiCtrlTypeT enum_type;
                expected_str = "TEXT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrltype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrltype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_TYPE_TEXT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlTypeT - SAHPI_CTRL_TYPE_OEM testcase */
        {
	        SaHpiCtrlTypeT value = SAHPI_CTRL_TYPE_OEM;
		SaHpiCtrlTypeT enum_type;
                expected_str = "OEM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrltype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrltype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_TYPE_OEM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlTypeT - Default testcase */
        {
	        SaHpiCtrlTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_ctrltype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiCtrlTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiCtrlTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_ctrltype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiCtrlTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_ctrltype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiCtrlStateDigitalT - SAHPI_CTRL_STATE_OFF testcase */
        {
	        SaHpiCtrlStateDigitalT value = SAHPI_CTRL_STATE_OFF;
		SaHpiCtrlStateDigitalT enum_type;
                expected_str = "OFF";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrlstatedigital(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrlstatedigital(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_STATE_OFF != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlStateDigitalT - SAHPI_CTRL_STATE_ON testcase */
        {
	        SaHpiCtrlStateDigitalT value = SAHPI_CTRL_STATE_ON;
		SaHpiCtrlStateDigitalT enum_type;
                expected_str = "ON";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrlstatedigital(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrlstatedigital(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_STATE_ON != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlStateDigitalT - SAHPI_CTRL_STATE_PULSE_OFF testcase */
        {
	        SaHpiCtrlStateDigitalT value = SAHPI_CTRL_STATE_PULSE_OFF;
		SaHpiCtrlStateDigitalT enum_type;
                expected_str = "PULSE_OFF";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrlstatedigital(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrlstatedigital(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_STATE_PULSE_OFF != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlStateDigitalT - SAHPI_CTRL_STATE_PULSE_ON testcase */
        {
	        SaHpiCtrlStateDigitalT value = SAHPI_CTRL_STATE_PULSE_ON;
		SaHpiCtrlStateDigitalT enum_type;
                expected_str = "PULSE_ON";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrlstatedigital(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrlstatedigital(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_STATE_PULSE_ON != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlStateDigitalT - Default testcase */
        {
	        SaHpiCtrlStateDigitalT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_ctrlstatedigital(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiCtrlStateDigitalT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiCtrlStateDigitalT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_ctrlstatedigital(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiCtrlStateDigitalT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_ctrlstatedigital(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiCtrlModeT - SAHPI_CTRL_MODE_AUTO testcase */
        {
	        SaHpiCtrlModeT value = SAHPI_CTRL_MODE_AUTO;
		SaHpiCtrlModeT enum_type;
                expected_str = "AUTO";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrlmode(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrlmode(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_MODE_AUTO != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlModeT - SAHPI_CTRL_MODE_MANUAL testcase */
        {
	        SaHpiCtrlModeT value = SAHPI_CTRL_MODE_MANUAL;
		SaHpiCtrlModeT enum_type;
                expected_str = "MANUAL";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrlmode(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrlmode(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_MODE_MANUAL != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlModeT - Default testcase */
        {
	        SaHpiCtrlModeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_ctrlmode(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiCtrlModeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiCtrlModeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_ctrlmode(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiCtrlModeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_ctrlmode(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiCtrlOutputTypeT - SAHPI_CTRL_GENERIC testcase */
        {
	        SaHpiCtrlOutputTypeT value = SAHPI_CTRL_GENERIC;
		SaHpiCtrlOutputTypeT enum_type;
                expected_str = "GENERIC";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrloutputtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrloutputtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_GENERIC != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlOutputTypeT - SAHPI_CTRL_LED testcase */
        {
	        SaHpiCtrlOutputTypeT value = SAHPI_CTRL_LED;
		SaHpiCtrlOutputTypeT enum_type;
                expected_str = "LED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrloutputtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrloutputtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_LED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlOutputTypeT - SAHPI_CTRL_FAN_SPEED testcase */
        {
	        SaHpiCtrlOutputTypeT value = SAHPI_CTRL_FAN_SPEED;
		SaHpiCtrlOutputTypeT enum_type;
                expected_str = "FAN_SPEED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrloutputtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrloutputtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_FAN_SPEED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlOutputTypeT - SAHPI_CTRL_DRY_CONTACT_CLOSURE testcase */
        {
	        SaHpiCtrlOutputTypeT value = SAHPI_CTRL_DRY_CONTACT_CLOSURE;
		SaHpiCtrlOutputTypeT enum_type;
                expected_str = "DRY_CONTACT_CLOSURE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrloutputtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrloutputtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_DRY_CONTACT_CLOSURE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlOutputTypeT - SAHPI_CTRL_POWER_SUPPLY_INHIBIT testcase */
        {
	        SaHpiCtrlOutputTypeT value = SAHPI_CTRL_POWER_SUPPLY_INHIBIT;
		SaHpiCtrlOutputTypeT enum_type;
                expected_str = "POWER_SUPPLY_INHIBIT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrloutputtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrloutputtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_POWER_SUPPLY_INHIBIT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlOutputTypeT - SAHPI_CTRL_AUDIBLE testcase */
        {
	        SaHpiCtrlOutputTypeT value = SAHPI_CTRL_AUDIBLE;
		SaHpiCtrlOutputTypeT enum_type;
                expected_str = "AUDIBLE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrloutputtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrloutputtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_AUDIBLE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlOutputTypeT - SAHPI_CTRL_FRONT_PANEL_LOCKOUT testcase */
        {
	        SaHpiCtrlOutputTypeT value = SAHPI_CTRL_FRONT_PANEL_LOCKOUT;
		SaHpiCtrlOutputTypeT enum_type;
                expected_str = "FRONT_PANEL_LOCKOUT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrloutputtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrloutputtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_FRONT_PANEL_LOCKOUT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlOutputTypeT - SAHPI_CTRL_POWER_INTERLOCK testcase */
        {
	        SaHpiCtrlOutputTypeT value = SAHPI_CTRL_POWER_INTERLOCK;
		SaHpiCtrlOutputTypeT enum_type;
                expected_str = "POWER_INTERLOCK";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrloutputtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrloutputtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_POWER_INTERLOCK != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlOutputTypeT - SAHPI_CTRL_POWER_STATE testcase */
        {
	        SaHpiCtrlOutputTypeT value = SAHPI_CTRL_POWER_STATE;
		SaHpiCtrlOutputTypeT enum_type;
                expected_str = "POWER_STATE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrloutputtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrloutputtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_POWER_STATE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlOutputTypeT - SAHPI_CTRL_LCD_DISPLAY testcase */
        {
	        SaHpiCtrlOutputTypeT value = SAHPI_CTRL_LCD_DISPLAY;
		SaHpiCtrlOutputTypeT enum_type;
                expected_str = "LCD_DISPLAY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrloutputtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrloutputtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_LCD_DISPLAY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlOutputTypeT - SAHPI_CTRL_OEM testcase */
        {
	        SaHpiCtrlOutputTypeT value = SAHPI_CTRL_OEM;
		SaHpiCtrlOutputTypeT enum_type;
                expected_str = "OEM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_ctrloutputtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_ctrloutputtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_OEM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiCtrlOutputTypeT - Default testcase */
        {
	        SaHpiCtrlOutputTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_ctrloutputtype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiCtrlOutputTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiCtrlOutputTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_ctrloutputtype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiCtrlOutputTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_ctrloutputtype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiIdrAreaTypeT - SAHPI_IDR_AREATYPE_INTERNAL_USE testcase */
        {
	        SaHpiIdrAreaTypeT value = SAHPI_IDR_AREATYPE_INTERNAL_USE;
		SaHpiIdrAreaTypeT enum_type;
                expected_str = "INTERNAL_USE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrareatype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrareatype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_AREATYPE_INTERNAL_USE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrAreaTypeT - SAHPI_IDR_AREATYPE_CHASSIS_INFO testcase */
        {
	        SaHpiIdrAreaTypeT value = SAHPI_IDR_AREATYPE_CHASSIS_INFO;
		SaHpiIdrAreaTypeT enum_type;
                expected_str = "CHASSIS_INFO";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrareatype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrareatype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_AREATYPE_CHASSIS_INFO != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrAreaTypeT - SAHPI_IDR_AREATYPE_BOARD_INFO testcase */
        {
	        SaHpiIdrAreaTypeT value = SAHPI_IDR_AREATYPE_BOARD_INFO;
		SaHpiIdrAreaTypeT enum_type;
                expected_str = "BOARD_INFO";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrareatype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrareatype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_AREATYPE_BOARD_INFO != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrAreaTypeT - SAHPI_IDR_AREATYPE_PRODUCT_INFO testcase */
        {
	        SaHpiIdrAreaTypeT value = SAHPI_IDR_AREATYPE_PRODUCT_INFO;
		SaHpiIdrAreaTypeT enum_type;
                expected_str = "PRODUCT_INFO";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrareatype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrareatype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_AREATYPE_PRODUCT_INFO != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrAreaTypeT - SAHPI_IDR_AREATYPE_OEM testcase */
        {
	        SaHpiIdrAreaTypeT value = SAHPI_IDR_AREATYPE_OEM;
		SaHpiIdrAreaTypeT enum_type;
                expected_str = "OEM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrareatype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrareatype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_AREATYPE_OEM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrAreaTypeT - SAHPI_IDR_AREATYPE_UNSPECIFIED testcase */
        {
	        SaHpiIdrAreaTypeT value = SAHPI_IDR_AREATYPE_UNSPECIFIED;
		SaHpiIdrAreaTypeT enum_type;
                expected_str = "UNSPECIFIED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrareatype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrareatype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_AREATYPE_UNSPECIFIED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrAreaTypeT - Default testcase */
        {
	        SaHpiIdrAreaTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_idrareatype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiIdrAreaTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiIdrAreaTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_idrareatype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiIdrAreaTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_idrareatype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiIdrFieldTypeT - SAHPI_IDR_FIELDTYPE_CHASSIS_TYPE testcase */
        {
	        SaHpiIdrFieldTypeT value = SAHPI_IDR_FIELDTYPE_CHASSIS_TYPE;
		SaHpiIdrFieldTypeT enum_type;
                expected_str = "CHASSIS_TYPE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrfieldtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrfieldtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_FIELDTYPE_CHASSIS_TYPE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrFieldTypeT - SAHPI_IDR_FIELDTYPE_MFG_DATETIME testcase */
        {
	        SaHpiIdrFieldTypeT value = SAHPI_IDR_FIELDTYPE_MFG_DATETIME;
		SaHpiIdrFieldTypeT enum_type;
                expected_str = "MFG_DATETIME";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrfieldtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrfieldtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_FIELDTYPE_MFG_DATETIME != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrFieldTypeT - SAHPI_IDR_FIELDTYPE_MANUFACTURER testcase */
        {
	        SaHpiIdrFieldTypeT value = SAHPI_IDR_FIELDTYPE_MANUFACTURER;
		SaHpiIdrFieldTypeT enum_type;
                expected_str = "MANUFACTURER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrfieldtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrfieldtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_FIELDTYPE_MANUFACTURER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrFieldTypeT - SAHPI_IDR_FIELDTYPE_PRODUCT_NAME testcase */
        {
	        SaHpiIdrFieldTypeT value = SAHPI_IDR_FIELDTYPE_PRODUCT_NAME;
		SaHpiIdrFieldTypeT enum_type;
                expected_str = "PRODUCT_NAME";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrfieldtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrfieldtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_FIELDTYPE_PRODUCT_NAME != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrFieldTypeT - SAHPI_IDR_FIELDTYPE_PRODUCT_VERSION testcase */
        {
	        SaHpiIdrFieldTypeT value = SAHPI_IDR_FIELDTYPE_PRODUCT_VERSION;
		SaHpiIdrFieldTypeT enum_type;
                expected_str = "PRODUCT_VERSION";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrfieldtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrfieldtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_FIELDTYPE_PRODUCT_VERSION != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrFieldTypeT - SAHPI_IDR_FIELDTYPE_SERIAL_NUMBER testcase */
        {
	        SaHpiIdrFieldTypeT value = SAHPI_IDR_FIELDTYPE_SERIAL_NUMBER;
		SaHpiIdrFieldTypeT enum_type;
                expected_str = "SERIAL_NUMBER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrfieldtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrfieldtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_FIELDTYPE_SERIAL_NUMBER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrFieldTypeT - SAHPI_IDR_FIELDTYPE_PART_NUMBER testcase */
        {
	        SaHpiIdrFieldTypeT value = SAHPI_IDR_FIELDTYPE_PART_NUMBER;
		SaHpiIdrFieldTypeT enum_type;
                expected_str = "PART_NUMBER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrfieldtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrfieldtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_FIELDTYPE_PART_NUMBER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrFieldTypeT - SAHPI_IDR_FIELDTYPE_FILE_ID testcase */
        {
	        SaHpiIdrFieldTypeT value = SAHPI_IDR_FIELDTYPE_FILE_ID;
		SaHpiIdrFieldTypeT enum_type;
                expected_str = "FILE_ID";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrfieldtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrfieldtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_FIELDTYPE_FILE_ID != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrFieldTypeT - SAHPI_IDR_FIELDTYPE_ASSET_TAG testcase */
        {
	        SaHpiIdrFieldTypeT value = SAHPI_IDR_FIELDTYPE_ASSET_TAG;
		SaHpiIdrFieldTypeT enum_type;
                expected_str = "ASSET_TAG";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrfieldtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrfieldtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_FIELDTYPE_ASSET_TAG != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrFieldTypeT - SAHPI_IDR_FIELDTYPE_CUSTOM testcase */
        {
	        SaHpiIdrFieldTypeT value = SAHPI_IDR_FIELDTYPE_CUSTOM;
		SaHpiIdrFieldTypeT enum_type;
                expected_str = "CUSTOM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrfieldtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrfieldtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_FIELDTYPE_CUSTOM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrFieldTypeT - SAHPI_IDR_FIELDTYPE_UNSPECIFIED testcase */
        {
	        SaHpiIdrFieldTypeT value = SAHPI_IDR_FIELDTYPE_UNSPECIFIED;
		SaHpiIdrFieldTypeT enum_type;
                expected_str = "UNSPECIFIED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_idrfieldtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_idrfieldtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_IDR_FIELDTYPE_UNSPECIFIED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiIdrFieldTypeT - Default testcase */
        {
	        SaHpiIdrFieldTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_idrfieldtype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiIdrFieldTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiIdrFieldTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_idrfieldtype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiIdrFieldTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_idrfieldtype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiWatchdogActionT - SAHPI_WA_NO_ACTION testcase */
        {
	        SaHpiWatchdogActionT value = SAHPI_WA_NO_ACTION;
		SaHpiWatchdogActionT enum_type;
                expected_str = "NO_ACTION";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WA_NO_ACTION != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogActionT - SAHPI_WA_RESET testcase */
        {
	        SaHpiWatchdogActionT value = SAHPI_WA_RESET;
		SaHpiWatchdogActionT enum_type;
                expected_str = "RESET";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WA_RESET != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogActionT - SAHPI_WA_POWER_DOWN testcase */
        {
	        SaHpiWatchdogActionT value = SAHPI_WA_POWER_DOWN;
		SaHpiWatchdogActionT enum_type;
                expected_str = "POWER_DOWN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WA_POWER_DOWN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogActionT - SAHPI_WA_POWER_CYCLE testcase */
        {
	        SaHpiWatchdogActionT value = SAHPI_WA_POWER_CYCLE;
		SaHpiWatchdogActionT enum_type;
                expected_str = "POWER_CYCLE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WA_POWER_CYCLE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogActionT - Default testcase */
        {
	        SaHpiWatchdogActionT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_watchdogaction(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiWatchdogActionT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiWatchdogActionT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_watchdogaction(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiWatchdogActionT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_watchdogaction(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiWatchdogActionEventT - SAHPI_WAE_NO_ACTION testcase */
        {
	        SaHpiWatchdogActionEventT value = SAHPI_WAE_NO_ACTION;
		SaHpiWatchdogActionEventT enum_type;
                expected_str = "NO_ACTION";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogactionevent(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogactionevent(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WAE_NO_ACTION != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogActionEventT - SAHPI_WAE_RESET testcase */
        {
	        SaHpiWatchdogActionEventT value = SAHPI_WAE_RESET;
		SaHpiWatchdogActionEventT enum_type;
                expected_str = "RESET";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogactionevent(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogactionevent(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WAE_RESET != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogActionEventT - SAHPI_WAE_POWER_DOWN testcase */
        {
	        SaHpiWatchdogActionEventT value = SAHPI_WAE_POWER_DOWN;
		SaHpiWatchdogActionEventT enum_type;
                expected_str = "POWER_DOWN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogactionevent(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogactionevent(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WAE_POWER_DOWN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogActionEventT - SAHPI_WAE_POWER_CYCLE testcase */
        {
	        SaHpiWatchdogActionEventT value = SAHPI_WAE_POWER_CYCLE;
		SaHpiWatchdogActionEventT enum_type;
                expected_str = "POWER_CYCLE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogactionevent(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogactionevent(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WAE_POWER_CYCLE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogActionEventT - SAHPI_WAE_TIMER_INT testcase */
        {
	        SaHpiWatchdogActionEventT value = SAHPI_WAE_TIMER_INT;
		SaHpiWatchdogActionEventT enum_type;
                expected_str = "TIMER_INT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogactionevent(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogactionevent(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WAE_TIMER_INT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogActionEventT - Default testcase */
        {
	        SaHpiWatchdogActionEventT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_watchdogactionevent(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiWatchdogActionEventT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiWatchdogActionEventT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_watchdogactionevent(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiWatchdogActionEventT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_watchdogactionevent(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiWatchdogPretimerInterruptT - SAHPI_WPI_NONE testcase */
        {
	        SaHpiWatchdogPretimerInterruptT value = SAHPI_WPI_NONE;
		SaHpiWatchdogPretimerInterruptT enum_type;
                expected_str = "NONE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogpretimerinterrupt(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogpretimerinterrupt(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WPI_NONE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogPretimerInterruptT - SAHPI_WPI_SMI testcase */
        {
	        SaHpiWatchdogPretimerInterruptT value = SAHPI_WPI_SMI;
		SaHpiWatchdogPretimerInterruptT enum_type;
                expected_str = "SMI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogpretimerinterrupt(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogpretimerinterrupt(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WPI_SMI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogPretimerInterruptT - SAHPI_WPI_NMI testcase */
        {
	        SaHpiWatchdogPretimerInterruptT value = SAHPI_WPI_NMI;
		SaHpiWatchdogPretimerInterruptT enum_type;
                expected_str = "NMI";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogpretimerinterrupt(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogpretimerinterrupt(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WPI_NMI != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogPretimerInterruptT - SAHPI_WPI_MESSAGE_INTERRUPT testcase */
        {
	        SaHpiWatchdogPretimerInterruptT value = SAHPI_WPI_MESSAGE_INTERRUPT;
		SaHpiWatchdogPretimerInterruptT enum_type;
                expected_str = "MESSAGE_INTERRUPT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogpretimerinterrupt(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogpretimerinterrupt(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WPI_MESSAGE_INTERRUPT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogPretimerInterruptT - SAHPI_WPI_OEM testcase */
        {
	        SaHpiWatchdogPretimerInterruptT value = SAHPI_WPI_OEM;
		SaHpiWatchdogPretimerInterruptT enum_type;
                expected_str = "OEM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogpretimerinterrupt(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogpretimerinterrupt(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WPI_OEM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogPretimerInterruptT - Default testcase */
        {
	        SaHpiWatchdogPretimerInterruptT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_watchdogpretimerinterrupt(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiWatchdogPretimerInterruptT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiWatchdogPretimerInterruptT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_watchdogpretimerinterrupt(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiWatchdogPretimerInterruptT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_watchdogpretimerinterrupt(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiWatchdogTimerUseT - SAHPI_WTU_NONE testcase */
        {
	        SaHpiWatchdogTimerUseT value = SAHPI_WTU_NONE;
		SaHpiWatchdogTimerUseT enum_type;
                expected_str = "NONE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogtimeruse(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogtimeruse(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WTU_NONE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogTimerUseT - SAHPI_WTU_BIOS_FRB2 testcase */
        {
	        SaHpiWatchdogTimerUseT value = SAHPI_WTU_BIOS_FRB2;
		SaHpiWatchdogTimerUseT enum_type;
                expected_str = "BIOS_FRB2";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogtimeruse(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogtimeruse(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WTU_BIOS_FRB2 != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogTimerUseT - SAHPI_WTU_BIOS_POST testcase */
        {
	        SaHpiWatchdogTimerUseT value = SAHPI_WTU_BIOS_POST;
		SaHpiWatchdogTimerUseT enum_type;
                expected_str = "BIOS_POST";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogtimeruse(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogtimeruse(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WTU_BIOS_POST != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogTimerUseT - SAHPI_WTU_OS_LOAD testcase */
        {
	        SaHpiWatchdogTimerUseT value = SAHPI_WTU_OS_LOAD;
		SaHpiWatchdogTimerUseT enum_type;
                expected_str = "OS_LOAD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogtimeruse(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogtimeruse(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WTU_OS_LOAD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogTimerUseT - SAHPI_WTU_SMS_OS testcase */
        {
	        SaHpiWatchdogTimerUseT value = SAHPI_WTU_SMS_OS;
		SaHpiWatchdogTimerUseT enum_type;
                expected_str = "SMS_OS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogtimeruse(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogtimeruse(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WTU_SMS_OS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogTimerUseT - SAHPI_WTU_OEM testcase */
        {
	        SaHpiWatchdogTimerUseT value = SAHPI_WTU_OEM;
		SaHpiWatchdogTimerUseT enum_type;
                expected_str = "OEM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogtimeruse(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogtimeruse(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WTU_OEM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogTimerUseT - SAHPI_WTU_UNSPECIFIED testcase */
        {
	        SaHpiWatchdogTimerUseT value = SAHPI_WTU_UNSPECIFIED;
		SaHpiWatchdogTimerUseT enum_type;
                expected_str = "UNSPECIFIED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_watchdogtimeruse(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_watchdogtimeruse(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WTU_UNSPECIFIED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiWatchdogTimerUseT - Default testcase */
        {
	        SaHpiWatchdogTimerUseT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_watchdogtimeruse(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiWatchdogTimerUseT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiWatchdogTimerUseT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_watchdogtimeruse(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiWatchdogTimerUseT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_watchdogtimeruse(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiHsIndicatorStateT - SAHPI_HS_INDICATOR_OFF testcase */
        {
	        SaHpiHsIndicatorStateT value = SAHPI_HS_INDICATOR_OFF;
		SaHpiHsIndicatorStateT enum_type;
                expected_str = "OFF";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_hsindicatorstate(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_hsindicatorstate(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_HS_INDICATOR_OFF != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiHsIndicatorStateT - SAHPI_HS_INDICATOR_ON testcase */
        {
	        SaHpiHsIndicatorStateT value = SAHPI_HS_INDICATOR_ON;
		SaHpiHsIndicatorStateT enum_type;
                expected_str = "ON";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_hsindicatorstate(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_hsindicatorstate(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_HS_INDICATOR_ON != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiHsIndicatorStateT - Default testcase */
        {
	        SaHpiHsIndicatorStateT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_hsindicatorstate(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiHsIndicatorStateT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiHsIndicatorStateT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_hsindicatorstate(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiHsIndicatorStateT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_hsindicatorstate(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiHsActionT - SAHPI_HS_ACTION_INSERTION testcase */
        {
	        SaHpiHsActionT value = SAHPI_HS_ACTION_INSERTION;
		SaHpiHsActionT enum_type;
                expected_str = "INSERTION";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_hsaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_hsaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_HS_ACTION_INSERTION != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiHsActionT - SAHPI_HS_ACTION_EXTRACTION testcase */
        {
	        SaHpiHsActionT value = SAHPI_HS_ACTION_EXTRACTION;
		SaHpiHsActionT enum_type;
                expected_str = "EXTRACTION";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_hsaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_hsaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_HS_ACTION_EXTRACTION != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiHsActionT - Default testcase */
        {
	        SaHpiHsActionT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_hsaction(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiHsActionT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiHsActionT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_hsaction(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiHsActionT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_hsaction(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiHsStateT - SAHPI_HS_STATE_INACTIVE testcase */
        {
	        SaHpiHsStateT value = SAHPI_HS_STATE_INACTIVE;
		SaHpiHsStateT enum_type;
                expected_str = "INACTIVE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_hsstate(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_hsstate(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_HS_STATE_INACTIVE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiHsStateT - SAHPI_HS_STATE_INSERTION_PENDING testcase */
        {
	        SaHpiHsStateT value = SAHPI_HS_STATE_INSERTION_PENDING;
		SaHpiHsStateT enum_type;
                expected_str = "INSERTION_PENDING";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_hsstate(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_hsstate(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_HS_STATE_INSERTION_PENDING != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiHsStateT - SAHPI_HS_STATE_ACTIVE testcase */
        {
	        SaHpiHsStateT value = SAHPI_HS_STATE_ACTIVE;
		SaHpiHsStateT enum_type;
                expected_str = "ACTIVE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_hsstate(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_hsstate(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_HS_STATE_ACTIVE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiHsStateT - SAHPI_HS_STATE_EXTRACTION_PENDING testcase */
        {
	        SaHpiHsStateT value = SAHPI_HS_STATE_EXTRACTION_PENDING;
		SaHpiHsStateT enum_type;
                expected_str = "EXTRACTION_PENDING";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_hsstate(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_hsstate(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_HS_STATE_EXTRACTION_PENDING != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiHsStateT - SAHPI_HS_STATE_NOT_PRESENT testcase */
        {
	        SaHpiHsStateT value = SAHPI_HS_STATE_NOT_PRESENT;
		SaHpiHsStateT enum_type;
                expected_str = "NOT_PRESENT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_hsstate(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_hsstate(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_HS_STATE_NOT_PRESENT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiHsStateT - Default testcase */
        {
	        SaHpiHsStateT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_hsstate(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiHsStateT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiHsStateT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_hsstate(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiHsStateT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_hsstate(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiSeverityT - SAHPI_CRITICAL testcase */
        {
	        SaHpiSeverityT value = SAHPI_CRITICAL;
		SaHpiSeverityT enum_type;
                expected_str = "CRITICAL";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_severity(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_severity(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CRITICAL != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSeverityT - SAHPI_MAJOR testcase */
        {
	        SaHpiSeverityT value = SAHPI_MAJOR;
		SaHpiSeverityT enum_type;
                expected_str = "MAJOR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_severity(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_severity(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_MAJOR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSeverityT - SAHPI_MINOR testcase */
        {
	        SaHpiSeverityT value = SAHPI_MINOR;
		SaHpiSeverityT enum_type;
                expected_str = "MINOR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_severity(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_severity(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_MINOR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSeverityT - SAHPI_INFORMATIONAL testcase */
        {
	        SaHpiSeverityT value = SAHPI_INFORMATIONAL;
		SaHpiSeverityT enum_type;
                expected_str = "INFORMATIONAL";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_severity(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_severity(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_INFORMATIONAL != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSeverityT - SAHPI_OK testcase */
        {
	        SaHpiSeverityT value = SAHPI_OK;
		SaHpiSeverityT enum_type;
                expected_str = "OK";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_severity(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_severity(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_OK != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSeverityT - SAHPI_DEBUG testcase */
        {
	        SaHpiSeverityT value = SAHPI_DEBUG;
		SaHpiSeverityT enum_type;
                expected_str = "DEBUG";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_severity(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_severity(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_DEBUG != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSeverityT - SAHPI_ALL_SEVERITIES testcase */
        {
	        SaHpiSeverityT value = SAHPI_ALL_SEVERITIES;
		SaHpiSeverityT enum_type;
                expected_str = "ALL_SEVERITIES";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_severity(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_severity(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ALL_SEVERITIES != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSeverityT - Default testcase */
        {
	        SaHpiSeverityT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_severity(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiSeverityT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiSeverityT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_severity(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiSeverityT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_severity(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiResourceEventTypeT - SAHPI_RESE_RESOURCE_FAILURE testcase */
        {
	        SaHpiResourceEventTypeT value = SAHPI_RESE_RESOURCE_FAILURE;
		SaHpiResourceEventTypeT enum_type;
                expected_str = "FAILURE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_resourceeventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_resourceeventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_RESE_RESOURCE_FAILURE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiResourceEventTypeT - SAHPI_RESE_RESOURCE_RESTORED testcase */
        {
	        SaHpiResourceEventTypeT value = SAHPI_RESE_RESOURCE_RESTORED;
		SaHpiResourceEventTypeT enum_type;
                expected_str = "RESTORED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_resourceeventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_resourceeventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_RESE_RESOURCE_RESTORED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiResourceEventTypeT - SAHPI_RESE_RESOURCE_ADDED testcase */
        {
	        SaHpiResourceEventTypeT value = SAHPI_RESE_RESOURCE_ADDED;
		SaHpiResourceEventTypeT enum_type;
                expected_str = "ADDED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_resourceeventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_resourceeventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_RESE_RESOURCE_ADDED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiResourceEventTypeT - Default testcase */
        {
	        SaHpiResourceEventTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_resourceeventtype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiResourceEventTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiResourceEventTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_resourceeventtype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiResourceEventTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_resourceeventtype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiDomainEventTypeT - SAHPI_DOMAIN_REF_ADDED testcase */
        {
	        SaHpiDomainEventTypeT value = SAHPI_DOMAIN_REF_ADDED;
		SaHpiDomainEventTypeT enum_type;
                expected_str = "ADDED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_domaineventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_domaineventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_DOMAIN_REF_ADDED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiDomainEventTypeT - SAHPI_DOMAIN_REF_REMOVED testcase */
        {
	        SaHpiDomainEventTypeT value = SAHPI_DOMAIN_REF_REMOVED;
		SaHpiDomainEventTypeT enum_type;
                expected_str = "REMOVED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_domaineventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_domaineventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_DOMAIN_REF_REMOVED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiDomainEventTypeT - Default testcase */
        {
	        SaHpiDomainEventTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_domaineventtype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiDomainEventTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiDomainEventTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_domaineventtype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiDomainEventTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_domaineventtype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiSwEventTypeT - SAHPI_HPIE_AUDIT testcase */
        {
	        SaHpiSwEventTypeT value = SAHPI_HPIE_AUDIT;
		SaHpiSwEventTypeT enum_type;
                expected_str = "AUDIT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sweventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sweventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_HPIE_AUDIT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSwEventTypeT - SAHPI_HPIE_STARTUP testcase */
        {
	        SaHpiSwEventTypeT value = SAHPI_HPIE_STARTUP;
		SaHpiSwEventTypeT enum_type;
                expected_str = "STARTUP";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sweventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sweventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_HPIE_STARTUP != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSwEventTypeT - SAHPI_HPIE_OTHER testcase */
        {
	        SaHpiSwEventTypeT value = SAHPI_HPIE_OTHER;
		SaHpiSwEventTypeT enum_type;
                expected_str = "OTHER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_sweventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_sweventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_HPIE_OTHER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiSwEventTypeT - Default testcase */
        {
	        SaHpiSwEventTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_sweventtype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiSwEventTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiSwEventTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_sweventtype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiSwEventTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_sweventtype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiEventTypeT - SAHPI_ET_RESOURCE testcase */
        {
	        SaHpiEventTypeT value = SAHPI_ET_RESOURCE;
		SaHpiEventTypeT enum_type;
                expected_str = "RESOURCE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ET_RESOURCE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventTypeT - SAHPI_ET_DOMAIN testcase */
        {
	        SaHpiEventTypeT value = SAHPI_ET_DOMAIN;
		SaHpiEventTypeT enum_type;
                expected_str = "DOMAIN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ET_DOMAIN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventTypeT - SAHPI_ET_SENSOR testcase */
        {
	        SaHpiEventTypeT value = SAHPI_ET_SENSOR;
		SaHpiEventTypeT enum_type;
                expected_str = "SENSOR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ET_SENSOR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventTypeT - SAHPI_ET_SENSOR_ENABLE_CHANGE testcase */
        {
	        SaHpiEventTypeT value = SAHPI_ET_SENSOR_ENABLE_CHANGE;
		SaHpiEventTypeT enum_type;
                expected_str = "SENSOR_ENABLE_CHANGE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ET_SENSOR_ENABLE_CHANGE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventTypeT - SAHPI_ET_HOTSWAP testcase */
        {
	        SaHpiEventTypeT value = SAHPI_ET_HOTSWAP;
		SaHpiEventTypeT enum_type;
                expected_str = "HOTSWAP";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ET_HOTSWAP != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventTypeT - SAHPI_ET_WATCHDOG testcase */
        {
	        SaHpiEventTypeT value = SAHPI_ET_WATCHDOG;
		SaHpiEventTypeT enum_type;
                expected_str = "WATCHDOG";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ET_WATCHDOG != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventTypeT - SAHPI_ET_HPI_SW testcase */
        {
	        SaHpiEventTypeT value = SAHPI_ET_HPI_SW;
		SaHpiEventTypeT enum_type;
                expected_str = "HPI_SW";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ET_HPI_SW != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventTypeT - SAHPI_ET_OEM testcase */
        {
	        SaHpiEventTypeT value = SAHPI_ET_OEM;
		SaHpiEventTypeT enum_type;
                expected_str = "OEM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ET_OEM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventTypeT - SAHPI_ET_USER testcase */
        {
	        SaHpiEventTypeT value = SAHPI_ET_USER;
		SaHpiEventTypeT enum_type;
                expected_str = "USER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ET_USER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventTypeT - Default testcase */
        {
	        SaHpiEventTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_eventtype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiEventTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiEventTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_eventtype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiEventTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_eventtype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiStatusCondTypeT - SAHPI_STATUS_COND_TYPE_SENSOR testcase */
        {
	        SaHpiStatusCondTypeT value = SAHPI_STATUS_COND_TYPE_SENSOR;
		SaHpiStatusCondTypeT enum_type;
                expected_str = "SENSOR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_statuscondtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_statuscondtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_STATUS_COND_TYPE_SENSOR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiStatusCondTypeT - SAHPI_STATUS_COND_TYPE_RESOURCE testcase */
        {
	        SaHpiStatusCondTypeT value = SAHPI_STATUS_COND_TYPE_RESOURCE;
		SaHpiStatusCondTypeT enum_type;
                expected_str = "RESOURCE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_statuscondtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_statuscondtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_STATUS_COND_TYPE_RESOURCE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiStatusCondTypeT - SAHPI_STATUS_COND_TYPE_OEM testcase */
        {
	        SaHpiStatusCondTypeT value = SAHPI_STATUS_COND_TYPE_OEM;
		SaHpiStatusCondTypeT enum_type;
                expected_str = "OEM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_statuscondtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_statuscondtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_STATUS_COND_TYPE_OEM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiStatusCondTypeT - SAHPI_STATUS_COND_TYPE_USER testcase */
        {
	        SaHpiStatusCondTypeT value = SAHPI_STATUS_COND_TYPE_USER;
		SaHpiStatusCondTypeT enum_type;
                expected_str = "USER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_statuscondtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_statuscondtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_STATUS_COND_TYPE_USER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiStatusCondTypeT - Default testcase */
        {
	        SaHpiStatusCondTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_statuscondtype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiStatusCondTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiStatusCondTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_statuscondtype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiStatusCondTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_statuscondtype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiAnnunciatorModeT - SAHPI_ANNUNCIATOR_MODE_AUTO testcase */
        {
	        SaHpiAnnunciatorModeT value = SAHPI_ANNUNCIATOR_MODE_AUTO;
		SaHpiAnnunciatorModeT enum_type;
                expected_str = "AUTO";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_annunciatormode(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_annunciatormode(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ANNUNCIATOR_MODE_AUTO != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiAnnunciatorModeT - SAHPI_ANNUNCIATOR_MODE_USER testcase */
        {
	        SaHpiAnnunciatorModeT value = SAHPI_ANNUNCIATOR_MODE_USER;
		SaHpiAnnunciatorModeT enum_type;
                expected_str = "USER";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_annunciatormode(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_annunciatormode(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ANNUNCIATOR_MODE_USER != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiAnnunciatorModeT - SAHPI_ANNUNCIATOR_MODE_SHARED testcase */
        {
	        SaHpiAnnunciatorModeT value = SAHPI_ANNUNCIATOR_MODE_SHARED;
		SaHpiAnnunciatorModeT enum_type;
                expected_str = "SHARED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_annunciatormode(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_annunciatormode(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ANNUNCIATOR_MODE_SHARED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiAnnunciatorModeT - Default testcase */
        {
	        SaHpiAnnunciatorModeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_annunciatormode(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiAnnunciatorModeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiAnnunciatorModeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_annunciatormode(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiAnnunciatorModeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_annunciatormode(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiAnnunciatorTypeT - SAHPI_ANNUNCIATOR_TYPE_LED testcase */
        {
	        SaHpiAnnunciatorTypeT value = SAHPI_ANNUNCIATOR_TYPE_LED;
		SaHpiAnnunciatorTypeT enum_type;
                expected_str = "LED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_annunciatortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_annunciatortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ANNUNCIATOR_TYPE_LED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiAnnunciatorTypeT - SAHPI_ANNUNCIATOR_TYPE_DRY_CONTACT_CLOSURE testcase */
        {
	        SaHpiAnnunciatorTypeT value = SAHPI_ANNUNCIATOR_TYPE_DRY_CONTACT_CLOSURE;
		SaHpiAnnunciatorTypeT enum_type;
                expected_str = "DRY_CONTACT_CLOSURE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_annunciatortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_annunciatortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ANNUNCIATOR_TYPE_DRY_CONTACT_CLOSURE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiAnnunciatorTypeT - SAHPI_ANNUNCIATOR_TYPE_AUDIBLE testcase */
        {
	        SaHpiAnnunciatorTypeT value = SAHPI_ANNUNCIATOR_TYPE_AUDIBLE;
		SaHpiAnnunciatorTypeT enum_type;
                expected_str = "AUDIBLE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_annunciatortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_annunciatortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ANNUNCIATOR_TYPE_AUDIBLE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiAnnunciatorTypeT - SAHPI_ANNUNCIATOR_TYPE_LCD_DISPLAY testcase */
        {
	        SaHpiAnnunciatorTypeT value = SAHPI_ANNUNCIATOR_TYPE_LCD_DISPLAY;
		SaHpiAnnunciatorTypeT enum_type;
                expected_str = "LCD_DISPLAY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_annunciatortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_annunciatortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ANNUNCIATOR_TYPE_LCD_DISPLAY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiAnnunciatorTypeT - SAHPI_ANNUNCIATOR_TYPE_MESSAGE testcase */
        {
	        SaHpiAnnunciatorTypeT value = SAHPI_ANNUNCIATOR_TYPE_MESSAGE;
		SaHpiAnnunciatorTypeT enum_type;
                expected_str = "MESSAGE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_annunciatortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_annunciatortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ANNUNCIATOR_TYPE_MESSAGE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiAnnunciatorTypeT - SAHPI_ANNUNCIATOR_TYPE_COMPOSITE testcase */
        {
	        SaHpiAnnunciatorTypeT value = SAHPI_ANNUNCIATOR_TYPE_COMPOSITE;
		SaHpiAnnunciatorTypeT enum_type;
                expected_str = "COMPOSITE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_annunciatortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_annunciatortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ANNUNCIATOR_TYPE_COMPOSITE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiAnnunciatorTypeT - SAHPI_ANNUNCIATOR_TYPE_OEM testcase */
        {
	        SaHpiAnnunciatorTypeT value = SAHPI_ANNUNCIATOR_TYPE_OEM;
		SaHpiAnnunciatorTypeT enum_type;
                expected_str = "OEM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_annunciatortype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_annunciatortype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ANNUNCIATOR_TYPE_OEM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiAnnunciatorTypeT - Default testcase */
        {
	        SaHpiAnnunciatorTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_annunciatortype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiAnnunciatorTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiAnnunciatorTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_annunciatortype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiAnnunciatorTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_annunciatortype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiRdrTypeT - SAHPI_NO_RECORD testcase */
        {
	        SaHpiRdrTypeT value = SAHPI_NO_RECORD;
		SaHpiRdrTypeT enum_type;
                expected_str = "NO_RECORD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_rdrtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_rdrtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_NO_RECORD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiRdrTypeT - SAHPI_CTRL_RDR testcase */
        {
	        SaHpiRdrTypeT value = SAHPI_CTRL_RDR;
		SaHpiRdrTypeT enum_type;
                expected_str = "CTRL_RDR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_rdrtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_rdrtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_CTRL_RDR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiRdrTypeT - SAHPI_SENSOR_RDR testcase */
        {
	        SaHpiRdrTypeT value = SAHPI_SENSOR_RDR;
		SaHpiRdrTypeT enum_type;
                expected_str = "SENSOR_RDR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_rdrtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_rdrtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SENSOR_RDR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiRdrTypeT - SAHPI_INVENTORY_RDR testcase */
        {
	        SaHpiRdrTypeT value = SAHPI_INVENTORY_RDR;
		SaHpiRdrTypeT enum_type;
                expected_str = "INVENTORY_RDR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_rdrtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_rdrtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_INVENTORY_RDR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiRdrTypeT - SAHPI_WATCHDOG_RDR testcase */
        {
	        SaHpiRdrTypeT value = SAHPI_WATCHDOG_RDR;
		SaHpiRdrTypeT enum_type;
                expected_str = "WATCHDOG_RDR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_rdrtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_rdrtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WATCHDOG_RDR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiRdrTypeT - SAHPI_ANNUNCIATOR_RDR testcase */
        {
	        SaHpiRdrTypeT value = SAHPI_ANNUNCIATOR_RDR;
		SaHpiRdrTypeT enum_type;
                expected_str = "ANNUNCIATOR_RDR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_rdrtype(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_rdrtype(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_ANNUNCIATOR_RDR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiRdrTypeT - Default testcase */
        {
	        SaHpiRdrTypeT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_rdrtype(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiRdrTypeT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiRdrTypeT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_rdrtype(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiRdrTypeT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_rdrtype(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiParmActionT - SAHPI_DEFAULT_PARM testcase */
        {
	        SaHpiParmActionT value = SAHPI_DEFAULT_PARM;
		SaHpiParmActionT enum_type;
                expected_str = "DEFAULT_PARM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_parmaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_parmaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_DEFAULT_PARM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiParmActionT - SAHPI_SAVE_PARM testcase */
        {
	        SaHpiParmActionT value = SAHPI_SAVE_PARM;
		SaHpiParmActionT enum_type;
                expected_str = "SAVE_PARM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_parmaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_parmaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_SAVE_PARM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiParmActionT - SAHPI_RESTORE_PARM testcase */
        {
	        SaHpiParmActionT value = SAHPI_RESTORE_PARM;
		SaHpiParmActionT enum_type;
                expected_str = "RESTORE_PARM";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_parmaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_parmaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_RESTORE_PARM != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiParmActionT - Default testcase */
        {
	        SaHpiParmActionT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_parmaction(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiParmActionT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiParmActionT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_parmaction(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiParmActionT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_parmaction(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiResetActionT - SAHPI_COLD_RESET testcase */
        {
	        SaHpiResetActionT value = SAHPI_COLD_RESET;
		SaHpiResetActionT enum_type;
                expected_str = "COLD_RESET";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_resetaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_resetaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_COLD_RESET != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiResetActionT - SAHPI_WARM_RESET testcase */
        {
	        SaHpiResetActionT value = SAHPI_WARM_RESET;
		SaHpiResetActionT enum_type;
                expected_str = "WARM_RESET";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_resetaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_resetaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_WARM_RESET != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiResetActionT - SAHPI_RESET_ASSERT testcase */
        {
	        SaHpiResetActionT value = SAHPI_RESET_ASSERT;
		SaHpiResetActionT enum_type;
                expected_str = "RESET_ASSERT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_resetaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_resetaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_RESET_ASSERT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiResetActionT - SAHPI_RESET_DEASSERT testcase */
        {
	        SaHpiResetActionT value = SAHPI_RESET_DEASSERT;
		SaHpiResetActionT enum_type;
                expected_str = "RESET_DEASSERT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_resetaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_resetaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_RESET_DEASSERT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiResetActionT - Default testcase */
        {
	        SaHpiResetActionT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_resetaction(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiResetActionT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiResetActionT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_resetaction(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiResetActionT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_resetaction(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiPowerStateT - SAHPI_POWER_OFF testcase */
        {
	        SaHpiPowerStateT value = SAHPI_POWER_OFF;
		SaHpiPowerStateT enum_type;
                expected_str = "OFF";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_powerstate(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_powerstate(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_POWER_OFF != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiPowerStateT - SAHPI_POWER_ON testcase */
        {
	        SaHpiPowerStateT value = SAHPI_POWER_ON;
		SaHpiPowerStateT enum_type;
                expected_str = "ON";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_powerstate(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_powerstate(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_POWER_ON != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiPowerStateT - SAHPI_POWER_CYCLE testcase */
        {
	        SaHpiPowerStateT value = SAHPI_POWER_CYCLE;
		SaHpiPowerStateT enum_type;
                expected_str = "CYCLE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_powerstate(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_powerstate(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_POWER_CYCLE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiPowerStateT - Default testcase */
        {
	        SaHpiPowerStateT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_powerstate(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiPowerStateT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiPowerStateT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_powerstate(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiPowerStateT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_powerstate(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiEventLogOverflowActionT - SAHPI_EL_OVERFLOW_DROP testcase */
        {
	        SaHpiEventLogOverflowActionT value = SAHPI_EL_OVERFLOW_DROP;
		SaHpiEventLogOverflowActionT enum_type;
                expected_str = "OVERFLOW_DROP";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventlogoverflowaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventlogoverflowaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EL_OVERFLOW_DROP != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventLogOverflowActionT - SAHPI_EL_OVERFLOW_OVERWRITE testcase */
        {
	        SaHpiEventLogOverflowActionT value = SAHPI_EL_OVERFLOW_OVERWRITE;
		SaHpiEventLogOverflowActionT enum_type;
                expected_str = "OVERFLOW_OVERWRITE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventlogoverflowaction(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventlogoverflowaction(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EL_OVERFLOW_OVERWRITE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventLogOverflowActionT - Default testcase */
        {
	        SaHpiEventLogOverflowActionT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_eventlogoverflowaction(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiEventLogOverflowActionT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiEventLogOverflowActionT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_eventlogoverflowaction(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiEventLogOverflowActionT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_eventlogoverflowaction(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaErrorT - SA_OK testcase */
        {
	        SaErrorT value = SA_OK;
		SaErrorT enum_type;
                expected_str = "SA_OK";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_OK != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_ERROR testcase */
        {
	        SaErrorT value = SA_ERR_HPI_ERROR;
		SaErrorT enum_type;
                expected_str = "ERROR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_ERROR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_UNSUPPORTED_API testcase */
        {
	        SaErrorT value = SA_ERR_HPI_UNSUPPORTED_API;
		SaErrorT enum_type;
                expected_str = "UNSUPPORTED_API";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_UNSUPPORTED_API != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_BUSY testcase */
        {
	        SaErrorT value = SA_ERR_HPI_BUSY;
		SaErrorT enum_type;
                expected_str = "BUSY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_BUSY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_INTERNAL_ERROR testcase */
        {
	        SaErrorT value = SA_ERR_HPI_INTERNAL_ERROR;
		SaErrorT enum_type;
                expected_str = "INTERNAL_ERROR";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_INTERNAL_ERROR != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_INVALID_CMD testcase */
        {
	        SaErrorT value = SA_ERR_HPI_INVALID_CMD;
		SaErrorT enum_type;
                expected_str = "INVALID_CMD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_INVALID_CMD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_TIMEOUT testcase */
        {
	        SaErrorT value = SA_ERR_HPI_TIMEOUT;
		SaErrorT enum_type;
                expected_str = "TIMEOUT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_TIMEOUT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_OUT_OF_SPACE testcase */
        {
	        SaErrorT value = SA_ERR_HPI_OUT_OF_SPACE;
		SaErrorT enum_type;
                expected_str = "OUT_OF_SPACE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_OUT_OF_SPACE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_OUT_OF_MEMORY testcase */
        {
	        SaErrorT value = SA_ERR_HPI_OUT_OF_MEMORY;
		SaErrorT enum_type;
                expected_str = "OUT_OF_MEMORY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_OUT_OF_MEMORY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_INVALID_PARAMS testcase */
        {
	        SaErrorT value = SA_ERR_HPI_INVALID_PARAMS;
		SaErrorT enum_type;
                expected_str = "INVALID_PARAMS";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_INVALID_PARAMS != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_INVALID_DATA testcase */
        {
	        SaErrorT value = SA_ERR_HPI_INVALID_DATA;
		SaErrorT enum_type;
                expected_str = "INVALID_DATA";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_INVALID_DATA != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_NOT_PRESENT testcase */
        {
	        SaErrorT value = SA_ERR_HPI_NOT_PRESENT;
		SaErrorT enum_type;
                expected_str = "NOT_PRESENT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_NOT_PRESENT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_NO_RESPONSE testcase */
        {
	        SaErrorT value = SA_ERR_HPI_NO_RESPONSE;
		SaErrorT enum_type;
                expected_str = "NO_RESPONSE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_NO_RESPONSE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_DUPLICATE testcase */
        {
	        SaErrorT value = SA_ERR_HPI_DUPLICATE;
		SaErrorT enum_type;
                expected_str = "DUPLICATE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_DUPLICATE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_INVALID_SESSION testcase */
        {
	        SaErrorT value = SA_ERR_HPI_INVALID_SESSION;
		SaErrorT enum_type;
                expected_str = "INVALID_SESSION";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_INVALID_SESSION != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_INVALID_DOMAIN testcase */
        {
	        SaErrorT value = SA_ERR_HPI_INVALID_DOMAIN;
		SaErrorT enum_type;
                expected_str = "INVALID_DOMAIN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_INVALID_DOMAIN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_INVALID_RESOURCE testcase */
        {
	        SaErrorT value = SA_ERR_HPI_INVALID_RESOURCE;
		SaErrorT enum_type;
                expected_str = "INVALID_RESOURCE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_INVALID_RESOURCE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_INVALID_REQUEST testcase */
        {
	        SaErrorT value = SA_ERR_HPI_INVALID_REQUEST;
		SaErrorT enum_type;
                expected_str = "INVALID_REQUEST";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_INVALID_REQUEST != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_ENTITY_NOT_PRESENT testcase */
        {
	        SaErrorT value = SA_ERR_HPI_ENTITY_NOT_PRESENT;
		SaErrorT enum_type;
                expected_str = "ENTITY_NOT_PRESENT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_ENTITY_NOT_PRESENT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_READ_ONLY testcase */
        {
	        SaErrorT value = SA_ERR_HPI_READ_ONLY;
		SaErrorT enum_type;
                expected_str = "READ_ONLY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_READ_ONLY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_CAPABILITY testcase */
        {
	        SaErrorT value = SA_ERR_HPI_CAPABILITY;
		SaErrorT enum_type;
                expected_str = "CAPABILITY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_CAPABILITY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - SA_ERR_HPI_UNKNOWN testcase */
        {
	        SaErrorT value = SA_ERR_HPI_UNKNOWN;
		SaErrorT enum_type;
                expected_str = "UNKNOWN";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_error(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_error(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SA_ERR_HPI_UNKNOWN != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaErrorT - Default testcase */
        {
	        SaErrorT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_error(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaErrorT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaErrorT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_error(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaErrorT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_error(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - SAHPI_EC_UNSPECIFIED testcase */
        {
	        SaHpiEventCategoryT value = SAHPI_EC_UNSPECIFIED;
		SaHpiEventCategoryT enum_type;
                expected_str = "UNSPECIFIED";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventcategory(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EC_UNSPECIFIED != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - SAHPI_EC_THRESHOLD testcase */
        {
	        SaHpiEventCategoryT value = SAHPI_EC_THRESHOLD;
		SaHpiEventCategoryT enum_type;
                expected_str = "THRESHOLD";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventcategory(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EC_THRESHOLD != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - SAHPI_EC_USAGE testcase */
        {
	        SaHpiEventCategoryT value = SAHPI_EC_USAGE;
		SaHpiEventCategoryT enum_type;
                expected_str = "USAGE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventcategory(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EC_USAGE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - SAHPI_EC_STATE testcase */
        {
	        SaHpiEventCategoryT value = SAHPI_EC_STATE;
		SaHpiEventCategoryT enum_type;
                expected_str = "STATE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventcategory(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EC_STATE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - SAHPI_EC_PRED_FAIL testcase */
        {
	        SaHpiEventCategoryT value = SAHPI_EC_PRED_FAIL;
		SaHpiEventCategoryT enum_type;
                expected_str = "PRED_FAIL";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventcategory(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EC_PRED_FAIL != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - SAHPI_EC_LIMIT testcase */
        {
	        SaHpiEventCategoryT value = SAHPI_EC_LIMIT;
		SaHpiEventCategoryT enum_type;
                expected_str = "LIMIT";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventcategory(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EC_LIMIT != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - SAHPI_EC_PERFORMANCE testcase */
        {
	        SaHpiEventCategoryT value = SAHPI_EC_PERFORMANCE;
		SaHpiEventCategoryT enum_type;
                expected_str = "PERFORMANCE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventcategory(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EC_PERFORMANCE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - SAHPI_EC_SEVERITY testcase */
        {
	        SaHpiEventCategoryT value = SAHPI_EC_SEVERITY;
		SaHpiEventCategoryT enum_type;
                expected_str = "SEVERITY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventcategory(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EC_SEVERITY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - SAHPI_EC_PRESENCE testcase */
        {
	        SaHpiEventCategoryT value = SAHPI_EC_PRESENCE;
		SaHpiEventCategoryT enum_type;
                expected_str = "PRESENCE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventcategory(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EC_PRESENCE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - SAHPI_EC_ENABLE testcase */
        {
	        SaHpiEventCategoryT value = SAHPI_EC_ENABLE;
		SaHpiEventCategoryT enum_type;
                expected_str = "ENABLE";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventcategory(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EC_ENABLE != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - SAHPI_EC_AVAILABILITY testcase */
        {
	        SaHpiEventCategoryT value = SAHPI_EC_AVAILABILITY;
		SaHpiEventCategoryT enum_type;
                expected_str = "AVAILABILITY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventcategory(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EC_AVAILABILITY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - SAHPI_EC_REDUNDANCY testcase */
        {
	        SaHpiEventCategoryT value = SAHPI_EC_REDUNDANCY;
		SaHpiEventCategoryT enum_type;
                expected_str = "REDUNDANCY";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventcategory(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EC_REDUNDANCY != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - SAHPI_EC_SENSOR_SPECIFIC testcase */
        {
	        SaHpiEventCategoryT value = SAHPI_EC_SENSOR_SPECIFIC;
		SaHpiEventCategoryT enum_type;
                expected_str = "SENSOR_SPECIFIC";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventcategory(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EC_SENSOR_SPECIFIC != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - SAHPI_EC_GENERIC testcase */
        {
	        SaHpiEventCategoryT value = SAHPI_EC_GENERIC;
		SaHpiEventCategoryT enum_type;
                expected_str = "GENERIC";
		SaErrorT err;
		SaHpiTextBufferT buffer;

                str = oh_lookup_eventcategory(value);
                if (strcmp(expected_str, str)) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s\n", str);
			printf("  Expected string=%s\n", expected_str);
                        return -1;             
                }

		err = oh_init_textbuffer(&buffer);
		err = oh_append_textbuffer(&buffer, str);
		
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != SA_OK) {
		    printf("  Error! Testcase failed. Line=%d\n", __LINE__);
		    printf("  Received error=%d\n", err);
		    return -1;
                }
    
                if (SAHPI_EC_GENERIC != enum_type) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
                        printf("  Received enum type=%x\n", enum_type);
                        return -1;
                }
	}

        /* SaHpiEventCategoryT - Default testcase */
        {
	        SaHpiEventCategoryT value = BAD_ENUM_VALUE;
                expected_str = NULL;

                str = oh_lookup_eventcategory(value);
                if (str != expected_str) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received string=%s; Expected string=%s\n", str, expected_str); 
                        return -1;             
                }

	}
    
	{ 
                /* SaHpiEventCategoryT - NULL buffer testcase */
	        SaErrorT  err, expected_err;     
		SaHpiTextBufferT buffer;
		SaHpiEventCategoryT enum_type;

		expected_err = SA_ERR_HPI_INVALID_PARAMS;
                err = oh_encode_eventcategory(0, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	             	
                /* SaHpiEventCategoryT - Invalid type testcase */
		err = oh_init_textbuffer(&buffer);		
		err = oh_append_textbuffer(&buffer, "INVALID_TYPE");

		expected_err = SA_ERR_HPI_INVALID_DATA;
                err = oh_encode_eventcategory(&buffer, &enum_type);
                if (err != expected_err) {
                        printf("  Error! Testcase failed. Line=%d\n", __LINE__);
			printf("  Received error=%d; Expected error=%d\n", err, expected_err);
                        return -1;
                }
	}

        return 0;
}
