/*
 * Copyright 2003 Sun Microsystems, Inc.  All Rights Reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Sun Microsystems, Inc., 4150 Network Circle, Santa Clara,
 * CA 95054 USA or visit www.sun.com if you need additional information or
 * have any questions.
 */

/*
 * @test
 * @bug 4920023
 * @summary Test hex floating-point literals
 * @author darcy
 *
 * @compile -source 1.5 HexThree.java
 * @run main HexThree
 */

public class HexThree {

    public static void main(String argv[]) {
	double [] testValues = {
	    +0X.0030000000000P+12,
	    +0X.0030000000000P+12D,
	    +0X.0030000000000P+12F,
	    +0X.0030000000000P+12d,
	    +0X.0030000000000P+12f,
	    +0X.0030000000000P12,
	    +0X.0030000000000P12D,
	    +0X.0030000000000P12F,
	    +0X.0030000000000P12d,
	    +0X.0030000000000P12f,
	    +0X.0030000000000p+12,
	    +0X.0030000000000p+12D,
	    +0X.0030000000000p+12F,
	    +0X.0030000000000p+12d,
	    +0X.0030000000000p+12f,
	    +0X.0030000000000p12,
	    +0X.0030000000000p12D,
	    +0X.0030000000000p12F,
	    +0X.0030000000000p12d,
	    +0X.0030000000000p12f,
	    +0X.0030P+12,
	    +0X.0030P+12D,
	    +0X.0030P+12F,
	    +0X.0030P+12d,
	    +0X.0030P+12f,
	    +0X.0030P12,
	    +0X.0030P12D,
	    +0X.0030P12F,
	    +0X.0030P12d,
	    +0X.0030P12f,
	    +0X.0030p+12,
	    +0X.0030p+12D,
	    +0X.0030p+12F,
	    +0X.0030p+12d,
	    +0X.0030p+12f,
	    +0X.0030p12,
	    +0X.0030p12D,
	    +0X.0030p12F,
	    +0X.0030p12d,
	    +0X.0030p12f,
	    +0X.003P+12,
	    +0X.003P+12D,
	    +0X.003P+12F,
	    +0X.003P+12d,
	    +0X.003P+12f,
	    +0X.003P12,
	    +0X.003P12D,
	    +0X.003P12F,
	    +0X.003P12d,
	    +0X.003P12f,
	    +0X.003p+12,
	    +0X.003p+12D,
	    +0X.003p+12F,
	    +0X.003p+12d,
	    +0X.003p+12f,
	    +0X.003p12,
	    +0X.003p12D,
	    +0X.003p12F,
	    +0X.003p12d,
	    +0X.003p12f,
	    +0X.3P+4,
	    +0X.3P+4D,
	    +0X.3P+4F,
	    +0X.3P+4d,
	    +0X.3P+4f,
	    +0X.3P4,
	    +0X.3P4D,
	    +0X.3P4F,
	    +0X.3P4d,
	    +0X.3P4f,
	    +0X.3p+4,
	    +0X.3p+4D,
	    +0X.3p+4F,
	    +0X.3p+4d,
	    +0X.3p+4f,
	    +0X.3p4,
	    +0X.3p4D,
	    +0X.3p4F,
	    +0X.3p4d,
	    +0X.3p4f,
	    +0X.C0P+2,
	    +0X.C0P+2D,
	    +0X.C0P+2F,
	    +0X.C0P+2d,
	    +0X.C0P+2f,
	    +0X.C0P2,
	    +0X.C0P2D,
	    +0X.C0P2F,
	    +0X.C0P2d,
	    +0X.C0P2f,
	    +0X.C0p+2,
	    +0X.C0p+2D,
	    +0X.C0p+2F,
	    +0X.C0p+2d,
	    +0X.C0p+2f,
	    +0X.C0p2,
	    +0X.C0p2D,
	    +0X.C0p2F,
	    +0X.C0p2d,
	    +0X.C0p2f,
	    +0X.CP+2,
	    +0X.CP+2D,
	    +0X.CP+2F,
	    +0X.CP+2d,
	    +0X.CP+2f,
	    +0X.CP2,
	    +0X.CP2D,
	    +0X.CP2F,
	    +0X.CP2d,
	    +0X.CP2f,
	    +0X.Cp+2,
	    +0X.Cp+2D,
	    +0X.Cp+2F,
	    +0X.Cp+2d,
	    +0X.Cp+2f,
	    +0X.Cp2,
	    +0X.Cp2D,
	    +0X.Cp2F,
	    +0X.Cp2d,
	    +0X.Cp2f,
	    +0X.c0P+2,
	    +0X.c0P+2D,
	    +0X.c0P+2F,
	    +0X.c0P+2d,
	    +0X.c0P+2f,
	    +0X.c0P2,
	    +0X.c0P2D,
	    +0X.c0P2F,
	    +0X.c0P2d,
	    +0X.c0P2f,
	    +0X.c0p+2,
	    +0X.c0p+2D,
	    +0X.c0p+2F,
	    +0X.c0p+2d,
	    +0X.c0p+2f,
	    +0X.c0p2,
	    +0X.c0p2D,
	    +0X.c0p2F,
	    +0X.c0p2d,
	    +0X.c0p2f,
	    +0X.cP+2,
	    +0X.cP+2D,
	    +0X.cP+2F,
	    +0X.cP+2d,
	    +0X.cP+2f,
	    +0X.cP2,
	    +0X.cP2D,
	    +0X.cP2F,
	    +0X.cP2d,
	    +0X.cP2f,
	    +0X.cp+2,
	    +0X.cp+2D,
	    +0X.cp+2F,
	    +0X.cp+2d,
	    +0X.cp+2f,
	    +0X.cp2,
	    +0X.cp2D,
	    +0X.cp2F,
	    +0X.cp2d,
	    +0X.cp2f,
	    +0X0.30P+4,
	    +0X0.30P+4D,
	    +0X0.30P+4F,
	    +0X0.30P+4d,
	    +0X0.30P+4f,
	    +0X0.30P4,
	    +0X0.30P4D,
	    +0X0.30P4F,
	    +0X0.30P4d,
	    +0X0.30P4f,
	    +0X0.30p+4,
	    +0X0.30p+4D,
	    +0X0.30p+4F,
	    +0X0.30p+4d,
	    +0X0.30p+4f,
	    +0X0.30p4,
	    +0X0.30p4D,
	    +0X0.30p4F,
	    +0X0.30p4d,
	    +0X0.30p4f,
	    +0X0.3P+4,
	    +0X0.3P+4D,
	    +0X0.3P+4F,
	    +0X0.3P+4d,
	    +0X0.3P+4f,
	    +0X0.3P4,
	    +0X0.3P4D,
	    +0X0.3P4F,
	    +0X0.3P4d,
	    +0X0.3P4f,
	    +0X0.3p+4,
	    +0X0.3p+4D,
	    +0X0.3p+4F,
	    +0X0.3p+4d,
	    +0X0.3p+4f,
	    +0X0.3p4,
	    +0X0.3p4D,
	    +0X0.3p4F,
	    +0X0.3p4d,
	    +0X0.3p4f,
	    +0X0.C0P+2,
	    +0X0.C0P+2D,
	    +0X0.C0P+2F,
	    +0X0.C0P+2d,
	    +0X0.C0P+2f,
	    +0X0.C0P2,
	    +0X0.C0P2D,
	    +0X0.C0P2F,
	    +0X0.C0P2d,
	    +0X0.C0P2f,
	    +0X0.C0p+2,
	    +0X0.C0p+2D,
	    +0X0.C0p+2F,
	    +0X0.C0p+2d,
	    +0X0.C0p+2f,
	    +0X0.C0p2,
	    +0X0.C0p2D,
	    +0X0.C0p2F,
	    +0X0.C0p2d,
	    +0X0.C0p2f,
	    +0X0.CP+2,
	    +0X0.CP+2D,
	    +0X0.CP+2F,
	    +0X0.CP+2d,
	    +0X0.CP+2f,
	    +0X0.CP2,
	    +0X0.CP2D,
	    +0X0.CP2F,
	    +0X0.CP2d,
	    +0X0.CP2f,
	    +0X0.Cp+2,
	    +0X0.Cp+2D,
	    +0X0.Cp+2F,
	    +0X0.Cp+2d,
	    +0X0.Cp+2f,
	    +0X0.Cp2,
	    +0X0.Cp2D,
	    +0X0.Cp2F,
	    +0X0.Cp2d,
	    +0X0.Cp2f,
	    +0X0.c0P+2,
	    +0X0.c0P+2D,
	    +0X0.c0P+2F,
	    +0X0.c0P+2d,
	    +0X0.c0P+2f,
	    +0X0.c0P2,
	    +0X0.c0P2D,
	    +0X0.c0P2F,
	    +0X0.c0P2d,
	    +0X0.c0P2f,
	    +0X0.c0p+2,
	    +0X0.c0p+2D,
	    +0X0.c0p+2F,
	    +0X0.c0p+2d,
	    +0X0.c0p+2f,
	    +0X0.c0p2,
	    +0X0.c0p2D,
	    +0X0.c0p2F,
	    +0X0.c0p2d,
	    +0X0.c0p2f,
	    +0X0.cP+2,
	    +0X0.cP+2D,
	    +0X0.cP+2F,
	    +0X0.cP+2d,
	    +0X0.cP+2f,
	    +0X0.cP2,
	    +0X0.cP2D,
	    +0X0.cP2F,
	    +0X0.cP2d,
	    +0X0.cP2f,
	    +0X0.cp+2,
	    +0X0.cp+2D,
	    +0X0.cp+2F,
	    +0X0.cp+2d,
	    +0X0.cp+2f,
	    +0X0.cp2,
	    +0X0.cp2D,
	    +0X0.cp2F,
	    +0X0.cp2d,
	    +0X0.cp2f,
	    +0X000000000.0030000000000P+12,
	    +0X000000000.0030000000000P+12D,
	    +0X000000000.0030000000000P+12F,
	    +0X000000000.0030000000000P+12d,
	    +0X000000000.0030000000000P+12f,
	    +0X000000000.0030000000000P12,
	    +0X000000000.0030000000000P12D,
	    +0X000000000.0030000000000P12F,
	    +0X000000000.0030000000000P12d,
	    +0X000000000.0030000000000P12f,
	    +0X000000000.0030000000000p+12,
	    +0X000000000.0030000000000p+12D,
	    +0X000000000.0030000000000p+12F,
	    +0X000000000.0030000000000p+12d,
	    +0X000000000.0030000000000p+12f,
	    +0X000000000.0030000000000p12,
	    +0X000000000.0030000000000p12D,
	    +0X000000000.0030000000000p12F,
	    +0X000000000.0030000000000p12d,
	    +0X000000000.0030000000000p12f,
	    +0X00003P+0,
	    +0X00003P+0D,
	    +0X00003P+0F,
	    +0X00003P+0d,
	    +0X00003P+0f,
	    +0X00003P-0,
	    +0X00003P-0D,
	    +0X00003P-0F,
	    +0X00003P-0d,
	    +0X00003P-0f,
	    +0X00003P0,
	    +0X00003P0D,
	    +0X00003P0F,
	    +0X00003P0d,
	    +0X00003P0f,
	    +0X00003p+0,
	    +0X00003p+0D,
	    +0X00003p+0F,
	    +0X00003p+0d,
	    +0X00003p+0f,
	    +0X00003p-0,
	    +0X00003p-0D,
	    +0X00003p-0F,
	    +0X00003p-0d,
	    +0X00003p-0f,
	    +0X00003p0,
	    +0X00003p0D,
	    +0X00003p0F,
	    +0X00003p0d,
	    +0X00003p0f,
	    +0X0003.P+0,
	    +0X0003.P+0D,
	    +0X0003.P+0F,
	    +0X0003.P+0d,
	    +0X0003.P+0f,
	    +0X0003.P-0,
	    +0X0003.P-0D,
	    +0X0003.P-0F,
	    +0X0003.P-0d,
	    +0X0003.P-0f,
	    +0X0003.P0,
	    +0X0003.P0D,
	    +0X0003.P0F,
	    +0X0003.P0d,
	    +0X0003.P0f,
	    +0X0003.p+0,
	    +0X0003.p+0D,
	    +0X0003.p+0F,
	    +0X0003.p+0d,
	    +0X0003.p+0f,
	    +0X0003.p-0,
	    +0X0003.p-0D,
	    +0X0003.p-0F,
	    +0X0003.p-0d,
	    +0X0003.p-0f,
	    +0X0003.p0,
	    +0X0003.p0D,
	    +0X0003.p0F,
	    +0X0003.p0d,
	    +0X0003.p0f,
	    +0X0003P+0,
	    +0X0003P+0D,
	    +0X0003P+0F,
	    +0X0003P+0d,
	    +0X0003P+0f,
	    +0X0003P-0,
	    +0X0003P-0D,
	    +0X0003P-0F,
	    +0X0003P-0d,
	    +0X0003P-0f,
	    +0X0003P0,
	    +0X0003P0D,
	    +0X0003P0F,
	    +0X0003P0d,
	    +0X0003P0f,
	    +0X0003p+0,
	    +0X0003p+0D,
	    +0X0003p+0F,
	    +0X0003p+0d,
	    +0X0003p+0f,
	    +0X0003p-0,
	    +0X0003p-0D,
	    +0X0003p-0F,
	    +0X0003p-0d,
	    +0X0003p-0f,
	    +0X0003p0,
	    +0X0003p0D,
	    +0X0003p0F,
	    +0X0003p0d,
	    +0X0003p0f,
	    +0X01.80P+1,
	    +0X01.80P+1D,
	    +0X01.80P+1F,
	    +0X01.80P+1d,
	    +0X01.80P+1f,
	    +0X01.80P1,
	    +0X01.80P1D,
	    +0X01.80P1F,
	    +0X01.80P1d,
	    +0X01.80P1f,
	    +0X01.80p+1,
	    +0X01.80p+1D,
	    +0X01.80p+1F,
	    +0X01.80p+1d,
	    +0X01.80p+1f,
	    +0X01.80p1,
	    +0X01.80p1D,
	    +0X01.80p1F,
	    +0X01.80p1d,
	    +0X01.80p1f,
	    +0X01.8P+1,
	    +0X01.8P+1D,
	    +0X01.8P+1F,
	    +0X01.8P+1d,
	    +0X01.8P+1f,
	    +0X01.8P1,
	    +0X01.8P1D,
	    +0X01.8P1F,
	    +0X01.8P1d,
	    +0X01.8P1f,
	    +0X01.8p+1,
	    +0X01.8p+1D,
	    +0X01.8p+1F,
	    +0X01.8p+1d,
	    +0X01.8p+1f,
	    +0X01.8p1,
	    +0X01.8p1D,
	    +0X01.8p1F,
	    +0X01.8p1d,
	    +0X01.8p1f,
	    +0X1.80P+1,
	    +0X1.80P+1D,
	    +0X1.80P+1F,
	    +0X1.80P+1d,
	    +0X1.80P+1f,
	    +0X1.80P1,
	    +0X1.80P1D,
	    +0X1.80P1F,
	    +0X1.80P1d,
	    +0X1.80P1f,
	    +0X1.80p+1,
	    +0X1.80p+1D,
	    +0X1.80p+1F,
	    +0X1.80p+1d,
	    +0X1.80p+1f,
	    +0X1.80p1,
	    +0X1.80p1D,
	    +0X1.80p1F,
	    +0X1.80p1d,
	    +0X1.80p1f,
	    +0X1.8P+1,
	    +0X1.8P+1D,
	    +0X1.8P+1F,
	    +0X1.8P+1d,
	    +0X1.8P+1f,
	    +0X1.8P1,
	    +0X1.8P1D,
	    +0X1.8P1F,
	    +0X1.8P1d,
	    +0X1.8P1f,
	    +0X1.8p+1,
	    +0X1.8p+1D,
	    +0X1.8p+1F,
	    +0X1.8p+1d,
	    +0X1.8p+1f,
	    +0X1.8p1,
	    +0X1.8p1D,
	    +0X1.8p1F,
	    +0X1.8p1d,
	    +0X1.8p1f,
	    +0X18.0P-3,
	    +0X18.0P-3D,
	    +0X18.0P-3F,
	    +0X18.0P-3d,
	    +0X18.0P-3f,
	    +0X18.0p-3,
	    +0X18.0p-3D,
	    +0X18.0p-3F,
	    +0X18.0p-3d,
	    +0X18.0p-3f,
	    +0X18P-3,
	    +0X18P-3D,
	    +0X18P-3F,
	    +0X18P-3d,
	    +0X18P-3f,
	    +0X18p-3,
	    +0X18p-3D,
	    +0X18p-3F,
	    +0X18p-3d,
	    +0X18p-3f,
	    +0X3.000000P+0,
	    +0X3.000000P+0D,
	    +0X3.000000P+0F,
	    +0X3.000000P+0d,
	    +0X3.000000P+0f,
	    +0X3.000000P-0,
	    +0X3.000000P-0D,
	    +0X3.000000P-0F,
	    +0X3.000000P-0d,
	    +0X3.000000P-0f,
	    +0X3.000000P0,
	    +0X3.000000P0D,
	    +0X3.000000P0F,
	    +0X3.000000P0d,
	    +0X3.000000P0f,
	    +0X3.000000p+0,
	    +0X3.000000p+0D,
	    +0X3.000000p+0F,
	    +0X3.000000p+0d,
	    +0X3.000000p+0f,
	    +0X3.000000p-0,
	    +0X3.000000p-0D,
	    +0X3.000000p-0F,
	    +0X3.000000p-0d,
	    +0X3.000000p-0f,
	    +0X3.000000p0,
	    +0X3.000000p0D,
	    +0X3.000000p0F,
	    +0X3.000000p0d,
	    +0X3.000000p0f,
	    +0X3.0P+0,
	    +0X3.0P+0D,
	    +0X3.0P+0F,
	    +0X3.0P+0d,
	    +0X3.0P+0f,
	    +0X3.0P-0,
	    +0X3.0P-0D,
	    +0X3.0P-0F,
	    +0X3.0P-0d,
	    +0X3.0P-0f,
	    +0X3.0P0,
	    +0X3.0P0D,
	    +0X3.0P0F,
	    +0X3.0P0d,
	    +0X3.0P0f,
	    +0X3.0p+0,
	    +0X3.0p+0D,
	    +0X3.0p+0F,
	    +0X3.0p+0d,
	    +0X3.0p+0f,
	    +0X3.0p-0,
	    +0X3.0p-0D,
	    +0X3.0p-0F,
	    +0X3.0p-0d,
	    +0X3.0p-0f,
	    +0X3.0p0,
	    +0X3.0p0D,
	    +0X3.0p0F,
	    +0X3.0p0d,
	    +0X3.0p0f,
	    +0X3.P+0,
	    +0X3.P+0D,
	    +0X3.P+0F,
	    +0X3.P+0d,
	    +0X3.P+0f,
	    +0X3.P-0,
	    +0X3.P-0D,
	    +0X3.P-0F,
	    +0X3.P-0d,
	    +0X3.P-0f,
	    +0X3.P0,
	    +0X3.P0D,
	    +0X3.P0F,
	    +0X3.P0d,
	    +0X3.P0f,
	    +0X3.p+0,
	    +0X3.p+0D,
	    +0X3.p+0F,
	    +0X3.p+0d,
	    +0X3.p+0f,
	    +0X3.p-0,
	    +0X3.p-0D,
	    +0X3.p-0F,
	    +0X3.p-0d,
	    +0X3.p-0f,
	    +0X3.p0,
	    +0X3.p0D,
	    +0X3.p0F,
	    +0X3.p0d,
	    +0X3.p0f,
	    +0X3000000.0000P-24,
	    +0X3000000.0000P-24D,
	    +0X3000000.0000P-24F,
	    +0X3000000.0000P-24d,
	    +0X3000000.0000P-24f,
	    +0X3000000.0000p-24,
	    +0X3000000.0000p-24D,
	    +0X3000000.0000p-24F,
	    +0X3000000.0000p-24d,
	    +0X3000000.0000p-24f,
	    +0X3000000.P-24,
	    +0X3000000.P-24D,
	    +0X3000000.P-24F,
	    +0X3000000.P-24d,
	    +0X3000000.P-24f,
	    +0X3000000.p-24,
	    +0X3000000.p-24D,
	    +0X3000000.p-24F,
	    +0X3000000.p-24d,
	    +0X3000000.p-24f,
	    +0X3000000P-24,
	    +0X3000000P-24D,
	    +0X3000000P-24F,
	    +0X3000000P-24d,
	    +0X3000000P-24f,
	    +0X3000000p-24,
	    +0X3000000p-24D,
	    +0X3000000p-24F,
	    +0X3000000p-24d,
	    +0X3000000p-24f,
	    +0X3P+0,
	    +0X3P+0D,
	    +0X3P+0F,
	    +0X3P+0d,
	    +0X3P+0f,
	    +0X3P-0,
	    +0X3P-0D,
	    +0X3P-0F,
	    +0X3P-0d,
	    +0X3P-0f,
	    +0X3P0,
	    +0X3P0D,
	    +0X3P0F,
	    +0X3P0d,
	    +0X3P0f,
	    +0X3p+0,
	    +0X3p+0D,
	    +0X3p+0F,
	    +0X3p+0d,
	    +0X3p+0f,
	    +0X3p-0,
	    +0X3p-0D,
	    +0X3p-0F,
	    +0X3p-0d,
	    +0X3p-0f,
	    +0X3p0,
	    +0X3p0D,
	    +0X3p0F,
	    +0X3p0d,
	    +0X3p0f,
	    +0XC.0P-2,
	    +0XC.0P-2D,
	    +0XC.0P-2F,
	    +0XC.0P-2d,
	    +0XC.0P-2f,
	    +0XC.0p-2,
	    +0XC.0p-2D,
	    +0XC.0p-2F,
	    +0XC.0p-2d,
	    +0XC.0p-2f,
	    +0XC.P-2,
	    +0XC.P-2D,
	    +0XC.P-2F,
	    +0XC.P-2d,
	    +0XC.P-2f,
	    +0XC.p-2,
	    +0XC.p-2D,
	    +0XC.p-2F,
	    +0XC.p-2d,
	    +0XC.p-2f,
	    +0XCP-2,
	    +0XCP-2D,
	    +0XCP-2F,
	    +0XCP-2d,
	    +0XCP-2f,
	    +0XCp-2,
	    +0XCp-2D,
	    +0XCp-2F,
	    +0XCp-2d,
	    +0XCp-2f,
	    +0Xc.0P-2,
	    +0Xc.0P-2D,
	    +0Xc.0P-2F,
	    +0Xc.0P-2d,
	    +0Xc.0P-2f,
	    +0Xc.0p-2,
	    +0Xc.0p-2D,
	    +0Xc.0p-2F,
	    +0Xc.0p-2d,
	    +0Xc.0p-2f,
	    +0Xc.P-2,
	    +0Xc.P-2D,
	    +0Xc.P-2F,
	    +0Xc.P-2d,
	    +0Xc.P-2f,
	    +0Xc.p-2,
	    +0Xc.p-2D,
	    +0Xc.p-2F,
	    +0Xc.p-2d,
	    +0Xc.p-2f,
	    +0XcP-2,
	    +0XcP-2D,
	    +0XcP-2F,
	    +0XcP-2d,
	    +0XcP-2f,
	    +0Xcp-2,
	    +0Xcp-2D,
	    +0Xcp-2F,
	    +0Xcp-2d,
	    +0Xcp-2f,
	    +0x.0030000000000P+12,
	    +0x.0030000000000P+12D,
	    +0x.0030000000000P+12F,
	    +0x.0030000000000P+12d,
	    +0x.0030000000000P+12f,
	    +0x.0030000000000P12,
	    +0x.0030000000000P12D,
	    +0x.0030000000000P12F,
	    +0x.0030000000000P12d,
	    +0x.0030000000000P12f,
	    +0x.0030000000000p+12,
	    +0x.0030000000000p+12D,
	    +0x.0030000000000p+12F,
	    +0x.0030000000000p+12d,
	    +0x.0030000000000p+12f,
	    +0x.0030000000000p12,
	    +0x.0030000000000p12D,
	    +0x.0030000000000p12F,
	    +0x.0030000000000p12d,
	    +0x.0030000000000p12f,
	    +0x.0030P+12,
	    +0x.0030P+12D,
	    +0x.0030P+12F,
	    +0x.0030P+12d,
	    +0x.0030P+12f,
	    +0x.0030P12,
	    +0x.0030P12D,
	    +0x.0030P12F,
	    +0x.0030P12d,
	    +0x.0030P12f,
	    +0x.0030p+12,
	    +0x.0030p+12D,
	    +0x.0030p+12F,
	    +0x.0030p+12d,
	    +0x.0030p+12f,
	    +0x.0030p12,
	    +0x.0030p12D,
	    +0x.0030p12F,
	    +0x.0030p12d,
	    +0x.0030p12f,
	    +0x.003P+12,
	    +0x.003P+12D,
	    +0x.003P+12F,
	    +0x.003P+12d,
	    +0x.003P+12f,
	    +0x.003P12,
	    +0x.003P12D,
	    +0x.003P12F,
	    +0x.003P12d,
	    +0x.003P12f,
	    +0x.003p+12,
	    +0x.003p+12D,
	    +0x.003p+12F,
	    +0x.003p+12d,
	    +0x.003p+12f,
	    +0x.003p12,
	    +0x.003p12D,
	    +0x.003p12F,
	    +0x.003p12d,
	    +0x.003p12f,
	    +0x.3P+4,
	    +0x.3P+4D,
	    +0x.3P+4F,
	    +0x.3P+4d,
	    +0x.3P+4f,
	    +0x.3P4,
	    +0x.3P4D,
	    +0x.3P4F,
	    +0x.3P4d,
	    +0x.3P4f,
	    +0x.3p+4,
	    +0x.3p+4D,
	    +0x.3p+4F,
	    +0x.3p+4d,
	    +0x.3p+4f,
	    +0x.3p4,
	    +0x.3p4D,
	    +0x.3p4F,
	    +0x.3p4d,
	    +0x.3p4f,
	    +0x.C0P+2,
	    +0x.C0P+2D,
	    +0x.C0P+2F,
	    +0x.C0P+2d,
	    +0x.C0P+2f,
	    +0x.C0P2,
	    +0x.C0P2D,
	    +0x.C0P2F,
	    +0x.C0P2d,
	    +0x.C0P2f,
	    +0x.C0p+2,
	    +0x.C0p+2D,
	    +0x.C0p+2F,
	    +0x.C0p+2d,
	    +0x.C0p+2f,
	    +0x.C0p2,
	    +0x.C0p2D,
	    +0x.C0p2F,
	    +0x.C0p2d,
	    +0x.C0p2f,
	    +0x.CP+2,
	    +0x.CP+2D,
	    +0x.CP+2F,
	    +0x.CP+2d,
	    +0x.CP+2f,
	    +0x.CP2,
	    +0x.CP2D,
	    +0x.CP2F,
	    +0x.CP2d,
	    +0x.CP2f,
	    +0x.Cp+2,
	    +0x.Cp+2D,
	    +0x.Cp+2F,
	    +0x.Cp+2d,
	    +0x.Cp+2f,
	    +0x.Cp2,
	    +0x.Cp2D,
	    +0x.Cp2F,
	    +0x.Cp2d,
	    +0x.Cp2f,
	    +0x.c0P+2,
	    +0x.c0P+2D,
	    +0x.c0P+2F,
	    +0x.c0P+2d,
	    +0x.c0P+2f,
	    +0x.c0P2,
	    +0x.c0P2D,
	    +0x.c0P2F,
	    +0x.c0P2d,
	    +0x.c0P2f,
	    +0x.c0p+2,
	    +0x.c0p+2D,
	    +0x.c0p+2F,
	    +0x.c0p+2d,
	    +0x.c0p+2f,
	    +0x.c0p2,
	    +0x.c0p2D,
	    +0x.c0p2F,
	    +0x.c0p2d,
	    +0x.c0p2f,
	    +0x.cP+2,
	    +0x.cP+2D,
	    +0x.cP+2F,
	    +0x.cP+2d,
	    +0x.cP+2f,
	    +0x.cP2,
	    +0x.cP2D,
	    +0x.cP2F,
	    +0x.cP2d,
	    +0x.cP2f,
	    +0x.cp+2,
	    +0x.cp+2D,
	    +0x.cp+2F,
	    +0x.cp+2d,
	    +0x.cp+2f,
	    +0x.cp2,
	    +0x.cp2D,
	    +0x.cp2F,
	    +0x.cp2d,
	    +0x.cp2f,
	    +0x0.30P+4,
	    +0x0.30P+4D,
	    +0x0.30P+4F,
	    +0x0.30P+4d,
	    +0x0.30P+4f,
	    +0x0.30P4,
	    +0x0.30P4D,
	    +0x0.30P4F,
	    +0x0.30P4d,
	    +0x0.30P4f,
	    +0x0.30p+4,
	    +0x0.30p+4D,
	    +0x0.30p+4F,
	    +0x0.30p+4d,
	    +0x0.30p+4f,
	    +0x0.30p4,
	    +0x0.30p4D,
	    +0x0.30p4F,
	    +0x0.30p4d,
	    +0x0.30p4f,
	    +0x0.3P+4,
	    +0x0.3P+4D,
	    +0x0.3P+4F,
	    +0x0.3P+4d,
	    +0x0.3P+4f,
	    +0x0.3P4,
	    +0x0.3P4D,
	    +0x0.3P4F,
	    +0x0.3P4d,
	    +0x0.3P4f,
	    +0x0.3p+4,
	    +0x0.3p+4D,
	    +0x0.3p+4F,
	    +0x0.3p+4d,
	    +0x0.3p+4f,
	    +0x0.3p4,
	    +0x0.3p4D,
	    +0x0.3p4F,
	    +0x0.3p4d,
	    +0x0.3p4f,
	    +0x0.C0P+2,
	    +0x0.C0P+2D,
	    +0x0.C0P+2F,
	    +0x0.C0P+2d,
	    +0x0.C0P+2f,
	    +0x0.C0P2,
	    +0x0.C0P2D,
	    +0x0.C0P2F,
	    +0x0.C0P2d,
	    +0x0.C0P2f,
	    +0x0.C0p+2,
	    +0x0.C0p+2D,
	    +0x0.C0p+2F,
	    +0x0.C0p+2d,
	    +0x0.C0p+2f,
	    +0x0.C0p2,
	    +0x0.C0p2D,
	    +0x0.C0p2F,
	    +0x0.C0p2d,
	    +0x0.C0p2f,
	    +0x0.CP+2,
	    +0x0.CP+2D,
	    +0x0.CP+2F,
	    +0x0.CP+2d,
	    +0x0.CP+2f,
	    +0x0.CP2,
	    +0x0.CP2D,
	    +0x0.CP2F,
	    +0x0.CP2d,
	    +0x0.CP2f,
	    +0x0.Cp+2,
	    +0x0.Cp+2D,
	    +0x0.Cp+2F,
	    +0x0.Cp+2d,
	    +0x0.Cp+2f,
	    +0x0.Cp2,
	    +0x0.Cp2D,
	    +0x0.Cp2F,
	    +0x0.Cp2d,
	    +0x0.Cp2f,
	    +0x0.c0P+2,
	    +0x0.c0P+2D,
	    +0x0.c0P+2F,
	    +0x0.c0P+2d,
	    +0x0.c0P+2f,
	    +0x0.c0P2,
	    +0x0.c0P2D,
	    +0x0.c0P2F,
	    +0x0.c0P2d,
	    +0x0.c0P2f,
	    +0x0.c0p+2,
	    +0x0.c0p+2D,
	    +0x0.c0p+2F,
	    +0x0.c0p+2d,
	    +0x0.c0p+2f,
	    +0x0.c0p2,
	    +0x0.c0p2D,
	    +0x0.c0p2F,
	    +0x0.c0p2d,
	    +0x0.c0p2f,
	    +0x0.cP+2,
	    +0x0.cP+2D,
	    +0x0.cP+2F,
	    +0x0.cP+2d,
	    +0x0.cP+2f,
	    +0x0.cP2,
	    +0x0.cP2D,
	    +0x0.cP2F,
	    +0x0.cP2d,
	    +0x0.cP2f,
	    +0x0.cp+2,
	    +0x0.cp+2D,
	    +0x0.cp+2F,
	    +0x0.cp+2d,
	    +0x0.cp+2f,
	    +0x0.cp2,
	    +0x0.cp2D,
	    +0x0.cp2F,
	    +0x0.cp2d,
	    +0x0.cp2f,
	    +0x000000000.0030000000000P+12,
	    +0x000000000.0030000000000P+12D,
	    +0x000000000.0030000000000P+12F,
	    +0x000000000.0030000000000P+12d,
	    +0x000000000.0030000000000P+12f,
	    +0x000000000.0030000000000P12,
	    +0x000000000.0030000000000P12D,
	    +0x000000000.0030000000000P12F,
	    +0x000000000.0030000000000P12d,
	    +0x000000000.0030000000000P12f,
	    +0x000000000.0030000000000p+12,
	    +0x000000000.0030000000000p+12D,
	    +0x000000000.0030000000000p+12F,
	    +0x000000000.0030000000000p+12d,
	    +0x000000000.0030000000000p+12f,
	    +0x000000000.0030000000000p12,
	    +0x000000000.0030000000000p12D,
	    +0x000000000.0030000000000p12F,
	    +0x000000000.0030000000000p12d,
	    +0x000000000.0030000000000p12f,
	    +0x00003P+0,
	    +0x00003P+0D,
	    +0x00003P+0F,
	    +0x00003P+0d,
	    +0x00003P+0f,
	    +0x00003P-0,
	    +0x00003P-0D,
	    +0x00003P-0F,
	    +0x00003P-0d,
	    +0x00003P-0f,
	    +0x00003P0,
	    +0x00003P0D,
	    +0x00003P0F,
	    +0x00003P0d,
	    +0x00003P0f,
	    +0x00003p+0,
	    +0x00003p+0D,
	    +0x00003p+0F,
	    +0x00003p+0d,
	    +0x00003p+0f,
	    +0x00003p-0,
	    +0x00003p-0D,
	    +0x00003p-0F,
	    +0x00003p-0d,
	    +0x00003p-0f,
	    +0x00003p0,
	    +0x00003p0D,
	    +0x00003p0F,
	    +0x00003p0d,
	    +0x00003p0f,
	    +0x0003.P+0,
	    +0x0003.P+0D,
	    +0x0003.P+0F,
	    +0x0003.P+0d,
	    +0x0003.P+0f,
	    +0x0003.P-0,
	    +0x0003.P-0D,
	    +0x0003.P-0F,
	    +0x0003.P-0d,
	    +0x0003.P-0f,
	    +0x0003.P0,
	    +0x0003.P0D,
	    +0x0003.P0F,
	    +0x0003.P0d,
	    +0x0003.P0f,
	    +0x0003.p+0,
	    +0x0003.p+0D,
	    +0x0003.p+0F,
	    +0x0003.p+0d,
	    +0x0003.p+0f,
	    +0x0003.p-0,
	    +0x0003.p-0D,
	    +0x0003.p-0F,
	    +0x0003.p-0d,
	    +0x0003.p-0f,
	    +0x0003.p0,
	    +0x0003.p0D,
	    +0x0003.p0F,
	    +0x0003.p0d,
	    +0x0003.p0f,
	    +0x0003P+0,
	    +0x0003P+0D,
	    +0x0003P+0F,
	    +0x0003P+0d,
	    +0x0003P+0f,
	    +0x0003P-0,
	    +0x0003P-0D,
	    +0x0003P-0F,
	    +0x0003P-0d,
	    +0x0003P-0f,
	    +0x0003P0,
	    +0x0003P0D,
	    +0x0003P0F,
	    +0x0003P0d,
	    +0x0003P0f,
	    +0x0003p+0,
	    +0x0003p+0D,
	    +0x0003p+0F,
	    +0x0003p+0d,
	    +0x0003p+0f,
	    +0x0003p-0,
	    +0x0003p-0D,
	    +0x0003p-0F,
	    +0x0003p-0d,
	    +0x0003p-0f,
	    +0x0003p0,
	    +0x0003p0D,
	    +0x0003p0F,
	    +0x0003p0d,
	    +0x0003p0f,
	    +0x01.80P+1,
	    +0x01.80P+1D,
	    +0x01.80P+1F,
	    +0x01.80P+1d,
	    +0x01.80P+1f,
	    +0x01.80P1,
	    +0x01.80P1D,
	    +0x01.80P1F,
	    +0x01.80P1d,
	    +0x01.80P1f,
	    +0x01.80p+1,
	    +0x01.80p+1D,
	    +0x01.80p+1F,
	    +0x01.80p+1d,
	    +0x01.80p+1f,
	    +0x01.80p1,
	    +0x01.80p1D,
	    +0x01.80p1F,
	    +0x01.80p1d,
	    +0x01.80p1f,
	    +0x01.8P+1,
	    +0x01.8P+1D,
	    +0x01.8P+1F,
	    +0x01.8P+1d,
	    +0x01.8P+1f,
	    +0x01.8P1,
	    +0x01.8P1D,
	    +0x01.8P1F,
	    +0x01.8P1d,
	    +0x01.8P1f,
	    +0x01.8p+1,
	    +0x01.8p+1D,
	    +0x01.8p+1F,
	    +0x01.8p+1d,
	    +0x01.8p+1f,
	    +0x01.8p1,
	    +0x01.8p1D,
	    +0x01.8p1F,
	    +0x01.8p1d,
	    +0x01.8p1f,
	    +0x1.80P+1,
	    +0x1.80P+1D,
	    +0x1.80P+1F,
	    +0x1.80P+1d,
	    +0x1.80P+1f,
	    +0x1.80P1,
	    +0x1.80P1D,
	    +0x1.80P1F,
	    +0x1.80P1d,
	    +0x1.80P1f,
	    +0x1.80p+1,
	    +0x1.80p+1D,
	    +0x1.80p+1F,
	    +0x1.80p+1d,
	    +0x1.80p+1f,
	    +0x1.80p1,
	    +0x1.80p1D,
	    +0x1.80p1F,
	    +0x1.80p1d,
	    +0x1.80p1f,
	    +0x1.8P+1,
	    +0x1.8P+1D,
	    +0x1.8P+1F,
	    +0x1.8P+1d,
	    +0x1.8P+1f,
	    +0x1.8P1,
	    +0x1.8P1D,
	    +0x1.8P1F,
	    +0x1.8P1d,
	    +0x1.8P1f,
	    +0x1.8p+1,
	    +0x1.8p+1D,
	    +0x1.8p+1F,
	    +0x1.8p+1d,
	    +0x1.8p+1f,
	    +0x1.8p1,
	    +0x1.8p1D,
	    +0x1.8p1F,
	    +0x1.8p1d,
	    +0x1.8p1f,
	    +0x18.0P-3,
	    +0x18.0P-3D,
	    +0x18.0P-3F,
	    +0x18.0P-3d,
	    +0x18.0P-3f,
	    +0x18.0p-3,
	    +0x18.0p-3D,
	    +0x18.0p-3F,
	    +0x18.0p-3d,
	    +0x18.0p-3f,
	    +0x18P-3,
	    +0x18P-3D,
	    +0x18P-3F,
	    +0x18P-3d,
	    +0x18P-3f,
	    +0x18p-3,
	    +0x18p-3D,
	    +0x18p-3F,
	    +0x18p-3d,
	    +0x18p-3f,
	    +0x3.000000P+0,
	    +0x3.000000P+0D,
	    +0x3.000000P+0F,
	    +0x3.000000P+0d,
	    +0x3.000000P+0f,
	    +0x3.000000P-0,
	    +0x3.000000P-0D,
	    +0x3.000000P-0F,
	    +0x3.000000P-0d,
	    +0x3.000000P-0f,
	    +0x3.000000P0,
	    +0x3.000000P0D,
	    +0x3.000000P0F,
	    +0x3.000000P0d,
	    +0x3.000000P0f,
	    +0x3.000000p+0,
	    +0x3.000000p+0D,
	    +0x3.000000p+0F,
	    +0x3.000000p+0d,
	    +0x3.000000p+0f,
	    +0x3.000000p-0,
	    +0x3.000000p-0D,
	    +0x3.000000p-0F,
	    +0x3.000000p-0d,
	    +0x3.000000p-0f,
	    +0x3.000000p0,
	    +0x3.000000p0D,
	    +0x3.000000p0F,
	    +0x3.000000p0d,
	    +0x3.000000p0f,
	    +0x3.0P+0,
	    +0x3.0P+0D,
	    +0x3.0P+0F,
	    +0x3.0P+0d,
	    +0x3.0P+0f,
	    +0x3.0P-0,
	    +0x3.0P-0D,
	    +0x3.0P-0F,
	    +0x3.0P-0d,
	    +0x3.0P-0f,
	    +0x3.0P0,
	    +0x3.0P0D,
	    +0x3.0P0F,
	    +0x3.0P0d,
	    +0x3.0P0f,
	    +0x3.0p+0,
	    +0x3.0p+0D,
	    +0x3.0p+0F,
	    +0x3.0p+0d,
	    +0x3.0p+0f,
	    +0x3.0p-0,
	    +0x3.0p-0D,
	    +0x3.0p-0F,
	    +0x3.0p-0d,
	    +0x3.0p-0f,
	    +0x3.0p0,
	    +0x3.0p0D,
	    +0x3.0p0F,
	    +0x3.0p0d,
	    +0x3.0p0f,
	    +0x3.P+0,
	    +0x3.P+0D,
	    +0x3.P+0F,
	    +0x3.P+0d,
	    +0x3.P+0f,
	    +0x3.P-0,
	    +0x3.P-0D,
	    +0x3.P-0F,
	    +0x3.P-0d,
	    +0x3.P-0f,
	    +0x3.P0,
	    +0x3.P0D,
	    +0x3.P0F,
	    +0x3.P0d,
	    +0x3.P0f,
	    +0x3.p+0,
	    +0x3.p+0D,
	    +0x3.p+0F,
	    +0x3.p+0d,
	    +0x3.p+0f,
	    +0x3.p-0,
	    +0x3.p-0D,
	    +0x3.p-0F,
	    +0x3.p-0d,
	    +0x3.p-0f,
	    +0x3.p0,
	    +0x3.p0D,
	    +0x3.p0F,
	    +0x3.p0d,
	    +0x3.p0f,
	    +0x3000000.0000P-24,
	    +0x3000000.0000P-24D,
	    +0x3000000.0000P-24F,
	    +0x3000000.0000P-24d,
	    +0x3000000.0000P-24f,
	    +0x3000000.0000p-24,
	    +0x3000000.0000p-24D,
	    +0x3000000.0000p-24F,
	    +0x3000000.0000p-24d,
	    +0x3000000.0000p-24f,
	    +0x3000000.P-24,
	    +0x3000000.P-24D,
	    +0x3000000.P-24F,
	    +0x3000000.P-24d,
	    +0x3000000.P-24f,
	    +0x3000000.p-24,
	    +0x3000000.p-24D,
	    +0x3000000.p-24F,
	    +0x3000000.p-24d,
	    +0x3000000.p-24f,
	    +0x3000000P-24,
	    +0x3000000P-24D,
	    +0x3000000P-24F,
	    +0x3000000P-24d,
	    +0x3000000P-24f,
	    +0x3000000p-24,
	    +0x3000000p-24D,
	    +0x3000000p-24F,
	    +0x3000000p-24d,
	    +0x3000000p-24f,
	    +0x3P+0,
	    +0x3P+0D,
	    +0x3P+0F,
	    +0x3P+0d,
	    +0x3P+0f,
	    +0x3P-0,
	    +0x3P-0D,
	    +0x3P-0F,
	    +0x3P-0d,
	    +0x3P-0f,
	    +0x3P0,
	    +0x3P0D,
	    +0x3P0F,
	    +0x3P0d,
	    +0x3P0f,
	    +0x3p+0,
	    +0x3p+0D,
	    +0x3p+0F,
	    +0x3p+0d,
	    +0x3p+0f,
	    +0x3p-0,
	    +0x3p-0D,
	    +0x3p-0F,
	    +0x3p-0d,
	    +0x3p-0f,
	    +0x3p0,
	    +0x3p0D,
	    +0x3p0F,
	    +0x3p0d,
	    +0x3p0f,
	    +0xC.0P-2,
	    +0xC.0P-2D,
	    +0xC.0P-2F,
	    +0xC.0P-2d,
	    +0xC.0P-2f,
	    +0xC.0p-2,
	    +0xC.0p-2D,
	    +0xC.0p-2F,
	    +0xC.0p-2d,
	    +0xC.0p-2f,
	    +0xC.P-2,
	    +0xC.P-2D,
	    +0xC.P-2F,
	    +0xC.P-2d,
	    +0xC.P-2f,
	    +0xC.p-2,
	    +0xC.p-2D,
	    +0xC.p-2F,
	    +0xC.p-2d,
	    +0xC.p-2f,
	    +0xCP-2,
	    +0xCP-2D,
	    +0xCP-2F,
	    +0xCP-2d,
	    +0xCP-2f,
	    +0xCp-2,
	    +0xCp-2D,
	    +0xCp-2F,
	    +0xCp-2d,
	    +0xCp-2f,
	    +0xc.0P-2,
	    +0xc.0P-2D,
	    +0xc.0P-2F,
	    +0xc.0P-2d,
	    +0xc.0P-2f,
	    +0xc.0p-2,
	    +0xc.0p-2D,
	    +0xc.0p-2F,
	    +0xc.0p-2d,
	    +0xc.0p-2f,
	    +0xc.P-2,
	    +0xc.P-2D,
	    +0xc.P-2F,
	    +0xc.P-2d,
	    +0xc.P-2f,
	    +0xc.p-2,
	    +0xc.p-2D,
	    +0xc.p-2F,
	    +0xc.p-2d,
	    +0xc.p-2f,
	    +0xcP-2,
	    +0xcP-2D,
	    +0xcP-2F,
	    +0xcP-2d,
	    +0xcP-2f,
	    +0xcp-2,
	    +0xcp-2D,
	    +0xcp-2F,
	    +0xcp-2d,
	    +0xcp-2f,
	    -0X.0030000000000P+12,
	    -0X.0030000000000P+12D,
	    -0X.0030000000000P+12F,
	    -0X.0030000000000P+12d,
	    -0X.0030000000000P+12f,
	    -0X.0030000000000P12,
	    -0X.0030000000000P12D,
	    -0X.0030000000000P12F,
	    -0X.0030000000000P12d,
	    -0X.0030000000000P12f,
	    -0X.0030000000000p+12,
	    -0X.0030000000000p+12D,
	    -0X.0030000000000p+12F,
	    -0X.0030000000000p+12d,
	    -0X.0030000000000p+12f,
	    -0X.0030000000000p12,
	    -0X.0030000000000p12D,
	    -0X.0030000000000p12F,
	    -0X.0030000000000p12d,
	    -0X.0030000000000p12f,
	    -0X.0030P+12,
	    -0X.0030P+12D,
	    -0X.0030P+12F,
	    -0X.0030P+12d,
	    -0X.0030P+12f,
	    -0X.0030P12,
	    -0X.0030P12D,
	    -0X.0030P12F,
	    -0X.0030P12d,
	    -0X.0030P12f,
	    -0X.0030p+12,
	    -0X.0030p+12D,
	    -0X.0030p+12F,
	    -0X.0030p+12d,
	    -0X.0030p+12f,
	    -0X.0030p12,
	    -0X.0030p12D,
	    -0X.0030p12F,
	    -0X.0030p12d,
	    -0X.0030p12f,
	    -0X.003P+12,
	    -0X.003P+12D,
	    -0X.003P+12F,
	    -0X.003P+12d,
	    -0X.003P+12f,
	    -0X.003P12,
	    -0X.003P12D,
	    -0X.003P12F,
	    -0X.003P12d,
	    -0X.003P12f,
	    -0X.003p+12,
	    -0X.003p+12D,
	    -0X.003p+12F,
	    -0X.003p+12d,
	    -0X.003p+12f,
	    -0X.003p12,
	    -0X.003p12D,
	    -0X.003p12F,
	    -0X.003p12d,
	    -0X.003p12f,
	    -0X.3P+4,
	    -0X.3P+4D,
	    -0X.3P+4F,
	    -0X.3P+4d,
	    -0X.3P+4f,
	    -0X.3P4,
	    -0X.3P4D,
	    -0X.3P4F,
	    -0X.3P4d,
	    -0X.3P4f,
	    -0X.3p+4,
	    -0X.3p+4D,
	    -0X.3p+4F,
	    -0X.3p+4d,
	    -0X.3p+4f,
	    -0X.3p4,
	    -0X.3p4D,
	    -0X.3p4F,
	    -0X.3p4d,
	    -0X.3p4f,
	    -0X.C0P+2,
	    -0X.C0P+2D,
	    -0X.C0P+2F,
	    -0X.C0P+2d,
	    -0X.C0P+2f,
	    -0X.C0P2,
	    -0X.C0P2D,
	    -0X.C0P2F,
	    -0X.C0P2d,
	    -0X.C0P2f,
	    -0X.C0p+2,
	    -0X.C0p+2D,
	    -0X.C0p+2F,
	    -0X.C0p+2d,
	    -0X.C0p+2f,
	    -0X.C0p2,
	    -0X.C0p2D,
	    -0X.C0p2F,
	    -0X.C0p2d,
	    -0X.C0p2f,
	    -0X.CP+2,
	    -0X.CP+2D,
	    -0X.CP+2F,
	    -0X.CP+2d,
	    -0X.CP+2f,
	    -0X.CP2,
	    -0X.CP2D,
	    -0X.CP2F,
	    -0X.CP2d,
	    -0X.CP2f,
	    -0X.Cp+2,
	    -0X.Cp+2D,
	    -0X.Cp+2F,
	    -0X.Cp+2d,
	    -0X.Cp+2f,
	    -0X.Cp2,
	    -0X.Cp2D,
	    -0X.Cp2F,
	    -0X.Cp2d,
	    -0X.Cp2f,
	    -0X.c0P+2,
	    -0X.c0P+2D,
	    -0X.c0P+2F,
	    -0X.c0P+2d,
	    -0X.c0P+2f,
	    -0X.c0P2,
	    -0X.c0P2D,
	    -0X.c0P2F,
	    -0X.c0P2d,
	    -0X.c0P2f,
	    -0X.c0p+2,
	    -0X.c0p+2D,
	    -0X.c0p+2F,
	    -0X.c0p+2d,
	    -0X.c0p+2f,
	    -0X.c0p2,
	    -0X.c0p2D,
	    -0X.c0p2F,
	    -0X.c0p2d,
	    -0X.c0p2f,
	    -0X.cP+2,
	    -0X.cP+2D,
	    -0X.cP+2F,
	    -0X.cP+2d,
	    -0X.cP+2f,
	    -0X.cP2,
	    -0X.cP2D,
	    -0X.cP2F,
	    -0X.cP2d,
	    -0X.cP2f,
	    -0X.cp+2,
	    -0X.cp+2D,
	    -0X.cp+2F,
	    -0X.cp+2d,
	    -0X.cp+2f,
	    -0X.cp2,
	    -0X.cp2D,
	    -0X.cp2F,
	    -0X.cp2d,
	    -0X.cp2f,
	    -0X0.30P+4,
	    -0X0.30P+4D,
	    -0X0.30P+4F,
	    -0X0.30P+4d,
	    -0X0.30P+4f,
	    -0X0.30P4,
	    -0X0.30P4D,
	    -0X0.30P4F,
	    -0X0.30P4d,
	    -0X0.30P4f,
	    -0X0.30p+4,
	    -0X0.30p+4D,
	    -0X0.30p+4F,
	    -0X0.30p+4d,
	    -0X0.30p+4f,
	    -0X0.30p4,
	    -0X0.30p4D,
	    -0X0.30p4F,
	    -0X0.30p4d,
	    -0X0.30p4f,
	    -0X0.3P+4,
	    -0X0.3P+4D,
	    -0X0.3P+4F,
	    -0X0.3P+4d,
	    -0X0.3P+4f,
	    -0X0.3P4,
	    -0X0.3P4D,
	    -0X0.3P4F,
	    -0X0.3P4d,
	    -0X0.3P4f,
	    -0X0.3p+4,
	    -0X0.3p+4D,
	    -0X0.3p+4F,
	    -0X0.3p+4d,
	    -0X0.3p+4f,
	    -0X0.3p4,
	    -0X0.3p4D,
	    -0X0.3p4F,
	    -0X0.3p4d,
	    -0X0.3p4f,
	    -0X0.C0P+2,
	    -0X0.C0P+2D,
	    -0X0.C0P+2F,
	    -0X0.C0P+2d,
	    -0X0.C0P+2f,
	    -0X0.C0P2,
	    -0X0.C0P2D,
	    -0X0.C0P2F,
	    -0X0.C0P2d,
	    -0X0.C0P2f,
	    -0X0.C0p+2,
	    -0X0.C0p+2D,
	    -0X0.C0p+2F,
	    -0X0.C0p+2d,
	    -0X0.C0p+2f,
	    -0X0.C0p2,
	    -0X0.C0p2D,
	    -0X0.C0p2F,
	    -0X0.C0p2d,
	    -0X0.C0p2f,
	    -0X0.CP+2,
	    -0X0.CP+2D,
	    -0X0.CP+2F,
	    -0X0.CP+2d,
	    -0X0.CP+2f,
	    -0X0.CP2,
	    -0X0.CP2D,
	    -0X0.CP2F,
	    -0X0.CP2d,
	    -0X0.CP2f,
	    -0X0.Cp+2,
	    -0X0.Cp+2D,
	    -0X0.Cp+2F,
	    -0X0.Cp+2d,
	    -0X0.Cp+2f,
	    -0X0.Cp2,
	    -0X0.Cp2D,
	    -0X0.Cp2F,
	    -0X0.Cp2d,
	    -0X0.Cp2f,
	    -0X0.c0P+2,
	    -0X0.c0P+2D,
	    -0X0.c0P+2F,
	    -0X0.c0P+2d,
	    -0X0.c0P+2f,
	    -0X0.c0P2,
	    -0X0.c0P2D,
	    -0X0.c0P2F,
	    -0X0.c0P2d,
	    -0X0.c0P2f,
	    -0X0.c0p+2,
	    -0X0.c0p+2D,
	    -0X0.c0p+2F,
	    -0X0.c0p+2d,
	    -0X0.c0p+2f,
	    -0X0.c0p2,
	    -0X0.c0p2D,
	    -0X0.c0p2F,
	    -0X0.c0p2d,
	    -0X0.c0p2f,
	    -0X0.cP+2,
	    -0X0.cP+2D,
	    -0X0.cP+2F,
	    -0X0.cP+2d,
	    -0X0.cP+2f,
	    -0X0.cP2,
	    -0X0.cP2D,
	    -0X0.cP2F,
	    -0X0.cP2d,
	    -0X0.cP2f,
	    -0X0.cp+2,
	    -0X0.cp+2D,
	    -0X0.cp+2F,
	    -0X0.cp+2d,
	    -0X0.cp+2f,
	    -0X0.cp2,
	    -0X0.cp2D,
	    -0X0.cp2F,
	    -0X0.cp2d,
	    -0X0.cp2f,
	    -0X000000000.0030000000000P+12,
	    -0X000000000.0030000000000P+12D,
	    -0X000000000.0030000000000P+12F,
	    -0X000000000.0030000000000P+12d,
	    -0X000000000.0030000000000P+12f,
	    -0X000000000.0030000000000P12,
	    -0X000000000.0030000000000P12D,
	    -0X000000000.0030000000000P12F,
	    -0X000000000.0030000000000P12d,
	    -0X000000000.0030000000000P12f,
	    -0X000000000.0030000000000p+12,
	    -0X000000000.0030000000000p+12D,
	    -0X000000000.0030000000000p+12F,
	    -0X000000000.0030000000000p+12d,
	    -0X000000000.0030000000000p+12f,
	    -0X000000000.0030000000000p12,
	    -0X000000000.0030000000000p12D,
	    -0X000000000.0030000000000p12F,
	    -0X000000000.0030000000000p12d,
	    -0X000000000.0030000000000p12f,
	    -0X00003P+0,
	    -0X00003P+0D,
	    -0X00003P+0F,
	    -0X00003P+0d,
	    -0X00003P+0f,
	    -0X00003P-0,
	    -0X00003P-0D,
	    -0X00003P-0F,
	    -0X00003P-0d,
	    -0X00003P-0f,
	    -0X00003P0,
	    -0X00003P0D,
	    -0X00003P0F,
	    -0X00003P0d,
	    -0X00003P0f,
	    -0X00003p+0,
	    -0X00003p+0D,
	    -0X00003p+0F,
	    -0X00003p+0d,
	    -0X00003p+0f,
	    -0X00003p-0,
	    -0X00003p-0D,
	    -0X00003p-0F,
	    -0X00003p-0d,
	    -0X00003p-0f,
	    -0X00003p0,
	    -0X00003p0D,
	    -0X00003p0F,
	    -0X00003p0d,
	    -0X00003p0f,
	    -0X0003.P+0,
	    -0X0003.P+0D,
	    -0X0003.P+0F,
	    -0X0003.P+0d,
	    -0X0003.P+0f,
	    -0X0003.P-0,
	    -0X0003.P-0D,
	    -0X0003.P-0F,
	    -0X0003.P-0d,
	    -0X0003.P-0f,
	    -0X0003.P0,
	    -0X0003.P0D,
	    -0X0003.P0F,
	    -0X0003.P0d,
	    -0X0003.P0f,
	    -0X0003.p+0,
	    -0X0003.p+0D,
	    -0X0003.p+0F,
	    -0X0003.p+0d,
	    -0X0003.p+0f,
	    -0X0003.p-0,
	    -0X0003.p-0D,
	    -0X0003.p-0F,
	    -0X0003.p-0d,
	    -0X0003.p-0f,
	    -0X0003.p0,
	    -0X0003.p0D,
	    -0X0003.p0F,
	    -0X0003.p0d,
	    -0X0003.p0f,
	    -0X0003P+0,
	    -0X0003P+0D,
	    -0X0003P+0F,
	    -0X0003P+0d,
	    -0X0003P+0f,
	    -0X0003P-0,
	    -0X0003P-0D,
	    -0X0003P-0F,
	    -0X0003P-0d,
	    -0X0003P-0f,
	    -0X0003P0,
	    -0X0003P0D,
	    -0X0003P0F,
	    -0X0003P0d,
	    -0X0003P0f,
	    -0X0003p+0,
	    -0X0003p+0D,
	    -0X0003p+0F,
	    -0X0003p+0d,
	    -0X0003p+0f,
	    -0X0003p-0,
	    -0X0003p-0D,
	    -0X0003p-0F,
	    -0X0003p-0d,
	    -0X0003p-0f,
	    -0X0003p0,
	    -0X0003p0D,
	    -0X0003p0F,
	    -0X0003p0d,
	    -0X0003p0f,
	    -0X01.80P+1,
	    -0X01.80P+1D,
	    -0X01.80P+1F,
	    -0X01.80P+1d,
	    -0X01.80P+1f,
	    -0X01.80P1,
	    -0X01.80P1D,
	    -0X01.80P1F,
	    -0X01.80P1d,
	    -0X01.80P1f,
	    -0X01.80p+1,
	    -0X01.80p+1D,
	    -0X01.80p+1F,
	    -0X01.80p+1d,
	    -0X01.80p+1f,
	    -0X01.80p1,
	    -0X01.80p1D,
	    -0X01.80p1F,
	    -0X01.80p1d,
	    -0X01.80p1f,
	    -0X01.8P+1,
	    -0X01.8P+1D,
	    -0X01.8P+1F,
	    -0X01.8P+1d,
	    -0X01.8P+1f,
	    -0X01.8P1,
	    -0X01.8P1D,
	    -0X01.8P1F,
	    -0X01.8P1d,
	    -0X01.8P1f,
	    -0X01.8p+1,
	    -0X01.8p+1D,
	    -0X01.8p+1F,
	    -0X01.8p+1d,
	    -0X01.8p+1f,
	    -0X01.8p1,
	    -0X01.8p1D,
	    -0X01.8p1F,
	    -0X01.8p1d,
	    -0X01.8p1f,
	    -0X1.80P+1,
	    -0X1.80P+1D,
	    -0X1.80P+1F,
	    -0X1.80P+1d,
	    -0X1.80P+1f,
	    -0X1.80P1,
	    -0X1.80P1D,
	    -0X1.80P1F,
	    -0X1.80P1d,
	    -0X1.80P1f,
	    -0X1.80p+1,
	    -0X1.80p+1D,
	    -0X1.80p+1F,
	    -0X1.80p+1d,
	    -0X1.80p+1f,
	    -0X1.80p1,
	    -0X1.80p1D,
	    -0X1.80p1F,
	    -0X1.80p1d,
	    -0X1.80p1f,
	    -0X1.8P+1,
	    -0X1.8P+1D,
	    -0X1.8P+1F,
	    -0X1.8P+1d,
	    -0X1.8P+1f,
	    -0X1.8P1,
	    -0X1.8P1D,
	    -0X1.8P1F,
	    -0X1.8P1d,
	    -0X1.8P1f,
	    -0X1.8p+1,
	    -0X1.8p+1D,
	    -0X1.8p+1F,
	    -0X1.8p+1d,
	    -0X1.8p+1f,
	    -0X1.8p1,
	    -0X1.8p1D,
	    -0X1.8p1F,
	    -0X1.8p1d,
	    -0X1.8p1f,
	    -0X18.0P-3,
	    -0X18.0P-3D,
	    -0X18.0P-3F,
	    -0X18.0P-3d,
	    -0X18.0P-3f,
	    -0X18.0p-3,
	    -0X18.0p-3D,
	    -0X18.0p-3F,
	    -0X18.0p-3d,
	    -0X18.0p-3f,
	    -0X18P-3,
	    -0X18P-3D,
	    -0X18P-3F,
	    -0X18P-3d,
	    -0X18P-3f,
	    -0X18p-3,
	    -0X18p-3D,
	    -0X18p-3F,
	    -0X18p-3d,
	    -0X18p-3f,
	    -0X3.000000P+0,
	    -0X3.000000P+0D,
	    -0X3.000000P+0F,
	    -0X3.000000P+0d,
	    -0X3.000000P+0f,
	    -0X3.000000P-0,
	    -0X3.000000P-0D,
	    -0X3.000000P-0F,
	    -0X3.000000P-0d,
	    -0X3.000000P-0f,
	    -0X3.000000P0,
	    -0X3.000000P0D,
	    -0X3.000000P0F,
	    -0X3.000000P0d,
	    -0X3.000000P0f,
	    -0X3.000000p+0,
	    -0X3.000000p+0D,
	    -0X3.000000p+0F,
	    -0X3.000000p+0d,
	    -0X3.000000p+0f,
	    -0X3.000000p-0,
	    -0X3.000000p-0D,
	    -0X3.000000p-0F,
	    -0X3.000000p-0d,
	    -0X3.000000p-0f,
	    -0X3.000000p0,
	    -0X3.000000p0D,
	    -0X3.000000p0F,
	    -0X3.000000p0d,
	    -0X3.000000p0f,
	    -0X3.0P+0,
	    -0X3.0P+0D,
	    -0X3.0P+0F,
	    -0X3.0P+0d,
	    -0X3.0P+0f,
	    -0X3.0P-0,
	    -0X3.0P-0D,
	    -0X3.0P-0F,
	    -0X3.0P-0d,
	    -0X3.0P-0f,
	    -0X3.0P0,
	    -0X3.0P0D,
	    -0X3.0P0F,
	    -0X3.0P0d,
	    -0X3.0P0f,
	    -0X3.0p+0,
	    -0X3.0p+0D,
	    -0X3.0p+0F,
	    -0X3.0p+0d,
	    -0X3.0p+0f,
	    -0X3.0p-0,
	    -0X3.0p-0D,
	    -0X3.0p-0F,
	    -0X3.0p-0d,
	    -0X3.0p-0f,
	    -0X3.0p0,
	    -0X3.0p0D,
	    -0X3.0p0F,
	    -0X3.0p0d,
	    -0X3.0p0f,
	    -0X3.P+0,
	    -0X3.P+0D,
	    -0X3.P+0F,
	    -0X3.P+0d,
	    -0X3.P+0f,
	    -0X3.P-0,
	    -0X3.P-0D,
	    -0X3.P-0F,
	    -0X3.P-0d,
	    -0X3.P-0f,
	    -0X3.P0,
	    -0X3.P0D,
	    -0X3.P0F,
	    -0X3.P0d,
	    -0X3.P0f,
	    -0X3.p+0,
	    -0X3.p+0D,
	    -0X3.p+0F,
	    -0X3.p+0d,
	    -0X3.p+0f,
	    -0X3.p-0,
	    -0X3.p-0D,
	    -0X3.p-0F,
	    -0X3.p-0d,
	    -0X3.p-0f,
	    -0X3.p0,
	    -0X3.p0D,
	    -0X3.p0F,
	    -0X3.p0d,
	    -0X3.p0f,
	    -0X3000000.0000P-24,
	    -0X3000000.0000P-24D,
	    -0X3000000.0000P-24F,
	    -0X3000000.0000P-24d,
	    -0X3000000.0000P-24f,
	    -0X3000000.0000p-24,
	    -0X3000000.0000p-24D,
	    -0X3000000.0000p-24F,
	    -0X3000000.0000p-24d,
	    -0X3000000.0000p-24f,
	    -0X3000000.P-24,
	    -0X3000000.P-24D,
	    -0X3000000.P-24F,
	    -0X3000000.P-24d,
	    -0X3000000.P-24f,
	    -0X3000000.p-24,
	    -0X3000000.p-24D,
	    -0X3000000.p-24F,
	    -0X3000000.p-24d,
	    -0X3000000.p-24f,
	    -0X3000000P-24,
	    -0X3000000P-24D,
	    -0X3000000P-24F,
	    -0X3000000P-24d,
	    -0X3000000P-24f,
	    -0X3000000p-24,
	    -0X3000000p-24D,
	    -0X3000000p-24F,
	    -0X3000000p-24d,
	    -0X3000000p-24f,
	    -0X3P+0,
	    -0X3P+0D,
	    -0X3P+0F,
	    -0X3P+0d,
	    -0X3P+0f,
	    -0X3P-0,
	    -0X3P-0D,
	    -0X3P-0F,
	    -0X3P-0d,
	    -0X3P-0f,
	    -0X3P0,
	    -0X3P0D,
	    -0X3P0F,
	    -0X3P0d,
	    -0X3P0f,
	    -0X3p+0,
	    -0X3p+0D,
	    -0X3p+0F,
	    -0X3p+0d,
	    -0X3p+0f,
	    -0X3p-0,
	    -0X3p-0D,
	    -0X3p-0F,
	    -0X3p-0d,
	    -0X3p-0f,
	    -0X3p0,
	    -0X3p0D,
	    -0X3p0F,
	    -0X3p0d,
	    -0X3p0f,
	    -0XC.0P-2,
	    -0XC.0P-2D,
	    -0XC.0P-2F,
	    -0XC.0P-2d,
	    -0XC.0P-2f,
	    -0XC.0p-2,
	    -0XC.0p-2D,
	    -0XC.0p-2F,
	    -0XC.0p-2d,
	    -0XC.0p-2f,
	    -0XC.P-2,
	    -0XC.P-2D,
	    -0XC.P-2F,
	    -0XC.P-2d,
	    -0XC.P-2f,
	    -0XC.p-2,
	    -0XC.p-2D,
	    -0XC.p-2F,
	    -0XC.p-2d,
	    -0XC.p-2f,
	    -0XCP-2,
	    -0XCP-2D,
	    -0XCP-2F,
	    -0XCP-2d,
	    -0XCP-2f,
	    -0XCp-2,
	    -0XCp-2D,
	    -0XCp-2F,
	    -0XCp-2d,
	    -0XCp-2f,
	    -0Xc.0P-2,
	    -0Xc.0P-2D,
	    -0Xc.0P-2F,
	    -0Xc.0P-2d,
	    -0Xc.0P-2f,
	    -0Xc.0p-2,
	    -0Xc.0p-2D,
	    -0Xc.0p-2F,
	    -0Xc.0p-2d,
	    -0Xc.0p-2f,
	    -0Xc.P-2,
	    -0Xc.P-2D,
	    -0Xc.P-2F,
	    -0Xc.P-2d,
	    -0Xc.P-2f,
	    -0Xc.p-2,
	    -0Xc.p-2D,
	    -0Xc.p-2F,
	    -0Xc.p-2d,
	    -0Xc.p-2f,
	    -0XcP-2,
	    -0XcP-2D,
	    -0XcP-2F,
	    -0XcP-2d,
	    -0XcP-2f,
	    -0Xcp-2,
	    -0Xcp-2D,
	    -0Xcp-2F,
	    -0Xcp-2d,
	    -0Xcp-2f,
	    -0x.0030000000000P+12,
	    -0x.0030000000000P+12D,
	    -0x.0030000000000P+12F,
	    -0x.0030000000000P+12d,
	    -0x.0030000000000P+12f,
	    -0x.0030000000000P12,
	    -0x.0030000000000P12D,
	    -0x.0030000000000P12F,
	    -0x.0030000000000P12d,
	    -0x.0030000000000P12f,
	    -0x.0030000000000p+12,
	    -0x.0030000000000p+12D,
	    -0x.0030000000000p+12F,
	    -0x.0030000000000p+12d,
	    -0x.0030000000000p+12f,
	    -0x.0030000000000p12,
	    -0x.0030000000000p12D,
	    -0x.0030000000000p12F,
	    -0x.0030000000000p12d,
	    -0x.0030000000000p12f,
	    -0x.0030P+12,
	    -0x.0030P+12D,
	    -0x.0030P+12F,
	    -0x.0030P+12d,
	    -0x.0030P+12f,
	    -0x.0030P12,
	    -0x.0030P12D,
	    -0x.0030P12F,
	    -0x.0030P12d,
	    -0x.0030P12f,
	    -0x.0030p+12,
	    -0x.0030p+12D,
	    -0x.0030p+12F,
	    -0x.0030p+12d,
	    -0x.0030p+12f,
	    -0x.0030p12,
	    -0x.0030p12D,
	    -0x.0030p12F,
	    -0x.0030p12d,
	    -0x.0030p12f,
	    -0x.003P+12,
	    -0x.003P+12D,
	    -0x.003P+12F,
	    -0x.003P+12d,
	    -0x.003P+12f,
	    -0x.003P12,
	    -0x.003P12D,
	    -0x.003P12F,
	    -0x.003P12d,
	    -0x.003P12f,
	    -0x.003p+12,
	    -0x.003p+12D,
	    -0x.003p+12F,
	    -0x.003p+12d,
	    -0x.003p+12f,
	    -0x.003p12,
	    -0x.003p12D,
	    -0x.003p12F,
	    -0x.003p12d,
	    -0x.003p12f,
	    -0x.3P+4,
	    -0x.3P+4D,
	    -0x.3P+4F,
	    -0x.3P+4d,
	    -0x.3P+4f,
	    -0x.3P4,
	    -0x.3P4D,
	    -0x.3P4F,
	    -0x.3P4d,
	    -0x.3P4f,
	    -0x.3p+4,
	    -0x.3p+4D,
	    -0x.3p+4F,
	    -0x.3p+4d,
	    -0x.3p+4f,
	    -0x.3p4,
	    -0x.3p4D,
	    -0x.3p4F,
	    -0x.3p4d,
	    -0x.3p4f,
	    -0x.C0P+2,
	    -0x.C0P+2D,
	    -0x.C0P+2F,
	    -0x.C0P+2d,
	    -0x.C0P+2f,
	    -0x.C0P2,
	    -0x.C0P2D,
	    -0x.C0P2F,
	    -0x.C0P2d,
	    -0x.C0P2f,
	    -0x.C0p+2,
	    -0x.C0p+2D,
	    -0x.C0p+2F,
	    -0x.C0p+2d,
	    -0x.C0p+2f,
	    -0x.C0p2,
	    -0x.C0p2D,
	    -0x.C0p2F,
	    -0x.C0p2d,
	    -0x.C0p2f,
	    -0x.CP+2,
	    -0x.CP+2D,
	    -0x.CP+2F,
	    -0x.CP+2d,
	    -0x.CP+2f,
	    -0x.CP2,
	    -0x.CP2D,
	    -0x.CP2F,
	    -0x.CP2d,
	    -0x.CP2f,
	    -0x.Cp+2,
	    -0x.Cp+2D,
	    -0x.Cp+2F,
	    -0x.Cp+2d,
	    -0x.Cp+2f,
	    -0x.Cp2,
	    -0x.Cp2D,
	    -0x.Cp2F,
	    -0x.Cp2d,
	    -0x.Cp2f,
	    -0x.c0P+2,
	    -0x.c0P+2D,
	    -0x.c0P+2F,
	    -0x.c0P+2d,
	    -0x.c0P+2f,
	    -0x.c0P2,
	    -0x.c0P2D,
	    -0x.c0P2F,
	    -0x.c0P2d,
	    -0x.c0P2f,
	    -0x.c0p+2,
	    -0x.c0p+2D,
	    -0x.c0p+2F,
	    -0x.c0p+2d,
	    -0x.c0p+2f,
	    -0x.c0p2,
	    -0x.c0p2D,
	    -0x.c0p2F,
	    -0x.c0p2d,
	    -0x.c0p2f,
	    -0x.cP+2,
	    -0x.cP+2D,
	    -0x.cP+2F,
	    -0x.cP+2d,
	    -0x.cP+2f,
	    -0x.cP2,
	    -0x.cP2D,
	    -0x.cP2F,
	    -0x.cP2d,
	    -0x.cP2f,
	    -0x.cp+2,
	    -0x.cp+2D,
	    -0x.cp+2F,
	    -0x.cp+2d,
	    -0x.cp+2f,
	    -0x.cp2,
	    -0x.cp2D,
	    -0x.cp2F,
	    -0x.cp2d,
	    -0x.cp2f,
	    -0x0.30P+4,
	    -0x0.30P+4D,
	    -0x0.30P+4F,
	    -0x0.30P+4d,
	    -0x0.30P+4f,
	    -0x0.30P4,
	    -0x0.30P4D,
	    -0x0.30P4F,
	    -0x0.30P4d,
	    -0x0.30P4f,
	    -0x0.30p+4,
	    -0x0.30p+4D,
	    -0x0.30p+4F,
	    -0x0.30p+4d,
	    -0x0.30p+4f,
	    -0x0.30p4,
	    -0x0.30p4D,
	    -0x0.30p4F,
	    -0x0.30p4d,
	    -0x0.30p4f,
	    -0x0.3P+4,
	    -0x0.3P+4D,
	    -0x0.3P+4F,
	    -0x0.3P+4d,
	    -0x0.3P+4f,
	    -0x0.3P4,
	    -0x0.3P4D,
	    -0x0.3P4F,
	    -0x0.3P4d,
	    -0x0.3P4f,
	    -0x0.3p+4,
	    -0x0.3p+4D,
	    -0x0.3p+4F,
	    -0x0.3p+4d,
	    -0x0.3p+4f,
	    -0x0.3p4,
	    -0x0.3p4D,
	    -0x0.3p4F,
	    -0x0.3p4d,
	    -0x0.3p4f,
	    -0x0.C0P+2,
	    -0x0.C0P+2D,
	    -0x0.C0P+2F,
	    -0x0.C0P+2d,
	    -0x0.C0P+2f,
	    -0x0.C0P2,
	    -0x0.C0P2D,
	    -0x0.C0P2F,
	    -0x0.C0P2d,
	    -0x0.C0P2f,
	    -0x0.C0p+2,
	    -0x0.C0p+2D,
	    -0x0.C0p+2F,
	    -0x0.C0p+2d,
	    -0x0.C0p+2f,
	    -0x0.C0p2,
	    -0x0.C0p2D,
	    -0x0.C0p2F,
	    -0x0.C0p2d,
	    -0x0.C0p2f,
	    -0x0.CP+2,
	    -0x0.CP+2D,
	    -0x0.CP+2F,
	    -0x0.CP+2d,
	    -0x0.CP+2f,
	    -0x0.CP2,
	    -0x0.CP2D,
	    -0x0.CP2F,
	    -0x0.CP2d,
	    -0x0.CP2f,
	    -0x0.Cp+2,
	    -0x0.Cp+2D,
	    -0x0.Cp+2F,
	    -0x0.Cp+2d,
	    -0x0.Cp+2f,
	    -0x0.Cp2,
	    -0x0.Cp2D,
	    -0x0.Cp2F,
	    -0x0.Cp2d,
	    -0x0.Cp2f,
	    -0x0.c0P+2,
	    -0x0.c0P+2D,
	    -0x0.c0P+2F,
	    -0x0.c0P+2d,
	    -0x0.c0P+2f,
	    -0x0.c0P2,
	    -0x0.c0P2D,
	    -0x0.c0P2F,
	    -0x0.c0P2d,
	    -0x0.c0P2f,
	    -0x0.c0p+2,
	    -0x0.c0p+2D,
	    -0x0.c0p+2F,
	    -0x0.c0p+2d,
	    -0x0.c0p+2f,
	    -0x0.c0p2,
	    -0x0.c0p2D,
	    -0x0.c0p2F,
	    -0x0.c0p2d,
	    -0x0.c0p2f,
	    -0x0.cP+2,
	    -0x0.cP+2D,
	    -0x0.cP+2F,
	    -0x0.cP+2d,
	    -0x0.cP+2f,
	    -0x0.cP2,
	    -0x0.cP2D,
	    -0x0.cP2F,
	    -0x0.cP2d,
	    -0x0.cP2f,
	    -0x0.cp+2,
	    -0x0.cp+2D,
	    -0x0.cp+2F,
	    -0x0.cp+2d,
	    -0x0.cp+2f,
	    -0x0.cp2,
	    -0x0.cp2D,
	    -0x0.cp2F,
	    -0x0.cp2d,
	    -0x0.cp2f,
	    -0x000000000.0030000000000P+12,
	    -0x000000000.0030000000000P+12D,
	    -0x000000000.0030000000000P+12F,
	    -0x000000000.0030000000000P+12d,
	    -0x000000000.0030000000000P+12f,
	    -0x000000000.0030000000000P12,
	    -0x000000000.0030000000000P12D,
	    -0x000000000.0030000000000P12F,
	    -0x000000000.0030000000000P12d,
	    -0x000000000.0030000000000P12f,
	    -0x000000000.0030000000000p+12,
	    -0x000000000.0030000000000p+12D,
	    -0x000000000.0030000000000p+12F,
	    -0x000000000.0030000000000p+12d,
	    -0x000000000.0030000000000p+12f,
	    -0x000000000.0030000000000p12,
	    -0x000000000.0030000000000p12D,
	    -0x000000000.0030000000000p12F,
	    -0x000000000.0030000000000p12d,
	    -0x000000000.0030000000000p12f,
	    -0x00003P+0,
	    -0x00003P+0D,
	    -0x00003P+0F,
	    -0x00003P+0d,
	    -0x00003P+0f,
	    -0x00003P-0,
	    -0x00003P-0D,
	    -0x00003P-0F,
	    -0x00003P-0d,
	    -0x00003P-0f,
	    -0x00003P0,
	    -0x00003P0D,
	    -0x00003P0F,
	    -0x00003P0d,
	    -0x00003P0f,
	    -0x00003p+0,
	    -0x00003p+0D,
	    -0x00003p+0F,
	    -0x00003p+0d,
	    -0x00003p+0f,
	    -0x00003p-0,
	    -0x00003p-0D,
	    -0x00003p-0F,
	    -0x00003p-0d,
	    -0x00003p-0f,
	    -0x00003p0,
	    -0x00003p0D,
	    -0x00003p0F,
	    -0x00003p0d,
	    -0x00003p0f,
	    -0x0003.P+0,
	    -0x0003.P+0D,
	    -0x0003.P+0F,
	    -0x0003.P+0d,
	    -0x0003.P+0f,
	    -0x0003.P-0,
	    -0x0003.P-0D,
	    -0x0003.P-0F,
	    -0x0003.P-0d,
	    -0x0003.P-0f,
	    -0x0003.P0,
	    -0x0003.P0D,
	    -0x0003.P0F,
	    -0x0003.P0d,
	    -0x0003.P0f,
	    -0x0003.p+0,
	    -0x0003.p+0D,
	    -0x0003.p+0F,
	    -0x0003.p+0d,
	    -0x0003.p+0f,
	    -0x0003.p-0,
	    -0x0003.p-0D,
	    -0x0003.p-0F,
	    -0x0003.p-0d,
	    -0x0003.p-0f,
	    -0x0003.p0,
	    -0x0003.p0D,
	    -0x0003.p0F,
	    -0x0003.p0d,
	    -0x0003.p0f,
	    -0x0003P+0,
	    -0x0003P+0D,
	    -0x0003P+0F,
	    -0x0003P+0d,
	    -0x0003P+0f,
	    -0x0003P-0,
	    -0x0003P-0D,
	    -0x0003P-0F,
	    -0x0003P-0d,
	    -0x0003P-0f,
	    -0x0003P0,
	    -0x0003P0D,
	    -0x0003P0F,
	    -0x0003P0d,
	    -0x0003P0f,
	    -0x0003p+0,
	    -0x0003p+0D,
	    -0x0003p+0F,
	    -0x0003p+0d,
	    -0x0003p+0f,
	    -0x0003p-0,
	    -0x0003p-0D,
	    -0x0003p-0F,
	    -0x0003p-0d,
	    -0x0003p-0f,
	    -0x0003p0,
	    -0x0003p0D,
	    -0x0003p0F,
	    -0x0003p0d,
	    -0x0003p0f,
	    -0x01.80P+1,
	    -0x01.80P+1D,
	    -0x01.80P+1F,
	    -0x01.80P+1d,
	    -0x01.80P+1f,
	    -0x01.80P1,
	    -0x01.80P1D,
	    -0x01.80P1F,
	    -0x01.80P1d,
	    -0x01.80P1f,
	    -0x01.80p+1,
	    -0x01.80p+1D,
	    -0x01.80p+1F,
	    -0x01.80p+1d,
	    -0x01.80p+1f,
	    -0x01.80p1,
	    -0x01.80p1D,
	    -0x01.80p1F,
	    -0x01.80p1d,
	    -0x01.80p1f,
	    -0x01.8P+1,
	    -0x01.8P+1D,
	    -0x01.8P+1F,
	    -0x01.8P+1d,
	    -0x01.8P+1f,
	    -0x01.8P1,
	    -0x01.8P1D,
	    -0x01.8P1F,
	    -0x01.8P1d,
	    -0x01.8P1f,
	    -0x01.8p+1,
	    -0x01.8p+1D,
	    -0x01.8p+1F,
	    -0x01.8p+1d,
	    -0x01.8p+1f,
	    -0x01.8p1,
	    -0x01.8p1D,
	    -0x01.8p1F,
	    -0x01.8p1d,
	    -0x01.8p1f,
	    -0x1.80P+1,
	    -0x1.80P+1D,
	    -0x1.80P+1F,
	    -0x1.80P+1d,
	    -0x1.80P+1f,
	    -0x1.80P1,
	    -0x1.80P1D,
	    -0x1.80P1F,
	    -0x1.80P1d,
	    -0x1.80P1f,
	    -0x1.80p+1,
	    -0x1.80p+1D,
	    -0x1.80p+1F,
	    -0x1.80p+1d,
	    -0x1.80p+1f,
	    -0x1.80p1,
	    -0x1.80p1D,
	    -0x1.80p1F,
	    -0x1.80p1d,
	    -0x1.80p1f,
	    -0x1.8P+1,
	    -0x1.8P+1D,
	    -0x1.8P+1F,
	    -0x1.8P+1d,
	    -0x1.8P+1f,
	    -0x1.8P1,
	    -0x1.8P1D,
	    -0x1.8P1F,
	    -0x1.8P1d,
	    -0x1.8P1f,
	    -0x1.8p+1,
	    -0x1.8p+1D,
	    -0x1.8p+1F,
	    -0x1.8p+1d,
	    -0x1.8p+1f,
	    -0x1.8p1,
	    -0x1.8p1D,
	    -0x1.8p1F,
	    -0x1.8p1d,
	    -0x1.8p1f,
	    -0x18.0P-3,
	    -0x18.0P-3D,
	    -0x18.0P-3F,
	    -0x18.0P-3d,
	    -0x18.0P-3f,
	    -0x18.0p-3,
	    -0x18.0p-3D,
	    -0x18.0p-3F,
	    -0x18.0p-3d,
	    -0x18.0p-3f,
	    -0x18P-3,
	    -0x18P-3D,
	    -0x18P-3F,
	    -0x18P-3d,
	    -0x18P-3f,
	    -0x18p-3,
	    -0x18p-3D,
	    -0x18p-3F,
	    -0x18p-3d,
	    -0x18p-3f,
	    -0x3.000000P+0,
	    -0x3.000000P+0D,
	    -0x3.000000P+0F,
	    -0x3.000000P+0d,
	    -0x3.000000P+0f,
	    -0x3.000000P-0,
	    -0x3.000000P-0D,
	    -0x3.000000P-0F,
	    -0x3.000000P-0d,
	    -0x3.000000P-0f,
	    -0x3.000000P0,
	    -0x3.000000P0D,
	    -0x3.000000P0F,
	    -0x3.000000P0d,
	    -0x3.000000P0f,
	    -0x3.000000p+0,
	    -0x3.000000p+0D,
	    -0x3.000000p+0F,
	    -0x3.000000p+0d,
	    -0x3.000000p+0f,
	    -0x3.000000p-0,
	    -0x3.000000p-0D,
	    -0x3.000000p-0F,
	    -0x3.000000p-0d,
	    -0x3.000000p-0f,
	    -0x3.000000p0,
	    -0x3.000000p0D,
	    -0x3.000000p0F,
	    -0x3.000000p0d,
	    -0x3.000000p0f,
	    -0x3.0P+0,
	    -0x3.0P+0D,
	    -0x3.0P+0F,
	    -0x3.0P+0d,
	    -0x3.0P+0f,
	    -0x3.0P-0,
	    -0x3.0P-0D,
	    -0x3.0P-0F,
	    -0x3.0P-0d,
	    -0x3.0P-0f,
	    -0x3.0P0,
	    -0x3.0P0D,
	    -0x3.0P0F,
	    -0x3.0P0d,
	    -0x3.0P0f,
	    -0x3.0p+0,
	    -0x3.0p+0D,
	    -0x3.0p+0F,
	    -0x3.0p+0d,
	    -0x3.0p+0f,
	    -0x3.0p-0,
	    -0x3.0p-0D,
	    -0x3.0p-0F,
	    -0x3.0p-0d,
	    -0x3.0p-0f,
	    -0x3.0p0,
	    -0x3.0p0D,
	    -0x3.0p0F,
	    -0x3.0p0d,
	    -0x3.0p0f,
	    -0x3.P+0,
	    -0x3.P+0D,
	    -0x3.P+0F,
	    -0x3.P+0d,
	    -0x3.P+0f,
	    -0x3.P-0,
	    -0x3.P-0D,
	    -0x3.P-0F,
	    -0x3.P-0d,
	    -0x3.P-0f,
	    -0x3.P0,
	    -0x3.P0D,
	    -0x3.P0F,
	    -0x3.P0d,
	    -0x3.P0f,
	    -0x3.p+0,
	    -0x3.p+0D,
	    -0x3.p+0F,
	    -0x3.p+0d,
	    -0x3.p+0f,
	    -0x3.p-0,
	    -0x3.p-0D,
	    -0x3.p-0F,
	    -0x3.p-0d,
	    -0x3.p-0f,
	    -0x3.p0,
	    -0x3.p0D,
	    -0x3.p0F,
	    -0x3.p0d,
	    -0x3.p0f,
	    -0x3000000.0000P-24,
	    -0x3000000.0000P-24D,
	    -0x3000000.0000P-24F,
	    -0x3000000.0000P-24d,
	    -0x3000000.0000P-24f,
	    -0x3000000.0000p-24,
	    -0x3000000.0000p-24D,
	    -0x3000000.0000p-24F,
	    -0x3000000.0000p-24d,
	    -0x3000000.0000p-24f,
	    -0x3000000.P-24,
	    -0x3000000.P-24D,
	    -0x3000000.P-24F,
	    -0x3000000.P-24d,
	    -0x3000000.P-24f,
	    -0x3000000.p-24,
	    -0x3000000.p-24D,
	    -0x3000000.p-24F,
	    -0x3000000.p-24d,
	    -0x3000000.p-24f,
	    -0x3000000P-24,
	    -0x3000000P-24D,
	    -0x3000000P-24F,
	    -0x3000000P-24d,
	    -0x3000000P-24f,
	    -0x3000000p-24,
	    -0x3000000p-24D,
	    -0x3000000p-24F,
	    -0x3000000p-24d,
	    -0x3000000p-24f,
	    -0x3P+0,
	    -0x3P+0D,
	    -0x3P+0F,
	    -0x3P+0d,
	    -0x3P+0f,
	    -0x3P-0,
	    -0x3P-0D,
	    -0x3P-0F,
	    -0x3P-0d,
	    -0x3P-0f,
	    -0x3P0,
	    -0x3P0D,
	    -0x3P0F,
	    -0x3P0d,
	    -0x3P0f,
	    -0x3p+0,
	    -0x3p+0D,
	    -0x3p+0F,
	    -0x3p+0d,
	    -0x3p+0f,
	    -0x3p-0,
	    -0x3p-0D,
	    -0x3p-0F,
	    -0x3p-0d,
	    -0x3p-0f,
	    -0x3p0,
	    -0x3p0D,
	    -0x3p0F,
	    -0x3p0d,
	    -0x3p0f,
	    -0xC.0P-2,
	    -0xC.0P-2D,
	    -0xC.0P-2F,
	    -0xC.0P-2d,
	    -0xC.0P-2f,
	    -0xC.0p-2,
	    -0xC.0p-2D,
	    -0xC.0p-2F,
	    -0xC.0p-2d,
	    -0xC.0p-2f,
	    -0xC.P-2,
	    -0xC.P-2D,
	    -0xC.P-2F,
	    -0xC.P-2d,
	    -0xC.P-2f,
	    -0xC.p-2,
	    -0xC.p-2D,
	    -0xC.p-2F,
	    -0xC.p-2d,
	    -0xC.p-2f,
	    -0xCP-2,
	    -0xCP-2D,
	    -0xCP-2F,
	    -0xCP-2d,
	    -0xCP-2f,
	    -0xCp-2,
	    -0xCp-2D,
	    -0xCp-2F,
	    -0xCp-2d,
	    -0xCp-2f,
	    -0xc.0P-2,
	    -0xc.0P-2D,
	    -0xc.0P-2F,
	    -0xc.0P-2d,
	    -0xc.0P-2f,
	    -0xc.0p-2,
	    -0xc.0p-2D,
	    -0xc.0p-2F,
	    -0xc.0p-2d,
	    -0xc.0p-2f,
	    -0xc.P-2,
	    -0xc.P-2D,
	    -0xc.P-2F,
	    -0xc.P-2d,
	    -0xc.P-2f,
	    -0xc.p-2,
	    -0xc.p-2D,
	    -0xc.p-2F,
	    -0xc.p-2d,
	    -0xc.p-2f,
	    -0xcP-2,
	    -0xcP-2D,
	    -0xcP-2F,
	    -0xcP-2d,
	    -0xcP-2f,
	    -0xcp-2,
	    -0xcp-2D,
	    -0xcp-2F,
	    -0xcp-2d,
	    -0xcp-2f,
	    0X.0030000000000P+12,
	    0X.0030000000000P+12D,
	    0X.0030000000000P+12F,
	    0X.0030000000000P+12d,
	    0X.0030000000000P+12f,
	    0X.0030000000000P12,
	    0X.0030000000000P12D,
	    0X.0030000000000P12F,
	    0X.0030000000000P12d,
	    0X.0030000000000P12f,
	    0X.0030000000000p+12,
	    0X.0030000000000p+12D,
	    0X.0030000000000p+12F,
	    0X.0030000000000p+12d,
	    0X.0030000000000p+12f,
	    0X.0030000000000p12,
	    0X.0030000000000p12D,
	    0X.0030000000000p12F,
	    0X.0030000000000p12d,
	    0X.0030000000000p12f,
	    0X.0030P+12,
	    0X.0030P+12D,
	    0X.0030P+12F,
	    0X.0030P+12d,
	    0X.0030P+12f,
	    0X.0030P12,
	    0X.0030P12D,
	    0X.0030P12F,
	    0X.0030P12d,
	    0X.0030P12f,
	    0X.0030p+12,
	    0X.0030p+12D,
	    0X.0030p+12F,
	    0X.0030p+12d,
	    0X.0030p+12f,
	    0X.0030p12,
	    0X.0030p12D,
	    0X.0030p12F,
	    0X.0030p12d,
	    0X.0030p12f,
	    0X.003P+12,
	    0X.003P+12D,
	    0X.003P+12F,
	    0X.003P+12d,
	    0X.003P+12f,
	    0X.003P12,
	    0X.003P12D,
	    0X.003P12F,
	    0X.003P12d,
	    0X.003P12f,
	    0X.003p+12,
	    0X.003p+12D,
	    0X.003p+12F,
	    0X.003p+12d,
	    0X.003p+12f,
	    0X.003p12,
	    0X.003p12D,
	    0X.003p12F,
	    0X.003p12d,
	    0X.003p12f,
	    0X.3P+4,
	    0X.3P+4D,
	    0X.3P+4F,
	    0X.3P+4d,
	    0X.3P+4f,
	    0X.3P4,
	    0X.3P4D,
	    0X.3P4F,
	    0X.3P4d,
	    0X.3P4f,
	    0X.3p+4,
	    0X.3p+4D,
	    0X.3p+4F,
	    0X.3p+4d,
	    0X.3p+4f,
	    0X.3p4,
	    0X.3p4D,
	    0X.3p4F,
	    0X.3p4d,
	    0X.3p4f,
	    0X.C0P+2,
	    0X.C0P+2D,
	    0X.C0P+2F,
	    0X.C0P+2d,
	    0X.C0P+2f,
	    0X.C0P2,
	    0X.C0P2D,
	    0X.C0P2F,
	    0X.C0P2d,
	    0X.C0P2f,
	    0X.C0p+2,
	    0X.C0p+2D,
	    0X.C0p+2F,
	    0X.C0p+2d,
	    0X.C0p+2f,
	    0X.C0p2,
	    0X.C0p2D,
	    0X.C0p2F,
	    0X.C0p2d,
	    0X.C0p2f,
	    0X.CP+2,
	    0X.CP+2D,
	    0X.CP+2F,
	    0X.CP+2d,
	    0X.CP+2f,
	    0X.CP2,
	    0X.CP2D,
	    0X.CP2F,
	    0X.CP2d,
	    0X.CP2f,
	    0X.Cp+2,
	    0X.Cp+2D,
	    0X.Cp+2F,
	    0X.Cp+2d,
	    0X.Cp+2f,
	    0X.Cp2,
	    0X.Cp2D,
	    0X.Cp2F,
	    0X.Cp2d,
	    0X.Cp2f,
	    0X.c0P+2,
	    0X.c0P+2D,
	    0X.c0P+2F,
	    0X.c0P+2d,
	    0X.c0P+2f,
	    0X.c0P2,
	    0X.c0P2D,
	    0X.c0P2F,
	    0X.c0P2d,
	    0X.c0P2f,
	    0X.c0p+2,
	    0X.c0p+2D,
	    0X.c0p+2F,
	    0X.c0p+2d,
	    0X.c0p+2f,
	    0X.c0p2,
	    0X.c0p2D,
	    0X.c0p2F,
	    0X.c0p2d,
	    0X.c0p2f,
	    0X.cP+2,
	    0X.cP+2D,
	    0X.cP+2F,
	    0X.cP+2d,
	    0X.cP+2f,
	    0X.cP2,
	    0X.cP2D,
	    0X.cP2F,
	    0X.cP2d,
	    0X.cP2f,
	    0X.cp+2,
	    0X.cp+2D,
	    0X.cp+2F,
	    0X.cp+2d,
	    0X.cp+2f,
	    0X.cp2,
	    0X.cp2D,
	    0X.cp2F,
	    0X.cp2d,
	    0X.cp2f,
	    0X0.30P+4,
	    0X0.30P+4D,
	    0X0.30P+4F,
	    0X0.30P+4d,
	    0X0.30P+4f,
	    0X0.30P4,
	    0X0.30P4D,
	    0X0.30P4F,
	    0X0.30P4d,
	    0X0.30P4f,
	    0X0.30p+4,
	    0X0.30p+4D,
	    0X0.30p+4F,
	    0X0.30p+4d,
	    0X0.30p+4f,
	    0X0.30p4,
	    0X0.30p4D,
	    0X0.30p4F,
	    0X0.30p4d,
	    0X0.30p4f,
	    0X0.3P+4,
	    0X0.3P+4D,
	    0X0.3P+4F,
	    0X0.3P+4d,
	    0X0.3P+4f,
	    0X0.3P4,
	    0X0.3P4D,
	    0X0.3P4F,
	    0X0.3P4d,
	    0X0.3P4f,
	    0X0.3p+4,
	    0X0.3p+4D,
	    0X0.3p+4F,
	    0X0.3p+4d,
	    0X0.3p+4f,
	    0X0.3p4,
	    0X0.3p4D,
	    0X0.3p4F,
	    0X0.3p4d,
	    0X0.3p4f,
	    0X0.C0P+2,
	    0X0.C0P+2D,
	    0X0.C0P+2F,
	    0X0.C0P+2d,
	    0X0.C0P+2f,
	    0X0.C0P2,
	    0X0.C0P2D,
	    0X0.C0P2F,
	    0X0.C0P2d,
	    0X0.C0P2f,
	    0X0.C0p+2,
	    0X0.C0p+2D,
	    0X0.C0p+2F,
	    0X0.C0p+2d,
	    0X0.C0p+2f,
	    0X0.C0p2,
	    0X0.C0p2D,
	    0X0.C0p2F,
	    0X0.C0p2d,
	    0X0.C0p2f,
	    0X0.CP+2,
	    0X0.CP+2D,
	    0X0.CP+2F,
	    0X0.CP+2d,
	    0X0.CP+2f,
	    0X0.CP2,
	    0X0.CP2D,
	    0X0.CP2F,
	    0X0.CP2d,
	    0X0.CP2f,
	    0X0.Cp+2,
	    0X0.Cp+2D,
	    0X0.Cp+2F,
	    0X0.Cp+2d,
	    0X0.Cp+2f,
	    0X0.Cp2,
	    0X0.Cp2D,
	    0X0.Cp2F,
	    0X0.Cp2d,
	    0X0.Cp2f,
	    0X0.c0P+2,
	    0X0.c0P+2D,
	    0X0.c0P+2F,
	    0X0.c0P+2d,
	    0X0.c0P+2f,
	    0X0.c0P2,
	    0X0.c0P2D,
	    0X0.c0P2F,
	    0X0.c0P2d,
	    0X0.c0P2f,
	    0X0.c0p+2,
	    0X0.c0p+2D,
	    0X0.c0p+2F,
	    0X0.c0p+2d,
	    0X0.c0p+2f,
	    0X0.c0p2,
	    0X0.c0p2D,
	    0X0.c0p2F,
	    0X0.c0p2d,
	    0X0.c0p2f,
	    0X0.cP+2,
	    0X0.cP+2D,
	    0X0.cP+2F,
	    0X0.cP+2d,
	    0X0.cP+2f,
	    0X0.cP2,
	    0X0.cP2D,
	    0X0.cP2F,
	    0X0.cP2d,
	    0X0.cP2f,
	    0X0.cp+2,
	    0X0.cp+2D,
	    0X0.cp+2F,
	    0X0.cp+2d,
	    0X0.cp+2f,
	    0X0.cp2,
	    0X0.cp2D,
	    0X0.cp2F,
	    0X0.cp2d,
	    0X0.cp2f,
	    0X000000000.0030000000000P+12,
	    0X000000000.0030000000000P+12D,
	    0X000000000.0030000000000P+12F,
	    0X000000000.0030000000000P+12d,
	    0X000000000.0030000000000P+12f,
	    0X000000000.0030000000000P12,
	    0X000000000.0030000000000P12D,
	    0X000000000.0030000000000P12F,
	    0X000000000.0030000000000P12d,
	    0X000000000.0030000000000P12f,
	    0X000000000.0030000000000p+12,
	    0X000000000.0030000000000p+12D,
	    0X000000000.0030000000000p+12F,
	    0X000000000.0030000000000p+12d,
	    0X000000000.0030000000000p+12f,
	    0X000000000.0030000000000p12,
	    0X000000000.0030000000000p12D,
	    0X000000000.0030000000000p12F,
	    0X000000000.0030000000000p12d,
	    0X000000000.0030000000000p12f,
	    0X00003P+0,
	    0X00003P+0D,
	    0X00003P+0F,
	    0X00003P+0d,
	    0X00003P+0f,
	    0X00003P-0,
	    0X00003P-0D,
	    0X00003P-0F,
	    0X00003P-0d,
	    0X00003P-0f,
	    0X00003P0,
	    0X00003P0D,
	    0X00003P0F,
	    0X00003P0d,
	    0X00003P0f,
	    0X00003p+0,
	    0X00003p+0D,
	    0X00003p+0F,
	    0X00003p+0d,
	    0X00003p+0f,
	    0X00003p-0,
	    0X00003p-0D,
	    0X00003p-0F,
	    0X00003p-0d,
	    0X00003p-0f,
	    0X00003p0,
	    0X00003p0D,
	    0X00003p0F,
	    0X00003p0d,
	    0X00003p0f,
	    0X0003.P+0,
	    0X0003.P+0D,
	    0X0003.P+0F,
	    0X0003.P+0d,
	    0X0003.P+0f,
	    0X0003.P-0,
	    0X0003.P-0D,
	    0X0003.P-0F,
	    0X0003.P-0d,
	    0X0003.P-0f,
	    0X0003.P0,
	    0X0003.P0D,
	    0X0003.P0F,
	    0X0003.P0d,
	    0X0003.P0f,
	    0X0003.p+0,
	    0X0003.p+0D,
	    0X0003.p+0F,
	    0X0003.p+0d,
	    0X0003.p+0f,
	    0X0003.p-0,
	    0X0003.p-0D,
	    0X0003.p-0F,
	    0X0003.p-0d,
	    0X0003.p-0f,
	    0X0003.p0,
	    0X0003.p0D,
	    0X0003.p0F,
	    0X0003.p0d,
	    0X0003.p0f,
	    0X0003P+0,
	    0X0003P+0D,
	    0X0003P+0F,
	    0X0003P+0d,
	    0X0003P+0f,
	    0X0003P-0,
	    0X0003P-0D,
	    0X0003P-0F,
	    0X0003P-0d,
	    0X0003P-0f,
	    0X0003P0,
	    0X0003P0D,
	    0X0003P0F,
	    0X0003P0d,
	    0X0003P0f,
	    0X0003p+0,
	    0X0003p+0D,
	    0X0003p+0F,
	    0X0003p+0d,
	    0X0003p+0f,
	    0X0003p-0,
	    0X0003p-0D,
	    0X0003p-0F,
	    0X0003p-0d,
	    0X0003p-0f,
	    0X0003p0,
	    0X0003p0D,
	    0X0003p0F,
	    0X0003p0d,
	    0X0003p0f,
	    0X01.80P+1,
	    0X01.80P+1D,
	    0X01.80P+1F,
	    0X01.80P+1d,
	    0X01.80P+1f,
	    0X01.80P1,
	    0X01.80P1D,
	    0X01.80P1F,
	    0X01.80P1d,
	    0X01.80P1f,
	    0X01.80p+1,
	    0X01.80p+1D,
	    0X01.80p+1F,
	    0X01.80p+1d,
	    0X01.80p+1f,
	    0X01.80p1,
	    0X01.80p1D,
	    0X01.80p1F,
	    0X01.80p1d,
	    0X01.80p1f,
	    0X01.8P+1,
	    0X01.8P+1D,
	    0X01.8P+1F,
	    0X01.8P+1d,
	    0X01.8P+1f,
	    0X01.8P1,
	    0X01.8P1D,
	    0X01.8P1F,
	    0X01.8P1d,
	    0X01.8P1f,
	    0X01.8p+1,
	    0X01.8p+1D,
	    0X01.8p+1F,
	    0X01.8p+1d,
	    0X01.8p+1f,
	    0X01.8p1,
	    0X01.8p1D,
	    0X01.8p1F,
	    0X01.8p1d,
	    0X01.8p1f,
	    0X1.80P+1,
	    0X1.80P+1D,
	    0X1.80P+1F,
	    0X1.80P+1d,
	    0X1.80P+1f,
	    0X1.80P1,
	    0X1.80P1D,
	    0X1.80P1F,
	    0X1.80P1d,
	    0X1.80P1f,
	    0X1.80p+1,
	    0X1.80p+1D,
	    0X1.80p+1F,
	    0X1.80p+1d,
	    0X1.80p+1f,
	    0X1.80p1,
	    0X1.80p1D,
	    0X1.80p1F,
	    0X1.80p1d,
	    0X1.80p1f,
	    0X1.8P+1,
	    0X1.8P+1D,
	    0X1.8P+1F,
	    0X1.8P+1d,
	    0X1.8P+1f,
	    0X1.8P1,
	    0X1.8P1D,
	    0X1.8P1F,
	    0X1.8P1d,
	    0X1.8P1f,
	    0X1.8p+1,
	    0X1.8p+1D,
	    0X1.8p+1F,
	    0X1.8p+1d,
	    0X1.8p+1f,
	    0X1.8p1,
	    0X1.8p1D,
	    0X1.8p1F,
	    0X1.8p1d,
	    0X1.8p1f,
	    0X18.0P-3,
	    0X18.0P-3D,
	    0X18.0P-3F,
	    0X18.0P-3d,
	    0X18.0P-3f,
	    0X18.0p-3,
	    0X18.0p-3D,
	    0X18.0p-3F,
	    0X18.0p-3d,
	    0X18.0p-3f,
	    0X18P-3,
	    0X18P-3D,
	    0X18P-3F,
	    0X18P-3d,
	    0X18P-3f,
	    0X18p-3,
	    0X18p-3D,
	    0X18p-3F,
	    0X18p-3d,
	    0X18p-3f,
	    0X3.000000P+0,
	    0X3.000000P+0D,
	    0X3.000000P+0F,
	    0X3.000000P+0d,
	    0X3.000000P+0f,
	    0X3.000000P-0,
	    0X3.000000P-0D,
	    0X3.000000P-0F,
	    0X3.000000P-0d,
	    0X3.000000P-0f,
	    0X3.000000P0,
	    0X3.000000P0D,
	    0X3.000000P0F,
	    0X3.000000P0d,
	    0X3.000000P0f,
	    0X3.000000p+0,
	    0X3.000000p+0D,
	    0X3.000000p+0F,
	    0X3.000000p+0d,
	    0X3.000000p+0f,
	    0X3.000000p-0,
	    0X3.000000p-0D,
	    0X3.000000p-0F,
	    0X3.000000p-0d,
	    0X3.000000p-0f,
	    0X3.000000p0,
	    0X3.000000p0D,
	    0X3.000000p0F,
	    0X3.000000p0d,
	    0X3.000000p0f,
	    0X3.0P+0,
	    0X3.0P+0D,
	    0X3.0P+0F,
	    0X3.0P+0d,
	    0X3.0P+0f,
	    0X3.0P-0,
	    0X3.0P-0D,
	    0X3.0P-0F,
	    0X3.0P-0d,
	    0X3.0P-0f,
	    0X3.0P0,
	    0X3.0P0D,
	    0X3.0P0F,
	    0X3.0P0d,
	    0X3.0P0f,
	    0X3.0p+0,
	    0X3.0p+0D,
	    0X3.0p+0F,
	    0X3.0p+0d,
	    0X3.0p+0f,
	    0X3.0p-0,
	    0X3.0p-0D,
	    0X3.0p-0F,
	    0X3.0p-0d,
	    0X3.0p-0f,
	    0X3.0p0,
	    0X3.0p0D,
	    0X3.0p0F,
	    0X3.0p0d,
	    0X3.0p0f,
	    0X3.P+0,
	    0X3.P+0D,
	    0X3.P+0F,
	    0X3.P+0d,
	    0X3.P+0f,
	    0X3.P-0,
	    0X3.P-0D,
	    0X3.P-0F,
	    0X3.P-0d,
	    0X3.P-0f,
	    0X3.P0,
	    0X3.P0D,
	    0X3.P0F,
	    0X3.P0d,
	    0X3.P0f,
	    0X3.p+0,
	    0X3.p+0D,
	    0X3.p+0F,
	    0X3.p+0d,
	    0X3.p+0f,
	    0X3.p-0,
	    0X3.p-0D,
	    0X3.p-0F,
	    0X3.p-0d,
	    0X3.p-0f,
	    0X3.p0,
	    0X3.p0D,
	    0X3.p0F,
	    0X3.p0d,
	    0X3.p0f,
	    0X3000000.0000P-24,
	    0X3000000.0000P-24D,
	    0X3000000.0000P-24F,
	    0X3000000.0000P-24d,
	    0X3000000.0000P-24f,
	    0X3000000.0000p-24,
	    0X3000000.0000p-24D,
	    0X3000000.0000p-24F,
	    0X3000000.0000p-24d,
	    0X3000000.0000p-24f,
	    0X3000000.P-24,
	    0X3000000.P-24D,
	    0X3000000.P-24F,
	    0X3000000.P-24d,
	    0X3000000.P-24f,
	    0X3000000.p-24,
	    0X3000000.p-24D,
	    0X3000000.p-24F,
	    0X3000000.p-24d,
	    0X3000000.p-24f,
	    0X3000000P-24,
	    0X3000000P-24D,
	    0X3000000P-24F,
	    0X3000000P-24d,
	    0X3000000P-24f,
	    0X3000000p-24,
	    0X3000000p-24D,
	    0X3000000p-24F,
	    0X3000000p-24d,
	    0X3000000p-24f,
	    0X3P+0,
	    0X3P+0D,
	    0X3P+0F,
	    0X3P+0d,
	    0X3P+0f,
	    0X3P-0,
	    0X3P-0D,
	    0X3P-0F,
	    0X3P-0d,
	    0X3P-0f,
	    0X3P0,
	    0X3P0D,
	    0X3P0F,
	    0X3P0d,
	    0X3P0f,
	    0X3p+0,
	    0X3p+0D,
	    0X3p+0F,
	    0X3p+0d,
	    0X3p+0f,
	    0X3p-0,
	    0X3p-0D,
	    0X3p-0F,
	    0X3p-0d,
	    0X3p-0f,
	    0X3p0,
	    0X3p0D,
	    0X3p0F,
	    0X3p0d,
	    0X3p0f,
	    0XC.0P-2,
	    0XC.0P-2D,
	    0XC.0P-2F,
	    0XC.0P-2d,
	    0XC.0P-2f,
	    0XC.0p-2,
	    0XC.0p-2D,
	    0XC.0p-2F,
	    0XC.0p-2d,
	    0XC.0p-2f,
	    0XC.P-2,
	    0XC.P-2D,
	    0XC.P-2F,
	    0XC.P-2d,
	    0XC.P-2f,
	    0XC.p-2,
	    0XC.p-2D,
	    0XC.p-2F,
	    0XC.p-2d,
	    0XC.p-2f,
	    0XCP-2,
	    0XCP-2D,
	    0XCP-2F,
	    0XCP-2d,
	    0XCP-2f,
	    0XCp-2,
	    0XCp-2D,
	    0XCp-2F,
	    0XCp-2d,
	    0XCp-2f,
	    0Xc.0P-2,
	    0Xc.0P-2D,
	    0Xc.0P-2F,
	    0Xc.0P-2d,
	    0Xc.0P-2f,
	    0Xc.0p-2,
	    0Xc.0p-2D,
	    0Xc.0p-2F,
	    0Xc.0p-2d,
	    0Xc.0p-2f,
	    0Xc.P-2,
	    0Xc.P-2D,
	    0Xc.P-2F,
	    0Xc.P-2d,
	    0Xc.P-2f,
	    0Xc.p-2,
	    0Xc.p-2D,
	    0Xc.p-2F,
	    0Xc.p-2d,
	    0Xc.p-2f,
	    0XcP-2,
	    0XcP-2D,
	    0XcP-2F,
	    0XcP-2d,
	    0XcP-2f,
	    0Xcp-2,
	    0Xcp-2D,
	    0Xcp-2F,
	    0Xcp-2d,
	    0Xcp-2f,
	    0x.0030000000000P+12,
	    0x.0030000000000P+12D,
	    0x.0030000000000P+12F,
	    0x.0030000000000P+12d,
	    0x.0030000000000P+12f,
	    0x.0030000000000P12,
	    0x.0030000000000P12D,
	    0x.0030000000000P12F,
	    0x.0030000000000P12d,
	    0x.0030000000000P12f,
	    0x.0030000000000p+12,
	    0x.0030000000000p+12D,
	    0x.0030000000000p+12F,
	    0x.0030000000000p+12d,
	    0x.0030000000000p+12f,
	    0x.0030000000000p12,
	    0x.0030000000000p12D,
	    0x.0030000000000p12F,
	    0x.0030000000000p12d,
	    0x.0030000000000p12f,
	    0x.0030P+12,
	    0x.0030P+12D,
	    0x.0030P+12F,
	    0x.0030P+12d,
	    0x.0030P+12f,
	    0x.0030P12,
	    0x.0030P12D,
	    0x.0030P12F,
	    0x.0030P12d,
	    0x.0030P12f,
	    0x.0030p+12,
	    0x.0030p+12D,
	    0x.0030p+12F,
	    0x.0030p+12d,
	    0x.0030p+12f,
	    0x.0030p12,
	    0x.0030p12D,
	    0x.0030p12F,
	    0x.0030p12d,
	    0x.0030p12f,
	    0x.003P+12,
	    0x.003P+12D,
	    0x.003P+12F,
	    0x.003P+12d,
	    0x.003P+12f,
	    0x.003P12,
	    0x.003P12D,
	    0x.003P12F,
	    0x.003P12d,
	    0x.003P12f,
	    0x.003p+12,
	    0x.003p+12D,
	    0x.003p+12F,
	    0x.003p+12d,
	    0x.003p+12f,
	    0x.003p12,
	    0x.003p12D,
	    0x.003p12F,
	    0x.003p12d,
	    0x.003p12f,
	    0x.3P+4,
	    0x.3P+4D,
	    0x.3P+4F,
	    0x.3P+4d,
	    0x.3P+4f,
	    0x.3P4,
	    0x.3P4D,
	    0x.3P4F,
	    0x.3P4d,
	    0x.3P4f,
	    0x.3p+4,
	    0x.3p+4D,
	    0x.3p+4F,
	    0x.3p+4d,
	    0x.3p+4f,
	    0x.3p4,
	    0x.3p4D,
	    0x.3p4F,
	    0x.3p4d,
	    0x.3p4f,
	    0x.C0P+2,
	    0x.C0P+2D,
	    0x.C0P+2F,
	    0x.C0P+2d,
	    0x.C0P+2f,
	    0x.C0P2,
	    0x.C0P2D,
	    0x.C0P2F,
	    0x.C0P2d,
	    0x.C0P2f,
	    0x.C0p+2,
	    0x.C0p+2D,
	    0x.C0p+2F,
	    0x.C0p+2d,
	    0x.C0p+2f,
	    0x.C0p2,
	    0x.C0p2D,
	    0x.C0p2F,
	    0x.C0p2d,
	    0x.C0p2f,
	    0x.CP+2,
	    0x.CP+2D,
	    0x.CP+2F,
	    0x.CP+2d,
	    0x.CP+2f,
	    0x.CP2,
	    0x.CP2D,
	    0x.CP2F,
	    0x.CP2d,
	    0x.CP2f,
	    0x.Cp+2,
	    0x.Cp+2D,
	    0x.Cp+2F,
	    0x.Cp+2d,
	    0x.Cp+2f,
	    0x.Cp2,
	    0x.Cp2D,
	    0x.Cp2F,
	    0x.Cp2d,
	    0x.Cp2f,
	    0x.c0P+2,
	    0x.c0P+2D,
	    0x.c0P+2F,
	    0x.c0P+2d,
	    0x.c0P+2f,
	    0x.c0P2,
	    0x.c0P2D,
	    0x.c0P2F,
	    0x.c0P2d,
	    0x.c0P2f,
	    0x.c0p+2,
	    0x.c0p+2D,
	    0x.c0p+2F,
	    0x.c0p+2d,
	    0x.c0p+2f,
	    0x.c0p2,
	    0x.c0p2D,
	    0x.c0p2F,
	    0x.c0p2d,
	    0x.c0p2f,
	    0x.cP+2,
	    0x.cP+2D,
	    0x.cP+2F,
	    0x.cP+2d,
	    0x.cP+2f,
	    0x.cP2,
	    0x.cP2D,
	    0x.cP2F,
	    0x.cP2d,
	    0x.cP2f,
	    0x.cp+2,
	    0x.cp+2D,
	    0x.cp+2F,
	    0x.cp+2d,
	    0x.cp+2f,
	    0x.cp2,
	    0x.cp2D,
	    0x.cp2F,
	    0x.cp2d,
	    0x.cp2f,
	    0x0.30P+4,
	    0x0.30P+4D,
	    0x0.30P+4F,
	    0x0.30P+4d,
	    0x0.30P+4f,
	    0x0.30P4,
	    0x0.30P4D,
	    0x0.30P4F,
	    0x0.30P4d,
	    0x0.30P4f,
	    0x0.30p+4,
	    0x0.30p+4D,
	    0x0.30p+4F,
	    0x0.30p+4d,
	    0x0.30p+4f,
	    0x0.30p4,
	    0x0.30p4D,
	    0x0.30p4F,
	    0x0.30p4d,
	    0x0.30p4f,
	    0x0.3P+4,
	    0x0.3P+4D,
	    0x0.3P+4F,
	    0x0.3P+4d,
	    0x0.3P+4f,
	    0x0.3P4,
	    0x0.3P4D,
	    0x0.3P4F,
	    0x0.3P4d,
	    0x0.3P4f,
	    0x0.3p+4,
	    0x0.3p+4D,
	    0x0.3p+4F,
	    0x0.3p+4d,
	    0x0.3p+4f,
	    0x0.3p4,
	    0x0.3p4D,
	    0x0.3p4F,
	    0x0.3p4d,
	    0x0.3p4f,
	    0x0.C0P+2,
	    0x0.C0P+2D,
	    0x0.C0P+2F,
	    0x0.C0P+2d,
	    0x0.C0P+2f,
	    0x0.C0P2,
	    0x0.C0P2D,
	    0x0.C0P2F,
	    0x0.C0P2d,
	    0x0.C0P2f,
	    0x0.C0p+2,
	    0x0.C0p+2D,
	    0x0.C0p+2F,
	    0x0.C0p+2d,
	    0x0.C0p+2f,
	    0x0.C0p2,
	    0x0.C0p2D,
	    0x0.C0p2F,
	    0x0.C0p2d,
	    0x0.C0p2f,
	    0x0.CP+2,
	    0x0.CP+2D,
	    0x0.CP+2F,
	    0x0.CP+2d,
	    0x0.CP+2f,
	    0x0.CP2,
	    0x0.CP2D,
	    0x0.CP2F,
	    0x0.CP2d,
	    0x0.CP2f,
	    0x0.Cp+2,
	    0x0.Cp+2D,
	    0x0.Cp+2F,
	    0x0.Cp+2d,
	    0x0.Cp+2f,
	    0x0.Cp2,
	    0x0.Cp2D,
	    0x0.Cp2F,
	    0x0.Cp2d,
	    0x0.Cp2f,
	    0x0.c0P+2,
	    0x0.c0P+2D,
	    0x0.c0P+2F,
	    0x0.c0P+2d,
	    0x0.c0P+2f,
	    0x0.c0P2,
	    0x0.c0P2D,
	    0x0.c0P2F,
	    0x0.c0P2d,
	    0x0.c0P2f,
	    0x0.c0p+2,
	    0x0.c0p+2D,
	    0x0.c0p+2F,
	    0x0.c0p+2d,
	    0x0.c0p+2f,
	    0x0.c0p2,
	    0x0.c0p2D,
	    0x0.c0p2F,
	    0x0.c0p2d,
	    0x0.c0p2f,
	    0x0.cP+2,
	    0x0.cP+2D,
	    0x0.cP+2F,
	    0x0.cP+2d,
	    0x0.cP+2f,
	    0x0.cP2,
	    0x0.cP2D,
	    0x0.cP2F,
	    0x0.cP2d,
	    0x0.cP2f,
	    0x0.cp+2,
	    0x0.cp+2D,
	    0x0.cp+2F,
	    0x0.cp+2d,
	    0x0.cp+2f,
	    0x0.cp2,
	    0x0.cp2D,
	    0x0.cp2F,
	    0x0.cp2d,
	    0x0.cp2f,
	    0x000000000.0030000000000P+12,
	    0x000000000.0030000000000P+12D,
	    0x000000000.0030000000000P+12F,
	    0x000000000.0030000000000P+12d,
	    0x000000000.0030000000000P+12f,
	    0x000000000.0030000000000P12,
	    0x000000000.0030000000000P12D,
	    0x000000000.0030000000000P12F,
	    0x000000000.0030000000000P12d,
	    0x000000000.0030000000000P12f,
	    0x000000000.0030000000000p+12,
	    0x000000000.0030000000000p+12D,
	    0x000000000.0030000000000p+12F,
	    0x000000000.0030000000000p+12d,
	    0x000000000.0030000000000p+12f,
	    0x000000000.0030000000000p12,
	    0x000000000.0030000000000p12D,
	    0x000000000.0030000000000p12F,
	    0x000000000.0030000000000p12d,
	    0x000000000.0030000000000p12f,
	    0x00003P+0,
	    0x00003P+0D,
	    0x00003P+0F,
	    0x00003P+0d,
	    0x00003P+0f,
	    0x00003P-0,
	    0x00003P-0D,
	    0x00003P-0F,
	    0x00003P-0d,
	    0x00003P-0f,
	    0x00003P0,
	    0x00003P0D,
	    0x00003P0F,
	    0x00003P0d,
	    0x00003P0f,
	    0x00003p+0,
	    0x00003p+0D,
	    0x00003p+0F,
	    0x00003p+0d,
	    0x00003p+0f,
	    0x00003p-0,
	    0x00003p-0D,
	    0x00003p-0F,
	    0x00003p-0d,
	    0x00003p-0f,
	    0x00003p0,
	    0x00003p0D,
	    0x00003p0F,
	    0x00003p0d,
	    0x00003p0f,
	    0x0003.P+0,
	    0x0003.P+0D,
	    0x0003.P+0F,
	    0x0003.P+0d,
	    0x0003.P+0f,
	    0x0003.P-0,
	    0x0003.P-0D,
	    0x0003.P-0F,
	    0x0003.P-0d,
	    0x0003.P-0f,
	    0x0003.P0,
	    0x0003.P0D,
	    0x0003.P0F,
	    0x0003.P0d,
	    0x0003.P0f,
	    0x0003.p+0,
	    0x0003.p+0D,
	    0x0003.p+0F,
	    0x0003.p+0d,
	    0x0003.p+0f,
	    0x0003.p-0,
	    0x0003.p-0D,
	    0x0003.p-0F,
	    0x0003.p-0d,
	    0x0003.p-0f,
	    0x0003.p0,
	    0x0003.p0D,
	    0x0003.p0F,
	    0x0003.p0d,
	    0x0003.p0f,
	    0x0003P+0,
	    0x0003P+0D,
	    0x0003P+0F,
	    0x0003P+0d,
	    0x0003P+0f,
	    0x0003P-0,
	    0x0003P-0D,
	    0x0003P-0F,
	    0x0003P-0d,
	    0x0003P-0f,
	    0x0003P0,
	    0x0003P0D,
	    0x0003P0F,
	    0x0003P0d,
	    0x0003P0f,
	    0x0003p+0,
	    0x0003p+0D,
	    0x0003p+0F,
	    0x0003p+0d,
	    0x0003p+0f,
	    0x0003p-0,
	    0x0003p-0D,
	    0x0003p-0F,
	    0x0003p-0d,
	    0x0003p-0f,
	    0x0003p0,
	    0x0003p0D,
	    0x0003p0F,
	    0x0003p0d,
	    0x0003p0f,
	    0x01.80P+1,
	    0x01.80P+1D,
	    0x01.80P+1F,
	    0x01.80P+1d,
	    0x01.80P+1f,
	    0x01.80P1,
	    0x01.80P1D,
	    0x01.80P1F,
	    0x01.80P1d,
	    0x01.80P1f,
	    0x01.80p+1,
	    0x01.80p+1D,
	    0x01.80p+1F,
	    0x01.80p+1d,
	    0x01.80p+1f,
	    0x01.80p1,
	    0x01.80p1D,
	    0x01.80p1F,
	    0x01.80p1d,
	    0x01.80p1f,
	    0x01.8P+1,
	    0x01.8P+1D,
	    0x01.8P+1F,
	    0x01.8P+1d,
	    0x01.8P+1f,
	    0x01.8P1,
	    0x01.8P1D,
	    0x01.8P1F,
	    0x01.8P1d,
	    0x01.8P1f,
	    0x01.8p+1,
	    0x01.8p+1D,
	    0x01.8p+1F,
	    0x01.8p+1d,
	    0x01.8p+1f,
	    0x01.8p1,
	    0x01.8p1D,
	    0x01.8p1F,
	    0x01.8p1d,
	    0x01.8p1f,
	    0x1.80P+1,
	    0x1.80P+1D,
	    0x1.80P+1F,
	    0x1.80P+1d,
	    0x1.80P+1f,
	    0x1.80P1,
	    0x1.80P1D,
	    0x1.80P1F,
	    0x1.80P1d,
	    0x1.80P1f,
	    0x1.80p+1,
	    0x1.80p+1D,
	    0x1.80p+1F,
	    0x1.80p+1d,
	    0x1.80p+1f,
	    0x1.80p1,
	    0x1.80p1D,
	    0x1.80p1F,
	    0x1.80p1d,
	    0x1.80p1f,
	    0x1.8P+1,
	    0x1.8P+1D,
	    0x1.8P+1F,
	    0x1.8P+1d,
	    0x1.8P+1f,
	    0x1.8P1,
	    0x1.8P1D,
	    0x1.8P1F,
	    0x1.8P1d,
	    0x1.8P1f,
	    0x1.8p+1,
	    0x1.8p+1D,
	    0x1.8p+1F,
	    0x1.8p+1d,
	    0x1.8p+1f,
	    0x1.8p1,
	    0x1.8p1D,
	    0x1.8p1F,
	    0x1.8p1d,
	    0x1.8p1f,
	    0x18.0P-3,
	    0x18.0P-3D,
	    0x18.0P-3F,
	    0x18.0P-3d,
	    0x18.0P-3f,
	    0x18.0p-3,
	    0x18.0p-3D,
	    0x18.0p-3F,
	    0x18.0p-3d,
	    0x18.0p-3f,
	    0x18P-3,
	    0x18P-3D,
	    0x18P-3F,
	    0x18P-3d,
	    0x18P-3f,
	    0x18p-3,
	    0x18p-3D,
	    0x18p-3F,
	    0x18p-3d,
	    0x18p-3f,
	    0x3.000000P+0,
	    0x3.000000P+0D,
	    0x3.000000P+0F,
	    0x3.000000P+0d,
	    0x3.000000P+0f,
	    0x3.000000P-0,
	    0x3.000000P-0D,
	    0x3.000000P-0F,
	    0x3.000000P-0d,
	    0x3.000000P-0f,
	    0x3.000000P0,
	    0x3.000000P0D,
	    0x3.000000P0F,
	    0x3.000000P0d,
	    0x3.000000P0f,
	    0x3.000000p+0,
	    0x3.000000p+0D,
	    0x3.000000p+0F,
	    0x3.000000p+0d,
	    0x3.000000p+0f,
	    0x3.000000p-0,
	    0x3.000000p-0D,
	    0x3.000000p-0F,
	    0x3.000000p-0d,
	    0x3.000000p-0f,
	    0x3.000000p0,
	    0x3.000000p0D,
	    0x3.000000p0F,
	    0x3.000000p0d,
	    0x3.000000p0f,
	    0x3.0P+0,
	    0x3.0P+0D,
	    0x3.0P+0F,
	    0x3.0P+0d,
	    0x3.0P+0f,
	    0x3.0P-0,
	    0x3.0P-0D,
	    0x3.0P-0F,
	    0x3.0P-0d,
	    0x3.0P-0f,
	    0x3.0P0,
	    0x3.0P0D,
	    0x3.0P0F,
	    0x3.0P0d,
	    0x3.0P0f,
	    0x3.0p+0,
	    0x3.0p+0D,
	    0x3.0p+0F,
	    0x3.0p+0d,
	    0x3.0p+0f,
	    0x3.0p-0,
	    0x3.0p-0D,
	    0x3.0p-0F,
	    0x3.0p-0d,
	    0x3.0p-0f,
	    0x3.0p0,
	    0x3.0p0D,
	    0x3.0p0F,
	    0x3.0p0d,
	    0x3.0p0f,
	    0x3.P+0,
	    0x3.P+0D,
	    0x3.P+0F,
	    0x3.P+0d,
	    0x3.P+0f,
	    0x3.P-0,
	    0x3.P-0D,
	    0x3.P-0F,
	    0x3.P-0d,
	    0x3.P-0f,
	    0x3.P0,
	    0x3.P0D,
	    0x3.P0F,
	    0x3.P0d,
	    0x3.P0f,
	    0x3.p+0,
	    0x3.p+0D,
	    0x3.p+0F,
	    0x3.p+0d,
	    0x3.p+0f,
	    0x3.p-0,
	    0x3.p-0D,
	    0x3.p-0F,
	    0x3.p-0d,
	    0x3.p-0f,
	    0x3.p0,
	    0x3.p0D,
	    0x3.p0F,
	    0x3.p0d,
	    0x3.p0f,
	    0x3000000.0000P-24,
	    0x3000000.0000P-24D,
	    0x3000000.0000P-24F,
	    0x3000000.0000P-24d,
	    0x3000000.0000P-24f,
	    0x3000000.0000p-24,
	    0x3000000.0000p-24D,
	    0x3000000.0000p-24F,
	    0x3000000.0000p-24d,
	    0x3000000.0000p-24f,
	    0x3000000.P-24,
	    0x3000000.P-24D,
	    0x3000000.P-24F,
	    0x3000000.P-24d,
	    0x3000000.P-24f,
	    0x3000000.p-24,
	    0x3000000.p-24D,
	    0x3000000.p-24F,
	    0x3000000.p-24d,
	    0x3000000.p-24f,
	    0x3000000P-24,
	    0x3000000P-24D,
	    0x3000000P-24F,
	    0x3000000P-24d,
	    0x3000000P-24f,
	    0x3000000p-24,
	    0x3000000p-24D,
	    0x3000000p-24F,
	    0x3000000p-24d,
	    0x3000000p-24f,
	    0x3P+0,
	    0x3P+0D,
	    0x3P+0F,
	    0x3P+0d,
	    0x3P+0f,
	    0x3P-0,
	    0x3P-0D,
	    0x3P-0F,
	    0x3P-0d,
	    0x3P-0f,
	    0x3P0,
	    0x3P0D,
	    0x3P0F,
	    0x3P0d,
	    0x3P0f,
	    0x3p+0,
	    0x3p+0D,
	    0x3p+0F,
	    0x3p+0d,
	    0x3p+0f,
	    0x3p-0,
	    0x3p-0D,
	    0x3p-0F,
	    0x3p-0d,
	    0x3p-0f,
	    0x3p0,
	    0x3p0D,
	    0x3p0F,
	    0x3p0d,
	    0x3p0f,
	    0xC.0P-2,
	    0xC.0P-2D,
	    0xC.0P-2F,
	    0xC.0P-2d,
	    0xC.0P-2f,
	    0xC.0p-2,
	    0xC.0p-2D,
	    0xC.0p-2F,
	    0xC.0p-2d,
	    0xC.0p-2f,
	    0xC.P-2,
	    0xC.P-2D,
	    0xC.P-2F,
	    0xC.P-2d,
	    0xC.P-2f,
	    0xC.p-2,
	    0xC.p-2D,
	    0xC.p-2F,
	    0xC.p-2d,
	    0xC.p-2f,
	    0xCP-2,
	    0xCP-2D,
	    0xCP-2F,
	    0xCP-2d,
	    0xCP-2f,
	    0xCp-2,
	    0xCp-2D,
	    0xCp-2F,
	    0xCp-2d,
	    0xCp-2f,
	    0xc.0P-2,
	    0xc.0P-2D,
	    0xc.0P-2F,
	    0xc.0P-2d,
	    0xc.0P-2f,
	    0xc.0p-2,
	    0xc.0p-2D,
	    0xc.0p-2F,
	    0xc.0p-2d,
	    0xc.0p-2f,
	    0xc.P-2,
	    0xc.P-2D,
	    0xc.P-2F,
	    0xc.P-2d,
	    0xc.P-2f,
	    0xc.p-2,
	    0xc.p-2D,
	    0xc.p-2F,
	    0xc.p-2d,
	    0xc.p-2f,
	    0xcP-2,
	    0xcP-2D,
	    0xcP-2F,
	    0xcP-2d,
	    0xcP-2f,
	    0xcp-2,
	    0xcp-2D,
	    0xcp-2F,
	    0xcp-2d,
	    0xcp-2f,
	};

	for(int i = 0; i <  testValues.length; i++) {
	    double d = testValues[i];
	    if (Math.abs(d) != 3.0)
		throw new RuntimeException("Bad value for literal at index " + 
					   i + "." );
	}
    }
}
