/*
 * effect-module.h --
 *
 *      EffectModule declaration
 *
 * Copyright (c) 1993-2001 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* @(#) $Header: /usr/mash/src/repository/mash/mash-1/fx/effects/effect-module.h,v 1.1 2002/02/07 04:18:02 chema Exp $ */


#ifndef mash_fx_effects_effect_module_h
#define mash_fx_effects_effect_module_h


#include "module.h"
#include "fx/vidreps.h"

#define EFFECT_MAX_INPUTS 5

//
// Note: effect implementations may be "copy" or "overwrite". In the "copy" 
//	case, the input and output frames lie in different memory locations. 
//	In the "overwrite" case, both frames lie in the same memory spot. 
//	The second case is an enhancement over the first. Unfortunately some 
//	codecs require not modifying the input frame (partial-frame updating 
//	codecs like H.261), so in this case "overwrite" codecs can be used only 
//	in zero copy effects. 
//
//	Moreover, only the triggering frame can be used as "overwrite" frame 
//	because we cannot know for sure if when the next triggering frame 
//	arrives the others inputs have been updated. Therefore, as a first 
//	implementation all effects will use copy. 
//


class EffectModule : public Module {
public:
	EffectModule(int inputs, int csss);
	int command(int argc, const char*const* argv);

	virtual void recv(Uncompressed* input, int id);

	// the following method is defined as abstarct in the Module class, so 
	//	we have to define it
	//virtual void recv(Buffer *bp) {};
	virtual void recv(Buffer *bp) {
		printf ("-----shouldn't be here!!!\n\n");
	};

	// any effect has to define the trigger_effect method. If the effect has 
	//	only one input, you can just ignore input_id
	virtual void trigger_effect(Uncompressed* input) = 0;

	virtual void deliver_frame() {
		target_->recv(output_);
	};

protected:
	virtual inline void in_size(int input, int w, int h) {
		inw_[input] = w;
		inh_[input] = h;
		inframesize_[input] = w * h;
	}
	virtual inline int in_samesize(int input, const Uncompressed* uf) {
		return ((uf->w_ == inw_[input]) && (uf->h_ == inh_[input]));
	}

	// buffers for all the inputs except the trigger one
	Uncompressed* buffer_[EFFECT_MAX_INPUTS];
	Uncompressed *output_;

	// csss is the color subsampling scheme of the output frame, which depends 
	//	only on the encoder used to send the FXed stream. Effects may be carried 
	//	out using a different csss than the output, and inputs may use 
	//	different csss.
	//
	//	To make things simpler, effects will always be carried out using the 
	//	output csss. Of course sometimes this doesn't make sense, as in a 
	//	computer-intensive effect where the inputs are 4:2:0 and the output 
	//	is 4:4:4, in which we're doing two csss upgradings (one for every 
	//	input) and the effect using full-sized chrominances instead of the 
	//	effect over one-fourth-sized chrominances plus one csss upgrading (for 
	//	the output). This may be added in the future, though.
	// 
	//	Consequence: only inputs may have to be converted to the effect 
	//	csss. 
	//
	//	Currently we support the following csss (number used in the 
	//	EffectModule constructor in parenthesis). 4:4:4 (444), 4:2:2 (422), 
	//	4:2:0 (420), and 4:1:1 (411).
	//
	int csss_;


private:
	// the following variable is used by multiple-input effects
	int input_id_;

	int inputs_;
	int inw_[EFFECT_MAX_INPUTS];
	int inh_[EFFECT_MAX_INPUTS];
	int inframesize_[EFFECT_MAX_INPUTS];

	// TBD: maybe a link to the previous object??
};


#endif

