# mps.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#FIXME
proc havefont args { return 1 }

#
# We want these resources to override user defaults
# (the option command's "userDefault" priority is 60)
# We do this for a consistent user inteface "look".
# Too often, people define *background and *foreground
# in their X resources, which gives bad results with tk.
#
option add *background gray80 61
option add *foreground black 61
option add *activeBackground gray95 61
option add *selectBackground gray95 61
option add *Scale.sliderForeground gray66 61
option add *Scale.activeForeground gray80 61
#option add *Scale.background gray70 61
option add *Scrollbar.foreground gray80 61
option add *Scrollbar.activeForeground gray70 61
option add *disabledForeground gray40

option add *Radiobutton.relief flat startupFile

#
# These can be overridden.
#
option add Tkgs.iconPrefix tkgs: startupFile
option add Tkgs.foundry adobe startupFile

#FIXME not fully tested
proc mapf f {
	if { ! [havefont $f] } {
		set i [string first 75 $f]
		set f [string range $f 0 [expr $i - 1]]*-*-*-*-*-*
	}
	return $f
}
set ff [option get . foundry Tkgs]
set helv10 [mapf "-$ff-helvetica-medium-r-normal--*-100-75-75-*-*-*-*"]
set helv10b [mapf "-$ff-helvetica-bold-r-normal--*-100-75-75-*-*-*-*"]
set helv10o [mapf "-$ff-helvetica-bold-o-normal--*-100-75-75-*-*-*-*"]
set helv12 [mapf "-$ff-helvetica-medium-r-normal--*-120-75-75-*-*-*-*"]
set helv12b [mapf "-$ff-helvetica-bold-r-normal--*-120-75-75-*-*-*-*"]
set helv14 [mapf "-$ff-helvetica-medium-r-normal--*-140-75-75-*-*-*-*"]
set helv14b [mapf "-$ff-helvetica-bold-r-normal--*-140-75-75-*-*-*-*"]
set times14 [mapf  "-$ff-times-medium-r-normal--*-140-75-75-*-*-*-*"]

option add *Font $helv12b startupFile
option add Tkgs.disablefont $helv10o
option add Tkgs.smallfont $helv10b
option add Tkgs.medfont $helv12b  startupFile
option add Tkgs.helpFont $times14 startupFile
option add Tkgs.entryFont $helv10 startupFile

proc build.bar w {
	global title
	frame $w.bar
	label $w.bar.title -text "mps v[version]" -font [smallfont]\
		-background gray -borderwidth 2 -relief raised
	button $w.bar.quit -text Quit -borderwidth 2 -relief raised \
		-background gray -font [smallfont] -command adios
	button $w.bar.menu -text Menu -borderwidth 2 -relief raised \
		-background gray -font [smallfont] \
		-command "toggle_window .menu"
	button $w.bar.help -text Help -borderwidth 2 -relief raised \
		-background gray -font [smallfont] \
		-command "toggle_window .help"

	pack $w.bar.title -side left -fill x -expand 1
	pack $w.bar.menu $w.bar.help $w.bar.quit -side left
}

#
# Build the user-interface.
#
proc build.tk { } {
#	global prefix
#	set prefix [option get . iconPrefix Tkgs]
	#wm iconname . $prefix$conf
	#wm title . $conf

	. configure -background [option get . background Tkgs]
	#
	# emulate implicit keyboard focus
	#
	bind . <Enter> { focus %W }
	#wm focusmodel . active
	bind . <q> { adios }
	bind . <Control-c> { exit 0 }
	bind . <Control-d> { exit 0 }

	frame .top
	set gs [new GPSinterp .top.wb]

	pack .top.wb -fill both -side bottom -expand 1
	pack .top -expand 1 -fill both

	#
	# Withdraw window so that user-placement is deferred
	# until after initial geometry is computed
	#
	wm withdraw .
	wm geometry . 425x550
	update idletasks
	set minwidth [winfo reqwidth .]
	set minheight [winfo reqheight .]
	#FIXME
	if { $minwidth < 200 || $minheight < 100 } {
		set minwidth 200
		set minheight 100
	}
	wm minsize . $minwidth $minheight
	wm deiconify .

	return $gs
}

Class GPSinterp

GPSinterp instproc fork {} {

	#
	# Here's where we hook into the kludge from ghostview
	# to pass an X window to ghostscript.
	# We bind the window ID to the environment
	# variable GHOSTVIEW.	We then pass a bunch of
	# information to ghostscript via the "GHOSTVIEW"
	# property on the window indicated here.  One of
	# these attributes is the Drawable, in our case a
	# pixmap ID.  This is handled in setup-property().
	#
	$self instvar path_
	set windowID [winfo id $path_]
puts "[winfo width $path_]X[winfo height $path_]"
	#FIXME use on-screen window for render... FIX THIS
	$self instvar pswin_
	set pixmapID [$pswin_ pixmap-id]
	puts pixmap=$pixmapID

	#
	# setting the Tcl "env" var sets the appropricate value in C,
	# so this value gets correctly transferred into the forked
	# process' environment
	#
	global env
	set env(GHOSTVIEW) "[expr $windowID] [expr $pixmapID]"
#	set env(DISPLAY) FIXME get display string
#	set env(DISPLAY) :0.0
	$self setup-property

	#
	# Arrange for special ghostscript ClientMessage events
	# to be dispatched to us.
	#
#	window_->bind_interp(this, pixmapID());
#	XDisplay* xd = window_->display()->rep()->display_;
#	XFlush(xd);
#		/*FIXME*/
#	active_interp = this;
#	(void)signal(SIGPIPE, sigpipe_handler);
#	(void)signal(SIGCHLD, sigpipe_handler);

	$self instvar pipe_
	set pipe_ [open "|gs -dQUIET -dNOPAUSE -dSAFER -dNOPLATFONTS -" w]
	#
	#FIXME comment this
	#
	fconfigure $pipe_ -blocking false
	$self dump \
		{/_$wb$showpage /showpage load def /showpage{stop}bind def}
	flush $pipe_
}

GPSinterp instproc init path {
	$self instvar orient_ pswin_ path_
	set orient_ 0

	#FIXME for now create only a single ps-window

	set pswin_ [new PostscriptWindow $path]
	set path_ $path
}

GPSinterp instproc dump msg {
	$self instvar pipe_
	puts stderr $msg
	puts $pipe_ $msg
}

GPSinterp instproc render-file f {
	$self instvar pipe_
#$self dump "0 0 moveto 100 100 lineto stroke showpage"
#flush $pipe_
#return
	$self dump [concat \
{userdict /$brkpage {} put
userdict /_$wb$save save put} \
($f)(r)file cvx stopped pop \
{grestoreall clear cleardictstack _$wb$save restore _$wb$showpage}]
	flush $pipe_
}

#FIXME
GPSinterp instproc width {} {
	$self instvar path_
	return [winfo width $path_]
}

#FIXME
GPSinterp instproc height {} {
	$self instvar path_
	return [winfo height $path_]
}

GPSinterp instproc setup-property {} {

#	Display* display = Session::instance()->default_display();
#	double dpi = double(display->to_pixels(72000.)) * scale_ / 1000.;

	#
	# <BackingStoreFlag, Orientation, llx, lly, urx, ury>
	# The bounding box coordinates are Postscript style (i.e.,
	# in points, not pixels).
	#
	$self instvar orient_ pswin_
	if $orient_ {
		set w [$self height]
		set h [$self width]
	} else {
		set w [$self width]
		set h [$self height]
	}
	#FIXME
	set scaledWidth $w
	set scaledHeight $h

	#FIXME
	set dpi 72

	set orient_ 0
	set s "0 $orient_ 0 0 $scaledWidth $scaledHeight $dpi $dpi"
	set s "0 $orient_ 160 266 452 526 72 72"
	#
	# <LeftMargin, BottomMargin, RightMargin, TopMargin, Width, Height>
	# The margins are in points.  The width & height are in pixels.
	#
#	set s "$s 0 0 0 0 $w $h"

	#FIXME window vs off-screen pixmap
	$pswin_ set-atom GHOSTVIEW $s
}

PostscriptWindow instproc init path {
	$self next $path
	$self instvar path_
	set path_ $path
}

PostscriptWindow instproc resize {} {
	$self instvar path_
	puts stderr "resize [winfo width $path_] [winfo height $path_]"
}

PostscriptWindow instproc recv-page {} {
}

puts foo
set gs [build.tk]
puts foo
update
puts foo
after 2000 "puts render ; $gs fork ; $gs render-file /tmp/xx.ps"
puts foo
