# hm-device.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/hm/hm-device.tcl,v 1.4 2002/02/03 04:27:05 lim Exp $


import RendezvousManager

Class GWHandler/Device -superclass GWHandler
Class ServiceCreator/Device -superclass ServiceCreator


ServiceCreator/Device instproc init {agent} {
    $self next $agent
    $self instvar rv_
    set rv_ [new RendezvousManager]
}

ServiceCreator/Device instproc destroy {} {
    $self next
    $self instvar rv_
    delete $rv_
}

ServiceCreator/Device instproc create_handler {srv_inst msg} {
    $self instvar agent_ rv_
    set ctrlspec "[$agent_ pick_mcastaddr]/[$agent_ uniqport]"
    set rspec "-rendez [$rv_ get_local_rv]"
    set h [new GWHandler/Device $agent_ $srv_inst $ctrlspec $rspec $msg]
    return $h
}


GWHandler/Device instproc init {agent sname ctrlspec rspec msg} {
    $self next $agent $sname "" "" ""
    $self instvar myargs_
    set myargs_ "$rspec $msg $ctrlspec"
    set serviceInst_ $sname

}

GWHandler/Device instproc execargs {} {
    $self instvar sessSpec_ myargs_
    return "$myargs_"

}

