# powerswitch-microgreenDuet.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/serial/powerswitch-microgreenDuet.tcl,v 1.6 2002/02/03 04:29:47 lim Exp $


import SerialChannel

#
# The extension of SerialChannel specialized to the Duet from
# Microgreen -- a controllable power switch
#
Class SerialChannel/Powerswitch-Microgreen-Duet -superclass SerialChannel

#
# init and open switch
#
SerialChannel/Powerswitch-Microgreen-Duet public init { args } {
    eval [list $self] next $args
    $self instvar parsePending_ plugState_

    $self device "/dev/cuac05"
    $self stopBits 1
    $self parity none
    $self baud 1200
    $self open
    set parsePending_ -1
    set plugState_(0) unknown
    set plugState_(1) unknown

}


#
# sets the power switch setting for one of the two plugs: number is
# either 0 or 1, and onOff is either 'on' or 'off'
#
SerialChannel/Powerswitch-Microgreen-Duet public set_power {number onOff} {
    $self instvar lastPlugNum_

    if {$number < 0 || $number > 1} {
	puts "currently only 2 outlets, 0 and 1"
	return
    }
    switch $onOff {
	on {
	    set val 0x4$number
	}
	off {
	    set val 0x0$number
	}
	default {
	    puts "parameter should be either 'on' or 'off'"
	    return
	}
    }
    $self clearReply
    $self send "$val"
    set lastPlugNum_ $number
    $self schedule_parse_reply 2000
}

SerialChannel/Powerswitch-Microgreen-Duet private parse_reply {} {
    $self instvar plugState_ lastPlugNum_

    set rep [$self getReply_hex]
    set rep [lindex $rep end]
    #puts $rep
    switch $rep {
	0xc0 {
	    set plugState_($lastPlugNum_) on
	}
	0x80 {
	    set plugState_($lastPlugNum_) off
	}
	default {
	    puts "strange reply from powerswitch: $rep"
	}
    }
    $self clearReply
}

SerialChannel/Powerswitch-Microgreen-Duet private schedule_parse_reply {time} {
    $self instvar parsePending_

    if {$parsePending_ != -1} {
	#puts "rescheduling pending parse..."
	after cancel $parsePending_
    }
    if {$time < 1000} {
	set time 1000
    }
    set parsePending_ [after $time "$self parse_reply"]
}

