# setup.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/setup/setup.tcl,v 1.15 2002/02/12 02:06:18 lim Exp $


import SetupDialog DirectoryDialog MessageBox


Class Setup


Setup proc.public instance { } {
	return [$self set instance_]
}


Setup public init { } {
	$self next

	Setup set instance_ $self
	if { [Setup system]=="Win32" } {
		$self set destination_ "C:/Program Files"
	} else {
		$self set destination_ "/usr/local"
	}

	$self set appname_ "your-app"
	$self set company_name_ ""

	$self set copyright_ {}
	$self set install_types_ [list typical custom]
	$self set install_types_help_ [list \
			"This is the recommended installation." \
			"Select this option to customize your\
			\ninstallation. Setup will prompt you to\
			\nselect individual components from the\
			\ncomplete installation list." ]

	# the subclassed constructor must redefine these
	$self set components(typical) {}
	$self set components(custom) {}

	# for each component, you must define the set of files to copy
	# for e.g. $self set files(foo) {}
}


Setup proc.public system { } {
	global tcl_platform
	if { $tcl_platform(platform)=="windows" } {
		return Win32
	} else {
		return Unix
	}
}


Setup public run { } {
	$self do_interactive
	$self do_install
	$self do_finish
}


Setup private do_interactive { } {
	$self instvar dialogs_
	set dialogs_ [$self dialog_list]

	# first create the dialog objects
	foreach cls [concat CancelDlg CustomDlg $dialogs_] {
		set path ".[string tolower $cls]"
		$cls $path
	}

	set cur_dlg [lindex $dialogs_ 0]
	while { 1 } {
		set retval [$self do_dialog $cur_dlg]
		if { $retval=={} } {
			break
		} elseif { $retval != 0 } {
			set idx [lsearch $dialogs_ $cur_dlg]
			set cur_dlg [lindex $dialogs_ \
					[expr $idx + $retval]]
		}
        }
}


Setup public do_dialog { dlg } {
	$self instvar dialogs_
	set path ".[string tolower $dlg]"

	if { ![catch {set next [$path subwidget next]}] } {
		# for the last dialog box, change the Next button to Finish
		if {$dlg == [lindex $dialogs_ end]} {
			$next configure -text "Finish" \
				-command "$path configure -result Finish"
		} else {
			$next configure -text "Next" \
				-command "$path configure -result Next"
		}
	}

	set retval [string tolower [$path invoke]]
	switch -exact -- [$path interpret_result $retval] {
		"back" {
			if [$path verify back] {
				return -1
			}
		}
		"next" {
			if [$path verify next] {
				return 1
			}
		}
		"finish" {
			if [$path verify finish] {
				return {}
			}
		}
		"cancel" {
			if { [.canceldlg invoke]=="Exit" } {
				exit
			}
		}
	}

	return 0
}


Setup public do_install { } {
	SetupProgress .progress
	.progress center

	$self copy_files

	after 1000
	destroy .progress
}


Setup private copy_files { } {
	$self instvar install_components_ files_

	set total [llength $install_components_]
	set idx 0
	set progress [winfo exists .progress]

	foreach component $install_components_ {
		set num_files [llength $files_($component)]
		set done [expr $idx*$num_files]
		if { $progress } {
			.progress subwidget bar configure \
					-max [expr $num_files*$total] \
					-value $done
			.progress subwidget info configure -text \
					"Copying $component"
			update
		}

		foreach file $files_($component) {
			if [catch {set files [glob $file]}] {
				set files $file
			}
			foreach f $files { $self copy_file $f }

			incr done
			if { $progress } {
				.progress subwidget bar configure -value $done
				update
			}
		}

		incr idx
		if { $progress } {
			.progress check_next
			update
		}
	}

	if { $progress } {
		.progress subwidget info configure -text {}
	}
}


Setup private copy_file { file } {
	$self instvar destination_ replace_all_
	if { ![info exists replace_all_] } { set replace_all_ 0 }

	if { ![file readable $file] } {
		$self warn "Cannot find source file \"$file\"\
				\nSome components seem to be missing from\
				\nthe installation package. Setup will\
				\nignore this file."
		return
	}

	set destfile [file join $destination_ $file]
	set destdir [file dirname $destfile]
	set retval [$self create_dir $destdir]
	if { $retval != {} } {
		$self warn "Could not create directory \"$destdir\":\n$retval\
				\n\nSetup will ignore this error and continue\
				\nwith the rest of the installation."
		return
	}

	if { [file exists $destfile] && $replace_all_==0 } {
		if { ![$self should_replace $destfile $file] } {
			continue
		}
	}

	if {[catch {file copy -force -- $file $destfile} msg]} {
		$self warn "Could not copy file:\n$msg\
				\n\nSetup will ignore this error and continue\
				\nwith the rest of the installation."
		return
	}
}


Setup private should_replace { dest src } {
	set text "File \"$dest\" already exists.\
			\nDo you want to replace it with \"$src\"?\n\n"
	if { ![catch {file stat $dest dstat}] && \
			![catch {file stat $src sstat}] } {
		append text "    $dest:\
				\n        Last modified: [clock format \
				$dstat(ctime) -format \
				{%a %b %d %H:%M:%S %Z %Y}]\
				\n        Size: $dstat(size) bytes\
				\n    $src:\
				\n        Last modified: [clock format \
				$sstat(ctime) -format \
				{%a %b %d %H:%M:%S %Z %Y}]\
				\n        Size: $sstat(size) bytes\n\n"
	}

	set retval [Dialog transient MessageBox -text $text \
			-image Icons(warning) -options { {text.wraplength 0} }\
			-type \
			{ {replace -text Replace -under 0 -image Icons(check)}\
			{ replaceall -text {Replace All} -under 8 } \
			{ skip -text "Skip" -under 0 -image Icons(cross) } }]
	switch -exact -- $retval {
		"replace" {
			return 1
		}
		"replaceall" {
			$self set replace_all_ 1
			return 1
		}
		"skip" {
			return 0
		}
	}

	return 0
}


Setup private warn { msg } {
	$self instvar appname_ error_occurred_

	if { [Dialog transient MessageBox -text "Error occurred in $appname_\
			Setup.\n\n$msg\n\nWould you like to continue with the\
			setup?" -image Icons(warning) -type yesno]=="no" } {
		exit
	}
	set error_occurred_ 1
}



Setup private do_finish { } {
	# FIXME: must prompt for cleanup of the untarred file here
	$self instvar appname_

	$self instvar error_occurred_
	if [info exists error_occurred_] {
		set text "\nThere were errors during the Setup process.\
				\nThe application may not have been installed\
				\nproperly.\
				\n\nYou should try to rectify those errors and\
				\ninvoke Setup again.\n\n"
		Dialog transient MessageBox -text $text -image Icons(warning) \
				-type ok
	} else {
		$self success
	}
	exit
}


Setup private success { } {
	set text "\n$appname_ has been successfully installed\
			\on your system.\n"
	Dialog transient MessageBox -text $text -image Icons(cal) \
			-type ok
}


Setup public dialog_list { } {
	$self instvar copyright_ install_types_

	set list [list WelcomeDlg]
	if { $copyright_ != {} } { lappend list CopyrightDlg }

	lappend list ChooseDstDlg
	if { [llength $install_types_] > 0 } { lappend list InstallTypeDlg }

	return $list
}


Setup public get_dirdlg { } {
	$self instvar dirdlg_
	if [info exists dirdlg_] { return $dirdlg_ }

	set dirdlg_ [DirectoryDialog .dirdlg]
	return $dirdlg_
}


#
# This function returns $dirname if it is a valid directory, otherwise
# it returns the first valid durectory that is found in its ancestry
#
Setup public get_real_dir { dirname } {
	while { $dirname != {} } {
		if [file isdirectory $dirname] {
			break
		}
		set newdir [file dirname $dirname]
		if { $newdir == $dirname } break
		set dirname $newdir
	}
	return $dirname
}


Setup private create_dir { path } {
	set dir ""
	foreach split [file split $path] {
		set dir [file join $dir $split]
		if { ![file exists $dir] } {
			if [catch {file mkdir $dir} msg] {
				return $msg
			}
		}
	}

	return {}
}

