# aswitch.tcl --
#
#       Not used anymore.
#
#       Allows you to define a state machine in a file that determines how
#       video should be switched during a broadcast.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

Import enable

source ../lib/tcl/sleep.tcl

import 405Client

Class AutoSwitch

namespace eval AutoSwitch {
    variable enabled
    variable output
}

AutoSwitch instproc init {base filename {extendedGUI 1}} {
    $self instvar 405_ stateMachine_

    # default state machine
    set stateMachine_(num) 0

    $self readStateMachine $filename

    set 405_ [new 405Client]
    $405_ callback_register AutoSwitch_amxCallback
    # FIXME - need to enable the amx callback
#    $405_ callback_enable AutoSwitch_amxCallback

    $self initUI $base $extendedGUI

    $self setDefaults

    # loop once a second and step through the state machine
    $self switchLoop
}

AutoSwitch instproc initUI {base extendedGUI} {
    frame $base.controls -borderwidth 3
    pack $base.controls -side top -fill x

    checkbutton $base.controls.onOff -text "Enable Auto Switching" -variable AutoSwitch::enabled -command "$self processEnabledDisabled"
    pack $base.controls.onOff -side left

    if {$extendedGUI} {
	# select which output to control
	frame $base.outputs -borderwidth 3
	pack $base.outputs -side top -fill x
	# I have to give each button its own frame to make it look pretty and
	#  line up correctly
	frame $base.outputs.labelFrame
	pack $base.outputs.labelFrame -side top -fill x
	label $base.outputs.labelFrame.outputLabel -text "Output"
	pack $base.outputs.labelFrame.outputLabel -side left

	frame $base.outputs.htsrBut
	pack $base.outputs.htsrBut -side top -fill x
	radiobutton $base.outputs.htsrBut.htsr -text "htsr" -variable AutoSwitch::output -value "htsr"
	pack $base.outputs.htsrBut.htsr -side left

	frame $base.outputs.htsr2But
	pack $base.outputs.htsr2But -side top -fill x
	radiobutton $base.outputs.htsr2But.htsr2 -text "htsr2" -variable AutoSwitch::output -value "htsr2"
	pack $base.outputs.htsr2But.htsr2 -side left
    }
}

AutoSwitch instproc setDefaults {} {
    set AutoSwitch::output "htsr"
}

# FIXME - do we want/need a setStateMachine proc where you pass it the
#   specification of a state machine

AutoSwitch instproc readStateMachine {filename} {
    $self instvar stateMachine_

    if {$filename == ""} {
	return
    }

    if [catch {open $filename r} fd] {
	puts stdout "Cannot open config file $filename"
	return 0
    }

    # overwrite any existing state machine
    set num 0

    # use hh:mm:ss version to set duration (or mm:ss) (or ss)
    while {[gets $fd line] >= 0} {
	if {$line != ""} {
	    if {[string index $line 0] != "#"} {
		set lLine [split $line " "]
		set stateLabel [string trim [lindex $lLine 0]]
		set cameraView [string trim [lindex $lLine 1]]
		set duration [string trim [lindex $lLine 2]]
		set nextState [string trim [lindex $lLine 3]]
#		puts stdout "stateLabel=$stateLabel, cameraView=$cameraView, duration=$duration, nextState=$nextState"

		set temp [split $duration ":"]
		set format [llength $temp]
		if {$format == 2} {
		    set hrs 0
		    set mins 0
		    set secs [lindex $temp 0]
		}
		if {$format == 2} {
		    set hrs 0
		    set mins [lindex $temp 0]
		    set secs [lindex $temp 1]
		}
		if {$format == 3} {
		    set hrs [lindex $temp 0]
		    set mins [lindex $temp 1]
		    set secs [lindex $temp 2]
		}
		set duration [expr [expr $hrs * 3600] + [expr $mins * 60] + $secs]
		set stateMachine_($stateLabel,input) $cameraView
		set stateMachine_($stateLabel,duration) $duration
		set stateMachine_($stateLabel,nextState) $nextState
		set num [expr $num + 1]
	    }
	}
    }
    set stateMachine_(num) $num

    $self resetStateMachine

    close $fd
    return 1
}

AutoSwitch instproc resetStateMachine {} {
    $self instvar stateMachine_

    set stateMachine_(counter) 0
    set stateMachine_(current) start
}

AutoSwitch instproc startStateMachine {} {
    $self instvar 405_ stateMachine_

    $self resetStateMachine
    if {$stateMachine_(num) > 0} {
	set curState $stateMachine_(current)
	$405_ matrix_switchVideoStream $stateMachine_($curState,input) $AutoSwitch::output
    }
}

AutoSwitch instproc processEnabledDisabled {} {
    if {$AutoSwitch::enabled} {
	puts stdout "enabling autoswitch"
	# FIXME - should we reset and go to the first state of the
	#    state machine here?
	$self startStateMachine
    } else {
	puts stdout "disabling autoswitch"
    }
}

AutoSwitch instproc switchLoop {} {
    if {$AutoSwitch::enabled} {
	$self processTimeout
    }
    # schedule the next callback 1 second later
    after 1000 "$self switchLoop"
}

AutoSwitch instproc processTimeout {} {
    $self instvar 405_ stateMachine_

    if {!$AutoSwitch::enabled} {
	return
    }

    if {$stateMachine_(num) == 0} {
	return
    }

    set counter [expr $stateMachine_(counter) + 1]
    set stateMachine_(counter) $counter
    set curState $stateMachine_(current)
    if {$counter >= $stateMachine_($curState,duration)} {
	set stateMachine_(counter) 0
	set next $stateMachine_($curState,nextState)
	set stateMachine_(current) $next
	$405_ matrix_switchVideoStream $stateMachine_($next,input) $AutoSwitch::output
    }
}

# FIXME - if we don't do expand and just include this object, this procedure
#   won't be defined, right?
#
# the proper way to do this is to define the callback as "$self callback" so
#   that no global procedure is needed
proc AutoSwitch_amxCallback {amxMsg} {
    puts stdout "AutoSwitch_amxCallback called"
}

AutoSwitch public setOutput {output} {
    switch -exact -- $output {
	htsr -
	htsr2 {
	    set AutoSwitch::output $output
	}
	default {
	    return -code error "AutoSwitch::setOutput: output must be \[htsr, htsr2\]"
	}
    }
}

AutoSwitch public enable {} {
    set AutoSwitch::enabled 1
    $self processEnabledDisabled
}

AutoSwitch public disable {} {
    set AutoSwitch::enabled 0
    $self processEnabledDisabled
}
