#!/bin/sh
# path trick for wish variants \
exec tclsh $0 ${1+"$@"}

# import the DpTcl library
source dp-lib.tcl

global g_client


# main program starts here

set port 8024

# modify this to be the name of the machine you are running the server on
set hostname "quimby"

# connect to the remote server at $hostname
set g_client [dp_MakeRPCClient $hostname $port]

set myhost [info hostname]

# call the Hello World procedure on the remote machine
dp_RPC $g_client helloWorld $myhost

# call the helloWorld procedure on the remote machine
set cmd "helloWorld $myhost"
dp_RPC $g_client $cmd

# call the getServerHost proc on the remote machine, and put the
#   return value in the otherHost variable
set otherHost [dp_RPC $g_client getServerHost]
puts stdout "the server is running on $otherHost"

# dp_RPC is used to invoke a procedure on the remote host and get
#   the return value back

# dp_RDO is used to invoke a procedure on the remote host but it
#   doesn't wait for the return value

# in general, you can always use dp_RPC, so unless you are worried about
#   performance, you should use dp_RPC

# call the helloWorld procedure on the remote machine but don't wait
#   for it to complete and return a value
dp_RDO $g_client helloWorld $myhost

# call the getServerHost proc on the remote machine, but do it with
#   dp_RDO and note the return value doesn't come back
set otherHost [dp_RDO $g_client getServerHost]
puts stdout "the server is running on $otherHost"

# kill the server and exit
dp_RPC $g_client killServer
exit