;;;-*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;

(defstruct subprimitive-info
  name
  offset
  nailed-down
  argument-mask
  registers-used
  )

(defmethod make-load-form ((s subprimitive-info) &optional env)
  (make-load-form-saving-slots s :environment env))

(defmethod print-object ((s subprimitive-info) stream)
  (print-unreadable-object (s stream :type t)
    (format stream "~A @ #x~x" 
            (subprimitive-info-name s)
            (subprimitive-info-offset s))))

(eval-when (:compile-toplevel :load-toplevel :execute)
(defparameter *next-subprim-offset* (ash 1 20))
)

; For now, nothing's nailed down and we don't say anything about
; registers clobbered.
(macrolet ((defppcsubprim (name)
            (let* ((offset *next-subprim-offset*)
		   (info (make-subprimitive-info :name name
						 :offset offset)))
              (incf *next-subprim-offset* 4)
              `(progn
                 (makunbound ',name)
                 (defconstant ,name ,offset)
                  ,info))))
  (setq *next-subprim-offset* (ash 1 20))
 (defparameter *subprims*
    (vector
     (defppcsubprim .SPjmpsym)
     (defppcsubprim .SPjmpnfn)
     (defppcsubprim .SPfuncall)
     (defppcsubprim .SPmkcatch1v)
     (defppcsubprim .SPmkunwind)
     (defppcsubprim .SPmkcatchmv)
     (defppcsubprim .SPthrow)
     (defppcsubprim .SPnthrowvalues)
     (defppcsubprim .SPnthrow1value)
     (defppcsubprim .SPbind)
     (defppcsubprim .SPbind-self)
     (defppcsubprim .SPbind-nil)
     (defppcsubprim .SPunbind)
     (defppcsubprim .SPunbind-n)
     (defppcsubprim .SPunbind-to)
     (defppcsubprim .SPconslist)
     (defppcsubprim .SPconslist-star)
     (defppcsubprim .SPstkconslist)
     (defppcsubprim .SPstkconslist-star)
     (defppcsubprim .SPmkstackv)
     (defppcsubprim .SPsubtag-misc-ref)
     (defppcsubprim .SPnewblocktag)
     (defppcsubprim .SPnewgotag)
     (defppcsubprim .SPstack-misc-alloc)
     (defppcsubprim .SPgvector)
     (defppcsubprim .SPnvalret)
     (defppcsubprim .SPmvpass)
     (defppcsubprim .SPfitvals)
     (defppcsubprim .SPnthvalue)
     (defppcsubprim .SPvalues)
     (defppcsubprim .SPdefault-optional-args)
     (defppcsubprim .SPopt-supplied-p)
     (defppcsubprim .SPheap-rest-arg)
     (defppcsubprim .SPreq-heap-rest-arg)
     (defppcsubprim .SPheap-cons-rest-arg)
     (defppcsubprim .SPsimple-keywords)
     (defppcsubprim .SPkeyword-args)
     (defppcsubprim .SPkeyword-bind)
     (defppcsubprim .SPffcall)
     (defppcsubprim .SPffcalladdress)
     (defppcsubprim .SPksignalerr)
     (defppcsubprim .SPstack-rest-arg)
     (defppcsubprim .SPreq-stack-rest-arg)
     (defppcsubprim .SPstack-cons-rest-arg)
     (defppcsubprim .SPstrap)
     (defppcsubprim .SPcall-closure)
     (defppcsubprim .SPgetXlong)
     (defppcsubprim .SPspreadargz)
     (defppcsubprim .SPtfuncallgen)
     (defppcsubprim .SPtfuncallslide)
     (defppcsubprim .SPtfuncallvsp)
     (defppcsubprim .SPtcallsymgen)
     (defppcsubprim .SPtcallsymslide)
     (defppcsubprim .SPtcallsymvsp)
     (defppcsubprim .SPtcallnfngen)
     (defppcsubprim .SPtcallnfnslide)
     (defppcsubprim .SPtcallnfnvsp)
     (defppcsubprim .SPmisc-ref)
     (defppcsubprim .SPmisc-set)
     (defppcsubprim .SPstkconsyz)
     (defppcsubprim .SPstkvcell0)
     (defppcsubprim .SPstkvcellvsp)
     (defppcsubprim .SPmakestackblock)
     (defppcsubprim .SPmakestackblock0)
     (defppcsubprim .SPmakestacklist)
     (defppcsubprim .SPstkgvector)
     (defppcsubprim .SPmisc-alloc)
     (defppcsubprim .SPregtrap)
     (defppcsubprim .SPbind-self-boundp-check)
     (defppcsubprim .SPmacro-bind)
     (defppcsubprim .SPdestructuring-bind)
     (defppcsubprim .SPdestructuring-bind-inner)
     (defppcsubprim .SPrecover-values)
     (defppcsubprim .SPvpopargregs)
     (defppcsubprim .SPinteger-sign)
     (defppcsubprim .SPsubtag-misc-set)
     (defppcsubprim .SPspread-lexpr-z)
     (defppcsubprim .SPsetqsym)
     (defppcsubprim .SPreset)
     (defppcsubprim .SPmvslide)
     (defppcsubprim .SPsave-values)
     (defppcsubprim .SPadd-values)
     (defppcsubprim .SPcallback)
     (defppcsubprim .SPmisc-alloc-init)
     (defppcsubprim .SPstack-misc-alloc-init)
     (defppcsubprim .SPprogvsave)
     (defppcsubprim .SPprogvrestore)
     (defppcsubprim .SPcallbuiltin)
     (defppcsubprim .SPcallbuiltin0)
     (defppcsubprim .SPcallbuiltin1)
     (defppcsubprim .SPcallbuiltin2)
     (defppcsubprim .SPcallbuiltin3)
     (defppcsubprim .SPpopj)
     (defppcsubprim .SPrestorefullcontext)
     (defppcsubprim .SPsavecontextvsp)
     (defppcsubprim .SPsavecontext0)
     (defppcsubprim .SPrestorecontext)
     (defppcsubprim .SPlexpr-entry)
     (defppcsubprim .SPdarwin-syscall)
     (defppcsubprim .SPbuiltin-plus)
     (defppcsubprim .SPbuiltin-minus)
     (defppcsubprim .SPbuiltin-times)
     (defppcsubprim .SPbuiltin-div)
     (defppcsubprim .SPbuiltin-eq)
     (defppcsubprim .SPbuiltin-ne)
     (defppcsubprim .SPbuiltin-gt)
     (defppcsubprim .SPbuiltin-ge)
     (defppcsubprim .SPbuiltin-lt)
     (defppcsubprim .SPbuiltin-le)
     (defppcsubprim .SPbuiltin-eql)
     (defppcsubprim .SPbuiltin-length)
     (defppcsubprim .SPbuiltin-seqtype)
     (defppcsubprim .SPbuiltin-assq)
     (defppcsubprim .SPbuiltin-memq)
     (defppcsubprim .SPbuiltin-logbitp)
     (defppcsubprim .SPbuiltin-logior)
     (defppcsubprim .SPbuiltin-logand)
     (defppcsubprim .SPbuiltin-ash)
     (defppcsubprim .SPbuiltin-negate)
     (defppcsubprim .SPbuiltin-logxor)
     (defppcsubprim .SPbuiltin-aref1)
     (defppcsubprim .SPbuiltin-aset1)
     (defppcsubprim .SPbreakpoint)
     (defppcsubprim .SPeabi-ff-call)
     (defppcsubprim .SPeabi-callback)
     (defppcsubprim .SPsyscall)
     (defppcsubprim .SPgetu64)
     (defppcsubprim .SPgets64)
     (defppcsubprim .SPmakeu64)
     (defppcsubprim .SPmakes64)
)))

(defun subprim-name->offset (name)
  (let* ((sprec (find name *subprims* 
                      :test #'string-equal 
                      :key #'subprimitive-info-name)))
    (if sprec
      (subprimitive-info-offset sprec)
      (error "subprim named ~s not found." name))))

(ccl::provide "SUBPRIMS")
