;;; -*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;


;;; Fix a code vector so that its subprim references are relative to (this image's) subprims-base.
;;; Then, do an FF-CALL to MakeDataExecutable so that the data cache gets flushed.
;;; This needs to be called inside a WITHOUT-INTERRUPTS.
(defppclapfunction %make-code-executable ((codev arg_z))
  (let ((len temp2)
	(word-offset imm0))
    (save-lisp-context)
    (getvheader word-offset codev)
    (header-length len word-offset)
    ;; This is going to have to pass a lisp object to a foreign function.
    ;; If we ever have a preemptive scheduler, we'd better hope that
    ;; WITHOUT-INTERRUPTS refuses to run lisp code from a callback.
    (stwu sp (- (+ ppc::eabi-c-frame.minsize ppc::lisp-frame.size)) sp)	; make an FFI frame.
    (la imm0 arch::misc-data-offset codev)
    (stw imm0 ppc::eabi-c-frame.param0 sp)
    (stw len ppc::eabi-c-frame.param1 sp)
    (ref-global imm3 kernel-imports)
    (lwz arg_z arch::kernel-import-MakeDataExecutable imm3)
    (bla .SPeabi-ff-call)
    (mr arg_z rnil)
    (restore-full-lisp-context)
    (blr)))

; end of ppc-def.lisp
