/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of Opensourced MCL.

   Opensourced MCL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   Opensourced MCL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include "bits.h"
#include "lisp.h"

/*
  06/28/96  gb  operator precedence in zero_bits.
  ----- 3.9
  04/10/96  gb  use alloc_ptr_critical.
  12/13/95  gb  fix ref_bit, set_n_bits
*/

int
set_bit(bitvector bits,unsigned bitnum)
{
  unsigned 
    windex = bitnum>>5, 
    old = bits[windex],
    new = old | (0x80000000 >> (bitnum & 0x1f));
  if (new == old) {
    return 1;			/* Was set */
  } else {
    bits[windex] = new;
    return 0;			/* Was clear */
  }
}

/* This should be a lot faster than calling set_bit N times */

void
set_n_bits(bitvector bits, unsigned first, unsigned n)
{
  if (n) {
    unsigned
      lastbit = (first+n)-1,
      leftbit = first & 0x1f,
      leftmask = 0xffffffff >> leftbit,
      rightmask = 0xffffffff << (31 - (lastbit & 0x1f)),
      *wstart = ((unsigned *) bits) + (first>>5),
      *wend = ((unsigned *) bits) + (lastbit>>5);

    if (wstart == wend) {
      *wstart |= (leftmask & rightmask);
    } else {
      *wstart++ |= leftmask;
      n -= (32 - leftbit);
      
      while (n >= 32) {
        *wstart++ = 0xffffffff;
        n-=32;
      }
      
      if (n) {
        *wstart |= rightmask;
      }
    }
  }
}
  
int
clr_bit(bitvector bits, unsigned bitnum)
{
  unsigned 
    windex = bitnum>>5, 
    old = bits[windex],
    new = old & ~(0x80000000 >> (bitnum & 0x1f));
  if (new == old) {
    return 0;	/* Was clear */
  } else {
    bits[windex] = new;
    return 1;	/* Was set */
  }
}

unsigned
ref_bit(bitvector bits,unsigned bitnum)
{
  return ((bits[bitnum>>5] & (0x80000000 >> (bitnum & 0x1f))) != 0);
}

bitvector 
new_bitvector(unsigned nbits)
{
  return (bitvector) zalloc((sizeof(unsigned)*(nbits+31)>>5));
}

/* Note that this zeros fullwords */
void
zero_bits(bitvector bits, unsigned nbits)
{
  memset(bits, 0, (sizeof(unsigned)*((nbits+31)>>5)));
}

void
ior_bits(bitvector dest, bitvector src, unsigned nbits)
{
  while (nbits > 0) {
    *dest++ |= *src++;
    nbits -= 32;
  }
}
