/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of Opensourced MCL.

   Opensourced MCL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   Opensourced MCL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

/* The assembler has to do the arithmetic here:	 the expression
   may not be evaluable by m4.
*/
define([lwi],[ifdef([DARWIN],[
	.if ((($2) & 0xffff8000) == 0xffff8000)
	 li $1,($2)
	.elseif ((($2) & 0xffff8000) == 0)
	 li $1,$2
	.else
	 lis $1,(($2)>>16)
	 .if (($2) & 0xffff) <> 0
	  ori $1,$1,(($2) & 0xffff)
	 .endif
	.endif],[
	.ifeq (($2) & 0xffff8000)-0xffff8000
	 li $1,$2
	.else
	 .ifeq (($2) & 0xffff8000)
	  li $1,$2
	 .else
	  lis $1,($2>>16)
	  .ifne ($2 & 0xffff)
	   ori $1,$1,$2 & 0xffff
	  .endif
	 .endif
	.endif
])])


define([extract_fulltag],[
	clrlwi $1,$2,nbits_in_word-ntagbits])

define([extract_lisptag],[
	clrlwi $1,$2,nbits_in_word-nlisptagbits])

define([extract_lisptag_],[
	clrlwi. $1,$2,nbits_in_word-nlisptagbits])

define([merge_lisptag],[
	rlwimi $1,$2,nlisptagbits,28,29])

define([merge_lisptag_],[
	rlwimi. $1,$2,nlisptagbits,28,29])

define([extract_2_lisptags],[
	extract_lisptag($1,$2)
	merge_lisptag($1,$3)])

define([extract_2_lisptags_],[
	extract_lisptag($1,$2)
	merge_lisptag_($1,$3)])

define([extract_subtag],[
	lbz $1,misc_subtag_offset($2)])

define([extract_lowbyte],[
	clrlwi $1,$2,nbits_in_word-num_subtag_bits])

define([extract_header],[
	lwz $1,misc_header_offset($2)])

define([extract_typecode],[
	new_local_labels()
	extract_lisptag($1,$2)
	cmpwi cr0,$1,tag_misc
	bne cr0,local_label(not_misc)
	extract_subtag($1,$2)
local_label(not_misc):])

define([box_fixnum],[
	slwi $1,$2,fixnumshift])

define([unbox_fixnum],[	
	srawi $1,$2,fixnumshift])

define([loaddf],[
	lfd $1,dfloat.value($2)])
	
define([storedf],[
	stfd $1,dfloat.value($2)])

define([push],[
	stwu $1,-4($2)])
	
	/* Generally not a great idea. */
define([pop],[
	lwz $1,0($2)
	la $2,4($2)])
	
define([vpush],[
	push($1,vsp)])
	
define([vpop],[
	pop($1,vsp)])
	
define([memoize],[
	push($1,memo)])
		
define([unlink],[
	lwz $1,0($1)])

	
define([set_nargs],[
	lwi(nargs,($1)<<fixnumshift)])
	
define([bitclr],[
	rlwinm $1,$2,0,0x1f&((31-($3))+1),0x1f&((31-($3))-1)])
	

define([vref32],[
	lwz $1,misc_data_offset+(($3)<<2)($2)])
	
define([vref16],[/* dest,src,n*/
	lhz $1,misc_data_offset+(($3)<<1)($2)])
	
define([getvheader],[
	lwz $1,vector.header($2)])
	
	/* Size is unboxed element count */
define([header_size],[
	srwi $1,$2,num_subtag_bits])
	
	/* "Length" is fixnum element count */
define([header_length],[
	rlwinm $1,$2,nbits_in_word-(num_subtag_bits-nfixnumtagbits),(num_subtag_bits-nfixnumtagbits),31-nfixnumtagbits])


define([vector_size],[
	getvheader(ifelse($3.[],$1,$3),$2)
	header_size($1,ifelse($3.[],$1,$3))])
	
define([vector_length],[
	getvheader($3,$2)
	header_length($1,$3)])

	
define([ref_global],[
	lwz $1,lisp_globals.$2(ifelse($3,[],rnil,$3))])

define([set_global3],[
	stw $1,lisp_globals.$2($3)])
	
define([set_global],[
	set_global3($1,$2,ifelse($3,[],rnil,$3))])

define([ref_nrs_value],[
	lwz $1,((nrs.$2)+(symbol.vcell))(rnil)])
	
define([set_nrs_value],[
	stw $1,((nrs.$2)+(symbol.vcell))(rnil)])

define([extract_unsigned_byte_bits],[
        rlwinm $1,$2,0,32-fixnumshift,31-($3+fixnumshift)])

define([extract_unsigned_byte_bits_],[/* dest,src,width*/
        rlwinm. $1,$2,0,32-fixnumshift,31-($3+fixnumshift)])
	
	/* vpop argregs - nargs is known to be non-zero */
define([vpop_argregs_nz],[
	new_local_labels()
	cmplwi cr1,nargs,2*4
	vpop(arg_z)
	blt cr1,local_label(l0)
	vpop(arg_y)
	bne cr1,local_label(l0)
	vpop(arg_x)
local_label(l0):])

	/* vpush argregs */
define([vpush_argregs],[
	new_local_labels()
	cmplwi cr0,nargs,0
	cmplwi cr1,nargs,2*4
	beq cr0,local_label(done)
	blt cr1,local_label(z)
	beq cr1,local_label(yz)
	vpush(arg_x)
local_label(yz):
	vpush(arg_y)
local_label(z):
	vpush(arg_z)
local_label(done):
])

define([create_lisp_frame],[
	stwu sp,-lisp_frame.size(sp)])

define([discard_lisp_frame],[
	la sp,lisp_frame.size(sp)])
	
	
define([_car],[
	lwz $1,cons.car($2)])
	
define([_cdr],[
	lwz $1,cons.cdr($2)])
	
define([rplaca],[
	stw $2,cons.car($1)])
	
define([rplacd],[
	stw $2,cons.cdr($1)])

define([vpush_saveregs],[
	vpush(save7)
	vpush(save6)
	vpush(save5)
	vpush(save4)
	vpush(save3)
	vpush(save2)
	vpush(save1)
	vpush(save0)])
	
define([restore_saveregs],[
	lwz save0,0($1)
	lwz save1,4($1)
	lwz save2,8($1)
	lwz save3,12($1)	
	lwz save4,16($1)
	lwz save5,20($1)
	lwz save6,24($1)
	lwz save7,28($1)])

define([vpop_saveregs],[
	restore_saveregs(vsp)
	la vsp,32(vsp)])

define([trap_unless_lisptag_equal],[
	extract_lisptag($3,$1)
	twnei $3,$2])

define([trap_unless_fulltag_equal],[
	extract_fulltag($3,$1)
	twnei $3,$2])
	
	
/* "jump" to the code-vector of the function in nfn. */
define([jump_nfn],[
	lwz temp0,_function.codevector(nfn)
	mtctr temp0
	bctr])


/* "jump" to the function in fnames function cell. */
define([jump_fname],[
	lwz nfn,symbol.fcell(fname)
	jump_nfn()])

/* Altivec. N.B.: gas 2.11 supports the Altivec instruction set */

define([LVX],[
	.long (31<<26)+(($1)<<21)+(($2)<<16)+(($3<<11))+(103<<1)
])

define([STVX],[
	.long (31<<26)+(($1)<<21)+(($2)<<16)+(($3<<11))+(231<<1)
])

define([MFVSCR],[
	.long (4<<26)+(($1)<<21)+(770<<1)
])

define([MTVSCR],[
	.long (4<<26)+(($1)<<21)+(802<<1)
])
