/*
   Copyright (C) 1994-2001 Digitool, Inc
   This file is part of Opensourced MCL.

   Opensourced MCL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   Opensourced MCL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



/* Subprims for catch, throw, unwind_protect. */


	include(lisp.s)
	_beginfile
	.globl _SPunbind_to

_spentry(mkcatch1v)
	__(li imm2,0)
	__(b mkcatch)

_spentry(mkunwind)
	__(lwi(arg_z,unbound_marker))
	/*b _SPmkcatchmv */

_spentry(mkcatchmv)
	__(li imm2,fixnum_one)
	/*b mkcatch */

/* Push a catch frame on the temp stack (and some of it on the cstack, as well.) */
/* The PC in question is 4 bytes past the caller's return address. ALWAYS. */
/* The catch tag is in arg_z, the multiple-value flags is in imm2. */
/* Bash some of the imm registers and loc_pc. */

/* THIS HAS TO LOOK ATOMIC TO ANY (future) preemptive scheduler. */
mkcatch:
	__(mflr loc_pc)
	__(ref_global(imm0,catch_top))
	__(lwz imm1,0(loc_pc)) /* a forward branch to the catch/unwind cleanup */
	__(rlwinm imm1,imm1,0,6,29)	/* extract LI */
	__(add loc_pc,loc_pc,imm1)
	__(create_lisp_frame())
	__(stw fn,lisp_frame.savefn(sp))
	__(stw loc_pc,lisp_frame.savelr(sp))
	__(stw vsp,lisp_frame.savevsp(sp))
	__(sub loc_pc,loc_pc,imm1)
	__(la loc_pc,4(loc_pc))	/* skip over the forward branch */
	__(mtlr loc_pc)
	__(mr initptr,tsp)
	__(stwu tsp,-(catch_frame.size+8)(tsp))
	__(stw rzero,4(tsp))
	__(la imm1,8+fulltag_misc(tsp))
	__(stw arg_z,catch_frame.catch_tag(imm1))
	__(stw imm0,catch_frame.link(imm1))
	__(stw imm2,catch_frame.mvflag(imm1))
	__(ref_global(imm0,db_link))
	__(stw sp,catch_frame.csp(imm1))
	__(lwi(imm2,(catch_frame.element_count<<num_subtag_bits)|subtag_catch_frame))
	__(stw imm0,catch_frame.db_link(imm1))
 	__(stmw first_nvr,catch_frame.regs(imm1))
	__(stw imm2,catch_frame.header(imm1))
	__(ref_global(imm0,xframe))
	__(stw imm0,catch_frame.xframe(imm1))
	__(stw rzero,catch_frame.tsp_segment(imm1))
	__(mr initptr,freeptr)
	__(set_global(imm1,catch_top))
	__(blr)

/* Caller has pushed tag and 0 or more values; nargs = nvalues. */
/* Otherwise, process unwind-protects and throw to indicated catch frame. */
	.globl _SPthrow
_spentry(throw)
	__(ref_global(imm1,catch_top))
	__(li imm0,0) /* count intervening catch/unwind-protect frames. */
	__(cmpwi cr0,imm1,0)
	__(lwzx temp0,vsp,nargs)
	__(beq- cr0,_throw_tag_not_found)
_throw_loop:
	__(lwz temp1,catch_frame.catch_tag(imm1))
	__(cmpw cr0,temp0,temp1)
	__(mr imm2,imm1)
	__(lwz imm1,catch_frame.link(imm1))
	__(cmpwi cr1,imm1,0)
	__(beq cr0,_throw_found)
	__(addi imm0,imm0,fixnum_one)
	__(beq- cr1,_throw_tag_not_found)
	__(b _throw_loop)
/* imm2: (tstack-consed) target catch frame, imm0: count of intervening frames.
  If target isn't a multiple-value receiver, discard extra values 
  (less hair, maybe.) */
_throw_found:
	__(lwz imm1,catch_frame.mvflag(imm2))
	__(cmpwi cr0,imm1,0)
	__(cmpwi cr1,nargs,0)
	__(li fn,0)
	__(add imm1,vsp,nargs)
	__(la imm1,-4(imm1))
	__(bne cr0,_throw_all_values)
	__(set_nargs(1))
	__(beq cr1,_throw_default_1_val)
	__(mr vsp,imm1)
	__(b _throw_all_values)
_throw_default_1_val:
	__(vpush(rnil))
_throw_all_values:
	__(bl nthrowvalues)
	__(ref_global(imm3,catch_top))
	__(ref_global(imm1,db_link))
	__(lwz imm0,catch_frame.db_link(imm3))
	__(lwz imm4,catch_frame.mvflag(imm3))
	__(cmpw cr0,imm0,imm1)
	__(cmpwi cr1,imm4,0)
	__(la tsp,-(fulltag_misc+8)(imm3))
	__(beq cr0,_throw_dont_unbind)
	__(bl _SPunbind_to)
_throw_dont_unbind:
	__(add imm0,vsp,nargs)
	__(cmpwi cr0,nargs,0)
	__(lwz imm1,catch_frame.csp(imm3))
	__(lwz imm1,lisp_frame.savevsp(imm1))
	__(bne cr1,_throw_multiple)
/* Catcher expects single value in arg_z */
	__(lwz arg_z,-4(imm0))
	__(b _throw_pushed_values)
_throw_multiple:
	__(beq cr0,_throw_pushed_values)
	__(mr imm2,nargs)
_throw_mvloop:
	__(subi imm2,imm2,fixnum_one)
	__(cmpwi imm2,0)
	__(lwzu temp0,-4(imm0))
	__(push(temp0,imm1))
	__(bgt _throw_mvloop)
_throw_pushed_values:
	__(mr vsp,imm1)
	__(lwz sp,catch_frame.csp(imm3))
	__(lwz fn,lisp_frame.savefn(sp))
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(discard_lisp_frame())
	__(mtlr loc_pc)
	__(lmw first_nvr,catch_frame.regs(imm3))
	__(lwz imm1,catch_frame.xframe(imm3))
	__(set_global(imm1,xframe))
	__(lwz imm3,catch_frame.link(imm3))
	__(set_global(imm3,catch_top))
	__(unlink(tsp))
	__(blr)
_throw_tag_not_found:
	__(uuo_interr(error_throw_tag_missing,temp0))
	__(stwux temp0,vsp,nargs)
	__(b throw)

/* This takes N multiple values atop the vstack. */
_spentry(nthrowvalues)
	__(mr imm4,imm0)
_nthrowv_nextframe:
	__(subi imm4,imm4,fixnum_one)
	__(cmpwi cr1,imm4,0)
	__(ref_global(temp0,catch_top))
	__(ref_global(imm1,db_link))
	__(bltlr cr1)
	__(lwz imm0,catch_frame.db_link(temp0))
	__(lwz imm3,catch_frame.link(temp0))
	__(cmpw cr0,imm0,imm1)
	__(set_global(imm3,catch_top))
	__(lwz temp1,catch_frame.catch_tag(temp0))
	__(cmpwi cr7,temp1,unbound_marker)		/* unwind-protect ? */
	__(lwz sp,catch_frame.csp(temp0))
	__(beq cr0,_nthrowv_dont_unbind)
	__(mflr loc_pc)
	__(bl _SPunbind_to)
	__(mtlr loc_pc)
_nthrowv_dont_unbind:
	__(beq cr7,_nthrowv_do_unwind)
/* A catch frame.  If the last one, restore context from there. */
	__(bne cr1,_nthrowv_skip)
	__(lwz first_nvr,catch_frame.xframe(temp0))
	__(set_global(first_nvr,xframe))
	__(lwz imm0,lisp_frame.savevsp(sp))
	__(stw rzero,lisp_frame.savevsp(sp))	/* marker for stack overflow code */
	__(add imm1,vsp,nargs)
	__(mr imm2,nargs)
	__(b _nthrowv_push_test)
_nthrowv_push_loop:
	__(lwzu temp1,-4(imm1))
	__(push(temp1,imm0))
_nthrowv_push_test:
	__(cmpwi imm2,0)
	__(subi imm2,imm2,fixnum_one)
	__(bne _nthrowv_push_loop)
	__(mr vsp,imm0)
	__(lmw first_nvr,catch_frame.regs(temp0))

_nthrowv_skip:
	__(la tsp,-(8+fulltag_misc)(temp0))
	__(unlink(tsp))
	__(discard_lisp_frame())
	__(b _nthrowv_nextframe)
_nthrowv_do_unwind:
/* This is harder.  Call the cleanup code with the multiple values (and */
/* nargs, which is a fixnum.)  Remember the throw count (also a fixnum) */
/* as well. */
/* Save our caller's LR and FN in the csp frame created by the unwind- */
/* protect.  (Clever, eh ?) */
	__(lwz first_nvr,catch_frame.xframe(temp0))
	__(set_global(first_nvr,xframe))
	__(lmw first_nvr,catch_frame.regs(temp0))
	__(la tsp,-(8+fulltag_misc)(temp0))
	__(unlink(tsp))
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(lwz nfn,lisp_frame.savefn(sp))
	__(mtctr loc_pc)	/* cleanup code address. */
	__(stw fn,lisp_frame.savefn(sp))
	__(mflr loc_pc)
	__(mr fn,nfn)
	__(stw loc_pc,lisp_frame.savelr(sp))
	__(addi imm0,nargs,(8+8))	/* tsp overhead, nargs, throw count */
	__(neg imm0,imm0)
	__(bitclr(imm0,imm0,2))
	__(stwux tsp,tsp,imm0)
	__(stw rzero,4(tsp))
	__(mr imm2,nargs)
	__(add imm1,nargs,vsp)
	__(sub imm0,tsp,imm0)                      /* end of tsp frame */
	__(stw rzero,-4(imm0))
	__(la imm0,8(tsp))
	__(stw nargs,0(imm0))
	__(b _nthrowv_tpushtest)
_nthrowv_tpushloop:
	__(lwzu temp0,-4(imm1))
	__(stwu temp0,4(imm0))
	__(subi imm2,imm2,fixnum_one)
_nthrowv_tpushtest:
	__(cmpwi imm2,0)
	__(bne _nthrowv_tpushloop)
	__(stwu imm4,4(imm0))
	__(lwz vsp,lisp_frame.savevsp(sp))
	__(stw rzero,lisp_frame.savevsp(sp))       /* tell stack overflow code to skip this frame */
	__(bctrl)
	__(la imm0,8(tsp))
	__(lwz fn,lisp_frame.savefn(sp))
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(discard_lisp_frame())
	__(mtlr loc_pc)
	__(lwz nargs,0(imm0))
	__(mr imm2,nargs)
	__(b _nthrowv_tpoptest)
_nthrowv_tpoploop:
	__(lwzu temp0,4(imm0))
	__(vpush(temp0))
	__(subi imm2,imm2,fixnum_one)
_nthrowv_tpoptest:
	__(cmpwi imm2,0)
	__(bne _nthrowv_tpoploop)
	__(lwz imm4,4(imm0))
	__(unlink(tsp))
	__(b _nthrowv_nextframe)

/* This is a (slight) optimization.  When running an unwind-protect, */
/* save the single value and the throw count in the tstack frame. */
/* Note that this takes a single value in arg_z. */
_spentry(nthrow1value)
	__(mr imm4,imm0)
nthrow1value_aux:
_nthrow1v_nextframe:
	__(subi imm4,imm4,fixnum_one)
	__(cmpwi cr1,imm4,0)
	__(ref_global(temp0,catch_top))
	__(ref_global(imm1,db_link))
	__(set_nargs(1))
	__(bltlr cr1)
	__(lwz imm3,catch_frame.link(temp0))
	__(lwz imm0,catch_frame.db_link(temp0))
	__(cmpw cr0,imm0,imm1)
	__(set_global(imm3,catch_top))
	__(lwz temp1,catch_frame.catch_tag(temp0))
	__(cmpwi cr7,temp1,unbound_marker)		/* unwind-protect ? */
	__(lwz sp,catch_frame.csp(temp0))
	__(beq cr0,_nthrow1v_dont_unbind)
	 __(mflr loc_pc)
	 __(bl _SPunbind_to)
	 __(mtlr loc_pc)
_nthrow1v_dont_unbind:
	__(beq cr7,_nthrow1v_do_unwind)
/* A catch frame.  If the last one, restore context from there. */
	__(bne cr1,_nthrow1v_skip)
	__(lwz vsp,lisp_frame.savevsp(sp))
	__(lwz first_nvr,catch_frame.xframe(temp0))
	__(set_global(first_nvr,xframe))
	__(lmw first_nvr,catch_frame.regs(temp0))
_nthrow1v_skip:
	__(la tsp,-(8+fulltag_misc)(temp0))
	__(unlink(tsp))
	__(discard_lisp_frame())
	__(b _nthrow1v_nextframe)
_nthrow1v_do_unwind:
/* This is harder, but not as hard (not as much BLTing) as the */
/* multiple-value case. */

/* Save our caller's LR and FN in the csp frame created by the unwind- */
/* protect.  (Clever, eh ?) */

	__(lwz first_nvr,catch_frame.xframe(temp0))
	__(set_global(first_nvr,xframe))
	__(lmw first_nvr,catch_frame.regs(temp0))
	__(la tsp,-(8+fulltag_misc)(temp0))
	__(unlink(tsp))
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(lwz nfn,lisp_frame.savefn(sp))
	__(mtctr loc_pc)		/* cleanup code address. */
	__(stw fn,lisp_frame.savefn(sp))
	__(mflr loc_pc)
	__(mr fn,nfn)
	__(stw loc_pc,lisp_frame.savelr(sp))
	__(stwu tsp,-(8+8)(tsp))	/* tsp overhead, value, throw count */
	__(stw rzero,4(tsp))
	__(stw arg_z,8(tsp))
	__(stw imm4,12(tsp))
	__(lwz vsp,lisp_frame.savevsp(sp))
	__(stw rzero,lisp_frame.savevsp(sp))       /* Tell stack overflow code to ignore this frame */
	__(bctrl)
	__(lwz arg_z,8(tsp))
	__(lwz imm4,12(tsp))
	__(lwz fn,lisp_frame.savefn(sp))
	__(lwz loc_pc,lisp_frame.savelr(sp))
	__(discard_lisp_frame())
	__(mtlr loc_pc)
	__(unlink(tsp))
	__(b _nthrow1v_nextframe)
	_endfile

