/*
 * Copyright (C) 2000, 2001, Amnon Barak (amnon@cs.huji.ac.il)
 *
 * Permission to use this software is hereby granted under the terms of the
 * GNU General Public License, as published by the Free Software Foundation.
 *
 * THIS  SOFTWARE  IS  PROVIDED IN ITS  "AS IS"  CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Amnon Shiloh, Oren Laadan.
 */

#ifndef _MOS_DEBUG_H
#define _MOS_DEBUG_H

#ifdef CONFIG_MOSIX_DEBUG

extern unsigned long ds_debug;

#define DSDEB_ERROR	0x00000001
#ifdef CONFIG_MOSIX_DFSA
#define	DSDEB_DFSA	0x00000002
#endif /* CONFIG_MOSIX_DFSA */
#define DSDEB_MIG	0x00000010
#define	DSDEB_EXPEL	0x00000020
#define	DSDEB_HOLD	0x00000040
#define	DSDEB_MIGSTAGE	0x00000080
#define DSDEB_WHERETO	0x00000100
#define DSDEB_INFO	0x00000200
#define DSDEB_PROC	0x00000400
#define	DSDEB_CACHE	0x00000800
#define	DSDEB_CACHESTOP 0x00001000
#define DSDEB_CONFIG	0x00002000
#define	DSDEB_LOAD	0x00004000
#define	DSDEB_CONSIDER	0x00008000
#define	DSDEB_LOADS	0x00010000
#define	DSDEB_ANCESSTOR	0x00020000
#define	DSDEB_DECAY	0x00040000
#define	DSDEB_MEM	0x00080000
#define	DSDEB_NOTCACHED	0x00100000
#define	DSDEB_SUPERMEM	0x00200000

#define DSDEB_COMMOPEN	0x00400000
#define DSDEB_COMMACPT	0x00800000
#define DSDEB_COMMFLAGS	0x01000000
#define DSDEB_COMMRECV	0x02000000
#define DSDEB_COMMSEND	0x04000000
#define DSDEB_COMMADDR	0x08000000
#define	DSDEB_COMMDORECV 0x10000000
#define	DSDEB_COMMDOSEND 0x20000000
#define	DSDEB_DEBUGSEND	0x40000000


#define DSDEB_COMM	(DSDEB_COMMOPEN|DSDEB_COMMACPT|DSDEB_COMMFLAGS|	\
			 DSDEB_COMMRECV|DSDEB_COMMSEND|DSDEB_COMMADDR)

#endif /* CONFIG_MOSIX_DEBUG */

#ifdef CONFIG_MOSIX_UDB
extern void mosix_debugger(char *);
#define mosix_panic	mosix_debugger
#else
#define mosix_panic	panic
#endif /* CONFIG_MOSIX_UDB */
#endif
