// $Id: PrinterPortLogger.hh,v 1.17 2005/01/13 18:25:36 m9710797 Exp $

#ifndef __MSXPRINTERPORTLOGGER_HH__
#define __MSXPRINTERPORTLOGGER_HH__

#include "PrinterPortDevice.hh"
#include <memory>

namespace openmsx {

class File;
class FilenameSetting;

class PrinterPortLogger : public PrinterPortDevice
{
public:
	PrinterPortLogger();
	virtual ~PrinterPortLogger();

	// PrinterPortDevice
	virtual bool getStatus(const EmuTime& time);
	virtual void setStrobe(bool strobe, const EmuTime& time);
	virtual void writeData(byte data, const EmuTime& time);

	// Pluggable
	virtual const std::string& getName() const;
	virtual const std::string& getDescription() const;
	virtual void plugHelper(Connector* connector, const EmuTime& time);
	virtual void unplugHelper(const EmuTime& time);

private:
	byte toPrint;
	bool prevStrobe;
	std::auto_ptr<File> file;
	std::auto_ptr<FilenameSetting> logFilenameSetting;
};

} // namespace openmsx

#endif // __MSXPRINTERPORTLOGGER_HH__
