// $Id: ReadDir.hh,v 1.3 2004/12/29 01:02:14 mthuurne Exp $

#ifndef __READDIR_HH__
#define __READDIR_HH__

#include <string>
#include <sys/types.h>
#include <dirent.h>

namespace openmsx {

/**
 * Simple wrapper around openmdir() / readdir() / closedir() functions.
 * Mainly usefull to automatically call closedir() when object goes out
 * of scope.
 */
class ReadDir
{
public:
	ReadDir(const std::string& directory);
	~ReadDir();

	struct dirent* getEntry();

private:
	DIR* dir;
};

} // namespace openmsx

#endif
