// $Id: KeyClick.hh,v 1.11 2005/06/26 19:17:46 m9710797 Exp $

#ifndef KEYCLICK_HH
#define KEYCLICK_HH

#include <memory>

namespace openmsx {

class Mixer;
class XMLElement;
class EmuTime;
class DACSound8U;

class KeyClick
{
public:
	KeyClick(Mixer& mixer, const XMLElement& config, const EmuTime& time);
	virtual ~KeyClick();

	void reset(const EmuTime& time);
	void setClick(bool status, const EmuTime& time);

private:
	const std::auto_ptr<DACSound8U> dac;
	bool status;
};

} // namespace openmsx

#endif
