/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.HorizontalAxis;
import com.jrefinery.chart.HorizontalDateAxis;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.HorizontalValuePlot;
import com.jrefinery.chart.LegendItemCollection;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalAxis;
import com.jrefinery.chart.VerticalNumberAxis;
import com.jrefinery.chart.VerticalValuePlot;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.Range;
import com.jrefinery.data.XYDataset;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class PeriodMarkerPlot
extends XYPlot
implements HorizontalValuePlot,
VerticalValuePlot {
    public PeriodMarkerPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2) {
        super(xYDataset, valueAxis, valueAxis2);
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public String getPlotType() {
        return "Period Marker Plot";
    }

    public Range getVerticalDataRange() {
        Range range = null;
        if (this.dataset != null) {
            range = DatasetUtilities.getRangeExtent(this.dataset);
        }
        return range;
    }

    public XYDataset getTempXYDataset() {
        return (XYDataset)this.dataset;
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        if (axis instanceof HorizontalNumberAxis) {
            return true;
        }
        return axis instanceof HorizontalDateAxis;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis instanceof VerticalNumberAxis;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        if (this.insets != null) {
            rectangle2D = new Rectangle2D.Double(rectangle2D.getX() + (double)this.insets.left, rectangle2D.getY() + (double)this.insets.top, rectangle2D.getWidth() - (double)this.insets.left - (double)this.insets.right, rectangle2D.getHeight() - (double)this.insets.top - (double)this.insets.bottom);
        }
        HorizontalAxis horizontalAxis = this.getHorizontalAxis();
        VerticalAxis verticalAxis = this.getVerticalAxis();
        double d = horizontalAxis.reserveHeight(graphics2D, this, rectangle2D);
        Rectangle2D rectangle2D2 = verticalAxis.reserveAxisArea(graphics2D, this, rectangle2D, d);
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX() + rectangle2D2.getWidth(), rectangle2D.getY(), rectangle2D.getWidth() - rectangle2D2.getWidth(), rectangle2D.getHeight() - d);
        this.drawOutlineAndBackground(graphics2D, double_);
        this.getDomainAxis().draw(graphics2D, rectangle2D, double_);
        this.getRangeAxis().draw(graphics2D, rectangle2D, double_);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(double_);
        XYDataset xYDataset = this.getTempXYDataset();
        if (xYDataset != null) {
            int n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                this.drawMarkedPeriods(xYDataset, n2, graphics2D, double_);
                ++n2;
            }
        }
        graphics2D.setClip(shape);
    }

    private void drawMarkedPeriods(XYDataset xYDataset, int n, Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Object object;
        int n2;
        Paint paint = this.getSeriesPaint(n);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(this.getSeriesStroke(n));
        float f = 0.1f;
        if (paint instanceof Color && (n2 = ((Color)(object = (Color)paint)).getRed() + ((Color)object).getGreen() + ((Color)object).getBlue()) > 255) {
            f = f * (float)n2 / 255.0f;
        }
        object = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, f));
        double d = rectangle2D.getMinY();
        double d2 = rectangle2D.getMaxY();
        int n3 = xYDataset.getItemCount(n);
        int n4 = 0;
        while (n4 < n3) {
            if (xYDataset.getYValue(n, n4).doubleValue() != 0.0) {
                Number number = n4 > 0 ? (Number)new Long((xYDataset.getXValue(n, n4).longValue() + xYDataset.getXValue(n, n4 - 1).longValue()) / 2L) : (Number)xYDataset.getXValue(n, n4);
                int n5 = n4 + 1;
                while (n5 < n3) {
                    if (xYDataset.getYValue(n, n5).doubleValue() == 0.0) break;
                    ++n5;
                }
                n4 = n5;
                Number number2 = n5 < n3 ? (Number)new Long((xYDataset.getXValue(n, n5 - 1).longValue() + xYDataset.getXValue(n, n5).longValue()) / 2L) : (Number)xYDataset.getXValue(n, n5 - 1);
                double d3 = this.getDomainAxis().translateValueToJava2D(number.doubleValue(), rectangle2D);
                double d4 = this.getDomainAxis().translateValueToJava2D(number2.doubleValue(), rectangle2D);
                this.markPeriod(d3, d4, d, d2, graphics2D);
            }
            ++n4;
        }
        graphics2D.setComposite((Composite)object);
    }

    private void markPeriod(double d, double d2, double d3, double d4, Graphics2D graphics2D) {
        graphics2D.fill(new Rectangle2D.Double(d, d3, d2 - d, d4 - d3));
    }

    public void zoom(double d) {
    }

    public List getLegendItemLabels() {
        return null;
    }
}

