/*************************************************************************
 *
 *  $RCSfile: fieldwin.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/25 16:02:06 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "fieldwin.hxx"

#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEFIELDSSUPPLIER_HXX_
#include <smart/com/sun/star/data/XDatabaseFieldsSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASEPARAMETERTYPE_HXX_
#include <smart/com/sun/star/data/DatabaseParameterType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASERECORDSUPPLIER_HXX_
#include <smart/com/sun/star/data/XDatabaseRecordSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEVARIANT_HXX_
#include <smart/com/sun/star/data/XDatabaseVariant.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASESEARCH_HXX_
#include <smart/com/sun/star/data/DatabaseSearch.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEFIELDDESCRIPTORFACTORY_HXX_
#include <smart/com/sun/star/data/XDatabaseFieldDescriptorFactory.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASEFIELDTYPE_HXX_
#include <smart/com/sun/star/data/DatabaseFieldType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASERECORDSTATUS_HXX_
#include <smart/com/sun/star/data/DatabaseRecordStatus.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASECURSOROPTION_HXX_
#include <smart/com/sun/star/data/DatabaseCursorOption.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASECURSORSUPPLIER_HXX_
#include <smart/com/sun/star/data/XDatabaseCursorSupplier.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XPREPAREDDATABASESTATEMENT_HXX_
#include <smart/com/sun/star/data/XPreparedDatabaseStatement.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASESTATEMENT_HXX_
#include <smart/com/sun/star/data/XDatabaseStatement.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEUPDATECURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseUpdateCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASECURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEBOOKMARKCURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseBookmarkCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_XDATABASEDIRECTCURSOR_HXX_
#include <smart/com/sun/star/data/XDatabaseDirectCursor.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASECURSORTYPE_HXX_
#include <smart/com/sun/star/data/DatabaseCursorType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_DATA_DATABASERECORDMODE_HXX_
#include <smart/com/sun/star/data/DatabaseRecordMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XUPDATEBROADCASTER_HXX_
#include <smart/com/sun/star/form/XUpdateBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XCONFIRMDELETEBROADCASTER_HXX_
#include <smart/com/sun/star/form/XConfirmDeleteBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEFORMUPDATE_HXX_
#include <smart/com/sun/star/form/XDatabaseFormUpdate.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XUPDATELISTENER_HXX_
#include <smart/com/sun/star/form/XUpdateListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATASELECTIONTYPE_HXX_
#include <smart/com/sun/star/form/DataSelectionType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XERRORLISTENER_HXX_
#include <smart/com/sun/star/form/XErrorListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XRESTORELISTENER_HXX_
#include <smart/com/sun/star/form/XRestoreListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATABASEPARAMETEREVENT_HXX_
#include <smart/com/sun/star/form/DatabaseParameterEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XINSERTLISTENER_HXX_
#include <smart/com/sun/star/form/XInsertListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDELETELISTENER_HXX_
#include <smart/com/sun/star/form/XDeleteListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_DATABASEDELETEEVENT_HXX_
#include <smart/com/sun/star/form/DatabaseDeleteEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XPOSITIONINGLISTENER_HXX_
#include <smart/com/sun/star/form/XPositioningListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XBOUNDCOMPONENT_HXX_
#include <smart/com/sun/star/form/XBoundComponent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEPARAMETERLISTENER_HXX_
#include <smart/com/sun/star/form/XDatabaseParameterListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XLOADLISTENER_HXX_
#include <smart/com/sun/star/form/XLoadListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_NAVIGATIONBARMODE_HXX_
#include <smart/com/sun/star/form/NavigationBarMode.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XCONFIRMDELETELISTENER_HXX_
#include <smart/com/sun/star/form/XConfirmDeleteListener.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XERRORBROADCASTER_HXX_
#include <smart/com/sun/star/form/XErrorBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_ERROREVENT_HXX_
#include <smart/com/sun/star/form/ErrorEvent.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_LISTSOURCETYPE_HXX_
#include <smart/com/sun/star/form/ListSourceType.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEPARAMETERBROADCASTER_HXX_
#include <smart/com/sun/star/form/XDatabaseParameterBroadcaster.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_TABULATORCYCLE_HXX_
#include <smart/com/sun/star/form/TabulatorCycle.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XDATABASEFORM_HXX_
#include <smart/com/sun/star/form/XDatabaseForm.hxx>
#endif
#ifndef _SMART_COM_SUN_STAR_FORM_XBOUNDCONTROL_HXX_
#include <smart/com/sun/star/form/XBoundControl.hxx>
#endif



#ifndef _SVX_FMEXCH_HXX
#include "adrexch.hxx"
#endif

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif

#ifndef _USR_REFL_HXX
#include <usr/refl.hxx>
#endif

#ifndef _SV_DRAG_HXX //autogen
#include <vcl/drag.hxx>
#endif

#include "adrprop.hrc"
#include "adrresid.hxx"
#include "adrprop.hrc"
#include "adrmod.hxx"
#include "adr.hrc"

const long STD_WIN_POS_X = 50;
const long STD_WIN_POS_Y = 50;

const long STD_WIN_SIZE_X = 120;
const long STD_WIN_SIZE_Y = 150;

const long MIN_WIN_SIZE_X = 50;
const long MIN_WIN_SIZE_Y = 50;

const long LISTBOX_BORDER = 2;

//==================================================================
// class AdrFieldListBox
//==================================================================

//------------------------------------------------------------------------------
AdrFieldListBox::AdrFieldListBox( AdrFieldWin* pParent )
	:SvTreeListBox( pParent, WB_HASBUTTONS|WB_BORDER )
	,pTabWin( pParent )
{
	String aString;
	for( USHORT i=1; i<11; i++ )
	{
		aString = "Feld ";
		aString += String(i);
		InsertEntry( aString );
	}
}

//------------------------------------------------------------------------------
AdrFieldListBox::~AdrFieldListBox()
{
}

//------------------------------------------------------------------------------
void AdrFieldListBox::Command(const CommandEvent& rEvt)
{
	switch (rEvt.GetCommand())
	{
		case COMMAND_STARTDRAG:
		{
			EndSelection();
			Pointer aMovePtr( POINTER_COPYDATA ),
					aCopyPtr( POINTER_COPYDATA ),
					aLinkPtr( POINTER_LINKDATA );

			String aCopyData = pTabWin->GetDatabaseName();
			aCopyData	+= char(11);
			aCopyData	+= pTabWin->GetObjectName();
			aCopyData	+= char(11);
			aCopyData	+= String(pTabWin->GetObjectType());
			aCopyData	+= char(11);
			
			SvLBoxEntry* pFirstSelected = FirstSelected();
			if( pFirstSelected )
				aCopyData += GetEntryText( pFirstSelected );
			else
				aCopyData += "";

			AdrFieldExchRef xFieldExch = new AdrFieldExch(aCopyData);
			DragManager::ExecuteDrag( xFieldExch, DRAG_LINKABLE | DRAG_COPYABLE );
		}	break;
		default:
			Window::Command( rEvt );
	}
}


//========================================================================
// class AdrFieldWin
//========================================================================

//-----------------------------------------------------------------------
AdrFieldWin::AdrFieldWin(Window* pParent)
			:FloatingWindow(pParent, WinBits(WB_STDMODELESS|WB_SIZEABLE))
			,nObjectType(0)
{
	SetBackgroundBrush( Brush( Color( COL_LIGHTGRAY ) ) );
	pListBox = new AdrFieldListBox( this );
	pListBox->Show();
	SetSizePixel(Size(STD_WIN_SIZE_X,STD_WIN_SIZE_Y));
}

//-----------------------------------------------------------------------
AdrFieldWin::~AdrFieldWin()
{
	delete pListBox;
}

//-----------------------------------------------------------------------
void AdrFieldWin::Resize()
{
	Point aPos = GetPosPixel();
	Size aSize = GetOutputSizePixel();

	//////////////////////////////////////////////////////////////////////

	// Groesse der ListBox anpassen
	Point aLBPos = Point( LISTBOX_BORDER, LISTBOX_BORDER );
	Size aLBSize( aSize );
	aLBSize.Width() -= (2*LISTBOX_BORDER);
	aLBSize.Height() -= (2*LISTBOX_BORDER);

	pListBox->SetPosSizePixel( aLBPos, aLBSize );
}

//-----------------------------------------------------------------------
void AdrFieldWin::Update(const XDatabaseFormRef& xForm)
{
	// ListBox loeschen
	pListBox->Clear();
	String aTitle(AdrResId(RID_ADR_STR_FIELDSELECTION));
	SetText(aTitle);

	XDatabaseCursorRef xCursor(xForm, USR_QUERY);
	XNameAccessRef xFields(xCursor->getRecord(), USR_QUERY);
	Sequence<UString> aNames = xFields->getElementNames();
	INT32 nFieldsCount = aNames.getLen();
	const UString* pNames = aNames.getConstArray();

	for (INT32 i=0; i<nFieldsCount; i++)
		pListBox->InsertEntry(U2S(pNames[i]));

	XPropertySetRef xSet(xForm, USR_QUERY);

	// Datenbank und Tabellennamen setzen
	aObjectName		= U2S(xSet->getPropertyValue(FM_PROP_CURSORSOURCE).getString());
	aDatabaseName	= U2S(xSet->getPropertyValue(FM_PROP_DATASOURCE).getString());
	nObjectType 	= (UINT16)xSet->getPropertyValue(FM_PROP_CURSORSOURCETYPE).getEnumAsINT32();

	// Prefix setzen
	String  aPrefix;
	String  aPrefixes( AdrResId(RID_ADR_STR_TABWIN_PREFIX) );

	switch( nObjectType )
	{
		case DataSelectionType_TABLE:
			aPrefix = aPrefixes.GetToken(0);
			break;
		case DataSelectionType_QUERY:
			aPrefix = aPrefixes.GetToken(1);
			break;
		case DataSelectionType_SQL:
			aPrefix = aPrefixes.GetToken(2);
			break;
		case DataSelectionType_SQLPASSTHROUGH:
			aPrefix = aPrefixes.GetToken(2);
			break;
	}

	// Titel setzen
	aTitle += " ";
	aTitle += aPrefix;
	aTitle += " ";
	aTitle += aObjectName;
	SetText( aTitle );
}



