#ifndef _THESLOOKUP_HXX_
#define _THESLOOKUP_HXX_

/* some maximum sizes for buffers */
#define MAX_WD_LEN 200
#define MAX_WDS    65535

/* convenience macros */
#define A2OU(x) ::rtl::OUString::createFromAscii( x )
#define OU2A(rtlOUString)     ::rtl::OString((rtlOUString).getStr(), (rtlOUString).getLength(), RTL_TEXTENCODING_ASCII_US).getStr()

using namespace osl;

class ThesLookup
{

       sal_Int32  nw;                  /* number of entries in thesaurus */
       sal_Char**  list;               /* stores word list */
       sal_uInt32* offst;              /* stores offset list */
       sal_uInt16* ilst;               /* synonym index lst */
 
        File  *pdfile;

	// disallow copy-constructor and assignment-operator for now
	ThesLookup(const ThesLookup &);
	ThesLookup & operator = (const ThesLookup &);

public:
	ThesLookup(const ::rtl::OUString& idxpath, const ::rtl::OUString& datpath);
	~ThesLookup();

        /* lookup text in index and return synonym count and pointer 
           to an array of sal_Char *  */
        /* note: calling routine should call rtl_freeMemory(*lsyn) if non-zero */
        /* but do *not* free any of the individual component sal_Char * , just dup them */
        sal_Int32 Lookup(const sal_Char * pText, sal_Int32 len, sal_Char*** lsyn); 

private:
        /* Open index and dat files and load list array */ 
        sal_Int32 thInitialize (const ::rtl::OUString& indxpath, const ::rtl::OUString& datpath);
        
        /* close and cleanup dat and idx files */
        sal_Int32 thCleanup ();

        /* read a text line (\n terminated) stripping off line terminator */
        sal_Int32 readLine(File * pf, sal_Char * buf, sal_Int32 nc);

        /* binary search on null terminated ASCII character strings */
        sal_Int32 binsearch(sal_Char * wrd, sal_Char* list[], int nlst);

        /* endian aware memcpy for strings of unsigned shorts */
        void end_cpy(sal_Char * q, sal_Char * p, sal_Int32 num_shorts);

};

///////////////////////////////////////////////////////////////////////////

#endif





