/*************************************************************************
 *
 *  $RCSfile: soprxsettings.cxx,v $
 *
 *  $Revision: 1.6.46.1 $
 *
 *  last change: $Author: hr $ $Date: 2004/01/09 18:54:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//------------------------------------------------------------------------
// includes
//------------------------------------------------------------------------

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#ifndef _SOPRXSETTINGS_HXX_
#include "soprxsettings.hxx"
#endif

#ifndef _OSL_SECURITY_HXX_
#include <osl/security.hxx>
#endif

#ifndef _OSL_PROFILE_HXX_
#include <osl/profile.hxx>
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _OSL_THREAD_H__
#include <osl/thread.h>
#endif

#if !(defined(MACOSX) || defined(FREEBSD))
#include <malloc.h>
#endif
#include <map>
#include <utility>

//------------------------------------------------------------------------
// namespace directives
//------------------------------------------------------------------------

using com::sun::star::uno::Reference;
using com::sun::star::uno::RuntimeException;
using com::sun::star::uno::Sequence;
using com::sun::star::lang::XServiceInfo;
using com::sun::star::system::XProxySettings;
using rtl::OUString;
using osl::Mutex;
using rtl::OString;

using namespace cppu;

//------------------------------------------------------------------------
// defines
//------------------------------------------------------------------------

#define COMP_IMPL_NAME   "com.sun.star.comp.system.SOffice52ProxySettings"

//------------------------------------------------------------------------
// constants
//------------------------------------------------------------------------

const OUString SOFFICE_USER_DIR = OUString::createFromAscii( "user/" );
const OUString SOFFICE          = OUString::createFromAscii( SAL_CONFIGFILE( "soffice" ) );
const OUString SVERSION         = OUString::createFromAscii( SAL_SYSCONFIGFILE( "sversion" ) );

const OString SO_INET_SECTION     = OString( "INet" );
const OString SV_VERSIONS_SECTION = OString( "Versions" );
const OString SV_SOFFICE52_KEY    = OString( "StarOffice 5.2" );

const OString SO_PROXY_TYPE_KEY          = OString( "ProxyType" );
const OString SO_HTTP_PROXY_NAME_KEY     = OString( "HTTPProxyName" );
const OString SO_HTTP_PROXY_PORT_KEY     = OString( "HTTPProxyPort" );
const OString SO_SECURITY_PROXY_NAME_KEY = OString( "SecurityProxyName" );
const OString SO_SECURITY_PROXY_PORT_KEY = OString( "SecurityProxyPort" );
const OString SO_FTP_PROXY_NAME_KEY      = OString( "FTPProxyName" );
const OString SO_FTP_PROXY_PORT_KEY      = OString( "FTPProxyPort" );
const OString SO_SOCKS_PROXY_NAME_KEY    = OString( "SOCKSProxyName" );
const OString SO_SOCKS_PROXY_PORT_KEY    = OString( "SOCKSProxyPort" );
const OString SO_NO_PROXY_KEY            = OString( "NoProxy" );

//------------------------------------------------------------------------
// helper functions
//------------------------------------------------------------------------

namespace // private
{
	Sequence< OUString > SAL_CALL Component_getSupportedServiceNames()
	{
		Sequence< OUString > aRet(2);
		aRet[0] = OUString::createFromAscii("com.sun.star.system.ProxySettings");
        aRet[1] = OUString::createFromAscii("com.sun.star.system.SOProxySettings");

		return aRet;
	}
         
} // end private namespace

//-------------------------------------------------
//
//-------------------------------------------------

CSoProxySettings::CSoProxySettings( ) : 
	WeakComponentImplHelper2< XProxySettings, XServiceInfo >( m_aMutex )
{	       
}

//-------------------------------------------------
//
//-------------------------------------------------

CSoProxySettings::~CSoProxySettings( )
{    
}

//-------------------------------------------------
//
//-------------------------------------------------

OUString SAL_CALL CSoProxySettings::getFtpProxyAddress(  ) throw (RuntimeException)
{
    if ( isProxyEnabled( ) )
        return readFromSo52SOfficeINetSection( SO_FTP_PROXY_NAME_KEY );

    return OUString( );
}

//-------------------------------------------------
//
//-------------------------------------------------

OUString SAL_CALL CSoProxySettings::getFtpProxyPort(  ) throw (RuntimeException)
{  
    if ( isProxyEnabled( ) )
        return readFromSo52SOfficeINetSection( SO_FTP_PROXY_PORT_KEY );

    return OUString( );
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSoProxySettings::getGopherProxyAddress(  ) throw (RuntimeException)
{
    return OUString( );
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSoProxySettings::getGopherProxyPort(  ) throw (RuntimeException)
{
    return OUString( );
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSoProxySettings::getHttpProxyAddress(  ) throw (RuntimeException)
{
    if ( isProxyEnabled( ) )
        return readFromSo52SOfficeINetSection( SO_HTTP_PROXY_NAME_KEY );

    return OUString( );
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSoProxySettings::getHttpProxyPort(  ) throw (RuntimeException)
{
    if ( isProxyEnabled( ) )
        return readFromSo52SOfficeINetSection( SO_HTTP_PROXY_PORT_KEY );

    return OUString( );
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSoProxySettings::getHttpsProxyAddress(  ) throw (RuntimeException)
{
    if ( isProxyEnabled( ) )
        return readFromSo52SOfficeINetSection( SO_SECURITY_PROXY_NAME_KEY );

    return OUString( );
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSoProxySettings::getHttpsProxyPort(  ) throw (RuntimeException)
{
    if ( isProxyEnabled( ) )
        return readFromSo52SOfficeINetSection( SO_SECURITY_PROXY_PORT_KEY );

    return OUString( );
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSoProxySettings::getSocksProxyAddress(  ) throw (RuntimeException)
{
    if ( isProxyEnabled( ) )
        return readFromSo52SOfficeINetSection( SO_SOCKS_PROXY_NAME_KEY );

    return OUString( );
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSoProxySettings::getSocksProxyPort(  ) throw (RuntimeException)
{
    if ( isProxyEnabled( ) )
        return readFromSo52SOfficeINetSection( SO_SOCKS_PROXY_PORT_KEY );

    return OUString( );
}

//-------------------------------------------------
//
//-------------------------------------------------
    
OUString SAL_CALL CSoProxySettings::getProxyBypassAddress(  ) throw (RuntimeException)
{
    if ( isProxyEnabled( ) )
        return readFromSo52SOfficeINetSection( SO_NO_PROXY_KEY );

    return OUString( );
}

//-------------------------------------------------
//
//-------------------------------------------------

sal_Bool SAL_CALL CSoProxySettings::isProxyEnabled( ) throw (RuntimeException)
{
    OUString proxyType = readFromSo52SOfficeINetSection( SO_PROXY_TYPE_KEY );
    sal_Int32 nProxyType = proxyType.toInt32( );
        
    return ( 2 == nProxyType );
}

// -------------------------------------------------
// XServiceInfo
// -------------------------------------------------

OUString SAL_CALL CSoProxySettings::getImplementationName(  ) 
	throw( RuntimeException )
{
	return OUString::createFromAscii( COMP_IMPL_NAME );
}

// -------------------------------------------------
//	XServiceInfo
// -------------------------------------------------

sal_Bool SAL_CALL CSoProxySettings::supportsService( const OUString& ServiceName ) 
	throw( RuntimeException )
{
	Sequence < OUString > SupportedServicesNames = Component_getSupportedServiceNames();

	for ( sal_Int32 n = SupportedServicesNames.getLength(); n--; )
		if (SupportedServicesNames[n].compareTo(ServiceName) == 0)
			return sal_True;

	return sal_False;
}

// -------------------------------------------------
//	XServiceInfo
// -------------------------------------------------

Sequence< OUString > SAL_CALL CSoProxySettings::getSupportedServiceNames(	 ) 
	throw( RuntimeException )
{
	return Component_getSupportedServiceNames();
}

//-------------------------------------------------
//
//-------------------------------------------------

OUString CSoProxySettings::readFromSo52SOfficeINetSection( const OString& aKey ) const
{
    OUString keyValue;

    try
    {
        OUString so52SOfficeDirURL = getSo52SOfficeDir( );
        if ( so52SOfficeDirURL.getLength( ) )
        {          
            osl::Profile profile( so52SOfficeDirURL );

            OString value;       
            value = profile.readString( SO_INET_SECTION, aKey, value );
            if ( value.getLength( ) )
                keyValue = OUString( 
                    value.getStr( ), 
                    value.getLength( ), 
                    osl_getThreadTextEncoding( ) );
        }
    }
    catch( std::exception& )
    {
        OSL_ENSURE( sal_False, "Could not read from profile" );
    }

    return keyValue;
}

//-------------------------------------------------
//
//-------------------------------------------------

rtl::OUString CSoProxySettings::getSo52SOfficeDir( ) const
{
    OUString so52SOfficeDirURL = getSo52UserDir( );
    if ( so52SOfficeDirURL.getLength( ) )
        osl::FileBase::getAbsoluteFileURL(
            so52SOfficeDirURL,
            SOFFICE,
            so52SOfficeDirURL );

    return so52SOfficeDirURL;
}

//-------------------------------------------------
// returns the SOffice 5.2 installation directory
// as file url
//-------------------------------------------------

OUString CSoProxySettings::getSo52UserDir( ) const
{
    OUString so52UserDirURL;
    OUString so52InstallDirURL = getSo52InstallDir( );

    if ( so52InstallDirURL.getLength( ) )
        osl::FileBase::getAbsoluteFileURL(
            so52InstallDirURL,
            SOFFICE_USER_DIR,
            so52UserDirURL );

    return so52UserDirURL;
}

//-------------------------------------------------
// returns the SOffice 5.2 installation directory
// as file url
//-------------------------------------------------

OUString CSoProxySettings::getSo52InstallDir( ) const
{
    OUString so52InstallDirURL;

    try
    {
        osl::Security security;
        OUString cfgDir;

        security.getConfigDir( cfgDir );
        if ( cfgDir.getLength( ) )
        {
            OUString cfgDirURL;
            osl::FileBase::getAbsoluteFileURL( 
                cfgDir, 
                SVERSION,
                cfgDirURL );

            osl::Profile profile( cfgDirURL );
            
            rtl::OString osSo52InstallDir;			
            osSo52InstallDir = profile.readString( 
                SV_VERSIONS_SECTION, 
                SV_SOFFICE52_KEY, 
                osSo52InstallDir );
            
            if ( osSo52InstallDir.getLength( ) )
            {
                OUString dir( 
                    osSo52InstallDir.getStr( ), 
                    osSo52InstallDir.getLength( ), 
                    osl_getThreadTextEncoding( ) );

                OUString dirURL;
                osl::FileBase::RC rc =
                    osl::FileBase::getFileURLFromSystemPath( 
                        dir, dirURL );

                if ( osl::FileBase::E_None == rc )                
                    so52InstallDirURL = dirURL;                                    
            }
        }       
    }
    catch( std::exception& )
    {
        OSL_ENSURE( sal_False, "Could not read from profile" );
    }
    
    return so52InstallDirURL;
}


