/*************************************************************************
 *
 *  $RCSfile: AppletResourceConnection.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:54:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package stardiv.net.protocol.appletresource;

import java.net.URL;
import java.io.IOException;
import java.io.InputStream;
import sun.net.www.URLConnection;
import sun.net.www.MessageHeader;
import sun.net.*;
import java.net.*;

import com.sun.star.lib.sandbox.ResourceProxy;
import com.sun.star.lib.sandbox.SandboxSecurityException;

/**
 * AppletResource: represents a resource obtained through an AppletClassLoader
 * Resource URLs are of the form "appresource:<baseURL>/+/<resource name>"
 *
 * @see		Handler
 * @version 	1.8, 11/23/96
 * @author	Eduardo Pelegri-Llopart
 */

public class AppletResourceConnection extends URLConnection {
    private static boolean debug = false;// debugging?

    private Object resource;	// the resource we are looking for
    private String base;	// basename for resource
    private String member;	// member relative to base
    private URL cachedURL;	// the URL under which the resource is cached

    protected AppletResourceConnection (URL url)
		throws MalformedURLException, IOException
    {
		super(url);
		debug("AppletResourceConnection("+url+")");
		String file = url.getFile();
		if (file.startsWith("/")) {
			file = file.substring(1);
		}
		base = file.substring(0, file.indexOf("/+/"));
		member = file.substring(file.indexOf("/+/")+3);
		cachedURL = new URL(base + member);

		debug(" base: "+base);
		debug(" member: "+member);
		debug(" cachedURL: "+cachedURL);
    }

	public static synchronized Object getContent(ResourceProxy resource, URL url) {
		SecurityManager securityManager = System.getSecurityManager();
		if(securityManager != null)
			securityManager.checkConnect(url.getHost(), url.getPort());

		Object content = null;
		
		try {
			content = resource.getContent();

			if (content != null && content instanceof String) {
				// this is a .class file...
				// no access to .class files through getResource() in 1.1
				throw new SandboxSecurityException("getresource.noclassaccess", url.toString());
			}
		}
		catch(IOException iOException) {
			if(debug) System.err.println("#### AppletResourceConnection.getContent - exception:" + iOException);
		}
		
		return content;
	}
	
    public void connect() throws IOException {
		debug("Looking for "+cachedURL+" in AppletResourceLoader");
		ResourceProxy resourceProxy = ResourceProxy.load(cachedURL, null);

		Object content = getContent(resourceProxy, cachedURL);

		if (content == null) {
			debug("Invalid resource name");
			resource = null;
			return;
		} else {
			debug("Found resource");
			resource = content;
		}
    }

    public Object getContent() throws IOException {
		if (!connected) {
			connect();
		}
		return resource;
    }

    public InputStream getInputStream() throws IOException {
		if (!connected) {
			connect();
		}

		if (resource instanceof InputStream) {
			return (InputStream) resource;
		}
		return ResourceProxy.load(cachedURL, null).getInputStream();
    }

    private void debug(String msg) {
		if (debug) {
			System.err.println(msg);
		}
    }
}
