/*************************************************************************
 *
 *  $RCSfile: iodlgimp.cxx,v $
 *
 *  $Revision: 1.19.278.2 $
 *
 *  last change: $Author: vg $ $Date: 2003/11/13 16:58:58 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

// includes *******************************************************************

#ifndef _HEADBAR_HXX
#include "headbar.hxx"
#endif
#ifndef _TOOLS_DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif
#ifndef _WLDCRD_HXX //autogen
#include <tools/wldcrd.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_MENU_HXX //autogen
#include <vcl/menu.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
// #97148# ---------------
#ifndef _SVTOOLS_CTYPEITM_HXX //autogen
#include "ctypeitm.hxx"
#endif
#ifndef _SFXENUMITEM_HXX
#include "eitem.hxx"
#endif
#ifndef INCLUDED_SVTOOLS_VIEWOPTIONS_HXX
#include "viewoptions.hxx"
#endif
#ifndef _SVT_FILEVIEW_HXX
#include "fileview.hxx"
#endif
#ifndef _SVTOOLS_SVTUNO_HXX
#include "svtuno.hxx"
#endif
#ifndef _SVTOOLS_SVTDATA_HXX
#include "svtdata.hxx"
#endif
#ifndef _IODLGIMP_HXX
#include "iodlgimp.hxx"
#endif
#ifndef _IODLGIMPL_HXX
#include "iodlg.hxx"
#endif
#ifndef _SVTOOLS_INETTBC_HXX
#include "inettbc.hxx"
#endif
#ifndef _SVTOOLS_IODLGIMPL_HRC
#include "iodlg.hrc"
#endif
#ifndef _SVTOOLS_IMAGEMGR_HXX
#include "imagemgr.hxx"
#endif
#ifndef _UNOTOOLS_LOCALFILEHELPER_HXX
#include <unotools/localfilehelper.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_USEROPTIONS_HXX
#include "useroptions.hxx"
#endif
#ifndef _ISOLANG_HXX
#include <tools/isolang.hxx>
#endif

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::utl;

// some stuff for easier changes for SvtViewOptions
static const sal_Char*		pViewOptDataName = "dialog data";
#define VIEWOPT_DATANAME	::rtl::OUString::createFromAscii( pViewOptDataName )

static inline void SetViewOptUserItem( SvtViewOptions& rOpt, const String& rData )
{
	rOpt.SetUserItem( VIEWOPT_DATANAME, makeAny( ::rtl::OUString( rData ) ) );
}

static inline String GetViewOptUserItem( const SvtViewOptions& rOpt )
{
	Any aAny( rOpt.GetUserItem( VIEWOPT_DATANAME ) );
	::rtl::OUString aUserData;
	aAny >>= aUserData;

	return String( aUserData );
}


#define _SVSTDARR_STRINGSSORTDTOR
#define _SVSTDARR_STRINGSDTOR
#define _SVSTDARR_USHORTS
#include "svstdarr.hxx"

// defines f"ur den Style der BrowseBox

#define STYLE_MULTI_SELECTION	\
	CNTVIEWSTYLE_NODE_BUTTONS | \
	CNTVIEWSTYLE_NODE_BUTTONS_AT_ROOT | \
	CNTVIEWSTYLE_SHOW_MESSAGES | \
	CNTVIEWSTYLE_SHOW_FOLDERS | \
	CNTVIEWSTYLE_NO_SMARTHIGHLIGHT | \
	CNTVIEWSTYLE_HIDE_OPENMENU | \
	CNTVIEWSTYLE_DEFAULT_APPEARANCE | \
	CNTVIEWSTYLE_SORT_BY_FOLDER

#define STYLE_SINGLE_SELECTION	\
	STYLE_MULTI_SELECTION | CNTVIEWSTYLE_SINGLE_SELECTION

#define BOOL_NOT_INITIALIZE		((sal_Bool)2)

//*****************************************************************************

String GetRegularExpression_Impl( const String& rFilter )
{
	String aFilter = rFilter;
	aFilter.EraseLeadingChars().EraseTrailingChars();
	String aRegExp = '^';

	for ( const sal_Unicode *pc = aFilter.GetBuffer(); *pc; ++pc )
	{
		if ( '*' == *pc )
			aRegExp += DEFINE_CONST_UNICODE(".*");
		else if ( '?' == *pc )
			aRegExp += '.';
		else
		{
			aRegExp += '\'';

			while ( *pc && *pc != '*' && *pc != '?' )
			{
				if ( '\'' == *pc )
					aRegExp += DEFINE_CONST_UNICODE("\\\'");
				else
					aRegExp += *pc;
				pc++;
			}
			aRegExp += '\'';

			if ( !*pc )
				break;
			else
				pc--;
		}
	}
	aRegExp += '$';
	return aRegExp;
}

//*****************************************************************************
// SvtFileDialogFilter_Impl
//*****************************************************************************

DBG_NAME( SvtFileDialogFilter_Impl )
SvtFileDialogFilter_Impl::SvtFileDialogFilter_Impl( const String& rName, const String& rType )
	:m_aName( rName )
	,m_aType( rType )
{
	DBG_CTOR( SvtFileDialogFilter_Impl, NULL );

	m_aType.ToLowerAscii();
}

//*****************************************************************************

SvtFileDialogFilter_Impl::~SvtFileDialogFilter_Impl()
{
	DBG_DTOR( SvtFileDialogFilter_Impl, NULL );
}

//*****************************************************************************
// SvtFileDialogFilterList_Impl
//*****************************************************************************

SV_IMPL_PTRARR( SvtFileDialogFilterList_Impl, SvtFileDialogFilter_Impl* );

//=============================================================================
//= SvtFileDialogURLSelector
//=============================================================================

//-----------------------------------------------------------------------------
SvtFileDialogURLSelector::SvtFileDialogURLSelector( SvtFileDialog* _pParent, const ResId& _rResId, sal_uInt16 _nButtonId )
    :MenuButton ( _pParent, _rResId )
	,m_pParent  ( _pParent )
    ,m_pMenu    ( new PopupMenu )
{
	SetStyle( GetStyle() | WB_NOPOINTERFOCUS | WB_RECTSTYLE | WB_SMALLSTYLE );
	SetImage( m_pParent->GetButtonImage( _nButtonId ) );
	SetMenuMode( MENUBUTTON_MENUMODE_TIMED );
	SetDropDown( PUSHBUTTON_DROPDOWN_TOOLBOX );
}

//-----------------------------------------------------------------------------
SvtFileDialogURLSelector::SvtFileDialogURLSelector( SvtFileDialog* _pParent, sal_uInt16 _nButtonId )
    :MenuButton ( _pParent, WB_SVLOOK )
	,m_pParent  ( _pParent )
    ,m_pMenu    ( new PopupMenu )
{
	SetStyle( GetStyle() | WB_NOPOINTERFOCUS | WB_RECTSTYLE | WB_SMALLSTYLE );
	SetImage( m_pParent->GetButtonImage( _nButtonId ) );
	SetMenuMode( MENUBUTTON_MENUMODE_TIMED );
	SetDropDown( PUSHBUTTON_DROPDOWN_TOOLBOX );
}

//-----------------------------------------------------------------------------
SvtFileDialogURLSelector::~SvtFileDialogURLSelector()
{
	delete m_pMenu;
}

//-----------------------------------------------------------------------------
void SvtFileDialogURLSelector::OpenURL( const String& rURL )
{
	INetURLObject aObj( rURL );
    DBG_ASSERT( aObj.GetProtocol() != INET_PROT_NOT_VALID, "SvtFileDialogURLSelector::OpenURL: Invalid URL!" );
	m_pParent->OpenURL_Impl( aObj.GetMainURL( INetURLObject::NO_DECODE ) );
}

//-----------------------------------------------------------------------------
void SvtFileDialogURLSelector::Activate()
{
	m_pMenu->Clear();

    FillURLMenu( m_pMenu );

	SetPopupMenu( m_pMenu );
}

//=============================================================================
//= SvtUpButton_Impl
//=============================================================================

//-----------------------------------------------------------------------------
SvtUpButton_Impl::SvtUpButton_Impl( SvtFileDialog* pParent, const ResId& rResId )
    :SvtFileDialogURLSelector( pParent, rResId, IMG_FILEDLG_BTN_UP )
	,_pURLs			         ( NULL )
{
}

//-----------------------------------------------------------------------------
SvtUpButton_Impl::~SvtUpButton_Impl()
{
	delete _pURLs;
}

//-----------------------------------------------------------------------------
void SvtUpButton_Impl::FillURLMenu( PopupMenu* _pMenu )
{
	SvtFileView* pBox = GetParent()->GetView();

	sal_uInt16 nItemId = 1;

	delete _pURLs;
	_pURLs = new SvStringsDtor;

	// "Ubergeordnete Ebenen bestimmen.
	INetURLObject aObject( pBox->GetViewURL() );
	sal_Int32 nCount = aObject.getSegmentCount();

	::svtools::VolumeInfo aVolInfo( sal_True /* volume */, sal_False /* remote */,
									sal_False /* removable */, sal_False /* floppy */,
									sal_False /* compact disk */ );
	sal_Bool bIsHighContrast = pBox->GetDisplayBackground().GetColor().IsDark();
	Image aVolumeImage( SvFileInformationManager::GetFolderImage( aVolInfo, bIsHighContrast ) );

	while ( nCount >= 1 )
	{
		aObject.removeSegment();
		String* pParentURL = new String( aObject.GetMainURL( INetURLObject::NO_DECODE ) );

        if ( GetParent()->isUrlAllowed( *pParentURL ) )
        {
		    String aTitle;
		    // 97148# --------------------------------
		    if ( !GetParent()->ContentGetTitle( *pParentURL, aTitle ) || aTitle.Len() == 0 )
			    aTitle = aObject.getName();

		    Image aImage = ( nCount > 1 ) // if nCount == 1 means workplace, which detects the wrong image
			    ? SvFileInformationManager::GetImage( aObject, bIsHighContrast )
			    : aVolumeImage;

            _pMenu->InsertItem( nItemId++, aTitle, aImage );
            _pURLs->Insert( pParentURL, _pURLs->Count() );

            if ( nCount == 1 )
            {
                // adjust the title of the top level entry (the workspace)
                String sUserLocale = SvtUserOptions().GetLocale();
                LanguageType eUserLang = ConvertIsoStringToLanguage( sUserLocale );
                _pMenu->SetItemText( --nItemId, SvtSimpleResId( STR_SVT_MIMETYPE_CNT_FSYSBOX, eUserLang ) );
            }
        }

        --nCount;
	}
}

//-----------------------------------------------------------------------------
void SvtUpButton_Impl::Select()
{
	sal_uInt16 nId = GetCurItemId();

	if ( nId )
	{
		--nId;
		DBG_ASSERT( nId <= _pURLs->Count(), "SvtUpButton_Impl:falscher Index" );

        String aURL = *(_pURLs->GetObject( nId ));
		GetParent()->OpenURL_Impl( aURL );
	}
}

//-----------------------------------------------------------------------------
void SvtUpButton_Impl::Click()
{
	GetParent()->PrevLevel_Impl();
}

//=============================================================================
//= SvtTravelButton_Impl
//=============================================================================

//-----------------------------------------------------------------------------
SvtTravelButton_Impl::SvtTravelButton_Impl( SvtFileDialog* pParent, const ResId& rResId )
    :SvtFileDialogURLSelector   ( pParent, rResId, IMG_FILEDLG_BTN_STD )
{
	SetDropDown( 0 );   // by default, don't drop down, as we don't have favourites
}

//-----------------------------------------------------------------------------
SvtTravelButton_Impl::SvtTravelButton_Impl( SvtFileDialog* pParent )
    :SvtFileDialogURLSelector   ( pParent, IMG_FILEDLG_BTN_STD )
{
	SetDropDown( 0 );   // by default, don't drop down, as we don't have favourites

    {
        PushButton aFakedResourceAccess( pParent, ResId( BTN_EXPLORERFILE_STANDARD ) );
        SetText( aFakedResourceAccess.GetText() );
        SetPosPixel( aFakedResourceAccess.GetPosPixel() );
        SetSizePixel( aFakedResourceAccess.GetSizePixel() );
        SetHelpId( aFakedResourceAccess.GetHelpId() );
    }

    Enable();
    Show();
}

//-----------------------------------------------------------------------------
void SvtTravelButton_Impl::SetFavouriteLocations( const ::std::vector< String >& _rLocations )
{
    m_aFavourites = _rLocations;
    // enable the drop down if and only if we have favourites
    SetDropDown( m_aFavourites.empty() ? 0 : PUSHBUTTON_DROPDOWN_TOOLBOX );
}

//-----------------------------------------------------------------------------
SvtTravelButton_Impl::~SvtTravelButton_Impl()
{
}

//-----------------------------------------------------------------------------
void SvtTravelButton_Impl::FillURLMenu( PopupMenu* _pMenu )
{
    if ( m_aFavourites.empty() )
        // though we claimed that we do not want to have a drop down button
        // in this case, VCL nevertheless behaves as if we had one .... :(
        return;

    _pMenu->Clear();

	sal_Bool bIsHighContrast = GetParent()->GetView()->GetDisplayBackground().GetColor().IsDark();

    USHORT nItemId = 1;
    String sDisplayName;

    ::std::vector< String >::const_iterator aLoop;
    for ( aLoop = m_aFavourites.begin(); aLoop != m_aFavourites.end(); ++aLoop, ++nItemId )
    {
        if ( GetParent()->isUrlAllowed( *aLoop ) )
        {
		    Image aImage = SvFileInformationManager::GetImage( *aLoop, bIsHighContrast );

            if ( LocalFileHelper::ConvertURLToSystemPath( *aLoop, sDisplayName ) )
                _pMenu->InsertItem( nItemId, sDisplayName, aImage );
            else
                _pMenu->InsertItem( nItemId, *aLoop, aImage );
        }
    }
}

//-----------------------------------------------------------------------------
void SvtTravelButton_Impl::Select()
{
	sal_uInt16 nId = GetCurItemId();
	if ( nId )
	{
		--nId;
        DBG_ASSERT( nId < m_aFavourites.size(), "SvtTravelButton_Impl::Select: invalid index!" );
        if ( nId < m_aFavourites.size() )
            OpenURL( m_aFavourites[ nId ] );
	}
}

//-----------------------------------------------------------------------------
void SvtTravelButton_Impl::Click()
{
	OpenURL( GetParent()->GetStandardDir() );
}

//*****************************************************************************
// SvtExpFileDlg_Impl
//*****************************************************************************

SvtExpFileDlg_Impl::SvtExpFileDlg_Impl( WinBits nBits )	:

	_pFilter            ( new SvtFileDialogFilterList_Impl() ),
	_pCurFilter         ( NULL ),
	_pDefaultFilter		( NULL ),
	_pUserFilter        ( NULL ),
	_pFtFileName        ( NULL ),
	_pEdFileName        ( NULL ),
	_pFtFileVersion     ( NULL ),
	_pLbFileVersion     ( NULL ),
	_pFtTemplates		( NULL ),
	_pLbTemplates		( NULL ),
	_pFtImageTemplates	( NULL ),
	_pLbImageTemplates	( NULL ),
	_pFtFileType        ( NULL ),
	_pLbFilter          ( NULL ),
	_pBtnFileOpen       ( NULL ),
	_pBtnCancel         ( NULL ),
	_pBtnHelp			( NULL ),
	_pBtnLocal          ( NULL ),
	_pBtnUp             ( NULL ),
	_pBtnNewFolder      ( NULL ),
	_pBtnStandard       ( NULL ),
	_pCbPassword        ( NULL ),
	_pCbAutoExtension   ( NULL ),
	_pCbOptions			( NULL ),
	_pFtCurrentPath     ( NULL ),
	_nState             ( FILEDLG_STATE_REMOTE ),
	_bDoubleClick       ( sal_False ),
	_bMultiSelection	( sal_False ),
	_bFolderHasOpened	( sal_False ),
	_nFixDeltaHeight    ( 0 ),
	_nStyle				( 0 ),
	m_bNeedDelayedFilterExecute	( sal_False )

{
}

//*****************************************************************************

SvtExpFileDlg_Impl::~SvtExpFileDlg_Impl()
{
	delete _pFtCurrentPath;
	delete _pCbPassword;
	delete _pCbAutoExtension;
	delete _pCbOptions;
	delete _pBtnStandard;
	delete _pBtnNewFolder;
	delete _pBtnUp;
	delete _pBtnLocal;
	delete _pBtnHelp;
	delete _pBtnCancel;
	delete _pBtnFileOpen;
	delete _pLbFilter;
	delete _pFtFileType;
	delete _pLbFileVersion;
	delete _pFtFileVersion;
	delete _pFtTemplates;
	delete _pLbTemplates;
	delete _pFtImageTemplates;
	delete _pLbImageTemplates;
	delete _pEdFileName;
	delete _pFtFileName;
	delete _pUserFilter;
	delete _pFilter;
}

//*****************************************************************************

void SvtExpFileDlg_Impl::SetStandardDir( const String& _rDir )
{
	_aStdDir = _rDir;
	if ( 0 == _aStdDir.Len() )
		_aStdDir.AssignAscii( "file:///" );
}

//*****************************************************************************

//-----------------------------------------------------------------------------
namespace {
	String lcl_DecoratedFilter( const String& _rOriginalFilter )
	{
		String aDecoratedFilter = '<';
		aDecoratedFilter += _rOriginalFilter;
		aDecoratedFilter += '>';
		return aDecoratedFilter;
	}
}

//-----------------------------------------------------------------------------

void SvtExpFileDlg_Impl::ClearFilterList( )
{
	_pLbFilter->Clear();
}

//-----------------------------------------------------------------------------
void SvtExpFileDlg_Impl::SetCurFilter( SvtFileDialogFilter_Impl* _pFilter, const String& _rDisplayName )
{
	DBG_ASSERT( _pFilter, "SvtExpFileDlg_Impl::SetCurFilter: invalid filter!" );
	DBG_ASSERT( ( _rDisplayName == _pFilter->GetName() )
			||	( _rDisplayName == lcl_DecoratedFilter( _pFilter->GetName() ) ),
			"SvtExpFileDlg_Impl::SetCurFilter: arguments are inconsistent!" );

	_pCurFilter = _pFilter;
	m_sCurrentFilterDisplayName = _rDisplayName;
}

//-----------------------------------------------------------------------------
void SvtExpFileDlg_Impl::InsertFilterListEntry( const SvtFileDialogFilter_Impl* _pFilterDesc )
{
	String sName = _pFilterDesc->GetName();
	if ( _pFilterDesc->isGroupSeparator() )
		sName = String::CreateFromAscii( "------------------------------------------" );
	else
		sName = _pFilterDesc->GetName();

	// insert an set user data
	USHORT nPos = _pLbFilter->InsertEntry( sName );
	_pLbFilter->SetEntryData( nPos, const_cast< void* >( static_cast< const void* >( _pFilterDesc ) ) );
}

//-----------------------------------------------------------------------------

void SvtExpFileDlg_Impl::InitFilterList( )
{
	// clear the current list
	ClearFilterList( );

	// reinit it
	USHORT nPos = _pFilter->Count();

	// search for the first entry which is no group separator
	while ( nPos-- && _pFilter->GetObject( nPos ) && _pFilter->GetObject( nPos )->isGroupSeparator() )
		;

	// add all following entries
	while ( (sal_Int16)nPos >= 0 )
		InsertFilterListEntry( _pFilter->GetObject( nPos-- ) );
}

//-----------------------------------------------------------------------------

void SvtExpFileDlg_Impl::CreateFilterListControl( Window* _pParent, const ResId& _rId )
{
	DBG_ASSERT( !_pLbFilter, "SvtExpFileDlg_Impl::CreateFilterListControl: already created the control!" );
	if ( !_pLbFilter )
		_pLbFilter = new ListBox( _pParent, _rId );
}

//-----------------------------------------------------------------------------

SvtFileDialogFilter_Impl* SvtExpFileDlg_Impl::FindFilter( const String& _rFilterName )
{
	// simply loop through the filter list and compare names ...
	USHORT nPos = _pFilter->Count();
	while ( nPos-- )
	{
		SvtFileDialogFilter_Impl* pFilter = _pFilter->GetObject( nPos );
		if ( pFilter->GetName() == _rFilterName )
			return pFilter;
	}
	return NULL;
}

#ifdef FILTER_MRU_LIST

//******************************************************************************
//* Ab hier kommen die Methoden zum Cachen der 5 letzten Filter oberhalb des   *
//* <Alle> Filters in der FilterListBox										   *
//******************************************************************************

// Anzahl der zuletzt genutzten Filter die am Anfang der
// FilterBox angezeigt werden sollen
#define CACHE_FILTERS_COUNT	5

// Trennzeichen zum speichern der 5 zuletzt genutzten Filter
#define MULTIFILTER_DELIMITER ';'

//******************************************************************************

void SvtExpFileDlg_Impl::InitFilterCache_Impl()
{
	SvtViewOptions aDlgOpt( E_DIALOG, _aIniKey );
	if ( aDlgOpt.Exists() )
	{
		String aFilters( GetViewOptUserItem( aDlgOpt ) );
		aDlgOpt.GetUserData();

		const sal_Unicode cTok = MULTIFILTER_DELIMITER;
		const xub_StrLen nCount = aFilters.GetTokenCount( cTok );

		// first token is the AutoExtension-flag -> so i = 1 and not i = 0
		for ( xub_StrLen i = 1; i < nCount; i++ )
			_aFilterCacheList.Insert( new String( aFilters.GetToken( i, cTok ) ), LIST_APPEND );

		// Position des <Alle> - Filters, falls er nicht da ist - raus
		String aAll( SvtResId( STR_FILTERNAME_ALL ) );
		sal_uInt16 nAllPos = _pLbFilter->GetEntryPos( aAll );
		if ( nAllPos == LISTBOX_ENTRY_NOTFOUND )
			return;
		// Wenn der <Alle> - Filter der Letzte ist - anhaengen
		if ( ++nAllPos >= _pLbFilter->GetEntryCount() )
			nAllPos = LISTBOX_APPEND;

		// die Top5 Filter in der Box nach oben kopieren
		String* pFilterStr = (String*)_aFilterCacheList.Last();
		while ( pFilterStr )
		{
			// Filter Nur in die Listbox eintragen, wenn er dort
			// bereits vorhanden ist
			sal_uInt16 nPos = _pLbFilter->GetEntryCount();
			while ( nPos-- )
			{
				if ( pFilterStr->CompareTo( _pLbFilter->GetEntry( nPos ) ) == COMPARE_EQUAL )
				{
					SvtFileDialogFilter_Impl* pFilterData = FindFilter( *pFilterStr );
					DBG_ASSERT( pFilterData, "SvtExpFileDlg_Impl::InitFilterCache_Impl: invalid filter name!" );

					if ( pFilterData )
					{
						sal_uInt16 nFilterPos = _pLbFilter->InsertEntry( lcl_DecoratedFilter( *pFilterStr ), nAllPos );
						_pLbFilter->SetEntryData( nFilterPos, pFilterData );
					}
					break;
				}
			}
			pFilterStr = (String*)_aFilterCacheList.Prev();
		}
	}
}

//******************************************************************************

void SvtExpFileDlg_Impl::SaveFilterCache_Impl()

/*	[Beschreibung]

	Filter Cache in die Ini schreiben
*/

{
	String aFilters;
	String* pFilterStr = (String*)_aFilterCacheList.First();
	while ( pFilterStr )
	{
		aFilters += *pFilterStr;
		aFilters += MULTIFILTER_DELIMITER;
		delete pFilterStr;
		pFilterStr = (String*)_aFilterCacheList.Next();
	}
	_aFilterCacheList.Clear();

	SvtViewOptions aDlgOpt( E_DIALOG, _aIniKey );
	String aUserData;
	if ( _pCbAutoExtension )
		aUserData = _pCbAutoExtension->IsChecked() ? '1' : '0';
	else if ( aDlgOpt.Exists() )
		aUserData = String( aDlgOpt.GetUserData() ).GetToken(0);
	else
		aUserData = '1';
	aUserData += ';';
	aUserData += aFilters;
	aUserData.EraseTrailingChars( MULTIFILTER_DELIMITER );
	SetViewOptUserItem( aDlgOpt, aUserData );
}

//******************************************************************************

// Selektierten Filter im Filter Cache merken

void SvtExpFileDlg_Impl::CacheFilter_Impl( const String& aFilter )
{
	// ist der Filter schon im cache, wird er zuerst aus selbigen entfernt.
	String* pFilterStr = (String*)_aFilterCacheList.First();
	while(pFilterStr)
	{
		if(aFilter.CompareTo(*pFilterStr) == COMPARE_EQUAL)
		{
			_aFilterCacheList.Remove();
			delete pFilterStr;
			break;
		}

		pFilterStr = (String*)_aFilterCacheList.Next();
	}

	_aFilterCacheList.Insert((void*)new String(aFilter), (sal_uInt32)0);

	// pruefen, ob der Cache voll ist
	if(_aFilterCacheList.Count() > CACHE_FILTERS_COUNT)
	{
		String* pFilterStr = (String*)_aFilterCacheList.Last();
		_aFilterCacheList.Remove();
		delete pFilterStr;
	}
}

#endif
