/*************************************************************************
 *
 *  $RCSfile: saldata.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:32 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/



#ifndef _SV_SALDATA_HXX

#define _SV_SALDATA_HXX



#ifndef _SV_SV_H

#include <sv.h>

#endif

#ifndef _SV_SVDATA_HXX

#include <svdata.hxx>

#endif

#ifndef _SV_SALWTYPE_HXX

#include <salwtype.hxx>

#endif



class ApplicationEvent;

class AutoTimer;

class SalFrame;



struct MemData;

class FontList;



typedef void (*SVLOOPPROC) ();

typedef short (*SVHOOK)    ( EventRecord *pEvent );



struct UserEventData								// mac PostMessage, SendMessage impl

{

	UserEventData	*mpNextEvent;

	SalFrame		*mpSalFrame;

	void			*mpEventData;

	ULONG			mnEvent;

	MAC_Point		maWhere;						// screen global

	long			mnWhen;							// milli secs since startup

};



struct SVLOOPPROCDATA

{

	SVLOOPPROCDATA	*mpNext;

	SVLOOPPROC		mpLoopProc;

};



struct AppEventList

{

	ApplicationEvent	*mpAppEvent;

	AppEventList		*mpNext;

};





// -----------

// - SalData -

// -----------



class SalData	// Achtung wird mit memset inited !

{

// ganz privat: 

	BOOL		ImplDispatchUserEvent( UserEventData* pUEvntDat );

public:

    UINT32                  mnTimerId;              // windows timer id, macs deadline time

    SALTIMERPROC            mpTimerProc;            // timer callback proc

    SALEXCEPTIONPROC        mpExceptionProc;        // excaption callback

	SalFrame*				mpWantLeaveMsg;         // frame pointer, that want a MOUSELEAVE message

    SalInstance*            mpFirstInstance;        // pointer of first instance

    SalFrame*               mpFirstFrame;           // pointer of first frame

	INT16					mnRefNum;				// RefNum des Res. Files der App

	UserEventData*			mpUserEvent;			// mac PostMessage impl

	SalFrame*				mpCaptureFrame;			// which frame gets the mouse clicks



	EventRecord				maLastEventRec;			//

	EventRecord*			mpMacEvent;				//
	EventRecord				maLastMouseDown;		// used for drag and Drop





	BOOL					mbInSuspendResume	:1;	// in suspend/resume event (wg clipboard)

	BOOL					mbInForeground		:1;	// Sind wir der Front-Prozess?

	BOOL					mbEnde				:1;	// Soll die Appl. beendet werden ?

	BOOL					mbMouseButtonDown	:1;	// Warten wir noch auf ein MB-Up event?

	BOOL					mbPrinterInit		:1;	// Wurde der Drucker schon initialisiert?



	WindowPtr				mpFocusWin;				// Zeiger auf das Focus-Window

	MemData*				mpMemData;				// memory mgr data (tools)

	FontList*				mpFontList;				// Liste der Fonts auf diesem Macintosh



	AppEventList*			mpAppEventList;			// Lister der AppEvents, die vor Execute

													// angefallen sind



	BOOL		ImplSendMessage( SalFrame* pSalFrame, void *pEventData, ULONG nEvent, MAC_Point where, long nWhen=0L );

	BOOL		ImplSendMessage( SalFrame* pSalFrame, void *pEventData, ULONG nEvent );

	BOOL		ImplSendMessage( UserEventData* pUEvntDat );

	BOOL		ImplDispatchUserEvents( long nWhenInMilliSecs );



	BOOL		ImplIsInSuspendResume() 				{ return mpFirstInstance ? mbInSuspendResume : 0;};

	void		ImplSetInSuspendResume(BOOL nSusRes)	{if(mpFirstInstance)mbInSuspendResume=nSusRes;};

					

};

inline void SetSalData( SalData* pData ) { ImplGetSVData()->mpSalData = (void*)pData; }

inline SalData* GetSalData() { return (SalData*)ImplGetSVData()->mpSalData; }



// SALGDI.CXX

void ImplInitSalGDI();

void ImplFreeSalGDI();

// SALTIMER.CXX

void SalTimerProc( void );



#define SOLID_BRUSH 128



// --------------

// - Prototypes -

// --------------



// \SV\MAC\SOURCE\APP\SALINST.CXX

long GetMilliSecsFromTicks( ULONG nTicksSinceStartUp );



// \SV\WIN\SOURCE\WINDOW\SALFRAME.CXX

void SalTestMouseLeave();



// -----------

// - Defines -

// -----------



#define SAL_MOUSELEAVE_TIMEOUT      300



#define SAL_USER_MSG				1000

// mpEventData == pData

//#define SAL_MSG_USEREVENT mac == SALEVENT_USEREVENT


#define SAL_MSG_MOUSELEAVE          (SAL_USER_MSG+112)





#endif  // _SV_SALDATA_HXX

