/*************************************************************************
 *
 *  $RCSfile: audioconvert.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <vsound.hxx>

using namespace vcl_sal;

#include <sunconvert.cxx>

AudioConverter::~AudioConverter()
{
}

class G721ToULawConverter : public AudioConverter
{
	g72x_state		m_aState;
public:
	G721ToULawConverter();
	virtual ~G721ToULawConverter();

	virtual void reset();
	virtual char* convert( char* In, int nBytesIn, int& nBytesOut );
};

G721ToULawConverter::G721ToULawConverter()
{
	reset();
}

G721ToULawConverter::~G721ToULawConverter()
{
}

void G721ToULawConverter::reset()
{
	g72x_init_state( &m_aState );
}

char* G721ToULawConverter::convert(
	char* pBuffer,
	int nBytesIn,
	int& nBytesOut )
{
	char* pRet = new char[ nBytesOut = nBytesIn*2 ];
	for( int m=0; m < nBytesOut; m++ )
		pRet[ m ] = (g721_decoder(
			m & 1 ? pBuffer[ m/2 ] >> 4 : pBuffer[ m/2 ] & 0x0f,
			AUDIO_ENCODING_ULAW,
			&m_aState ) & 0xff);

	return pRet;
}

AudioConverter* AudioConverter::createG721ToULawConverter()
{
	return new G721ToULawConverter;
}


class INT8ToUINT16Converter : public AudioConverter
{
public:
	INT8ToUINT16Converter() {}
	virtual ~INT8ToUINT16Converter();

	virtual void reset();
	virtual char* convert( char* In, int nBytesIn, int& nBytesOut );
};

INT8ToUINT16Converter::~INT8ToUINT16Converter()
{
}

void INT8ToUINT16Converter::reset()
{
}

char* INT8ToUINT16Converter::convert( char* pBuffer, int nBytesIn, int& nBytesOut )
{
	unsigned short* pShorts = new unsigned short[ nBytesIn ];
	nBytesOut = 2*nBytesIn;

	for( int i=0; i < nBytesIn; i++ )
	{
		signed char cByte = pBuffer[ i ];
		int nValue = cByte;
		nValue += 128;
		pShorts[ i ] = 257*nValue;
	} 
	return (char*)pShorts;
}

AudioConverter* AudioConverter::createINT8ToUINT16Converter()
{
	return new INT8ToUINT16Converter();
}

class SwapINT16Converter : public AudioConverter
{
public:
	SwapINT16Converter() {}
	virtual ~SwapINT16Converter();

	virtual void reset();
	virtual char* convert( char* In, int nBytesIn, int& nBytesOut );
};

SwapINT16Converter::~SwapINT16Converter()
{
}

void SwapINT16Converter::reset()
{
}

char* SwapINT16Converter::convert( char* In, int nBytesIn, int& nBytesOut )
{
	char* pRet = new char[ nBytesOut = nBytesIn ];

	for( int i = 0; i < nBytesIn; i+=2 )
	{
		pRet[ i   ] = In[ i+1 ];
		pRet[ i+1 ] = In[ i ];
	}
	return pRet;
}

AudioConverter* AudioConverter::createSwapINT16Converter()
{
	return new SwapINT16Converter();
}
