/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: registration.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/20 02:07:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <stdio.h>

#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif

#ifndef _CONNECTIVITY_DRIVERMANAGER_HXX_
#include "drivermanager.hxx"
#endif

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::registry;

//==========================================================================
//= registration
//==========================================================================
extern "C"
{

//---------------------------------------------------------------------------------------
	void SAL_CALL component_getImplementationEnvironment(const sal_Char** _ppEnvTypeName, uno_Environment** /*_ppEnv*/)
{
	*_ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

//---------------------------------------------------------------------------------------
sal_Bool SAL_CALL component_writeInfo(void* /*_pServiceManager*/, com::sun::star::registry::XRegistryKey* _pRegistryKey)
{


	sal_Bool bReturn = sal_False;

	try
	{
		::rtl::OUString sMainKeyName = ::rtl::OUString::createFromAscii("/");
		sMainKeyName += ::connectivity::sdbc::OSDBCDriverManager::getImplementationName_Static();
		sMainKeyName += ::rtl::OUString::createFromAscii("/UNO/SERVICES");
		Reference< XRegistryKey > xMainKey = _pRegistryKey->createKey(sMainKeyName);
		if (xMainKey.is())
		{
			Sequence< ::rtl::OUString > sServices(::connectivity::sdbc::OSDBCDriverManager::getSupportedServiceNames_Static());
			const ::rtl::OUString* pBegin = sServices.getConstArray();
			const ::rtl::OUString* pEnd = pBegin + sServices.getLength();
			for (;pBegin != pEnd ; ++pBegin)
				xMainKey->createKey(*pBegin);
			bReturn = sal_True;
		}
	}
	catch(InvalidRegistryException&)
	{
	}
	catch(InvalidValueException&)
	{
	}
	return bReturn;
}

//---------------------------------------------------------------------------------------
void* SAL_CALL component_getFactory(const sal_Char* _pImplName, ::com::sun::star::lang::XMultiServiceFactory* _pServiceManager, void* /*_pRegistryKey*/)
{
	void* pRet = NULL;

	if (::connectivity::sdbc::OSDBCDriverManager::getImplementationName_Static().compareToAscii(_pImplName) == 0)
	{
		Reference< XSingleServiceFactory > xFactory(
			::cppu::createOneInstanceFactory(
				_pServiceManager,
				::connectivity::sdbc::OSDBCDriverManager::getImplementationName_Static(),
				::connectivity::sdbc::OSDBCDriverManager::CreateInstance,
				::connectivity::sdbc::OSDBCDriverManager::getSupportedServiceNames_Static()
			)
		);
		if (xFactory.is())
		{
			xFactory->acquire();
			pRet = xFactory.get();
		}
	}

	return pRet;
}

}	// extern "C"


