/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: cfgservices.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/20 02:48:50 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef CFG_REGHELPER_HXX
#include "cfg_reghelper.hxx"
#endif


/********************************************************************************************/

using namespace ::rtl;
using namespace ::dbacfg;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::registry;

//***************************************************************************************
//
// registry functions
extern "C" void SAL_CALL createRegistryInfo_OCfgImport();

//***************************************************************************************
extern "C" void SAL_CALL createRegistryInfo_dbacfg()
{
	static sal_Bool bInit = sal_False;
	if (!bInit)
	{
		createRegistryInfo_OCfgImport();
		bInit = sal_True;
	}
}

//---------------------------------------------------------------------------------------

extern "C" void SAL_CALL component_getImplementationEnvironment(
				const sal_Char	**ppEnvTypeName,
				uno_Environment	**/*ppEnv*/
			)
{
	createRegistryInfo_dbacfg();
	*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

//---------------------------------------------------------------------------------------
extern "C" sal_Bool SAL_CALL component_writeInfo(
				void* pServiceManager,
				void* pRegistryKey
			)
{
	if (pRegistryKey) 
	try 
	{
		return ::dbacfg::OModuleRegistration::writeComponentInfos(
			static_cast<XMultiServiceFactory*>(pServiceManager),
			static_cast<XRegistryKey*>(pRegistryKey));
	}
	catch (InvalidRegistryException& )
	{
		OSL_ENSURE(sal_False, "DBA::component_writeInfo : could not create a registry key ! ## InvalidRegistryException !");
	}

	return sal_False;
}

//---------------------------------------------------------------------------------------
extern "C" void* SAL_CALL component_getFactory(
					const sal_Char* pImplementationName,
					void* pServiceManager,
					void* /*pRegistryKey*/)
{
	Reference< XInterface > xRet;
	if (pServiceManager && pImplementationName)
	{
		xRet = ::dbacfg::OModuleRegistration::getComponentFactory(
			::rtl::OUString::createFromAscii(pImplementationName),
			static_cast< XMultiServiceFactory* >(pServiceManager));
	}

	if (xRet.is())
		xRet->acquire();
	return xRet.get();
};

