/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fudgrare.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:20:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXDISPATCH_HXX
#include <sfx2/dispatch.hxx>
#endif

#pragma hdrstop

#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

#ifndef _SFXVIEWFRM_HXX
#include <sfx2/viewfrm.hxx>
#endif

#include <svx/svxids.hrc>

#include "app.hrc"
#include "schresid.hxx"
#include "strings.hrc"
#include "viewshel.hxx"
#include "schview.hxx"
#include "chwindow.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif
#include "attrib.hrc"
#include "attrib.hxx"
#include "undgrare.hxx"
#include "fudgrare.hxx"

TYPEINIT1(SchFuDiagramArea, SchFuPoor);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuDiagramArea::SchFuDiagramArea(SchViewShell* pViewSh, SchWindow* pWin,
								   SchView* pView, ChartModel* pDoc,
								   SfxRequest& rReq, Point &rMDPos)
	: SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	aMDPos       = rMDPos;

	const SfxItemSet* pArgs = rReq.GetArgs();

	if (!pArgs)
	{
//      FG: Mit dieser Zeile erhaelt man keinen modalen Dialog => Absturz falls ein Resize im Chart
//      stattfindet waehrend dieser Dialog geoeffnet ist.
//		SchAttribTabDlg* pDlg =	new SchAttribTabDlg(&pViewSh->GetViewFrame()->GetWindow(),
//								                    ATTR_DIAGRAM_AREA, &pDoc->GetDiagramAreaAttr(),
//								                    pDoc->GetObjectShell(), pDoc, 0,
//                                                    pDoc->ChartStyle());
		SchAttribTabDlg* pDlg =	new SchAttribTabDlg(NULL,
													ATTR_DIAGRAM_AREA, &pDoc->GetDiagramAreaAttr(),
													pDoc->GetObjectShell(), pDoc, 0,
													pDoc->ChartStyle());

		if (pDlg->Execute() == RET_OK)
		{
			rReq.Done(*pDlg->GetOutputItemSet());
			pArgs = rReq.GetArgs();
			delete pDlg;
		}
		else
		{
			delete pDlg;
			return;
		}

		pChDoc->CanRebuild (TRUE);
	}
	else pChDoc->CanRebuild (FALSE);

	if( pViewSh )
		pViewSh->GetViewFrame()->GetDispatcher()->Execute(
			SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON );

	SfxItemSet aOldAttr(pDoc->GetDiagramAreaAttr());

	pDoc->ChangeDiagramAreaAttr(*pArgs, NULL);
	SchUndoDiagramArea* pUndo =	new SchUndoDiagramArea(*pDoc, aOldAttr, *pArgs);
	pUndo->SetComment(String(SchResId(STR_UNDO_DIAGRAM_AREA)));
	pViewSh->GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
	RemarkObject ();
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuDiagramArea::Activate()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuDiagramArea::Deactivate()
{
}



