/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dlgcont.cxx,v $
 *
 *  $Revision: 1.16 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/19 22:09:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_INPUTSOURCE_HPP_
#include <com/sun/star/xml/sax/InputSource.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XSIMPLEFILEACCESS_HPP_
#include <com/sun/star/ucb/XSimpleFileAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XEXTENDEDDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XExtendedDocumentHandler.hpp>
#endif

#include "dlgcont.hxx"

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _UTL_STREAM_WRAPPER_HXX_
#include <unotools/streamwrap.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

#include <svtools/pathoptions.hxx>
#include <xmlscript/xmldlg_imexp.hxx>
#include <app.hxx>


using namespace com::sun::star::container;
using namespace com::sun::star::io;
using namespace com::sun::star::uno;
using namespace com::sun::star::ucb;
using namespace com::sun::star::lang;
using namespace com::sun::star::script;
using namespace com::sun::star::xml::sax;
using namespace com::sun::star;
using namespace cppu;
using namespace rtl;
using namespace osl;


//============================================================================
// Implementation class SfxDialogLibraryContainer

sal_Bool SfxDialogLibraryContainer::init
    ( const ::rtl::OUString& aInitialisationParam, const uno::Reference< embed::XStorage >& xStorage )
{
    return SfxLibraryContainer_Impl::init( 
          aInitialisationParam,
          OUString ( RTL_CONSTASCII_USTRINGPARAM("dialog") ),
		  OUString ( RTL_CONSTASCII_USTRINGPARAM("dialogs") ),
		  OUString ( RTL_CONSTASCII_USTRINGPARAM("xdl") ),
		  OUString ( RTL_CONSTASCII_USTRINGPARAM("Dialogs") ),
          xStorage );
}

// Ctor for service
SfxDialogLibraryContainer::SfxDialogLibraryContainer( void )
{
    // all initialisation has to be done
    // by calling XInitialization::initialize
}

SfxDialogLibraryContainer::SfxDialogLibraryContainer( const uno::Reference< embed::XStorage >& xStorage )
{
    OUString aInitialisationParam;
    init( aInitialisationParam, xStorage );
}

// Methods to get library instances of the correct type
SfxLibrary_Impl* SfxDialogLibraryContainer::implCreateLibrary( void )
{
	SfxLibrary_Impl* pRet = (SfxLibrary_Impl*) new SfxDialogLibrary( mxMSF, mxSFI );
	return pRet;
}

SfxLibrary_Impl* SfxDialogLibraryContainer::implCreateLibraryLink
	( const OUString& aLibInfoFileURL, const OUString& StorageURL, sal_Bool ReadOnly )
{
	SfxLibrary_Impl* pRet = 
		(SfxLibrary_Impl*) new SfxDialogLibrary
            ( mxMSF, mxSFI, aLibInfoFileURL, StorageURL, ReadOnly );
	return pRet;
}

Any SAL_CALL SfxDialogLibraryContainer::createEmptyLibraryElement( void )
{
	Reference< XInputStreamProvider > xISP;
	Any aRetAny;
	aRetAny <<= xISP;
	return aRetAny;
}

sal_Bool SAL_CALL SfxDialogLibraryContainer::isLibraryElementValid( Any aElement )
{
	Reference< XInputStreamProvider > xISP;
	aElement >>= xISP;
	sal_Bool bRet = xISP.is();
	return bRet;
}

bool writeOasis2OOoLibraryElement(
	Reference< XInputStream > xInput, Reference< XOutputStream > xOutput )
{
	Reference< XMultiServiceFactory > xMSF(
		comphelper::getProcessServiceFactory() );

    Reference< XComponentContext > xContext;
    Reference< beans::XPropertySet > xProps( xMSF, UNO_QUERY );
    OSL_ASSERT( xProps.is() );
    OSL_VERIFY( xProps->getPropertyValue(
		OUString::createFromAscii(("DefaultContext")) ) >>= xContext );

	Reference< lang::XMultiComponentFactory > xSMgr(
		xContext->getServiceManager() );

	if (! xSMgr.is())
	{
		return FALSE;
	}
	
	Reference< xml::sax::XParser > xParser(
		xSMgr->createInstanceWithContext(
            OUString( RTL_CONSTASCII_USTRINGPARAM(
				"com.sun.star.xml.sax.Parser" ) ),
			xContext ),
		UNO_QUERY );

	Reference< xml::sax::XExtendedDocumentHandler > xWriter(
		xSMgr->createInstanceWithContext(
            OUString( RTL_CONSTASCII_USTRINGPARAM(
				"com.sun.star.xml.sax.Writer" ) ),
			xContext ),
		UNO_QUERY );

	Reference< io::XActiveDataSource > xSource( xWriter, UNO_QUERY );
	xSource->setOutputStream( xOutput );

	if ( !xParser.is() || !xWriter.is() )
	{
		return FALSE;
	}
	
    Sequence<Any> aArgs( 1 );
    aArgs[0] <<= xWriter;

    Reference< xml::sax::XDocumentHandler > xHandler(
        xSMgr->createInstanceWithArgumentsAndContext(
            OUString( RTL_CONSTASCII_USTRINGPARAM(
                "com.sun.star.comp.Oasis2OOoTransformer" ) ),
            aArgs, xContext ),
        UNO_QUERY );

	xParser->setDocumentHandler( xHandler );
	
	xml::sax::InputSource source;
	source.aInputStream = xInput;
	source.sSystemId = OUString::createFromAscii( "virtual file" );
	
	xParser->parseStream( source );

	return TRUE;
}

void SAL_CALL SfxDialogLibraryContainer::writeLibraryElement
( 
	Any aElement,
	const OUString& /*aElementName*/, 
	Reference< XOutputStream > xOutput
)
	throw(Exception)
{
	Reference< XInputStreamProvider > xISP;
	aElement >>= xISP;
	if( !xISP.is() )
		return;

	Reference< XInputStream > xInput( xISP->createInputStream() );

	bool bComplete = FALSE;
	if ( mbOasis2OOoFormat )
	{
		bComplete = writeOasis2OOoLibraryElement( xInput, xOutput );
	}

	if ( bComplete == FALSE )
	{
		Sequence< sal_Int8 > bytes;
		sal_Int32 nRead = xInput->readBytes( bytes, xInput->available() );
		for (;;)
		{
			if( nRead )
				xOutput->writeBytes( bytes );

			nRead = xInput->readBytes( bytes, 1024 );
			if (! nRead)
				break;
		}
	}
	xInput->closeInput();
}

void SfxDialogLibraryContainer::storeLibrariesToStorage( const uno::Reference< embed::XStorage >& xStorage )
{
	mbOasis2OOoFormat = sal_False;

	if ( mxStorage.is() && xStorage.is() )
	{
		try
		{
			long nSource = SotStorage::GetVersion( mxStorage );
			long nTarget = SotStorage::GetVersion( xStorage );

			if ( nSource == SOFFICE_FILEFORMAT_CURRENT &&
				nTarget != SOFFICE_FILEFORMAT_CURRENT )
			{
				mbOasis2OOoFormat = sal_True;
			}
		}
		catch ( Exception& )
		{
			// if we cannot get the version then the
			// Oasis2OOoTransformer will not be used
			OSL_ASSERT(FALSE);
		}
	}

	SfxLibraryContainer_Impl::storeLibrariesToStorage( xStorage );

	mbOasis2OOoFormat = sal_False;
}


Any SAL_CALL SfxDialogLibraryContainer::importLibraryElement
	( const OUString& aFile, const uno::Reference< io::XInputStream >& xElementStream )
{
	Any aRetAny;

	// TODO: Member because later it will be a component
	Reference< XMultiServiceFactory > xMSF( comphelper::getProcessServiceFactory() );
	if( !xMSF.is() )
	{
		OSL_ENSURE( 0, "### couln't get ProcessServiceFactory\n" );
		return aRetAny;
	}

	Reference< XParser > xParser( xMSF->createInstance(
		OUString( RTL_CONSTASCII_USTRINGPARAM("com.sun.star.xml.sax.Parser") ) ), UNO_QUERY );
	if( !xParser.is() )
	{
		OSL_ENSURE( 0, "### couln't create sax parser component\n" );
		return aRetAny;
	}

	Reference< XNameContainer > xDialogModel( xMSF->createInstance
		( OUString(RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.awt.UnoControlDialogModel" ) ) ), UNO_QUERY );
	if( !xDialogModel.is() )
	{
		OSL_ENSURE( 0, "### couln't create com.sun.star.awt.UnoControlDialogModel component\n" );
		return aRetAny;
	}

	// Read from storage?
	sal_Bool bStorage = xElementStream.is();
	Reference< XInputStream > xInput;

	if( bStorage )
	{
		xInput = xElementStream;
	}
	else
	{
		try
		{
			xInput = mxSFI->openFileRead( aFile );
		}
		catch( Exception& )
		//catch( Exception& e )
		{
			// TODO:
			//throw WrappedTargetException( e );
		}
	}
	if( !xInput.is() )
		return aRetAny;

    Reference< XComponentContext > xContext;
    Reference< beans::XPropertySet > xProps( xMSF, UNO_QUERY );
    OSL_ASSERT( xProps.is() );
    OSL_VERIFY( xProps->getPropertyValue( ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("DefaultContext")) ) >>= xContext );

	InputSource source;
	source.aInputStream = xInput;
	source.sSystemId 	= aFile;
	
	// start parsing 
	xParser->setDocumentHandler( ::xmlscript::importDialogModel( xDialogModel, xContext ) );
	xParser->parseStream( source );

	// Create InputStream, TODO: Implement own InputStreamProvider
	// to avoid creating the DialogModel here!
	Reference< XInputStreamProvider > xISP = ::xmlscript::exportDialogModel( xDialogModel, xContext );
	aRetAny <<= xISP;
	return aRetAny;
}

void SAL_CALL SfxDialogLibraryContainer::importFromOldStorage( const ::rtl::OUString& )
{
    // Nothing to do here, old dialogs cannot be imported
}

SfxLibraryContainer_Impl* SfxDialogLibraryContainer::createInstanceImpl( void )
{
    return new SfxDialogLibraryContainer();
}


//============================================================================
// Methods XInitialization
void SAL_CALL SfxDialogLibraryContainer::initialize( const Sequence< Any >& aArguments ) 
    throw (::com::sun::star::uno::Exception, 
           ::com::sun::star::uno::RuntimeException)
{
	sal_Int32 nArgCount = aArguments.getLength();
	OSL_ENSURE( nArgCount, "SfxDialogLibraryContainer::initialize() called with no arguments\n" );

    OUString aInitialisationParam;
    if( nArgCount )
    {
        const Any* pArgs = aArguments.getConstArray();
        pArgs[0] >>= aInitialisationParam;
    	OSL_ENSURE( aInitialisationParam.getLength(), 
            "SfxDialogLibraryContainer::initialize() called with empty url\n" );
    }

    init( aInitialisationParam );
}


//============================================================================
// Service
SFX_IMPL_SINGLEFACTORY( SfxDialogLibraryContainer )

Sequence< OUString > SfxDialogLibraryContainer::impl_getStaticSupportedServiceNames()
{
    static Sequence< OUString > seqServiceNames( 1 );
    static sal_Bool bNeedsInit = sal_True;

	MutexGuard aGuard( Mutex::getGlobalMutex() );
    if( bNeedsInit )
    {
        OUString* pSeq = seqServiceNames.getArray();
        pSeq[0] = OUString::createFromAscii( "com.sun.star.script.DialogLibraryContainer" );
        bNeedsInit = sal_False;
    }
    return seqServiceNames;
}

OUString SfxDialogLibraryContainer::impl_getStaticImplementationName()
{
    static OUString aImplName;
    static sal_Bool bNeedsInit = sal_True;

	MutexGuard aGuard( Mutex::getGlobalMutex() );
    if( bNeedsInit )
    {
        aImplName = OUString::createFromAscii( "com.sun.star.comp.sfx2.DialogLibraryContainer" );
        bNeedsInit = sal_False;
    }
    return aImplName;
}

Reference< XInterface > SAL_CALL SfxDialogLibraryContainer::impl_createInstance
    ( const Reference< XMultiServiceFactory >& ) 
        throw( Exception )
{
    Reference< XInterface > xRet = 
        static_cast< XInterface* >( static_cast< OWeakObject* >(new SfxDialogLibraryContainer()) );
    return xRet;
}


//============================================================================
// Service for application library container
SFX_IMPL_ONEINSTANCEFACTORY( SfxApplicationDialogLibraryContainer )

Sequence< OUString > SfxApplicationDialogLibraryContainer::impl_getStaticSupportedServiceNames()
{
    static Sequence< OUString > seqServiceNames( 1 );
    static sal_Bool bNeedsInit = sal_True;

	MutexGuard aGuard( Mutex::getGlobalMutex() );
    if( bNeedsInit )
    {
        OUString* pSeq = seqServiceNames.getArray();
        pSeq[0] = OUString::createFromAscii( "com.sun.star.script.ApplicationDialogLibraryContainer" );
        bNeedsInit = sal_False;
    }
    return seqServiceNames;
}

OUString SfxApplicationDialogLibraryContainer::impl_getStaticImplementationName()
{
    static OUString aImplName;
    static sal_Bool bNeedsInit = sal_True;

	MutexGuard aGuard( Mutex::getGlobalMutex() );
    if( bNeedsInit )
    {
        aImplName = OUString::createFromAscii( "com.sun.star.comp.sfx2.ApplicationDialogLibraryContainer" );
        bNeedsInit = sal_False;
    }
    return aImplName;
}

Reference< XInterface > SAL_CALL SfxApplicationDialogLibraryContainer::impl_createInstance
    ( const Reference< XMultiServiceFactory >& ) 
        throw( Exception )
{
	SFX_APP()->GetBasicManager();
    Reference< XInterface > xRet = 
        Reference< XInterface >( SFX_APP()->GetDialogContainer(), UNO_QUERY );
    return xRet;
}


//============================================================================
// Implementation class SfxDialogLibrary

// Ctor
SfxDialogLibrary::SfxDialogLibrary( Reference< XMultiServiceFactory > xMSF, 
                                    Reference< XSimpleFileAccess > xSFI )
	: SfxLibrary_Impl( getCppuType( (const Reference< XInputStreamProvider > *)0 ), xMSF, xSFI )
{
}

SfxDialogLibrary::SfxDialogLibrary( Reference< XMultiServiceFactory > xMSF, 
                                    Reference< XSimpleFileAccess > xSFI,
                                    const OUString& aLibInfoFileURL, 
                                    const OUString& aStorageURL, 
                                    sal_Bool ReadOnly )
	: SfxLibrary_Impl( getCppuType( (const Reference< XInputStreamProvider > *)0 ),
                       xMSF, xSFI, aLibInfoFileURL, aStorageURL, ReadOnly)
{
}

//============================================================================

