/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_filtdlg.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:59:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// System - Includes ---------------------------------------------------------

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE -------------------------------------------------------------------
// auto strip #include <rangelst.hxx>
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif

// auto strip #ifndef _SV_WAITOBJ_HXX //autogen
// auto strip #include <vcl/waitobj.hxx>
// auto strip #endif

// auto strip #include "uiitems.hxx"
// auto strip #include "dbcolect.hxx"
// auto strip #include "reffact.hxx"
// auto strip #include "viewdata.hxx"
// auto strip #include "document.hxx"
// auto strip #include "scresid.hxx"

// auto strip #include "foptmgr.hxx"

#include "globstr.hrc"
#include "filter.hrc"

#define _FILTDLG_CXX
// auto strip #include "filtdlg.hxx"
#undef _FILTDLG_CXX

// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
namespace binfilter {

// DEFINE --------------------------------------------------------------------

#define ERRORBOX(rid)	ErrorBox( this, WinBits( WB_OK|WB_DEF_OK), \
				 				  ScGlobal::GetRscString(rid) ).Execute()


//============================================================================
//	class ScFilterDlg

//----------------------------------------------------------------------------

//STRIP001 ScFilterDlg::ScFilterDlg( SfxBindings* pB, SfxChildWindow* pCW, Window* pParent,
//STRIP001 						  const SfxItemSet&	rArgSet )
//STRIP001 
//STRIP001 	:	ScAnyRefDlg	( pB, pCW, pParent, RID_SCDLG_FILTER ),
//STRIP001 		//
//STRIP001 		_INIT_COMMON_FILTER_RSCOBJS
//STRIP001         aFlCriteria     ( this, ScResId( FL_CRITERIA ) ),
//STRIP001 		aFtConnect		( this, ScResId( FT_OP ) ),
//STRIP001 		aFtField		( this, ScResId( FT_FIELD ) ),
//STRIP001 		aFtCond			( this, ScResId( FT_COND ) ),
//STRIP001 		aFtVal			( this, ScResId( FT_VAL ) ),
//STRIP001 		aLbField1		( this, ScResId( LB_FIELD1 ) ),
//STRIP001 		aLbField2		( this, ScResId( LB_FIELD2 ) ),
//STRIP001 		aLbField3		( this, ScResId( LB_FIELD3 ) ),
//STRIP001 		aLbConnect1		( this, ScResId( LB_OP1 ) ),
//STRIP001 		aLbConnect2		( this, ScResId( LB_OP2 ) ),
//STRIP001 		aLbCond1		( this, ScResId( LB_COND1 ) ),
//STRIP001 		aLbCond2		( this, ScResId( LB_COND2 ) ),
//STRIP001 		aLbCond3		( this, ScResId( LB_COND3 ) ),
//STRIP001 		aEdVal1			( this, ScResId( ED_VAL1 ) ),
//STRIP001 		aEdVal2			( this, ScResId( ED_VAL2 ) ),
//STRIP001 		aEdVal3			( this, ScResId( ED_VAL3 ) ),
//STRIP001 		aStrEmpty		( ScResId( SCSTR_EMPTY ) ),
//STRIP001 		aStrNotEmpty	( ScResId( SCSTR_NOTEMPTY ) ),
//STRIP001 		aStrRow			( ScResId( SCSTR_ROW ) ),
//STRIP001 		aStrColumn		( ScResId( SCSTR_COLUMN ) ),
//STRIP001 		//
//STRIP001 		nWhichQuery		( rArgSet.GetPool()->GetWhich( SID_QUERY ) ),
//STRIP001 		theQueryData	( ((const ScQueryItem&)
//STRIP001 						   rArgSet.Get( nWhichQuery )).GetQueryData() ),
//STRIP001 		nFieldCount		( 0 ),
//STRIP001 		pOutItem		( NULL ),
//STRIP001 		pOptionsMgr		( NULL ),
//STRIP001 		pViewData		( NULL ),
//STRIP001 		pDoc			( NULL ),
//STRIP001 		pTimer			( NULL ),
//STRIP001 		bRefInputMode	( FALSE ),
//STRIP001 		nSrcTab			( 0 )
//STRIP001 {
//STRIP001 	for (USHORT i=0; i<=MAXCOL; i++)
//STRIP001 		pEntryLists[i] = NULL;
//STRIP001 
//STRIP001 	Init( rArgSet );
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// Hack: RefInput-Kontrolle
//STRIP001 	pTimer = new Timer;
//STRIP001 	pTimer->SetTimeout( 50 ); // 50ms warten
//STRIP001 	pTimer->SetTimeoutHdl( LINK( this, ScFilterDlg, TimeOutHdl ) );
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 __EXPORT ScFilterDlg::~ScFilterDlg()
//STRIP001 {
//STRIP001 	for (USHORT i=0; i<=MAXCOL; i++)
//STRIP001 		delete pEntryLists[i];
//STRIP001 
//STRIP001 	delete pOptionsMgr;
//STRIP001 	delete pOutItem;
//STRIP001 
//STRIP001 	// Hack: RefInput-Kontrolle
//STRIP001 	pTimer->Stop();
//STRIP001 	delete pTimer;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void __EXPORT ScFilterDlg::Init( const SfxItemSet& rArgSet )
//STRIP001 {
//STRIP001 	const ScQueryItem& rQueryItem = (const ScQueryItem&)
//STRIP001 									rArgSet.Get( nWhichQuery );
//STRIP001 
//STRIP001 	aBtnOk.SetClickHdl		( LINK( this, ScFilterDlg, EndDlgHdl ) );
//STRIP001 	aBtnCancel.SetClickHdl	( LINK( this, ScFilterDlg, EndDlgHdl ) );
//STRIP001 	aBtnMore.SetClickHdl	( LINK( this, ScFilterDlg, MoreClickHdl ) );
//STRIP001 	aBtnHeader.SetClickHdl	( LINK( this, ScFilterDlg, CheckBoxHdl ) );
//STRIP001 	aBtnCase.SetClickHdl	( LINK( this, ScFilterDlg, CheckBoxHdl ) );
//STRIP001 	//
//STRIP001 	aLbField1.SetSelectHdl	( LINK( this, ScFilterDlg, LbSelectHdl ) );
//STRIP001 	aLbField2.SetSelectHdl	( LINK( this, ScFilterDlg, LbSelectHdl ) );
//STRIP001 	aLbField3.SetSelectHdl	( LINK( this, ScFilterDlg, LbSelectHdl ) );
//STRIP001 	aLbConnect1.SetSelectHdl( LINK( this, ScFilterDlg, LbSelectHdl ) );
//STRIP001 	aLbConnect2.SetSelectHdl( LINK( this, ScFilterDlg, LbSelectHdl ) );
//STRIP001 
//STRIP001 	pViewData 	= rQueryItem.GetViewData();
//STRIP001 	pDoc	  	= pViewData ? pViewData->GetDocument() : NULL;
//STRIP001 	nSrcTab		= pViewData ? pViewData->GetTabNo() : NULL;
//STRIP001 
//STRIP001 	// fuer leichteren Zugriff:
//STRIP001 	aFieldLbArr	 [0] = &aLbField1;
//STRIP001 	aFieldLbArr	 [1] = &aLbField2;
//STRIP001 	aFieldLbArr	 [2] = &aLbField3;
//STRIP001 	aValueEdArr	 [0] = &aEdVal1;
//STRIP001 	aValueEdArr	 [1] = &aEdVal2;
//STRIP001 	aValueEdArr	 [2] = &aEdVal3;
//STRIP001 	aCondLbArr	 [0] = &aLbCond1;
//STRIP001 	aCondLbArr	 [1] = &aLbCond2;
//STRIP001 	aCondLbArr 	 [2] = &aLbCond3;
//STRIP001 
//STRIP001 	// Optionen initialisieren lassen:
//STRIP001 
//STRIP001 	pOptionsMgr	 = new ScFilterOptionsMgr(
//STRIP001 							this,
//STRIP001 							pViewData,
//STRIP001 							theQueryData,
//STRIP001 							aBtnMore,
//STRIP001 							aBtnCase,
//STRIP001 							aBtnRegExp,
//STRIP001 							aBtnHeader,
//STRIP001 							aBtnUnique,
//STRIP001 							aBtnCopyResult,
//STRIP001 							aBtnDestPers,
//STRIP001 							aLbCopyArea,
//STRIP001 							aEdCopyArea,
//STRIP001 							aRbCopyArea,
//STRIP001 							aFtDbAreaLabel,
//STRIP001 							aFtDbArea,
//STRIP001                             aFlOptions,
//STRIP001 							aStrNoName,
//STRIP001 							aStrUndefined );
//STRIP001 
//STRIP001 	// Feldlisten einlesen und Eintraege selektieren:
//STRIP001 
//STRIP001 	FillFieldLists();
//STRIP001 
//STRIP001 	for ( USHORT i=0; i<3; i++ )
//STRIP001 	{
//STRIP001 		String	aValStr;
//STRIP001 		USHORT	nCondPos	 = 0;
//STRIP001 		USHORT	nFieldSelPos = 0;
//STRIP001 
//STRIP001 		ScQueryEntry& rEntry = theQueryData.GetEntry(i);
//STRIP001 		if ( rEntry.bDoQuery )
//STRIP001 		{
//STRIP001 			nCondPos	 = (USHORT)rEntry.eOp;
//STRIP001 			nFieldSelPos = GetFieldSelPos( rEntry.nField );
//STRIP001 
//STRIP001 			if ( rEntry.nVal == SC_EMPTYFIELDS && !rEntry.bQueryByString && *rEntry.pStr == EMPTY_STRING )
//STRIP001 			{
//STRIP001 				aValStr = aStrEmpty;
//STRIP001 				aCondLbArr[i]->Disable();
//STRIP001 			}
//STRIP001 			else if ( rEntry.nVal == SC_NONEMPTYFIELDS && !rEntry.bQueryByString && *rEntry.pStr == EMPTY_STRING )
//STRIP001 			{
//STRIP001 				aValStr = aStrNotEmpty;
//STRIP001 				aCondLbArr[i]->Disable();
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aValStr = *rEntry.pStr;
//STRIP001 		}
//STRIP001 		else if ( i == 0 )
//STRIP001 			nFieldSelPos = GetFieldSelPos( pViewData->GetCurX() );
//STRIP001 
//STRIP001 		aFieldLbArr[i]->SelectEntryPos( nFieldSelPos );
//STRIP001 		aCondLbArr [i]->SelectEntryPos( nCondPos );
//STRIP001 		aValueEdArr[i]->SetText( aValStr );
//STRIP001 		aValueEdArr[i]->SetModifyHdl( LINK( this, ScFilterDlg, ValModifyHdl ) );
//STRIP001 		UpdateValueList( i+1 );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Disable/Enable Logik:
//STRIP001 
//STRIP001 	   (aLbField1.GetSelectEntryPos() != 0)
//STRIP001 	&& (aLbField2.GetSelectEntryPos() != 0)
//STRIP001 		? aLbConnect1.SelectEntryPos( (USHORT)theQueryData.GetEntry(1).eConnect )
//STRIP001 		: aLbConnect1.SetNoSelection();
//STRIP001 
//STRIP001 	   (aLbField2.GetSelectEntryPos() != 0)
//STRIP001 	&& (aLbField3.GetSelectEntryPos() != 0)
//STRIP001 		? aLbConnect2.SelectEntryPos( (USHORT)theQueryData.GetEntry(2).eConnect )
//STRIP001 		: aLbConnect2.SetNoSelection();
//STRIP001 
//STRIP001 	if ( aLbField1.GetSelectEntryPos() == 0 )
//STRIP001 	{
//STRIP001 		aLbConnect1.Disable();
//STRIP001 		aLbField2.Disable();
//STRIP001 		aLbCond2.Disable();
//STRIP001 		aEdVal2.Disable();
//STRIP001 	}
//STRIP001 	else if ( aLbConnect1.GetSelectEntryCount() == 0 )
//STRIP001 	{
//STRIP001 		aLbField2.Disable();
//STRIP001 		aLbCond2.Disable();
//STRIP001 		aEdVal2.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aLbField2.GetSelectEntryPos() == 0 )
//STRIP001 	{
//STRIP001 		aLbConnect2.Disable();
//STRIP001 		aLbField3.Disable();
//STRIP001 		aLbCond3.Disable();
//STRIP001 		aEdVal3.Disable();
//STRIP001 	}
//STRIP001 	else if ( aLbConnect2.GetSelectEntryCount() == 0 )
//STRIP001 	{
//STRIP001 		aLbField3.Disable();
//STRIP001 		aLbCond3.Disable();
//STRIP001 		aEdVal3.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if(pDoc!=NULL &&
//STRIP001 		pDoc->GetChangeTrack()!=NULL) aBtnCopyResult.Disable();
//STRIP001 	// Modal-Modus einschalten
//STRIP001 //	SetDispatcherLock( TRUE );
//STRIP001 	//@BugID 54702 Enablen/Disablen nur noch in Basisklasse
//STRIP001 //	SFX_APPWINDOW->Disable(FALSE);		//! allgemeine Methode im ScAnyRefDlg
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScFilterDlg::Close()
//STRIP001 {
//STRIP001 	return DoClose( ScFilterDlgWrapper::GetChildWindowId() );
//STRIP001 }


//----------------------------------------------------------------------------
// Uebergabe eines mit der Maus selektierten Tabellenbereiches, der dann als
// neue Selektion im Referenz-Edit angezeigt wird.

//STRIP001 void ScFilterDlg::SetReference( const ScRange& rRef, ScDocument* pDoc )
//STRIP001 {
//STRIP001 	if ( bRefInputMode )	// Nur moeglich, wenn im Referenz-Editmodus
//STRIP001 	{
//STRIP001 		if ( rRef.aStart != rRef.aEnd )
//STRIP001 			RefInputStart( &aEdCopyArea );
//STRIP001 		String aRefStr;
//STRIP001 		rRef.aStart.Format( aRefStr, SCA_ABS_3D, pDoc );
//STRIP001 		aEdCopyArea.SetRefString( aRefStr );
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScFilterDlg::SetActive()
//STRIP001 {
//STRIP001 	if ( bRefInputMode )
//STRIP001 	{
//STRIP001 		aEdCopyArea.GrabFocus();
//STRIP001 		if ( aEdCopyArea.GetModifyHdl().IsSet() )
//STRIP001 			((Link&)aEdCopyArea.GetModifyHdl()).Call( &aEdCopyArea );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		GrabFocus();
//STRIP001 
//STRIP001 	RefInputDone();
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScFilterDlg::FillFieldLists()
//STRIP001 {
//STRIP001 	aLbField1.Clear();
//STRIP001 	aLbField2.Clear();
//STRIP001 	aLbField3.Clear();
//STRIP001 	aLbField1.InsertEntry( aStrNone, 0 );
//STRIP001 	aLbField2.InsertEntry( aStrNone, 0 );
//STRIP001 	aLbField3.InsertEntry( aStrNone, 0 );
//STRIP001 
//STRIP001 	if ( pDoc )
//STRIP001 	{
//STRIP001 		String	aFieldName;
//STRIP001 		USHORT	nTab		= nSrcTab;
//STRIP001 		USHORT	nFirstCol	= theQueryData.nCol1;
//STRIP001 		USHORT	nFirstRow	= theQueryData.nRow1;
//STRIP001 		USHORT	nMaxCol		= theQueryData.nCol2;
//STRIP001 		USHORT	col = 0;
//STRIP001 		USHORT	i=1;
//STRIP001 
//STRIP001 		for ( col=nFirstCol; col<=nMaxCol; col++ )
//STRIP001 		{
//STRIP001 			pDoc->GetString( col, nFirstRow, nTab, aFieldName );
//STRIP001 			if ( !aBtnHeader.IsChecked() || (aFieldName.Len() == 0) )
//STRIP001 			{
//STRIP001 				aFieldName  = aStrColumn;
//STRIP001 				aFieldName += ' ';
//STRIP001 				if ( col < 26 )
//STRIP001 					aFieldName += (sal_Unicode)( 'A' + col );
//STRIP001 				else
//STRIP001 				{
//STRIP001 					aFieldName += (sal_Unicode)( 'A' + ( col / 26 ) - 1 );
//STRIP001 					aFieldName += (sal_Unicode)( 'A' + ( col % 26 ) );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			aLbField1.InsertEntry( aFieldName, i );
//STRIP001 			aLbField2.InsertEntry( aFieldName, i );
//STRIP001 			aLbField3.InsertEntry( aFieldName, i );
//STRIP001 			i++;
//STRIP001 		}
//STRIP001 		nFieldCount = i;
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 void ScFilterDlg::UpdateValueList( USHORT nList )
//STRIP001 {
//STRIP001 	if ( pDoc && nList>0 && nList<=3 )
//STRIP001 	{
//STRIP001 		::com::boBox*	pValList		= aValueEdArr[nList-1];
//STRIP001 		USHORT		nFieldSelPos	= aFieldLbArr[nList-1]->GetSelectEntryPos();
//STRIP001 		USHORT		nListPos		= 0;
//STRIP001 		String		aCurValue  		= pValList->GetText();
//STRIP001 
//STRIP001 		pValList->Clear();
//STRIP001 		pValList->InsertEntry( aStrNotEmpty, 0 );
//STRIP001 		pValList->InsertEntry( aStrEmpty, 1 );
//STRIP001 		nListPos = 2;
//STRIP001 
//STRIP001 		if ( nFieldSelPos )
//STRIP001 		{
//STRIP001 			WaitObject aWaiter( this );		// auch wenn nur die ListBox gefuellt wird
//STRIP001 
//STRIP001 			USHORT nColumn = theQueryData.nCol1 + nFieldSelPos - 1;
//STRIP001 			if (!pEntryLists[nColumn])
//STRIP001 			{
//STRIP001 				USHORT nTab		 = nSrcTab;
//STRIP001 				USHORT nFirstRow = theQueryData.nRow1;
//STRIP001 				USHORT nLastRow	 = theQueryData.nRow2;
//STRIP001 
//STRIP001 				//	erstmal ohne die erste Zeile
//STRIP001 
//STRIP001 				pEntryLists[nColumn] = new TypedStrCollection( 128, 128 );
//STRIP001 				pEntryLists[nColumn]->SetCaseSensitive( aBtnCase.IsChecked() );
//STRIP001 				pDoc->GetFilterEntriesArea( nColumn, nFirstRow+1, nLastRow,
//STRIP001 											nTab, *pEntryLists[nColumn] );
//STRIP001 
//STRIP001 				//	Eintrag fuer die erste Zeile
//STRIP001 				//!	Eintrag (pHdrEntry) ohne Collection erzeugen?
//STRIP001 
//STRIP001 				nHeaderPos[nColumn] = USHRT_MAX;
//STRIP001 				TypedStrCollection aHdrColl( 1, 1 );
//STRIP001 				pDoc->GetFilterEntriesArea( nColumn, nFirstRow, nFirstRow,
//STRIP001 											nTab, aHdrColl );
//STRIP001 				TypedStrData* pHdrEntry = aHdrColl[0];
//STRIP001 				if ( pHdrEntry )
//STRIP001 				{
//STRIP001 					TypedStrData* pNewEntry = new TypedStrData(*pHdrEntry);
//STRIP001 					if ( pEntryLists[nColumn]->Insert( pNewEntry ) )
//STRIP001 					{
//STRIP001 						nHeaderPos[nColumn] = pEntryLists[nColumn]->IndexOf( pNewEntry );
//STRIP001 						DBG_ASSERT( nHeaderPos[nColumn] != USHRT_MAX,
//STRIP001 									"Header-Eintrag nicht wiedergefunden" );
//STRIP001 					}
//STRIP001 					else
//STRIP001 						delete pNewEntry;			// war schon drin
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			TypedStrCollection* pColl = pEntryLists[nColumn];
//STRIP001 			USHORT nValueCount = pColl->GetCount();
//STRIP001 			if ( nValueCount > 0 )
//STRIP001 			{
//STRIP001 				for ( USHORT i=0; i<nValueCount; i++ )
//STRIP001 				{
//STRIP001 					pValList->InsertEntry( (*pColl)[i]->GetString(), nListPos );
//STRIP001 					nListPos++;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		pValList->SetText( aCurValue );
//STRIP001 	}
//STRIP001 
//STRIP001 	UpdateHdrInValueList( nList );
//STRIP001 }

//STRIP001 void ScFilterDlg::UpdateHdrInValueList( USHORT nList )
//STRIP001 {
//STRIP001 	//!	GetText / SetText ??
//STRIP001 
//STRIP001 	if ( pDoc && nList>0 && nList<=3 )
//STRIP001 	{
//STRIP001 		USHORT nFieldSelPos = aFieldLbArr[nList-1]->GetSelectEntryPos();
//STRIP001 		if ( nFieldSelPos )
//STRIP001 		{
//STRIP001 			USHORT nColumn = theQueryData.nCol1 + nFieldSelPos - 1;
//STRIP001 			if ( pEntryLists[nColumn] )
//STRIP001 			{
//STRIP001 				USHORT nPos = nHeaderPos[nColumn];
//STRIP001 				if ( nPos != USHRT_MAX )
//STRIP001 				{
//STRIP001 					::com::boBox* pValList = aValueEdArr[nList-1];
//STRIP001 					USHORT nListPos = nPos + 2;					// nach "leer" und "nicht leer"
//STRIP001 
//STRIP001 					TypedStrData* pHdrEntry = (*pEntryLists[nColumn])[nPos];
//STRIP001 					if ( pHdrEntry )
//STRIP001 					{
//STRIP001 						String aHdrStr = pHdrEntry->GetString();
//STRIP001 						BOOL bWasThere = ( pValList->GetEntry(nListPos) == aHdrStr );
//STRIP001 						BOOL bInclude = !aBtnHeader.IsChecked();
//STRIP001 
//STRIP001 						if (bInclude)			// Eintrag aufnehmen
//STRIP001 						{
//STRIP001 							if (!bWasThere)
//STRIP001 								pValList->InsertEntry(aHdrStr, nListPos);
//STRIP001 						}
//STRIP001 						else					// Eintrag weglassen
//STRIP001 						{
//STRIP001 							if (bWasThere)
//STRIP001 								pValList->RemoveEntry(nListPos);
//STRIP001 						}
//STRIP001 					}
//STRIP001 					else
//STRIP001 						DBG_ERROR("Eintag in Liste nicht gefunden");
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 				DBG_ERROR("Spalte noch nicht initialisiert");
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 void ScFilterDlg::ClearValueList( USHORT nList )
//STRIP001 {
//STRIP001 	if ( nList>0 && nList<=3 )
//STRIP001 	{
//STRIP001 		::com::boBox* pValList = aValueEdArr[nList-1];
//STRIP001 		pValList->Clear();
//STRIP001 		pValList->InsertEntry( aStrNotEmpty, 0 );
//STRIP001 		pValList->InsertEntry( aStrEmpty, 1 );
//STRIP001 		pValList->SetText( EMPTY_STRING );
//STRIP001 	}
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 USHORT ScFilterDlg::GetFieldSelPos( USHORT nField )
//STRIP001 {
//STRIP001 	if ( nField >= theQueryData.nCol1 && nField <= theQueryData.nCol2 )
//STRIP001 		return nField - theQueryData.nCol1 + 1;
//STRIP001 	else
//STRIP001 		return 0;
//STRIP001 }

//----------------------------------------------------------------------------

//STRIP001 ScQueryItem* ScFilterDlg::GetOutputItem()
//STRIP001 {
//STRIP001 	ScAddress		theCopyPos;
//STRIP001 	ScQueryParam 	theParam( theQueryData );
//STRIP001 	USHORT			nConnect1 = aLbConnect1.GetSelectEntryPos();
//STRIP001 	USHORT 			nConnect2 = aLbConnect2.GetSelectEntryPos();
//STRIP001 	BOOL			bCopyPosOk;
//STRIP001 
//STRIP001 	if ( aBtnCopyResult.IsChecked() )
//STRIP001 	{
//STRIP001 		String theCopyStr( aEdCopyArea.GetText() );
//STRIP001 		xub_StrLen nColonPos = theCopyStr.Search( ':' );
//STRIP001 
//STRIP001 		if ( STRING_NOTFOUND != nColonPos )
//STRIP001 			theCopyStr.Erase( nColonPos );
//STRIP001 
//STRIP001 		USHORT nResult = theCopyPos.Parse( theCopyStr, pDoc );
//STRIP001 		bCopyPosOk = ( SCA_VALID == (nResult & SCA_VALID) );
//STRIP001 	}
//STRIP001 
//STRIP001 	for ( USHORT i=0; i<3; i++ )
//STRIP001 	{
//STRIP001 		USHORT 		nField	= aFieldLbArr[i]->GetSelectEntryPos();
//STRIP001 		ScQueryOp	eOp		= (ScQueryOp)aCondLbArr[i]->GetSelectEntryPos();
//STRIP001 
//STRIP001 		BOOL bDoThis = (aFieldLbArr[i]->GetSelectEntryPos() != 0);
//STRIP001 		theParam.GetEntry(i).bDoQuery = bDoThis;
//STRIP001 
//STRIP001 		if ( bDoThis )
//STRIP001 		{
//STRIP001 			ScQueryEntry& rEntry = theParam.GetEntry(i);
//STRIP001 
//STRIP001 			String aStrVal( aValueEdArr[i]->GetText() );
//STRIP001 
//STRIP001 			/*
//STRIP001 			 * Dialog liefert die ausgezeichneten Feldwerte "leer"/"nicht leer"
//STRIP001 			 * als Konstanten in nVal in Verbindung mit dem Schalter
//STRIP001 			 * bQueryByString auf FALSE.
//STRIP001 			 */
//STRIP001 			if ( aStrVal == aStrEmpty )
//STRIP001 			{
//STRIP001 				rEntry.pStr->Erase();
//STRIP001 				rEntry.nVal = SC_EMPTYFIELDS;
//STRIP001 				rEntry.bQueryByString = FALSE;
//STRIP001 			}
//STRIP001 			else if ( aStrVal == aStrNotEmpty )
//STRIP001 			{
//STRIP001 				rEntry.pStr->Erase();
//STRIP001 				rEntry.nVal = SC_NONEMPTYFIELDS;
//STRIP001 				rEntry.bQueryByString = FALSE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				*rEntry.pStr		  = aStrVal;
//STRIP001 				rEntry.nVal			  = 0;
//STRIP001 				rEntry.bQueryByString = TRUE;
//STRIP001 			}
//STRIP001 
//STRIP001 			rEntry.nField = nField ? ( theQueryData.nCol1 + nField - 1 ) : 0;
//STRIP001 			rEntry.eOp	  = eOp;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	theParam.GetEntry(1).eConnect = (nConnect1 != LISTBOX_ENTRY_NOTFOUND)
//STRIP001 									? (ScQueryConnect)nConnect1
//STRIP001 									: SC_AND;
//STRIP001 	theParam.GetEntry(2).eConnect = (nConnect2 != LISTBOX_ENTRY_NOTFOUND)
//STRIP001 									? (ScQueryConnect)nConnect2
//STRIP001 									: SC_AND;
//STRIP001 
//STRIP001 	if ( aBtnCopyResult.IsChecked() && bCopyPosOk )
//STRIP001 	{
//STRIP001 		theParam.bInplace   = FALSE;
//STRIP001 		theParam.nDestTab	= theCopyPos.Tab();
//STRIP001 		theParam.nDestCol	= theCopyPos.Col();
//STRIP001 		theParam.nDestRow	= theCopyPos.Row();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		theParam.bInplace   = TRUE;
//STRIP001 		theParam.nDestTab	= 0;
//STRIP001 		theParam.nDestCol	= 0;
//STRIP001 		theParam.nDestRow	= 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	theParam.bHasHeader		= aBtnHeader.IsChecked();
//STRIP001 	theParam.bByRow			= TRUE;
//STRIP001 	theParam.bDuplicate		= !aBtnUnique.IsChecked();
//STRIP001 	theParam.bCaseSens 		= aBtnCase.IsChecked();
//STRIP001 	theParam.bRegExp		= aBtnRegExp.IsChecked();
//STRIP001 	theParam.bDestPers		= aBtnDestPers.IsChecked();
//STRIP001 
//STRIP001 	//	nur die drei eingestellten - alles andere zuruecksetzen
//STRIP001 
//STRIP001 	USHORT nEC = theParam.GetEntryCount();
//STRIP001 	for (i=3; i<nEC; i++)								// alles ueber 3
//STRIP001 		theParam.GetEntry(i).bDoQuery = FALSE;			// zuruecksetzen
//STRIP001 
//STRIP001 	DELETEZ( pOutItem );
//STRIP001 	pOutItem = new ScQueryItem( nWhichQuery, &theParam );
//STRIP001 
//STRIP001 	return pOutItem;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 BOOL ScFilterDlg::IsRefInputMode() const
//STRIP001 {
//STRIP001 	return bRefInputMode;
//STRIP001 }


//----------------------------------------------------------------------------
// Handler:
// ========

//STRIP001 IMPL_LINK( ScFilterDlg, EndDlgHdl, Button*, pBtn )
//STRIP001 {
//STRIP001 	if ( pBtn == &aBtnOk )
//STRIP001 	{
//STRIP001 		BOOL bAreaInputOk = TRUE;
//STRIP001 
//STRIP001 		if ( aBtnCopyResult.IsChecked() )
//STRIP001 		{
//STRIP001 			if ( !pOptionsMgr->VerifyPosStr( aEdCopyArea.GetText() ) )
//STRIP001 			{
//STRIP001 				if ( !aBtnMore.GetState() )
//STRIP001 					aBtnMore.SetState( TRUE );
//STRIP001 
//STRIP001 				ERRORBOX( STR_INVALID_TABREF );
//STRIP001 				aEdCopyArea.GrabFocus();
//STRIP001 				bAreaInputOk = FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( bAreaInputOk )
//STRIP001 		{
//STRIP001 			SetDispatcherLock( FALSE );
//STRIP001 			SwitchToDocument();
//STRIP001 			GetBindings().GetDispatcher()->Execute( FID_FILTER_OK,
//STRIP001 									  SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD,
//STRIP001 									  GetOutputItem(), 0L, 0L );
//STRIP001 			Close();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( pBtn == &aBtnCancel )
//STRIP001 	{
//STRIP001 		Close();
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScFilterDlg, MoreClickHdl, MoreButton*, pBtn )
//STRIP001 {
//STRIP001 	if ( aBtnMore.GetState() )
//STRIP001 		pTimer->Start();
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pTimer->Stop();
//STRIP001 		bRefInputMode = FALSE;
//STRIP001 		//@BugID 54702 Enablen/Disablen nur noch in Basisklasse
//STRIP001 		//SFX_APPWINDOW->Disable(FALSE);		//! allgemeine Methode im ScAnyRefDlg
//STRIP001 	}
//STRIP001 	return NULL;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScFilterDlg, TimeOutHdl, Timer*, _pTimer )
//STRIP001 {
//STRIP001     // alle 50ms nachschauen, ob RefInputMode noch stimmt
//STRIP001 
//STRIP001     if( _pTimer == pTimer && IsActive() )
//STRIP001         bRefInputMode = (aEdCopyArea.HasFocus() || aRbCopyArea.HasFocus());
//STRIP001 
//STRIP001     if ( aBtnMore.GetState() )
//STRIP001         pTimer->Start();
//STRIP001 
//STRIP001     return NULL;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScFilterDlg, LbSelectHdl, ListBox*, pLb )
//STRIP001 {
//STRIP001 	/*
//STRIP001 	 * Behandlung der Enable/Disable-Logik,
//STRIP001 	 * abhaengig davon, welche ListBox angefasst wurde:
//STRIP001 	 */
//STRIP001 
//STRIP001 	if ( pLb == &aLbConnect1 )
//STRIP001 	{
//STRIP001 		if ( !aLbField2.IsEnabled() )
//STRIP001 		{
//STRIP001 			aLbField2.Enable();
//STRIP001 			aLbCond2.Enable();
//STRIP001 			aEdVal2.Enable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( pLb == &aLbConnect2 )
//STRIP001 	{
//STRIP001 		if ( !aLbField3.IsEnabled() )
//STRIP001 		{
//STRIP001 			aLbField3.Enable();
//STRIP001 			aLbCond3.Enable();
//STRIP001 			aEdVal3.Enable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( pLb == &aLbField1 )
//STRIP001 	{
//STRIP001 		if ( aLbField1.GetSelectEntryPos() == 0 )
//STRIP001 		{
//STRIP001 			aLbConnect1.SetNoSelection();
//STRIP001 			aLbConnect2.SetNoSelection();
//STRIP001 			aLbField2.SelectEntryPos( 0 );
//STRIP001 			aLbField3.SelectEntryPos( 0 );
//STRIP001 			aLbCond2.SelectEntryPos( 0 );
//STRIP001 			aLbCond3.SelectEntryPos( 0 );
//STRIP001 			ClearValueList( 1 );
//STRIP001 			ClearValueList( 2 );
//STRIP001 			ClearValueList( 3 );
//STRIP001 
//STRIP001 			aLbConnect1.Disable();
//STRIP001 			aLbConnect2.Disable();
//STRIP001 			aLbField2.Disable();
//STRIP001 			aLbField3.Disable();
//STRIP001 			aLbCond2.Disable();
//STRIP001 			aLbCond3.Disable();
//STRIP001 			aEdVal2.Disable();
//STRIP001 			aEdVal3.Disable();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			UpdateValueList( 1 );
//STRIP001 			if ( !aLbConnect1.IsEnabled() )
//STRIP001 			{
//STRIP001 				aLbConnect1.Enable();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( pLb == &aLbField2 )
//STRIP001 	{
//STRIP001 		if ( aLbField2.GetSelectEntryPos() == 0 )
//STRIP001 		{
//STRIP001             aLbConnect2.SetNoSelection();
//STRIP001 			aLbField3.SelectEntryPos( 0 );
//STRIP001 			aLbCond3.SelectEntryPos( 0 );
//STRIP001 			ClearValueList( 2 );
//STRIP001 			ClearValueList( 3 );
//STRIP001 
//STRIP001 			aLbConnect2.Disable();
//STRIP001 			aLbField3.Disable();
//STRIP001 			aLbCond3.Disable();
//STRIP001 			aEdVal3.Disable();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			UpdateValueList( 2 );
//STRIP001 			if ( !aLbConnect2.IsEnabled() )
//STRIP001 			{
//STRIP001 				aLbConnect2.Enable();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( pLb == &aLbField3 )
//STRIP001 	{
//STRIP001 		( aLbField3.GetSelectEntryPos() == 0 )
//STRIP001 			? ClearValueList( 3 )
//STRIP001 			: UpdateValueList( 3 );
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScFilterDlg, CheckBoxHdl, CheckBox*, pBox )
//STRIP001 {
//STRIP001 	//	Spaltenkoepfe:
//STRIP001 	//		FeldListen: Spaltexx <-> Spaltenkopf-String
//STRIP001 	//		WertListen: Spaltenkopf-Wert entfaellt.
//STRIP001 	//	Gross-/Kleinschreibung:
//STRIP001 	//		WertListen: komplett neu
//STRIP001 
//STRIP001 	if ( pBox == &aBtnHeader )				// Feldlisten und Wertlisten
//STRIP001 	{
//STRIP001 		USHORT nCurSel1 = aLbField1.GetSelectEntryPos();
//STRIP001 		USHORT nCurSel2 = aLbField2.GetSelectEntryPos();
//STRIP001 		USHORT nCurSel3 = aLbField3.GetSelectEntryPos();
//STRIP001 		FillFieldLists();
//STRIP001 		aLbField1.SelectEntryPos( nCurSel1 );
//STRIP001 		aLbField2.SelectEntryPos( nCurSel2 );
//STRIP001 		aLbField3.SelectEntryPos( nCurSel3 );
//STRIP001 
//STRIP001 		UpdateHdrInValueList( 1 );
//STRIP001 		UpdateHdrInValueList( 2 );
//STRIP001 		UpdateHdrInValueList( 3 );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pBox == &aBtnCase )			// Wertlisten komplett
//STRIP001 	{
//STRIP001 		for (USHORT i=0; i<=MAXCOL; i++)
//STRIP001 			DELETEZ( pEntryLists[i] );
//STRIP001 
//STRIP001 		UpdateValueList( 1 );		// aktueller Text wird gemerkt
//STRIP001 		UpdateValueList( 2 );
//STRIP001 		UpdateValueList( 3 );
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }


//----------------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScFilterDlg, ValModifyHdl, ComboBox*, pEd )
//STRIP001 {
//STRIP001 	if ( pEd )
//STRIP001 	{
//STRIP001 		String aStrVal	= pEd->GetText();
//STRIP001 		ListBox* pLb	= &aLbCond1;
//STRIP001 
//STRIP001 			 if ( pEd == &aEdVal2 ) pLb = &aLbCond2;
//STRIP001 		else if ( pEd == &aEdVal3 )	pLb = &aLbCond3;
//STRIP001 
//STRIP001 		// wenn einer der Sonderwerte leer/nicht-leer
//STRIP001 		// gewaehlt wird, so macht nur der =-Operator Sinn:
//STRIP001 
//STRIP001 		if ( aStrEmpty == aStrVal || aStrNotEmpty == aStrVal )
//STRIP001 		{
//STRIP001 			pLb->SelectEntry( '=' );
//STRIP001 			pLb->Disable();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pLb->Enable();
//STRIP001 	}
//STRIP001 
//STRIP001 	return NULL;
//STRIP001 }


}
