/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_styfitem.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:03:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------

#pragma hdrstop

#include "styfitem.hxx"

#ifndef _SVTOOLS_LOCALRESACCESS_HXX_
#include <svtools/localresaccess.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX 
#include <tools/debug.hxx>
#endif
namespace binfilter {

// -----------------------------------------------------------------------

class SfxStyleFamilyItem_Impl
{
	Bitmap aBitmap;
	Image   aImage;
};

// -----------------------------------------------------------------------

// Implementierung des Resource-Konstruktors

/*N*/ SfxStyleFamilyItem::SfxStyleFamilyItem( const ResId &rResId ) :
/*N*/ 
/*N*/ 	Resource( rResId.SetRT( RSC_SFX_STYLE_FAMILY_ITEM ) )
/*N*/ 
/*N*/ {
/*N*/ 	USHORT nMask = (USHORT) ReadShortRes();
/*N*/ 
/*N*/ 	if(nMask & RSC_SFX_STYLE_ITEM_LIST)
/*N*/ 	{
/*N*/ 		USHORT nCount = (USHORT) ReadShortRes();
/*N*/ 		for( USHORT i = 0; i < nCount; i++ )
/*N*/ 		{
/*N*/ 			SfxFilterTupel *pTupel = new SfxFilterTupel;
/*N*/ 			pTupel->aName = ReadStringRes();
/*N*/ 			long lFlags = ReadLongRes();
/*N*/ 			pTupel->nFlags = (USHORT)lFlags;
/*N*/ 			aFilterList.Insert(pTupel, LIST_APPEND);
/*N*/ 		}
/*N*/ 	}
/*N*/ 	if(nMask & RSC_SFX_STYLE_ITEM_BITMAP)
/*N*/ 	{
/*?*/ 		aBitmap = Bitmap(ResId((RSHEADER_TYPE *)GetClassRes()));
/*?*/ 		IncrementRes( GetObjSizeRes( (RSHEADER_TYPE *)GetClassRes() ) );
/*N*/ 	}
/*N*/ 	if(nMask & RSC_SFX_STYLE_ITEM_TEXT)
/*N*/ 	{
/*N*/ 		aText = ReadStringRes();
/*N*/ 	}
/*N*/ 	if(nMask & RSC_SFX_STYLE_ITEM_HELPTEXT)
/*N*/ 	{
/*?*/ 		aHelpText = ReadStringRes();
/*N*/ 	}
/*N*/ 	if(nMask & RSC_SFX_STYLE_ITEM_STYLEFAMILY)
/*N*/ 	{
/*N*/ 		nFamily = (USHORT)ReadShortRes();
/*N*/ 	}
/*N*/ 	else
/*N*/ 		nFamily = SFX_STYLE_FAMILY_PARA;
/*N*/ 	if(nMask & RSC_SFX_STYLE_ITEM_IMAGE)
/*N*/ 	{
/*?*/ 		aImage = Image(ResId((RSHEADER_TYPE *)GetClassRes()));
/*?*/ 		IncrementRes( GetObjSizeRes( (RSHEADER_TYPE *)GetClassRes() ) );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		aImage = Image(aBitmap);
/*N*/ }

// -----------------------------------------------------------------------

// Destruktor; gibt interne Daten frei

/*N*/ SfxStyleFamilyItem::~SfxStyleFamilyItem()
/*N*/ {
/*N*/ 	SfxFilterTupel *pTupel = aFilterList.First();
/*N*/ 	while(pTupel)
/*N*/ 	{
/*N*/ 		delete pTupel;
/*N*/ 		pTupel = aFilterList.Next();
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------

// Implementierung des Resource-Konstruktors

/*N*/ SfxStyleFamilies::SfxStyleFamilies( const ResId& rResId ) :
/*N*/ 
/*N*/ 	Resource( rResId.SetRT( RSC_SFX_STYLE_FAMILIES ).SetAutoRelease( FALSE ) ),
/*N*/ 	aEntryList( 4, 1 )
/*N*/ {
/*N*/ 	USHORT nCount = (USHORT)ReadShortRes();
/*N*/ 	for( USHORT i = 0; i < nCount; i++ )
/*N*/ 	{
/*N*/ 		const ResId aResId((RSHEADER_TYPE *)GetClassRes());
/*N*/ 		SfxStyleFamilyItem *pItem = new SfxStyleFamilyItem(aResId);
/*N*/ 		IncrementRes( GetObjSizeRes( (RSHEADER_TYPE *)GetClassRes() ) );
/*N*/ 		aEntryList.Insert(pItem, LIST_APPEND);
/*N*/ 	}
/*N*/ 
/*N*/ 	FreeResource();
/*N*/ 
/*N*/ 	updateImages( rResId, BMP_COLOR_NORMAL );
/*N*/ }

// -----------------------------------------------------------------------

// Destruktor; gibt interne Daten frei

/*N*/ SfxStyleFamilies::~SfxStyleFamilies()
/*N*/ {
/*N*/ 	SfxStyleFamilyItem *pItem = aEntryList.First();
/*N*/ 
/*N*/ 	while(pItem)
/*N*/ 	{
/*N*/ 		delete pItem;
/*N*/ 		pItem = aEntryList.Next();
/*N*/ 	}
/*N*/ }


// -----------------------------------------------------------------------

/*N*/ sal_Bool SfxStyleFamilies::updateImages( const ResId& _rId, const BmpColorMode _eMode )
/*N*/ {
/*N*/ 	sal_Bool bSuccess = sal_False;
/*N*/ 
/*N*/ 	{
/*N*/ 		::svt::OLocalResourceAccess aLocalRes( _rId );
/*N*/ 
/*N*/ 		// check if the image list is present
/*N*/ 		ResId aImageListId( (sal_uInt16)_eMode + 1 );
/*N*/ 		aImageListId.SetRT( RSC_IMAGELIST );
/*N*/ 
/*N*/ 		if ( aLocalRes.IsAvailableRes( aImageListId ) )
/*N*/ 		{	// there is such a list
/*N*/ 			ImageList aImages( aImageListId );
/*N*/ 
/*N*/ 			// number of styles items/images
/*N*/ 			sal_uInt16 nCount = aImages.GetImageCount( );
/*N*/ 			DBG_ASSERT( Count() == nCount, "SfxStyleFamilies::updateImages: found the image list, but missing some bitmaps!" );
/*N*/ 			if ( nCount > Count() )
/*?*/ 				nCount = Count();
/*N*/ 
/*N*/ 			// set the images on the items
/*N*/ 			for ( sal_uInt16 i = 0; i < nCount; ++i )
/*N*/ 			{
/*N*/ 				SfxStyleFamilyItem* pItem = static_cast< SfxStyleFamilyItem* >( aEntryList.GetObject( i ) );
/*N*/ 				pItem->SetImage( aImages.GetImage( aImages.GetImageId( i ) ) );
/*N*/ 			}
/*N*/ 
/*N*/ 			bSuccess = sal_True;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	return bSuccess;
/*N*/ }
}
