/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_galctrl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:55:15 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #include <vcl/svapp.hxx>
#include "helpid.hrc"
// auto strip #include "galbrws2.hxx"
// auto strip #include "galtheme.hxx"
// auto strip #include "galmisc.hxx"
// auto strip #include "galctrl.hxx"

#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

// auto strip #include "AccessibleStringWrap.hxx"
// auto strip #include "svxfont.hxx"
namespace binfilter {

// -----------
// - Defines -
// -----------

#define GALLERY_BRWBOX_TITLE    1
#define GALLERY_BRWBOX_PATH     2

// ------------------
// - GalleryPreview -
// ------------------

//STRIP001 GalleryPreview::GalleryPreview( GalleryBrowser2* pParent, GalleryTheme* pTheme ) :
//STRIP001 	Window( pParent, WB_TABSTOP | WB_BORDER ),
//STRIP001 	DropTargetHelper( this ),
//STRIP001     DragSourceHelper( this ),
//STRIP001     mpTheme( pTheme )
//STRIP001 {
//STRIP001 	SetHelpId( HID_GALLERY_WINDOW );
//STRIP001     InitSettings();
//STRIP001 	aSound.SetNotifyHdl( LINK( this, GalleryPreview, SoundEndHdl ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryPreview::GalleryPreview( Window* pParent, const ResId & rResId  ) :
//STRIP001 	Window( pParent, rResId ),
//STRIP001 	DropTargetHelper( this ),
//STRIP001     DragSourceHelper( this ),
//STRIP001     mpTheme( NULL )
//STRIP001 {
//STRIP001 	SetHelpId( HID_GALLERY_PREVIEW );
//STRIP001     InitSettings();
//STRIP001     aSound.SetNotifyHdl( LINK( this, GalleryPreview, SoundEndHdl ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryPreview::~GalleryPreview()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryPreview::InitSettings()
//STRIP001 {
//STRIP001 	SetBackground( Wallpaper( GALLERY_BG_COLOR ) );
//STRIP001 	SetControlBackground( GALLERY_BG_COLOR );
//STRIP001 	SetControlForeground( GALLERY_FG_COLOR );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryPreview::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 		InitSettings();
//STRIP001 	else
//STRIP001 		Window::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryPreview::ImplGetGraphicCenterRect( const Graphic& rGraphic, Rectangle& rResultRect ) const
//STRIP001 {
//STRIP001 	const Size	aWinSize( GetOutputSizePixel() );
//STRIP001 	Size		aNewSize( LogicToPixel( rGraphic.GetPrefSize(), rGraphic.GetPrefMapMode() ) );
//STRIP001 	BOOL		bRet = FALSE;
//STRIP001 
//STRIP001 	if( aNewSize.Width() && aNewSize.Height() )
//STRIP001 	{
//STRIP001 		// scale to fit window
//STRIP001 		const double fGrfWH = (double) aNewSize.Width() / aNewSize.Height();
//STRIP001 		const double fWinWH = (double) aWinSize.Width() / aWinSize.Height();
//STRIP001 
//STRIP001 		if ( fGrfWH < fWinWH )
//STRIP001 		{
//STRIP001 			aNewSize.Width() = (long) ( aWinSize.Height() * fGrfWH );
//STRIP001 			aNewSize.Height()= aWinSize.Height();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aNewSize.Width() = aWinSize.Width();
//STRIP001 			aNewSize.Height()= (long) ( aWinSize.Width() / fGrfWH);
//STRIP001 		}
//STRIP001 
//STRIP001 		const Point aNewPos( ( aWinSize.Width()  - aNewSize.Width() ) >> 1,
//STRIP001 							 ( aWinSize.Height() - aNewSize.Height() ) >> 1 );
//STRIP001 
//STRIP001 		rResultRect = Rectangle( aNewPos, aNewSize );
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryPreview::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	Window::Paint( rRect );
//STRIP001 
//STRIP001 	if( ImplGetGraphicCenterRect( aGraphicObj.GetGraphic(), aPreviewRect ) )
//STRIP001 	{
//STRIP001 		const Point aPos( aPreviewRect.TopLeft() );
//STRIP001 		const Size	aSize( aPreviewRect.GetSize() );
//STRIP001 
//STRIP001 		if( aGraphicObj.IsAnimated() )
//STRIP001 			aGraphicObj.StartAnimation( this, aPos, aSize );
//STRIP001 		else
//STRIP001 			aGraphicObj.Draw( this, aPos, aSize );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryPreview::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     if( mpTheme && ( rMEvt.GetClicks() == 2 ) )
//STRIP001         ( (GalleryBrowser2*) GetParent() )->TogglePreview( this );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryPreview::Command(const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	Window::Command( rCEvt );
//STRIP001 
//STRIP001     if( mpTheme && ( rCEvt.GetCommand() == COMMAND_CONTEXTMENU ) )
//STRIP001         ( (GalleryBrowser2*) GetParent() )->ShowContextMenu( this, 
//STRIP001 			( rCEvt.IsMouseEvent() ? &rCEvt.GetMousePosPixel() : NULL ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryPreview::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     if( mpTheme )
//STRIP001     {
//STRIP001         GalleryBrowser2* pBrowser = static_cast< GalleryBrowser2* >( GetParent() );
//STRIP001 
//STRIP001         switch( rKEvt.GetKeyCode().GetCode() )
//STRIP001         {
//STRIP001             case( KEY_BACKSPACE ):
//STRIP001                 pBrowser->TogglePreview( this );
//STRIP001             break;
//STRIP001                 
//STRIP001             case( KEY_HOME ):
//STRIP001                 pBrowser->Travel( GALLERYBROWSERTRAVEL_FIRST );
//STRIP001             break;
//STRIP001 
//STRIP001             case( KEY_END ):
//STRIP001                 pBrowser->Travel( GALLERYBROWSERTRAVEL_LAST );
//STRIP001             break;
//STRIP001 
//STRIP001             case( KEY_LEFT ):
//STRIP001             case( KEY_UP ):
//STRIP001                 pBrowser->Travel( GALLERYBROWSERTRAVEL_PREVIOUS );
//STRIP001             break;
//STRIP001 
//STRIP001             case( KEY_RIGHT ):
//STRIP001             case( KEY_DOWN ):
//STRIP001                 pBrowser->Travel( GALLERYBROWSERTRAVEL_NEXT );
//STRIP001             break;
//STRIP001 
//STRIP001             default:
//STRIP001             {
//STRIP001                 if( !pBrowser->KeyInput( rKEvt, this ) )
//STRIP001                     Window::KeyInput( rKEvt );
//STRIP001             }
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001     else
//STRIP001         Window::KeyInput( rKEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Int8 GalleryPreview::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001     sal_Int8 nRet;
//STRIP001 
//STRIP001     if( mpTheme )
//STRIP001         nRet = ( (GalleryBrowser2*) GetParent() )->AcceptDrop( *this, rEvt );
//STRIP001     else
//STRIP001         nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001     return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Int8 GalleryPreview::ExecuteDrop( const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001     sal_Int8 nRet;
//STRIP001 
//STRIP001     if( mpTheme )
//STRIP001         nRet = ( (GalleryBrowser2*) GetParent() )->ExecuteDrop( *this, rEvt );
//STRIP001     else
//STRIP001         nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001     return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryPreview::StartDrag( sal_Int8 nAction, const Point& rPosPixel )
//STRIP001 {
//STRIP001     if( mpTheme )
//STRIP001         ( (GalleryBrowser2*) GetParent() )->StartDrag( this );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryPreview::PreviewSound( const INetURLObject& rURL )
//STRIP001 {
//STRIP001 	aSound.Stop();
//STRIP001     aSound.SetSoundName( rURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 	if( rURL.GetProtocol() != INET_PROT_NOT_VALID )
//STRIP001 		aSound.Play();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( GalleryPreview, SoundEndHdl, Sound*, pSound )
//STRIP001 {
//STRIP001 	aSound.SetSoundName( String() );
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------
//STRIP001 // - GalleryIconView -
//STRIP001 // -------------------
//STRIP001 
//STRIP001 GalleryIconView::GalleryIconView( GalleryBrowser2* pParent, GalleryTheme* pTheme ) :
//STRIP001 		ValueSet( pParent, WB_TABSTOP | WB_3DLOOK | WB_BORDER | WB_ITEMBORDER | WB_DOUBLEBORDER | WB_VSCROLL | WB_FLATVALUESET ),
//STRIP001 		DropTargetHelper( this ),
//STRIP001         DragSourceHelper( this ),
//STRIP001 		mpTheme	( pTheme )
//STRIP001 {
//STRIP001 	EnableFullItemMode( FALSE );
//STRIP001 
//STRIP001 	SetHelpId( HID_GALLERY_WINDOW );
//STRIP001     InitSettings();
//STRIP001 	SetExtraSpacing( 2 );
//STRIP001 	SetItemWidth( S_THUMB + 6 );
//STRIP001 	SetItemHeight( S_THUMB + 6 );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryIconView::~GalleryIconView()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryIconView::InitSettings()
//STRIP001 {
//STRIP001 	SetBackground( Wallpaper( GALLERY_BG_COLOR ) );
//STRIP001 	SetControlBackground( GALLERY_BG_COLOR );
//STRIP001 	SetControlForeground( GALLERY_FG_COLOR );
//STRIP001 	SetColor( GALLERY_BG_COLOR );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryIconView::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 		InitSettings();
//STRIP001 	else
//STRIP001 		ValueSet::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryIconView::UserDraw( const UserDrawEvent& rUDEvt )
//STRIP001 {
//STRIP001 	const USHORT nId = rUDEvt.GetItemId();
//STRIP001 
//STRIP001 	if( nId && mpTheme )
//STRIP001 	{
//STRIP001 		SgaObject* pObj = mpTheme->AcquireObject( nId - 1 );
//STRIP001 
//STRIP001 		if( pObj )
//STRIP001 		{
//STRIP001 			const Rectangle&	rRect = rUDEvt.GetRect();
//STRIP001 			OutputDevice*		pDev = rUDEvt.GetDevice();
//STRIP001 			Graphic 			aGraphic;
//STRIP001 
//STRIP001 			if( pObj->IsThumbBitmap() )
//STRIP001 			{
//STRIP001 				Bitmap aBmp( pObj->GetThumbBmp() );
//STRIP001 
//STRIP001 				if( pObj->GetObjKind() == SGA_OBJ_SOUND )
//STRIP001 					aBmp.Replace( COL_LIGHTMAGENTA, COL_WHITE );
//STRIP001 
//STRIP001 				if( ( pDev->GetBitCount() <= 8 ) && ( aBmp.GetBitCount() >= 8 ) )
//STRIP001 					aBmp.Dither( BMP_DITHER_FLOYD );
//STRIP001 
//STRIP001 				aGraphic = aBmp;
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aGraphic = pObj->GetThumbMtf();
//STRIP001 
//STRIP001 			Size aSize( aGraphic.GetSizePixel( pDev ) );
//STRIP001 
//STRIP001 			if ( aSize.Width() && aSize.Height() )
//STRIP001 			{
//STRIP001 				if( ( aSize.Width() > rRect.GetWidth() ) || ( aSize.Height() > rRect.GetHeight() ) )
//STRIP001 				{
//STRIP001 					Point			aNewPos;
//STRIP001 					const double	fBmpWH	= (double) aSize.Width() / aSize.Height();
//STRIP001 					const double	fThmpWH = (double) rRect.GetWidth() / rRect.GetHeight();
//STRIP001 
//STRIP001 					// Bitmap an Thumbgroesse anpassen
//STRIP001 					if ( fBmpWH < fThmpWH )
//STRIP001 					{
//STRIP001 						aSize.Width() = (long) ( rRect.GetHeight() * fBmpWH );
//STRIP001 						aSize.Height()= rRect.GetHeight();
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						aSize.Width() = rRect.GetWidth();
//STRIP001 						aSize.Height()= (long) ( rRect.GetWidth() / fBmpWH );
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				const Point aPos( ( ( rRect.GetWidth() - aSize.Width() ) >> 1 ) + rRect.Left(),
//STRIP001 								  ( ( rRect.GetHeight() - aSize.Height() ) >> 1 ) + rRect.Top() );
//STRIP001 
//STRIP001 				aGraphic.Draw( pDev, aPos, aSize );
//STRIP001 			}
//STRIP001 
//STRIP001 			SetItemText( nId, GalleryBrowser2::GetItemText( *mpTheme, *pObj, GALLERY_ITEM_THEMENAME | GALLERY_ITEM_TITLE | GALLERY_ITEM_PATH ) );
//STRIP001 			mpTheme->ReleaseObject( pObj );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryIconView::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001     ValueSet::MouseButtonDown( rMEvt );
//STRIP001 
//STRIP001     if( rMEvt.GetClicks() == 2 )
//STRIP001         ( (GalleryBrowser2*) GetParent() )->TogglePreview( this, &rMEvt.GetPosPixel() );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryIconView::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	ValueSet::Command( rCEvt );
//STRIP001 
//STRIP001     if( rCEvt.GetCommand() == COMMAND_CONTEXTMENU )
//STRIP001 	{
//STRIP001         ( (GalleryBrowser2*) GetParent() )->ShowContextMenu( this, 
//STRIP001 			( rCEvt.IsMouseEvent() ? &rCEvt.GetMousePosPixel() : NULL ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryIconView::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     if( !mpTheme || !static_cast< GalleryBrowser2* >( GetParent() )->KeyInput( rKEvt, this ) )
//STRIP001         ValueSet::KeyInput( rKEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Int8 GalleryIconView::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001 	return( static_cast< GalleryBrowser2* >( GetParent() )->AcceptDrop( *this, rEvt ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Int8 GalleryIconView::ExecuteDrop( const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001 	return(	static_cast< GalleryBrowser2* >( GetParent() )->ExecuteDrop( *this, rEvt ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryIconView::StartDrag( sal_Int8 nAction, const Point& rPosPixel )
//STRIP001 {
//STRIP001 	const CommandEvent	aEvt( GetPointerPosPixel(), COMMAND_STARTDRAG, TRUE );
//STRIP001 	Region				aRegion;
//STRIP001 
//STRIP001 	// call this to initiate dragging for ValueSet
//STRIP001     ValueSet::StartDrag( aEvt, aRegion );
//STRIP001     static_cast< GalleryBrowser2* >( GetParent() )->StartDrag( this );
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------
//STRIP001 // - GalleryListView -
//STRIP001 // -------------------
//STRIP001 
//STRIP001 GalleryListView::GalleryListView( GalleryBrowser2* pParent, GalleryTheme* pTheme ) :
//STRIP001     BrowseBox( pParent, WB_TABSTOP | WB_3DLOOK | WB_BORDER ),
//STRIP001     mpTheme( pTheme ),
//STRIP001     mnCurRow( 0 ),
//STRIP001     mbInit( FALSE )
//STRIP001 {
//STRIP001 	SetHelpId( HID_GALLERY_WINDOW );
//STRIP001 
//STRIP001     InitSettings();
//STRIP001 
//STRIP001     SetMode( BROWSER_AUTO_VSCROLL | BROWSER_AUTOSIZE_LASTCOL );
//STRIP001     SetDataRowHeight( 28 );
//STRIP001 	InsertDataColumn( GALLERY_BRWBOX_TITLE, String( GAL_RESID( RID_SVXSTR_GALLERY_TITLE ) ), 256  );
//STRIP001 	InsertDataColumn( GALLERY_BRWBOX_PATH, String( GAL_RESID( RID_SVXSTR_GALLERY_PATH ) ), 256 );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryListView::~GalleryListView()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryListView::InitSettings()
//STRIP001 {
//STRIP001 	SetBackground( Wallpaper( GALLERY_BG_COLOR ) );
//STRIP001 	SetControlBackground( GALLERY_BG_COLOR );
//STRIP001 	SetControlForeground( GALLERY_FG_COLOR );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryListView::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 		InitSettings();
//STRIP001 	else
//STRIP001 		BrowseBox::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryListView::SeekRow( long nRow )
//STRIP001 {
//STRIP001     mnCurRow = nRow;
//STRIP001     return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 String GalleryListView::GetCellText(long _nRow, USHORT nColumnId) const
//STRIP001 {
//STRIP001 	String sRet;
//STRIP001 	if( mpTheme && ( _nRow < static_cast< long >( mpTheme->GetObjectCount() ) ) )
//STRIP001 	{
//STRIP001     	SgaObject* pObj = mpTheme->AcquireObject( _nRow );
//STRIP001 
//STRIP001 		if( pObj )
//STRIP001 		{
//STRIP001 			sRet = GalleryBrowser2::GetItemText( *mpTheme, *pObj, 
//STRIP001 				( GALLERY_BRWBOX_TITLE == nColumnId ) ? GALLERY_ITEM_TITLE : GALLERY_ITEM_PATH );
//STRIP001 
//STRIP001 		    mpTheme->ReleaseObject( pObj );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return sRet;;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 Rectangle GalleryListView::GetFieldCharacterBounds(sal_Int32 _nRow,sal_Int32 _nColumnPos,sal_Int32 nIndex)
//STRIP001 {
//STRIP001     DBG_ASSERT(_nColumnPos >= 0 && _nColumnPos <= USHRT_MAX, "GalleryListView::GetFieldCharacterBounds: _nColumnId overflow");
//STRIP001 	Rectangle aRect;
//STRIP001 	if ( SeekRow(_nRow) )
//STRIP001 	{
//STRIP001         SvxFont aFont( GetFont() );
//STRIP001         AccessibleStringWrap aStringWrap( *this, aFont, GetCellText(_nRow, static_cast<USHORT>( GetColumnId( _nColumnPos ) ) ) );
//STRIP001         
//STRIP001         // get the bounds inside the string
//STRIP001         aStringWrap.GetCharacterBounds(nIndex, aRect);
//STRIP001 
//STRIP001         // offset to 
//STRIP001 	}
//STRIP001 	return aRect;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Int32 GalleryListView::GetFieldIndexAtPoint(sal_Int32 _nRow,sal_Int32 _nColumnPos,const Point& _rPoint)
//STRIP001 {
//STRIP001     DBG_ASSERT(_nColumnPos >= 0 && _nColumnPos <= USHRT_MAX, "GalleryListView::GetFieldIndexAtPoint: _nColumnId overflow");
//STRIP001 	sal_Int32 nRet = -1;
//STRIP001 	if ( SeekRow(_nRow) )
//STRIP001 	{
//STRIP001         SvxFont aFont( GetFont() );
//STRIP001         AccessibleStringWrap aStringWrap( *this, aFont, GetCellText(_nRow, static_cast<USHORT>(GetColumnId(_nColumnPos))) );
//STRIP001         nRet = aStringWrap.GetIndexAtPoint(_rPoint);
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryListView::PaintField( OutputDevice& rDev, const Rectangle& rRect, USHORT nColumnId ) const
//STRIP001 {
//STRIP001     rDev.Push( PUSH_CLIPREGION );
//STRIP001     rDev.IntersectClipRegion( rRect );
//STRIP001 
//STRIP001 	if( mpTheme && ( mnCurRow < mpTheme->GetObjectCount() ) )
//STRIP001 	{
//STRIP001     	SgaObject* pObj = mpTheme->AcquireObject( mnCurRow );
//STRIP001 
//STRIP001 		if( pObj )
//STRIP001 		{
//STRIP001             const long nTextPosY = rRect.Top() + ( ( rRect.GetHeight() - rDev.GetTextHeight() ) >> 1 );
//STRIP001 
//STRIP001             if( GALLERY_BRWBOX_TITLE == nColumnId )
//STRIP001             {
//STRIP001                 Rectangle       aOutputRect( rRect.TopLeft(), Size( rRect.GetHeight(), rRect.GetHeight() ) );
//STRIP001     			GraphicObject   aGrfObj;
//STRIP001 
//STRIP001                 if( pObj->GetObjKind() == SGA_OBJ_SOUND )
//STRIP001                     aGrfObj = Graphic( Bitmap( GAL_RESID( RID_SVXBMP_GALLERY_SOUND ) ) );
//STRIP001                 else if( pObj->IsThumbBitmap() )
//STRIP001 				    aGrfObj = Graphic( pObj->GetThumbBmp() );
//STRIP001 			    else
//STRIP001 				    aGrfObj = Graphic( pObj->GetThumbMtf() );
//STRIP001 
//STRIP001 			    Size aSize( rDev.LogicToPixel( aGrfObj.GetPrefSize(), aGrfObj.GetPrefMapMode() ) );
//STRIP001 
//STRIP001 			    if( aSize.Width() && aSize.Height() )
//STRIP001 			    {
//STRIP001 				    if( ( aSize.Width() > aOutputRect.GetWidth() ) || ( aSize.Height() > aOutputRect.GetHeight() ) )
//STRIP001 				    {
//STRIP001 					    Point			aNewPos;
//STRIP001 					    const double	fBmpWH	= (double) aSize.Width() / aSize.Height();
//STRIP001 					    const double	fThmpWH = (double) aOutputRect.GetWidth() / aOutputRect.GetHeight();
//STRIP001 
//STRIP001 					    // Bitmap an Thumbgroesse anpassen
//STRIP001 					    if ( fBmpWH < fThmpWH )
//STRIP001 					    {
//STRIP001 						    aSize.Width() = (long) ( aOutputRect.GetHeight() * fBmpWH );
//STRIP001 						    aSize.Height()= aOutputRect.GetHeight();
//STRIP001 					    }
//STRIP001 					    else
//STRIP001 					    {
//STRIP001 						    aSize.Width() = aOutputRect.GetWidth();
//STRIP001 						    aSize.Height()= (long) ( aOutputRect.GetWidth() / fBmpWH );
//STRIP001 					    }
//STRIP001 				    }
//STRIP001 
//STRIP001                     aSize.Width() = Max( aSize.Width(), 4L );
//STRIP001                     aSize.Height() = Max( aSize.Height(), 4L );
//STRIP001 
//STRIP001 				    const Point aPos( ( ( aOutputRect.GetWidth() - aSize.Width() ) >> 1 ) + aOutputRect.Left(),
//STRIP001 								      ( ( aOutputRect.GetHeight() - aSize.Height() ) >> 1 ) + aOutputRect.Top() );
//STRIP001 
//STRIP001 				    aGrfObj.Draw( &rDev, aPos, aSize );
//STRIP001 			    }
//STRIP001 
//STRIP001 			    rDev.DrawText( Point( aOutputRect.Right() + 6, nTextPosY ), GalleryBrowser2::GetItemText( *mpTheme, *pObj, GALLERY_ITEM_TITLE ) );
//STRIP001             }
//STRIP001             else if( GALLERY_BRWBOX_PATH == nColumnId )
//STRIP001                 rDev.DrawText( Point( rRect.Left(), nTextPosY ), GalleryBrowser2::GetItemText( *mpTheme, *pObj, GALLERY_ITEM_PATH ) );
//STRIP001 
//STRIP001 		    mpTheme->ReleaseObject( pObj );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     rDev.Pop();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryListView::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	BrowseBox::Command( rCEvt );
//STRIP001 
//STRIP001     if( rCEvt.GetCommand() == COMMAND_CONTEXTMENU )
//STRIP001 	{
//STRIP001 		const Point* pPos = NULL;
//STRIP001 
//STRIP001 		if( rCEvt.IsMouseEvent() && ( GetRowAtYPosPixel( rCEvt.GetMousePosPixel().Y() ) != BROWSER_ENDOFSELECTION ) )
//STRIP001 			pPos = &rCEvt.GetMousePosPixel();
//STRIP001 		
//STRIP001 		( (GalleryBrowser2*) GetParent() )->ShowContextMenu( this, pPos );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryListView::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     if( !mpTheme || !static_cast< GalleryBrowser2* >( GetParent() )->KeyInput( rKEvt, this ) )
//STRIP001         BrowseBox::KeyInput( rKEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryListView::DoubleClick( const BrowserMouseEvent& rEvt )
//STRIP001 {
//STRIP001     BrowseBox::DoubleClick( rEvt );
//STRIP001 
//STRIP001     if( rEvt.GetRow() != BROWSER_ENDOFSELECTION )
//STRIP001         ( (GalleryBrowser2*) GetParent() )->TogglePreview( this, &rEvt.GetPosPixel() );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryListView::Select()
//STRIP001 {
//STRIP001     if( maSelectHdl.IsSet() )
//STRIP001         maSelectHdl.Call( this );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Int8 GalleryListView::AcceptDrop( const BrowserAcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001     sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001    	if( mpTheme && !mpTheme->IsReadOnly() && !mpTheme ->IsImported() )
//STRIP001 	{
//STRIP001 		if( !mpTheme->IsDragging() )
//STRIP001 			nRet = DND_ACTION_COPY;
//STRIP001 		else
//STRIP001 			nRet = DND_ACTION_COPY;
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Int8 GalleryListView::ExecuteDrop( const BrowserExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001     ExecuteDropEvent aEvt( rEvt );
//STRIP001 
//STRIP001     aEvt.maPosPixel.Y() += GetTitleHeight();
//STRIP001     
//STRIP001     return(	( (GalleryBrowser2*) GetParent() )->ExecuteDrop( *this, aEvt ) );
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryListView::StartDrag( sal_Int8 nAction, const Point& rPosPixel )
//STRIP001 {
//STRIP001     ( (GalleryBrowser2*) GetParent() )->StartDrag( this, &rPosPixel );
//STRIP001 }
}
