/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_optspell.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:40:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// include ---------------------------------------------------------------

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_TYPE_HXX_
#include <com/sun/star/uno/Type.hxx>
#endif

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif

#ifndef _UNO_LINGU_HXX
#include <unolingu.hxx>
#endif
#ifndef _SVX_DLGUTIL_HXX
#include <dlgutil.hxx>
#endif

#ifndef _SFX_SFXUNO_HXX
#include <bf_sfx2/sfxuno.hxx>
#endif
#ifndef _LINGUISTIC_LNGPROPS_HHX_
#include <bf_linguistic/lngprops.hxx>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_DICTIONARYLISTEVENTFLAGS_HPP_
#include <com/sun/star/linguistic2/DictionaryListEventFlags.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_DICTIONARYLISTEVENT_HPP_
#include <com/sun/star/linguistic2/DictionaryListEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XDICTIONARYLISTEVENTLISTENER_HPP_
#include <com/sun/star/linguistic2/XDictionaryListEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XDICTIONARYLIST_HPP_
#include <com/sun/star/linguistic2/XDictionaryList.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XSTORABLE_HPP_
#include <com/sun/star/frame/XStorable.hpp>
#endif

#define _SVX_OPTSPELL_CXX

#include "optspell.hrc"
#include "dialogs.hrc"

#define _SVSTDARR_STRINGSDTOR
#include <svtools/svstdarr.hxx>
#define ITEMID_SPELLCHECK	0

#include "optdict.hxx"
#include "optitems.hxx"
#include "optspell.hxx"
#include "dialmgr.hxx"
namespace binfilter {

using namespace osl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::frame;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::linguistic2;

//STRIP001 #define C2U(cChar)  ::rtl::OUString::createFromAscii(cChar)
// static ----------------------------------------------------------------

//STRIP001 static const USHORT nNameLen = 8;

//STRIP001 static USHORT pRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_SPELL,
//STRIP001 	SID_ATTR_SPELL,
//STRIP001 	0
//STRIP001 };

//STRIP001 static Any lcl_Bool2Any(BOOL bVal)
//STRIP001 {
//STRIP001     Any aRet(&bVal, ::getBooleanCppuType());
//STRIP001     return aRet;
//STRIP001 }

//STRIP001 static sal_Bool lcl_Any2Bool(Any& rVal)
//STRIP001 {
//STRIP001     return *(sal_Bool*)rVal.getValue();
//STRIP001 }

// class SfxSpellTabPage -------------------------------------------------

//STRIP001 SfxSpellTabPage::SfxSpellTabPage( Window* pParent,
//STRIP001 								  const SfxItemSet& rSet ):
//STRIP001 
//STRIP001 	SfxTabPage( pParent, ResId( RID_SFXPAGE_SPELL, DIALOG_MGR() ), rSet ),
//STRIP001 
//STRIP001 	aBookBtn	( this, ResId( BTN_BOOK ) ),
//STRIP001 	aBookLB		( this, ResId( LB_BOOK ) ),
//STRIP001 	aBookBox	( this, ResId( GB_BOOK ) ),
//STRIP001 	aCapsBtn	( this, ResId( BTN_CAPS ) ),
//STRIP001 	aNumBtn		( this, ResId( BTN_NUMS ) ),
//STRIP001 	aUpLowBtn	( this, ResId( BTN_UPLOW ) ),
//STRIP001 	aAuditBox	( this, ResId( GB_AUDIT ) )
//STRIP001 {
//STRIP001 	uno::Reference< XDictionaryList > xDicList( SvxGetDictionaryList() );
//STRIP001 	if (xDicList.is())
//STRIP001 		aDics = xDicList->getDictionaries();
//STRIP001 	const SfxSpellCheckItem* pItem = 0;
//STRIP001 	SfxItemState eItemState = SFX_ITEM_UNKNOWN;
//STRIP001 
//STRIP001 	eItemState = rSet.GetItemState( GetWhich( SID_ATTR_SPELL ),
//STRIP001 									FALSE, (const SfxPoolItem**)&pItem );
//STRIP001 
//STRIP001 	// handelt es sich um ein Default-Item?
//STRIP001 	if ( eItemState == SFX_ITEM_DEFAULT )
//STRIP001 		pItem = (const SfxSpellCheckItem*)&(rSet.Get( GetWhich( SID_ATTR_SPELL ) ) );
//STRIP001 	else if ( eItemState == SFX_ITEM_DONTCARE )
//STRIP001 		pItem = NULL;
//STRIP001 
//STRIP001 	aBookBtn.SetClickHdl( LINK( this, SfxSpellTabPage, BookHdl ) );
//STRIP001 
//STRIP001 	// disable controls that can't be used due to missing services
//STRIP001 	if (!SvxGetLinguPropertySet().is())
//STRIP001 		Enable( FALSE );	// disable everything
//STRIP001 	else if (!xDicList.is())
//STRIP001 	{   // disable dictionary and dictionary list controls
//STRIP001 		aBookBtn.Enable( FALSE );
//STRIP001 		aBookLB .Enable( FALSE );
//STRIP001 		aBookBox.Enable( FALSE );
//STRIP001 	}
//STRIP001 	FreeResource();
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 USHORT* SfxSpellTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return pRanges;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 SfxTabPage* SfxSpellTabPage::Create( Window* pParent,
//STRIP001 									 const SfxItemSet& rAttrSet )
//STRIP001 {
//STRIP001 	return ( new SfxSpellTabPage( pParent, rAttrSet ) );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 BOOL SfxSpellTabPage::FillItemSet( SfxItemSet& rCoreSet )
//STRIP001 {
//STRIP001 	BOOL bModified = TRUE; // !!!!
//STRIP001 
//STRIP001 	uno::Reference< XDictionaryList > xDicList( SvxGetDictionaryList() );
//STRIP001 
//STRIP001 	// Dictionaries verwalten
//STRIP001 	const USHORT nCount = aDics.getLength();
//STRIP001 	const uno::Reference< XDictionary > *pDic = aDics.getConstArray();
//STRIP001 	const USHORT nSize  = aBookLB.GetSelectEntryCount();
//STRIP001 	//
//STRIP001 	BOOL bIsAnyPosDicActive = FALSE;
//STRIP001 	for ( USHORT j=0; j < nCount; ++j )
//STRIP001 	{
//STRIP001 		uno::Reference< XDictionary1 > xDic( pDic[j], UNO_QUERY);
//STRIP001 		if (!xDic.is())
//STRIP001 			continue;
//STRIP001 
//STRIP001 		BOOL bNegativ = xDic->getDictionaryType() == DictionaryType_NEGATIVE;
//STRIP001 		const String aName( ::GetDicInfoStr( xDic->getName(),
//STRIP001 											 xDic->getLanguage(),
//STRIP001 											 bNegativ ) );
//STRIP001 
//STRIP001 		BOOL bActivate = FALSE;
//STRIP001 		for ( USHORT i=0; i < nSize; ++i )
//STRIP001 		{   // Dictionary in der SSelection -> Aktivieren
//STRIP001 			if ( aName == aBookLB.GetSelectEntry(i) )
//STRIP001 			{
//STRIP001 				// any dictionary is persistent not readonly and may hold
//STRIP001 				// positive entries?
//STRIP001 				uno::Reference< XStorable > xStor( xDic, UNO_QUERY );
//STRIP001 				if (xStor.is() && xStor->hasLocation() && !xStor->isReadonly())
//STRIP001 					bIsAnyPosDicActive =
//STRIP001 							xDic->getDictionaryType() != DictionaryType_NEGATIVE;
//STRIP001 
//STRIP001 				bActivate = TRUE;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		xDic->setActive( bActivate );
//STRIP001 
//STRIP001 		// nicht in Selektion  -> Remove von der aktiven Liste falls vorhanden
//STRIP001 		//if ( i == nSize )
//STRIP001 		//	pSpell->RemoveDic(j);
//STRIP001 	}
//STRIP001 
//STRIP001 	// set spellchecker properties
//STRIP001 	uno::Reference< XPropertySet > xProp( SvxGetLinguPropertySet() );
//STRIP001 	if (xProp.is())
//STRIP001 	{
//STRIP001 		xProp->setPropertyValue( C2U(UPN_IS_SPELL_WITH_DIGITS),
//STRIP001 				lcl_Bool2Any( aNumBtn.IsChecked() ) );
//STRIP001 		xProp->setPropertyValue( C2U( UPN_IS_SPELL_UPPER_CASE ),
//STRIP001 				lcl_Bool2Any( aCapsBtn.IsChecked() ) );
//STRIP001 		xProp->setPropertyValue( C2U( UPN_IS_SPELL_CAPITALIZATION ),
//STRIP001 				lcl_Bool2Any( aUpLowBtn.IsChecked() ) );
//STRIP001 	}
//STRIP001 	return bModified;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void SfxSpellTabPage::Reset( const SfxItemSet& )
//STRIP001 {
//STRIP001 	UpdateBox();
//STRIP001 
//STRIP001 	// Optionen aus dem Speller einstellen
//STRIP001 	uno::Reference< XPropertySet > xProp( SvxGetLinguPropertySet() );
//STRIP001 	if (xProp.is())
//STRIP001 	{
//STRIP001 		aCapsBtn .Check( lcl_Any2Bool(
//STRIP001 				xProp->getPropertyValue( C2U( UPN_IS_SPELL_UPPER_CASE ) ) ) );
//STRIP001 		aNumBtn  .Check( lcl_Any2Bool(
//STRIP001 				xProp->getPropertyValue( C2U( UPN_IS_SPELL_WITH_DIGITS ) ) ) );
//STRIP001 		aUpLowBtn.Check( lcl_Any2Bool(
//STRIP001 				xProp->getPropertyValue( C2U( UPN_IS_SPELL_CAPITALIZATION ) ) ) );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SfxSpellTabPage, BookHdl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	// Selektion sichern
//STRIP001 	SvStringsDtor aList;
//STRIP001 
//STRIP001 	USHORT i;
//STRIP001 	for ( i=0; i < aBookLB.GetSelectEntryCount(); ++i )
//STRIP001 	{
//STRIP001 		String* pTmp = new String( aBookLB.GetSelectEntry(i) );
//STRIP001 		aList.Insert( pTmp, aList.Count() );
//STRIP001 	}
//STRIP001 
//STRIP001 	// erst Pointer auf TabControl holen, dann auf TabDialog
//STRIP001 	SvxEditDictionaryDialog* pDlg =
//STRIP001 		new SvxEditDictionaryDialog( this, aBookLB.GetSelectEntry(), xSpell );
//STRIP001 	pDlg->Execute();
//STRIP001 	delete pDlg;
//STRIP001 	pDlg = 0;
//STRIP001 
//STRIP001 	aBookLB.Clear();
//STRIP001 	UpdateBox();
//STRIP001 
//STRIP001 	// selektieren
//STRIP001 	for ( i=0; i < aList.Count(); ++i )
//STRIP001 		aBookLB.SelectEntry( *aList[i] );
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SfxSpellTabPage::UpdateBox()
//STRIP001 {
//STRIP001 	const USHORT nCount = aDics.getLength();
//STRIP001 	const uno::Reference< XDictionary > *pDic = aDics.getConstArray();
//STRIP001 	for ( USHORT i=0; i < nCount; ++i )
//STRIP001 	{
//STRIP001 		uno::Reference< XDictionary1 > xDic( pDic[i], UNO_QUERY );
//STRIP001 		if (!xDic.is())
//STRIP001 			continue;
//STRIP001 
//STRIP001 		BOOL bNegativ = xDic->getDictionaryType() == DictionaryType_NEGATIVE;
//STRIP001 		const String aName( ::GetDicInfoStr( xDic->getName(),
//STRIP001 											 xDic->getLanguage(),
//STRIP001 											 bNegativ ) );
//STRIP001 		aBookLB.InsertEntry( aName );
//STRIP001 
//STRIP001 		if (xDic->isActive())
//STRIP001 			aBookLB.SelectEntry( aName );
//STRIP001 	}
//STRIP001 }


}
