/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_srchcfg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:41:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _SVX_SRCHNCFG_HXX
#include <srchcfg.hxx>
#endif
#ifndef _SVARRAY_HXX //autogen
#include <svtools/svarray.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
namespace binfilter {

//-----------------------------------------------------------------------------
using namespace utl;
using namespace rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;

//STRIP001 #define C2U(cChar) OUString::createFromAscii(cChar)

//-----------------------------------------------------------------------------
//STRIP001 typedef SvxSearchEngineData* SvxSearchEngineDataPtr;
//STRIP001 SV_DECL_PTRARR_DEL(SvxSearchEngineArr, SvxSearchEngineDataPtr, 2, 2)//STRIP008 ;
//STRIP001 SV_IMPL_PTRARR(SvxSearchEngineArr, SvxSearchEngineDataPtr);
//-----------------------------------------------------------------------------
//STRIP001 struct SvxSearchConfig_Impl
//STRIP001 {
//STRIP001     SvxSearchEngineArr   aEngineArr;
//STRIP001 };
/* -----------------------------19.03.01 14:00--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 sal_Bool SvxSearchEngineData::operator==(const SvxSearchEngineData& rData)
//STRIP001 {
//STRIP001     return sEngineName      == rData.sEngineName     &&
//STRIP001             sAndPrefix       == rData.sAndPrefix      &&
//STRIP001             sAndSuffix       == rData.sAndSuffix      &&
//STRIP001             sAndSeparator    == rData.sAndSeparator   &&
//STRIP001             nAndCaseMatch    == rData.nAndCaseMatch   &&
//STRIP001             sOrPrefix        == rData.sOrPrefix       &&
//STRIP001             sOrSuffix        == rData.sOrSuffix       &&
//STRIP001             sOrSeparator     == rData.sOrSeparator    &&
//STRIP001             nOrCaseMatch     == rData.nOrCaseMatch    &&
//STRIP001             sExactPrefix     == rData.sExactPrefix    &&
//STRIP001             sExactSuffix     == rData.sExactSuffix    &&
//STRIP001             sExactSeparator  == rData.sExactSeparator &&
//STRIP001             nExactCaseMatch  == rData.nExactCaseMatch;
//STRIP001 }
/* -----------------------------16.01.01 15:36--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 const Sequence<OUString>& lcl_GetSearchPropertyNames_Impl()
//STRIP001 {
//STRIP001     static Sequence<OUString> aNames;
//STRIP001     if(!aNames.getLength())
//STRIP001     {
//STRIP001         aNames.realloc(12);
//STRIP001         OUString* pNames = aNames.getArray();
//STRIP001         pNames[0] = C2U("And/ooInetPrefix");
//STRIP001         pNames[1] = C2U("And/ooInetSuffix");
//STRIP001         pNames[2] = C2U("And/ooInetSeparator");
//STRIP001         pNames[3] = C2U("And/ooInetCaseMatch");
//STRIP001         pNames[4] = C2U("Or/ooInetPrefix");
//STRIP001         pNames[5] = C2U("Or/ooInetSuffix");
//STRIP001         pNames[6] = C2U("Or/ooInetSeparator");
//STRIP001         pNames[7] = C2U("Or/ooInetCaseMatch");
//STRIP001         pNames[8] = C2U("Exact/ooInetPrefix");
//STRIP001         pNames[9] = C2U("Exact/ooInetSuffix");
//STRIP001         pNames[10] = C2U("Exact/ooInetSeparator");
//STRIP001         pNames[11] = C2U("Exact/ooInetCaseMatch");
//STRIP001     }
//STRIP001     return aNames;
//STRIP001 }
// ---------------------------------------------------------------------------
//STRIP001 SvxSearchConfig::SvxSearchConfig(sal_Bool bEnableNotify) :
//STRIP001     utl::ConfigItem(C2U("Inet/SearchEngines"), CONFIG_MODE_DELAYED_UPDATE),
//STRIP001     pImpl(new SvxSearchConfig_Impl)
//STRIP001 {
//STRIP001 	if(bEnableNotify)
//STRIP001     {        
//STRIP001         //request notifications from the node
//STRIP001         Sequence<OUString> aEnable(1); 
//STRIP001         EnableNotification(aEnable);
//STRIP001     }
//STRIP001 	Load();
//STRIP001 }
/* -----------------------------16.01.01 15:36--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 SvxSearchConfig::~SvxSearchConfig()
//STRIP001 {
//STRIP001 	delete pImpl;
//STRIP001 }
/* -----------------------------17.01.01 09:57--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SvxSearchConfig::Load()
//STRIP001 {
//STRIP001     pImpl->aEngineArr.DeleteAndDestroy(0, pImpl->aEngineArr.Count());
//STRIP001     Sequence<OUString> aNodeNames = GetNodeNames(OUString());
//STRIP001     const OUString* pNodeNames = aNodeNames.getConstArray();
//STRIP001     for(sal_Int32 nNode = 0; nNode < aNodeNames.getLength(); nNode++)
//STRIP001     {
//STRIP001         SvxSearchEngineDataPtr pNew = new SvxSearchEngineData;
//STRIP001         pNew->sEngineName = pNodeNames[nNode];
//STRIP001         const Sequence<OUString>& rPropNames = lcl_GetSearchPropertyNames_Impl();
//STRIP001         const OUString* pPropNames = rPropNames.getConstArray();
//STRIP001         Sequence<OUString> aPropertyNames(rPropNames.getLength());
//STRIP001         OUString* pPropertyNames = aPropertyNames.getArray();
//STRIP001         const OUString sSlash(C2U("/"));
//STRIP001         sal_Int32 nProp;
//STRIP001         for(nProp = 0; nProp < rPropNames.getLength(); nProp++)
//STRIP001         {
//STRIP001             pPropertyNames[nProp] = pNodeNames[nNode];
//STRIP001             pPropertyNames[nProp] += sSlash;
//STRIP001             pPropertyNames[nProp] += pPropNames[nProp];
//STRIP001         }
//STRIP001         Sequence<Any> aValues = GetProperties(aPropertyNames);
//STRIP001         const Any* pValues = aValues.getConstArray();
//STRIP001         for(nProp = 0; nProp < rPropNames.getLength(); nProp++)
//STRIP001         {
//STRIP001             switch(nProp)
//STRIP001             {
//STRIP001                 case 0 : pValues[nProp] >>= pNew->sAndPrefix;      break;
//STRIP001                 case 1 : pValues[nProp] >>= pNew->sAndSuffix;      break;
//STRIP001                 case 2 : pValues[nProp] >>= pNew->sAndSeparator;   break;
//STRIP001                 case 3 : pValues[nProp] >>= pNew->nAndCaseMatch;   break;
//STRIP001 
//STRIP001                 case 4 : pValues[nProp] >>= pNew->sOrPrefix;       break;
//STRIP001                 case 5 : pValues[nProp] >>= pNew->sOrSuffix;       break;
//STRIP001                 case 6 : pValues[nProp] >>= pNew->sOrSeparator;    break;
//STRIP001                 case 7 : pValues[nProp] >>= pNew->nOrCaseMatch;    break;
//STRIP001 
//STRIP001                 case 8 : pValues[nProp] >>= pNew->sExactPrefix;    break;
//STRIP001                 case 9 : pValues[nProp] >>= pNew->sExactSuffix;    break;
//STRIP001                 case 10: pValues[nProp] >>= pNew->sExactSeparator; break;
//STRIP001                 case 11: pValues[nProp] >>= pNew->nExactCaseMatch; break;
//STRIP001             }
//STRIP001         }
//STRIP001         pImpl->aEngineArr.Insert(pNew, pImpl->aEngineArr.Count());
//STRIP001     }
//STRIP001 }
/* -----------------------------17.01.01 09:57--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void    SvxSearchConfig::Notify( const Sequence<OUString>& rPropertyNames)
//STRIP001 {
//STRIP001 	Load();
//STRIP001 }
/* -----------------------------16.01.01 15:36--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SvxSearchConfig::Commit()
//STRIP001 {
//STRIP001     OUString sNode;
//STRIP001     if(!pImpl->aEngineArr.Count())
//STRIP001         ClearNodeSet(sNode);
//STRIP001     else
//STRIP001     {
//STRIP001         Sequence<PropertyValue> aSetValues(12 * pImpl->aEngineArr.Count());
//STRIP001 		PropertyValue* pSetValues = aSetValues.getArray();
//STRIP001 		sal_Int32 nSetValue = 0;
//STRIP001 
//STRIP001         const Sequence<OUString>& rPropNames = lcl_GetSearchPropertyNames_Impl();
//STRIP001         const OUString* pPropNames = rPropNames.getConstArray();
//STRIP001         const OUString sSlash(C2U("/"));
//STRIP001         for(sal_uInt16 i = 0; i < pImpl->aEngineArr.Count(); i++)
//STRIP001 		{
//STRIP001             SvxSearchEngineDataPtr pSave = pImpl->aEngineArr[i];
//STRIP001             for(sal_Int16 nProp = 0; nProp < rPropNames.getLength(); nProp++)
//STRIP001             {
//STRIP001                 OUString sTmpName = sSlash;
//STRIP001                 sTmpName += pSave->sEngineName;
//STRIP001                 sTmpName += sSlash;
//STRIP001                 sTmpName += pPropNames[nProp];
//STRIP001                 pSetValues[nProp].Name = sTmpName;
//STRIP001                 switch(nProp)
//STRIP001                 {
//STRIP001                     case 0 : pSetValues[nProp].Value <<= pSave->sAndPrefix;      break;
//STRIP001                     case 1 : pSetValues[nProp].Value <<= pSave->sAndSuffix;      break;
//STRIP001                     case 2 : pSetValues[nProp].Value <<= pSave->sAndSeparator;   break;
//STRIP001                     case 3 : pSetValues[nProp].Value <<= pSave->nAndCaseMatch;   break;
//STRIP001 
//STRIP001                     case 4 : pSetValues[nProp].Value <<= pSave->sOrPrefix;       break;
//STRIP001                     case 5 : pSetValues[nProp].Value <<= pSave->sOrSuffix;       break;
//STRIP001                     case 6 : pSetValues[nProp].Value <<= pSave->sOrSeparator;    break;
//STRIP001                     case 7 : pSetValues[nProp].Value <<= pSave->nOrCaseMatch;    break;
//STRIP001 
//STRIP001                     case 8 : pSetValues[nProp].Value <<= pSave->sExactPrefix;    break;
//STRIP001                     case 9 : pSetValues[nProp].Value <<= pSave->sExactSuffix;    break;
//STRIP001                     case 10: pSetValues[nProp].Value <<= pSave->sExactSeparator; break;
//STRIP001                     case 11: pSetValues[nProp].Value <<= pSave->nExactCaseMatch; break;
//STRIP001                 }
//STRIP001             }
//STRIP001             pSetValues+= 12;
//STRIP001         }
//STRIP001 		ReplaceSetProperties(sNode, aSetValues);
//STRIP001     }
//STRIP001 }
/* -----------------------------19.03.01 10:02--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 sal_uInt16 SvxSearchConfig::Count()
//STRIP001 {
//STRIP001     return pImpl->aEngineArr.Count();
//STRIP001 }
/* -----------------------------19.03.01 10:02--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 const SvxSearchEngineData&  SvxSearchConfig::GetData(sal_uInt16 nPos)
//STRIP001 {
//STRIP001     DBG_ASSERT(nPos < pImpl->aEngineArr.Count(), "wrong array index")
//STRIP001     return *pImpl->aEngineArr[nPos];
//STRIP001 }
/* -----------------------------19.03.01 10:38--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 const SvxSearchEngineData*  SvxSearchConfig::GetData(const ::rtl::OUString& rEngineName)
//STRIP001 {
//STRIP001     for(sal_uInt16 nPos = 0; nPos < pImpl->aEngineArr.Count(); nPos++)
//STRIP001     {
//STRIP001         if(pImpl->aEngineArr[nPos]->sEngineName == rEngineName)
//STRIP001             return pImpl->aEngineArr[nPos];
//STRIP001     }
//STRIP001     return 0;
//STRIP001 }
/* -----------------------------19.03.01 10:02--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void  SvxSearchConfig::SetData(const SvxSearchEngineData& rData)
//STRIP001 {
//STRIP001     for(sal_uInt16 nPos = 0; nPos < pImpl->aEngineArr.Count(); nPos++)
//STRIP001     {
//STRIP001         if(pImpl->aEngineArr[nPos]->sEngineName == rData.sEngineName)
//STRIP001         {
//STRIP001             if((*pImpl->aEngineArr[nPos]) == rData)
//STRIP001                 return;
//STRIP001             pImpl->aEngineArr.DeleteAndDestroy(nPos, 1);
//STRIP001             break;
//STRIP001         }
//STRIP001     }
//STRIP001     SvxSearchEngineDataPtr pInsert = new SvxSearchEngineData(rData);
//STRIP001     pImpl->aEngineArr.Insert(pInsert, pImpl->aEngineArr.Count());
//STRIP001     SetModified();
//STRIP001 }
/* -----------------------------19.03.01 10:38--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SvxSearchConfig::RemoveData(const ::rtl::OUString& rEngineName)
//STRIP001 {
//STRIP001     for(sal_uInt16 nPos = 0; nPos < pImpl->aEngineArr.Count(); nPos++)
//STRIP001     {
//STRIP001         if(pImpl->aEngineArr[nPos]->sEngineName == rEngineName)
//STRIP001         {
//STRIP001             pImpl->aEngineArr.DeleteAndDestroy(nPos, 1);
//STRIP001             SetModified();
//STRIP001             return ;
//STRIP001         }
//STRIP001     }
//STRIP001 }

}
