/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_editsh.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 09:00:22 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #ifndef _HINTIDS_HXX
// auto strip #include <hintids.hxx>
// auto strip #endif

// auto strip #ifndef _LIST_HXX //autogen
// auto strip #include <tools/list.hxx>
// auto strip #endif
// auto strip #ifndef _URLOBJ_HXX //autogen
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif
// auto strip #ifndef _VCL_CMDEVT_HXX //autogen
// auto strip #include <vcl/cmdevt.hxx>
// auto strip #endif
// auto strip #ifndef _IPOBJ_HXX //autogen
// auto strip #include <so3/ipobj.hxx>
// auto strip #endif
// auto strip #ifndef _SCH_DLL_HXX //autogen
// auto strip #include <bf_sch/schdll.hxx>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_CHARCLASS_HXX
// auto strip #include <unotools/charclass.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_TRANSLITERATIONWRAPPER_HXX
// auto strip #include <unotools/transliterationwrapper.hxx>
// auto strip #endif

// auto strip #ifndef _SWWAIT_HXX
// auto strip #include <swwait.hxx>
// auto strip #endif
// auto strip #ifndef _FMTSRND_HXX //autogen
// auto strip #include <fmtsrnd.hxx>
// auto strip #endif
// auto strip #ifndef _FMTINFMT_HXX //autogen
// auto strip #include <fmtinfmt.hxx>
// auto strip #endif
// auto strip #ifndef _TXTINET_HXX //autogen
// auto strip #include <txtinet.hxx>
// auto strip #endif
// auto strip #ifndef _FRMFMT_HXX //autogen
// auto strip #include <frmfmt.hxx>
// auto strip #endif
// auto strip #ifndef _CHARFMT_HXX //autogen
// auto strip #include <charfmt.hxx>
// auto strip #endif
// auto strip #ifndef _DOCARY_HXX
// auto strip #include <docary.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #ifndef _EDITSH_HXX
// auto strip #include <editsh.hxx>
// auto strip #endif
// auto strip #ifndef _FRAME_HXX
// auto strip #include <frame.hxx>
// auto strip #endif
#ifndef _CNTFRM_HXX
#include <cntfrm.hxx>
#endif
// auto strip #ifndef _PAM_HXX
// auto strip #include <pam.hxx>
// auto strip #endif
// auto strip #ifndef _NODE_HXX
// auto strip #include <node.hxx>				// fuer GetSectionLevel()
// auto strip #endif
// auto strip #ifndef _NDTXT_HXX
// auto strip #include <ndtxt.hxx>			// fuer SwTxtNode
// auto strip #endif
// auto strip #ifndef _GRFATR_HXX
// auto strip #include <grfatr.hxx>
// auto strip #endif
// auto strip #ifndef _FLYFRM_HXX
// auto strip #include <flyfrm.hxx>
// auto strip #endif
// auto strip #ifndef _SWTABLE_HXX
// auto strip #include <swtable.hxx>
// auto strip #endif
// auto strip #ifndef _SWUNDO_HXX
// auto strip #include <swundo.hxx> 			// UNDO_START, UNDO_END
// auto strip #endif
// auto strip #ifndef _ERRHDL_HXX
// auto strip #include <errhdl.hxx>
// auto strip #endif
// auto strip #ifndef _CALC_HXX
// auto strip #include <calc.hxx>
// auto strip #endif
// auto strip #ifndef _EDIMP_HXX
// auto strip #include <edimp.hxx>
// auto strip #endif
// auto strip #ifndef _NDGRF_HXX
// auto strip #include <ndgrf.hxx>
// auto strip #endif
// auto strip #ifndef _NDOLE_HXX
// auto strip #include <ndole.hxx>
// auto strip #endif
// auto strip #ifndef _TXTFRM_HXX
// auto strip #include <txtfrm.hxx>
// auto strip #endif
// auto strip #ifndef _ROOTFRM_HXX
// auto strip #include <rootfrm.hxx>
// auto strip #endif
// auto strip #ifndef _EXTINPUT_HXX
// auto strip #include <extinput.hxx>
// auto strip #endif
// auto strip #ifndef _CRSSKIP_HXX
// auto strip #include <crsskip.hxx>
// auto strip #endif
// auto strip #ifndef _DRAWFONT_HXX
// auto strip #include <drawfont.hxx>
// auto strip #endif
// auto strip #ifndef _UNOOBJ_HXX
// auto strip #include <unoobj.hxx>
// auto strip #endif
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
namespace binfilter {
//STRIP001 SV_IMPL_PTRARR(SwGetINetAttrs, SwGetINetAttr*)

/******************************************************************************
 *						void SwEditShell::Insert(char c)
 ******************************************************************************/


//STRIP001 void SwEditShell::Insert( sal_Unicode c, BOOL bOnlyCurrCrsr )
//STRIP001 {
//STRIP001 	StartAllAction();
//STRIP001 	FOREACHPAM_START(this)
//STRIP001 
//STRIP001 		if( !GetDoc()->Insert(*PCURCRSR, c) )
//STRIP001 			ASSERT( FALSE, "Doc->Insert(c) failed." );
//STRIP001 
//STRIP001 		SaveTblBoxCntnt( PCURCRSR->GetPoint() );
//STRIP001 		if( bOnlyCurrCrsr )
//STRIP001 			break;
//STRIP001 
//STRIP001 	FOREACHPAM_END()
//STRIP001 
//STRIP001 	EndAllAction();
//STRIP001 }


/******************************************************************************
 *				  void SwEditShell::Insert(const String &rStr)
 ******************************************************************************/


//STRIP001 void SwEditShell::Insert(const String &rStr)
//STRIP001 {
//STRIP001 	StartAllAction();
//STRIP001 	FOREACHPAM_START(this)
//STRIP001 		//OPT: GetSystemCharSet
//STRIP001 		if( !GetDoc()->Insert( *PCURCRSR, rStr ) )
//STRIP001 			ASSERT( FALSE, "Doc->Insert(Str) failed." );
//STRIP001 
//STRIP001 		SaveTblBoxCntnt( PCURCRSR->GetPoint() );
//STRIP001 
//STRIP001 	FOREACHPAM_END()
//STRIP001 
//STRIP001     // calculate cursor bidi level
//STRIP001     SwCursor* pTmpCrsr = _GetCrsr();
//STRIP001     const BOOL bDoNotSetBidiLevel = ! pTmpCrsr ||
//STRIP001                                     ( 0 != (SwUnoCrsr*)*pTmpCrsr );
//STRIP001 
//STRIP001     if ( ! bDoNotSetBidiLevel )
//STRIP001     {
//STRIP001         SwNode& rNode = pTmpCrsr->GetPoint()->nNode.GetNode();
//STRIP001         if ( rNode.IsTxtNode() )
//STRIP001         {
//STRIP001             SwIndex& rIdx = pTmpCrsr->GetPoint()->nContent;
//STRIP001             xub_StrLen nPos = rIdx.GetIndex();
//STRIP001             xub_StrLen nPrevPos = nPos;
//STRIP001             if ( nPrevPos )
//STRIP001                 --nPrevPos;
//STRIP001 
//STRIP001             SwScriptInfo* pSI = SwScriptInfo::GetScriptInfo( ((SwTxtNode&)rNode),
//STRIP001                                                               sal_True );
//STRIP001 
//STRIP001             BYTE nLevel = 0;
//STRIP001             if ( ! pSI )
//STRIP001             {
//STRIP001                 // seems to be an empty paragraph.
//STRIP001                 Point aPt;
//STRIP001                 SwCntntFrm* pFrm =
//STRIP001                         ((SwTxtNode&)rNode).GetFrm( &aPt, pTmpCrsr->GetPoint(),
//STRIP001                                                     sal_False );
//STRIP001 
//STRIP001                 SwScriptInfo aScriptInfo;
//STRIP001                 aScriptInfo.InitScriptInfo( (SwTxtNode&)rNode, pFrm->IsRightToLeft() );
//STRIP001                 nLevel = aScriptInfo.DirType( nPrevPos );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001 				if ( STRING_LEN != pSI->GetInvalidity() )
//STRIP001 	                pSI->InitScriptInfo( (SwTxtNode&)rNode );
//STRIP001                 nLevel = pSI->DirType( nPrevPos );
//STRIP001             }
//STRIP001 
//STRIP001             pTmpCrsr->SetCrsrBidiLevel( nLevel );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001 	EndAllAction();
//STRIP001 }


/******************************************************************************
 *				void SwEditShell::Overwrite(const String &rStr)
 ******************************************************************************/


//STRIP001 void SwEditShell::Overwrite(const String &rStr)
//STRIP001 {
//STRIP001 	StartAllAction();
//STRIP001 	FOREACHPAM_START(this)
//STRIP001 		if( !GetDoc()->Overwrite(*PCURCRSR, rStr ) )
//STRIP001 			ASSERT( FALSE, "Doc->Overwrite(Str) failed." );
//STRIP001 		SaveTblBoxCntnt( PCURCRSR->GetPoint() );
//STRIP001 	FOREACHPAM_END()
//STRIP001 	EndAllAction();
//STRIP001 }


/******************************************************************************
 *						long SwEditShell::SplitNode()
 ******************************************************************************/

//STRIP001 long SwEditShell::SplitNode( BOOL bAutoFormat, BOOL bCheckTableStart )
//STRIP001 {
//STRIP001 	StartAllAction();
//STRIP001 	GetDoc()->StartUndo();
//STRIP001 
//STRIP001 	FOREACHPAM_START(this)
//STRIP001 		// eine Tabellen Zelle wird jetzt zu einer normalen Textzelle!
//STRIP001 		GetDoc()->ClearBoxNumAttrs( PCURCRSR->GetPoint()->nNode );
//STRIP001 		GetDoc()->SplitNode( *PCURCRSR->GetPoint(), bCheckTableStart );
//STRIP001 	FOREACHPAM_END()
//STRIP001 
//STRIP001 	GetDoc()->EndUndo();
//STRIP001 
//STRIP001 	if( bAutoFormat )
//STRIP001 		AutoFmtBySplitNode();
//STRIP001 
//STRIP001 	ClearTblBoxCntnt();
//STRIP001 
//STRIP001 	EndAllAction();
//STRIP001 	return(1L);
//STRIP001 }

/******************************************************************************
 *		  liefert einen Pointer auf einen SwGrfNode; dieser wird von
 *		  		GetGraphic() und GetGraphicSize() verwendet.
 ******************************************************************************/


//STRIP001 SwGrfNode * SwEditShell::_GetGrfNode() const
//STRIP001 {
//STRIP001 	SwGrfNode *pGrfNode = 0;
//STRIP001 	SwPaM* pCrsr = GetCrsr();
//STRIP001 	if( !pCrsr->HasMark() ||
//STRIP001 		pCrsr->GetPoint()->nNode == pCrsr->GetMark()->nNode )
//STRIP001 		pGrfNode = pCrsr->GetPoint()->nNode.GetNode().GetGrfNode();
//STRIP001 
//STRIP001 	ASSERT( pGrfNode, "ist keine Graphic!!" );
//STRIP001 	return pGrfNode;
//STRIP001 }
/******************************************************************************
 * 		liefert Pointer auf eine Graphic, wenn CurCrsr->GetPoint() auf
 * 			 einen SwGrfNode zeigt (und GetMark nicht gesetzt ist
 * 					 oder auf die gleiche Graphic zeigt)
 ******************************************************************************/

//STRIP001 const Graphic &SwEditShell::GetGraphic( BOOL bWait ) const
//STRIP001 {
//STRIP001 	SwGrfNode *pGrfNode = _GetGrfNode();
//STRIP001 	const Graphic& rGrf = pGrfNode->GetGrf();
//STRIP001 	if( rGrf.IsSwapOut() ||
//STRIP001 		( pGrfNode->IsLinkedFile() && GRAPHIC_DEFAULT == rGrf.GetType() ) )
//STRIP001 	{
//STRIP001 #ifndef PRODUCT
//STRIP001 		ASSERT( pGrfNode->SwapIn( bWait ) || !bWait, "Grafik konnte nicht geladen werden" );
//STRIP001 #else
//STRIP001 		pGrfNode->SwapIn( bWait );
//STRIP001 #endif
//STRIP001 	}
//STRIP001 	return rGrf;
//STRIP001 }

//STRIP001 BOOL SwEditShell::IsGrfSwapOut( BOOL bOnlyLinked ) const
//STRIP001 {
//STRIP001 	SwGrfNode *pGrfNode = _GetGrfNode();
//STRIP001 	return pGrfNode &&
//STRIP001 		(bOnlyLinked ? ( pGrfNode->IsLinkedFile() &&
//STRIP001 						( GRAPHIC_DEFAULT == pGrfNode->GetGrfObj().GetType()||
//STRIP001 						  pGrfNode->GetGrfObj().IsSwappedOut()))
//STRIP001 					 : pGrfNode->GetGrfObj().IsSwappedOut());
//STRIP001 }

//STRIP001 const GraphicObject& SwEditShell::GetGraphicObj() const
//STRIP001 {
//STRIP001 	SwGrfNode *pGrfNode = _GetGrfNode();
//STRIP001 	return pGrfNode->GetGrfObj();
//STRIP001 }

//STRIP001 USHORT SwEditShell::GetGraphicType() const
//STRIP001 {
//STRIP001 	SwGrfNode *pGrfNode = _GetGrfNode();
//STRIP001 	return pGrfNode->GetGrfObj().GetType();
//STRIP001 }

/******************************************************************************
 *		liefert die Groesse der Graphic, wenn CurCrsr->GetPoint() auf
 * 			einen SwGrfNode zeigt (und GetMark nicht gesetzt ist
 * 					oder auf die gleiche Graphic zeigt)
 ******************************************************************************/

//STRIP001 BOOL SwEditShell::GetGrfSize(Size& rSz) const
//STRIP001 {
//STRIP001 	SwNoTxtNode* pNoTxtNd;
//STRIP001 	SwPaM* pCurCrsr = GetCrsr();
//STRIP001 	if( ( !pCurCrsr->HasMark()
//STRIP001 		 || pCurCrsr->GetPoint()->nNode == pCurCrsr->GetMark()->nNode )
//STRIP001 		 && 0 != ( pNoTxtNd = pCurCrsr->GetNode()->GetNoTxtNode() ) )
//STRIP001 	{
//STRIP001 		rSz = pNoTxtNd->GetTwipSize();
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 
//STRIP001 }
/******************************************************************************
 * 		erneutes Einlesen, falls Graphic nicht Ok ist. Die
 * 		aktuelle wird durch die neue ersetzt.
 ******************************************************************************/

//STRIP001 void SwEditShell::ReRead( const String& rGrfName, const String& rFltName,
//STRIP001 					const Graphic* pGraphic, const GraphicObject* pGrfObj )
//STRIP001 {
//STRIP001 	StartAllAction();
//STRIP001 	pDoc->ReRead( *GetCrsr(), rGrfName, rFltName, pGraphic, pGrfObj );
//STRIP001 	EndAllAction();
//STRIP001 }


/******************************************************************************
 *	liefert den Namen und den FilterNamen einer Graphic, wenn der Cursor
 *	auf einer Graphic steht
 *	Ist ein String-Ptr != 0 dann returne den entsp. Namen
 ******************************************************************************/


//STRIP001 void SwEditShell::GetGrfNms( String* pGrfName, String* pFltName,
//STRIP001 							const SwFlyFrmFmt* pFmt ) const
//STRIP001 {
//STRIP001 	ASSERT( pGrfName || pFltName, "was wird denn nun erfragt?" );
//STRIP001 	if( pFmt )
//STRIP001 		GetDoc()->GetGrfNms( *pFmt, pGrfName, pFltName );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SwGrfNode *pGrfNode = _GetGrfNode();
//STRIP001 		if( pGrfNode->IsLinkedFile() )
//STRIP001 			pGrfNode->GetFileFilterNms( pGrfName, pFltName );
//STRIP001 	}
//STRIP001 }


// alternativen Text abfragen/setzen
//STRIP001 const String& SwEditShell::GetAlternateText() const
//STRIP001 {
//STRIP001 	SwPaM* pCrsr = GetCrsr();
//STRIP001 	const SwNoTxtNode* pNd;
//STRIP001 	if( !pCrsr->HasMark() && 0 != ( pNd = pCrsr->GetNode()->GetNoTxtNode()) )
//STRIP001 		return pNd->GetAlternateText();
//STRIP001 
//STRIP001 	return aEmptyStr;
//STRIP001 }


//STRIP001 void SwEditShell::SetAlternateText( const String& rTxt )
//STRIP001 {
//STRIP001 	SwPaM* pCrsr = GetCrsr();
//STRIP001 	SwNoTxtNode* pNd;
//STRIP001 	if( !pCrsr->HasMark() && 0 != ( pNd = pCrsr->GetNode()->GetNoTxtNode()) )
//STRIP001 		pNd->SetAlternateText( rTxt, sal_True );
//STRIP001 }


//STRIP001 const PolyPolygon *SwEditShell::GetGraphicPolygon() const
//STRIP001 {
//STRIP001 	SwNoTxtNode *pNd = GetCrsr()->GetNode()->GetNoTxtNode();
//STRIP001 	return pNd->HasContour();
//STRIP001 }


//STRIP001 void SwEditShell::SetGraphicPolygon( const PolyPolygon *pPoly )
//STRIP001 {
//STRIP001 	SwNoTxtNode *pNd = GetCrsr()->GetNode()->GetNoTxtNode();
//STRIP001 	StartAllAction();
//STRIP001 	pNd->SetContour( pPoly );
//STRIP001 	SwFlyFrm *pFly = (SwFlyFrm*)pNd->GetFrm()->GetUpper();
//STRIP001 	const SwFmtSurround &rSur = pFly->GetFmt()->GetSurround();
//STRIP001 	pFly->GetFmt()->SwModify::Modify( (SwFmtSurround*)&rSur,
//STRIP001 									  (SwFmtSurround*)&rSur );
//STRIP001 	GetDoc()->SetModified();
//STRIP001 	EndAllAction();
//STRIP001 }

//STRIP001 void SwEditShell::ClearAutomaticContour()
//STRIP001 {
//STRIP001 	SwNoTxtNode *pNd = GetCrsr()->GetNode()->GetNoTxtNode();
//STRIP001 	ASSERT( pNd, "is no NoTxtNode!" );
//STRIP001     if( pNd->HasAutomaticContour() )
//STRIP001     {
//STRIP001         StartAllAction();
//STRIP001         pNd->SetContour( NULL, FALSE );
//STRIP001         SwFlyFrm *pFly = (SwFlyFrm*)pNd->GetFrm()->GetUpper();
//STRIP001         const SwFmtSurround &rSur = pFly->GetFmt()->GetSurround();
//STRIP001         pFly->GetFmt()->SwModify::Modify( (SwFmtSurround*)&rSur,
//STRIP001                                           (SwFmtSurround*)&rSur );
//STRIP001         GetDoc()->SetModified();
//STRIP001         EndAllAction();
//STRIP001     }
//STRIP001 }

/******************************************************************************
 * 		liefert Pointer auf ein SvInPlaceObjectRef, wenn CurCrsr->GetPoint() auf
 * 			einen SwOLENode zeigt (und GetMark nicht gesetzt ist
 * 					oder auf das gleiche SvInPlaceObjectRef zeigt)
 * 		besorgt den Pointer vom Doc wenn das Objekt per Namen gesucht werden
 * 		soll
 ******************************************************************************/


//STRIP001 SvInPlaceObjectRef SwEditShell::GetOLEObj() const
//STRIP001 {
//STRIP001 	ASSERT(  CNT_OLE == GetCntType(), "GetOLEObj: kein OLENode." );
//STRIP001 	ASSERT( !GetCrsr()->HasMark() ||
//STRIP001 			(GetCrsr()->HasMark() &&
//STRIP001 				GetCrsr()->GetPoint()->nNode == GetCrsr()->GetMark()->nNode),
//STRIP001 			"GetOLEObj: kein OLENode." );
//STRIP001 
//STRIP001 	SwOLENode *pOLENode = GetCrsr()->GetNode()->GetOLENode();
//STRIP001 	ASSERT( pOLENode, "GetOLEObj: kein OLENode." );
//STRIP001 	SwOLEObj& rOObj = pOLENode->GetOLEObj();
//STRIP001 	return rOObj.GetOleRef();
//STRIP001 }


//STRIP001 BOOL SwEditShell::HasOLEObj( const String &rName ) const
//STRIP001 {
//STRIP001 	SwStartNode *pStNd;
//STRIP001 	SwNodeIndex aIdx( *GetNodes().GetEndOfAutotext().StartOfSectionNode(), 1 );
//STRIP001 	while ( 0 != (pStNd = aIdx.GetNode().GetStartNode()) )
//STRIP001 	{
//STRIP001 		aIdx++;
//STRIP001 		SwNode& rNd = aIdx.GetNode();
//STRIP001 		if( rNd.IsOLENode() &&
//STRIP001 			rName == ((SwOLENode&)rNd).GetChartTblName() &&
//STRIP001 			((SwOLENode&)rNd).GetFrm() )
//STRIP001 			return TRUE;
//STRIP001 
//STRIP001 		aIdx.Assign( *pStNd->EndOfSectionNode(), + 1 );
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }


//STRIP001 void SwEditShell::SetChartName( const String &rName )
//STRIP001 {
//STRIP001 	SwOLENode *pONd = GetCrsr()->GetNode()->GetOLENode();
//STRIP001 	ASSERT( pONd, "ChartNode not found" );
//STRIP001 	pONd->SetChartTblName( rName );
//STRIP001 }

//STRIP001 const String& SwEditShell::GetChartName( SvInPlaceObject* pObj )
//STRIP001 {
//STRIP001 	if( pObj )
//STRIP001 	{
//STRIP001 		SwClientIter aIter( *(SwModify*)GetDoc()->GetDfltGrfFmtColl() );
//STRIP001 		SwClient *pCli;
//STRIP001 		if( 0 != (pCli = aIter.First( TYPE(SwCntntNode) )) )
//STRIP001 			do{
//STRIP001 				if( ((SwCntntNode*)pCli)->IsOLENode() &&
//STRIP001 					((SwOLENode*)pCli)->GetOLEObj().IsOleRef() &&
//STRIP001 					pObj == &((SwOLENode*)pCli)->GetOLEObj().GetOleRef() )
//STRIP001 				{
//STRIP001 					return ((SwOLENode*)pCli)->GetChartTblName();
//STRIP001 				}
//STRIP001 			} while ( 0 != (pCli = aIter.Next()) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SwOLENode *pONd = GetCrsr()->GetNode()->GetOLENode();
//STRIP001 		if( pONd )
//STRIP001 			return pONd->GetChartTblName();
//STRIP001 	}
//STRIP001 
//STRIP001 	return aEmptyStr;
//STRIP001 }

//STRIP001 void SwEditShell::UpdateChartData( const String &rName, SchMemChart *&pData )
//STRIP001 {
//STRIP001 	//Fuer das Update brauchen wir die SwTable. Also muessen wir ggf. die
//STRIP001 	//gewuenschte Table anspringen.
//STRIP001 	String sSelection;
//STRIP001 	const SwTableNode *pTblNd = IsCrsrInTbl();
//STRIP001 	if( !pTblNd || rName != pTblNd->GetTable().GetFrmFmt()->GetName() )
//STRIP001 	{
//STRIP001 		Push();
//STRIP001 		GotoTable( rName );
//STRIP001 		pTblNd = IsCrsrInTbl();
//STRIP001 		Pop( FALSE );
//STRIP001 	}
//STRIP001 	else if( IsTableMode() )
//STRIP001 		sSelection = GetBoxNms();
//STRIP001 
//STRIP001 	if( pTblNd )
//STRIP001 		pData = pTblNd->GetTable().UpdateData( pData, &sSelection );
//STRIP001 }


//STRIP001 void SwEditShell::UpdateCharts( const String &rName )
//STRIP001 {
//STRIP001 	GetDoc()->UpdateCharts( rName );
//STRIP001 }


/******************************************************************************
 * 		Aenderung des Tabellennamens
 ******************************************************************************/

//STRIP001 void SwEditShell::SetTableName( SwFrmFmt& rTblFmt, const String &rNewName )
//STRIP001 {
//STRIP001 	GetDoc()->SetTableName( rTblFmt, rNewName );
//STRIP001 }

//STRIP001 #pragma optimize("",on)

// erfragen des akt. Wortes


//STRIP001 String SwEditShell::GetCurWord()
//STRIP001 {
//STRIP001 	String aString( GetDoc()->GetCurWord(*GetCrsr()) );
//STRIP001 	aString.EraseAllChars('\xff');
//STRIP001 	return aString;
//STRIP001 }

/****************************************************************************
 *			 void SwEditShell::UpdateDocStat( SwDocStat& rStat )
 ****************************************************************************/


//STRIP001 void SwEditShell::UpdateDocStat( SwDocStat& rStat )
//STRIP001 {
//STRIP001 	StartAllAction();
//STRIP001 	GetDoc()->UpdateDocStat( rStat );
//STRIP001 	EndAllAction();
//STRIP001 }

// OPT: eddocinl.cxx


//STRIP001 const SfxDocumentInfo* SwEditShell::GetInfo() const
//STRIP001 {
//STRIP001 	return GetDoc()->GetInfo();
//STRIP001 }


	// returne zum Namen die im Doc gesetzte Referenz
//STRIP001 const SwFmtRefMark* SwEditShell::GetRefMark( const String& rName ) const
//STRIP001 {
//STRIP001 	return GetDoc()->GetRefMark( rName );
//STRIP001 }

	// returne die Namen aller im Doc gesetzten Referenzen
//STRIP001 USHORT SwEditShell::GetRefMarks( SvStringsDtor* pStrings ) const
//STRIP001 {
//STRIP001 	return GetDoc()->GetRefMarks( pStrings );
//STRIP001 }

/******************************************************************************
 *			DropCap-SS
 ******************************************************************************/


//STRIP001 String SwEditShell::GetDropTxt( const USHORT nChars ) const
//STRIP001 {
//STRIP001 	String aTxt;
//STRIP001 	SwPaM* pCrsr = GetCrsr();
//STRIP001 	if( pCrsr->GetPoint()->nNode.GetIndex() ==
//STRIP001 		pCrsr->GetMark()->nNode.GetIndex() )
//STRIP001 	{
//STRIP001 		SwTxtNode* pTxtNd = pCrsr->GetNode()->GetTxtNode();
//STRIP001 		if( pTxtNd )
//STRIP001 		{
//STRIP001 			xub_StrLen nDropLen = pTxtNd->GetDropLen( nChars );
//STRIP001 			if( nDropLen )
//STRIP001 				aTxt = pTxtNd->GetTxt().Copy( 0, nDropLen );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return aTxt;
//STRIP001 }


//STRIP001 void SwEditShell::ReplaceDropTxt( const String &rStr )
//STRIP001 {
//STRIP001 	SwPaM* pCrsr = GetCrsr();
//STRIP001 	if( pCrsr->GetPoint()->nNode == pCrsr->GetMark()->nNode &&
//STRIP001 		pCrsr->GetNode()->GetTxtNode()->IsTxtNode() )
//STRIP001 	{
//STRIP001 		StartAllAction();
//STRIP001 
//STRIP001 		const SwNodeIndex& rNd = pCrsr->GetPoint()->nNode;
//STRIP001 		SwPaM aPam( rNd, rStr.Len(), rNd, 0 );
//STRIP001 		if( !GetDoc()->Overwrite( aPam, rStr ) )
//STRIP001 		{
//STRIP001 			ASSERT( FALSE, "Doc->Overwrite(Str) failed." );
//STRIP001 		}
//STRIP001 
//STRIP001 		EndAllAction();
//STRIP001 	}
//STRIP001 }

/******************************************************************************
 *	Methode		:
 *	Beschreibung:
 *	Erstellt	:	OK 25.04.94 13:45
 *	Aenderung	:
 ******************************************************************************/

//STRIP001 String SwEditShell::Calculate()
//STRIP001 {
//STRIP001 	String 	aFormel;					// die entgueltige Formel
//STRIP001 	SwPaM	*pPaMLast = (SwPaM*)GetCrsr()->GetNext(),
//STRIP001 			*pPaM = pPaMLast;			// die Pointer auf Cursor
//STRIP001 	SwCalc 	aCalc( *GetDoc() );
//STRIP001 	const CharClass& rCC = GetAppCharClass();
//STRIP001 
//STRIP001 	do {
//STRIP001 		SwTxtNode* pTxtNd = pPaM->GetNode()->GetTxtNode();
//STRIP001 		if(pTxtNd)
//STRIP001 		{
//STRIP001 			const SwPosition *pStart = pPaM->Start(), *pEnd = pPaM->End();
//STRIP001 			xub_StrLen nStt = pStart->nContent.GetIndex();
//STRIP001 			String aStr = pTxtNd->GetExpandTxt( nStt, pEnd->nContent.
//STRIP001 												GetIndex() - nStt );
//STRIP001 
//STRIP001 			rCC.toLower( aStr );
//STRIP001 
//STRIP001 			sal_Unicode ch;
//STRIP001 			BOOL 	bValidFlds = FALSE;
//STRIP001 			xub_StrLen nPos = 0;
//STRIP001 
//STRIP001 			while( nPos < aStr.Len() )
//STRIP001 			{
//STRIP001 				ch = aStr.GetChar( nPos++ );
//STRIP001 				if( rCC.isLetter( aStr, nPos-1 ) || ch == '_' )
//STRIP001 				{
//STRIP001 					xub_StrLen nStt = nPos-1;
//STRIP001 					while(  nPos < aStr.Len() &&
//STRIP001 							0 != ( ch = aStr.GetChar( nPos++ )) &&
//STRIP001 						   (rCC.isLetterNumeric( aStr, nPos - 1 ) ||
//STRIP001 						   	ch == '_'|| ch == '.' ))
//STRIP001 						;
//STRIP001 
//STRIP001 					if( nPos < aStr.Len() )
//STRIP001 						--nPos;
//STRIP001 
//STRIP001 					String sVar( aStr.Copy( nStt, nPos - nStt ));
//STRIP001 					if( !::binfilter::FindOperator( sVar ) &&
//STRIP001 						(::Find( sVar, aCalc.GetVarTable(),TBLSZ) ||
//STRIP001 						 aCalc.VarLook( sVar )) )
//STRIP001 					{
//STRIP001 						if( !bValidFlds )
//STRIP001 						{
//STRIP001 							GetDoc()->FldsToCalc( aCalc,
//STRIP001 												  pStart->nNode.GetIndex(),
//STRIP001 												  pStart->nContent.GetIndex() );
//STRIP001 							bValidFlds = TRUE;
//STRIP001 						}
//STRIP001 						(( aFormel += '(' ) +=
//STRIP001 								aCalc.GetStrResult( aCalc.VarLook( sVar )
//STRIP001 														->nValue )) += ')';
//STRIP001 					}
//STRIP001 					else
//STRIP001 						aFormel += sVar;
//STRIP001 				}
//STRIP001 				else
//STRIP001 					aFormel += ch;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	} while( pPaMLast != (pPaM = (SwPaM*)pPaM->GetNext()) );
//STRIP001 
//STRIP001 	return aCalc.GetStrResult( aCalc.Calculate(aFormel) );
//STRIP001 }


//STRIP001 SvxLinkManager& SwEditShell::GetLinkManager()
//STRIP001 {
//STRIP001 	return pDoc->GetLinkManager();
//STRIP001 }


//STRIP001 void *SwEditShell::GetIMapInventor() const
//STRIP001 {
//STRIP001 	//Als eindeutige Identifikation sollte der Node, auf dem der Crsr steht
//STRIP001 	//genuegen.
//STRIP001 	return (void*)GetCrsr()->GetNode();
//STRIP001 }


//STRIP001 Graphic SwEditShell::GetIMapGraphic( BOOL bWait ) const
//STRIP001 {
//STRIP001 	//Liefert immer eine Graphic, wenn der Crsr in einem Fly steht.
//STRIP001 	SET_CURR_SHELL( (ViewShell*)this );
//STRIP001 	Graphic aRet;
//STRIP001 	SwPaM* pCrsr = GetCrsr();
//STRIP001 	if ( !pCrsr->HasMark() )
//STRIP001 	{
//STRIP001 		SwNode *pNd =pCrsr->GetNode();
//STRIP001 		if( pNd->IsGrfNode() )
//STRIP001 		{
//STRIP001 			const Graphic& rGrf = ((SwGrfNode*)pNd)->GetGrf();
//STRIP001 			if( rGrf.IsSwapOut() || ( ((SwGrfNode*)pNd)->IsLinkedFile() &&
//STRIP001 									GRAPHIC_DEFAULT == rGrf.GetType() ) )
//STRIP001 			{
//STRIP001 #ifndef PRODUCT
//STRIP001 				ASSERT( ((SwGrfNode*)pNd)->SwapIn( bWait )||!bWait, "Grafik konnte nicht geladen werden" );
//STRIP001 #else
//STRIP001 				((SwGrfNode*)pNd)->SwapIn( bWait );
//STRIP001 #endif
//STRIP001 			}
//STRIP001 			aRet = rGrf;
//STRIP001 		}
//STRIP001 		else if ( pNd->IsOLENode() )
//STRIP001 		{
//STRIP001 			GDIMetaFile aMtf;
//STRIP001 			aRet = GetOLEObj()->GetGDIMetaFile( aMtf );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aRet = pNd->GetCntntNode()->GetFrm()->FindFlyFrm()->
//STRIP001 								GetFmt()->MakeGraphic();
//STRIP001 	}
//STRIP001 	return aRet;
//STRIP001 }


//STRIP001 BOOL SwEditShell::InsertURL( const SwFmtINetFmt& rFmt, const String& rStr, BOOL bKeepSelection )
//STRIP001 {
//STRIP001 	// URL und Hinweistext (direkt oder via Selektion) notwendig
//STRIP001 	if( !rFmt.GetValue().Len() ||	( !rStr.Len() && !HasSelection() ) )
//STRIP001 		return FALSE;
//STRIP001 	StartAllAction();
//STRIP001 	GetDoc()->StartUndo( UIUNDO_INSERT_URLTXT);
//STRIP001 	BOOL bInsTxt = TRUE;
//STRIP001 
//STRIP001 	if( rStr.Len() )
//STRIP001 	{
//STRIP001 		SwPaM* pCrsr = GetCrsr();
//STRIP001 		if( pCrsr->HasMark() && *pCrsr->GetPoint() != *pCrsr->GetMark() )
//STRIP001 		{
//STRIP001 			// Selection vorhanden, MehrfachSelektion?
//STRIP001 			BOOL bDelTxt = TRUE;
//STRIP001 			if( pCrsr->GetNext() == pCrsr )
//STRIP001 			{
//STRIP001 				// einfach Selection -> Text ueberpruefen
//STRIP001 				String sTxt( GetSelTxt() );
//STRIP001 				sTxt.EraseTrailingChars();
//STRIP001 				if( sTxt == rStr )
//STRIP001 					bDelTxt = bInsTxt = FALSE;
//STRIP001 			}
//STRIP001 			else if( rFmt.GetValue() == rStr )		// Name und URL gleich?
//STRIP001 				bDelTxt = bInsTxt = FALSE;
//STRIP001 
//STRIP001 			if( bDelTxt )
//STRIP001 				Delete();
//STRIP001 		}
//STRIP001 		else if( pCrsr->GetNext() != pCrsr && rFmt.GetValue() == rStr )
//STRIP001 			bInsTxt = FALSE;
//STRIP001 
//STRIP001 		if( bInsTxt )
//STRIP001 		{
//STRIP001 			Insert( rStr );
//STRIP001 			SetMark();
//STRIP001 			ExtendSelection( FALSE, rStr.Len() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		bInsTxt = FALSE;
//STRIP001 
//STRIP001 	SetAttr( rFmt );
//STRIP001 	if (bInsTxt && !IsCrsrPtAtEnd())
//STRIP001 		SwapPam();
//STRIP001 	if(!bKeepSelection)
//STRIP001 		ClearMark();
//STRIP001 	if( bInsTxt )
//STRIP001 		DontExpandFmt();
//STRIP001 	GetDoc()->EndUndo( UIUNDO_INSERT_URLTXT );
//STRIP001 	EndAllAction();
//STRIP001 	return TRUE;
//STRIP001 }


//STRIP001 USHORT SwEditShell::GetINetAttrs( SwGetINetAttrs& rArr )
//STRIP001 {
//STRIP001 	if( rArr.Count() )
//STRIP001 		rArr.DeleteAndDestroy( 0, rArr.Count() );
//STRIP001 
//STRIP001 	const SwTxtNode* pTxtNd;
//STRIP001 	const SwCharFmts* pFmts = GetDoc()->GetCharFmts();
//STRIP001 	for( USHORT n = pFmts->Count(); 1 < n; )
//STRIP001 	{
//STRIP001 		SwClientIter aIter( *(*pFmts)[  --n ] );
//STRIP001 
//STRIP001 		for( SwClient* pFnd = aIter.First(TYPE( SwTxtINetFmt ));
//STRIP001 				pFnd; pFnd = aIter.Next() )
//STRIP001 			if( 0 != ( pTxtNd = ((SwTxtINetFmt*)pFnd)->GetpTxtNode()) &&
//STRIP001 				pTxtNd->GetNodes().IsDocNodes() )
//STRIP001 			{
//STRIP001 				SwTxtINetFmt& rAttr = *(SwTxtINetFmt*)pFnd;
//STRIP001 				String sTxt( pTxtNd->GetExpandTxt( *rAttr.GetStart(),
//STRIP001 									*rAttr.GetEnd() - *rAttr.GetStart() ) );
//STRIP001 
//STRIP001 				sTxt.EraseAllChars( 0x0a );
//STRIP001 				sTxt.EraseLeadingChars().EraseTrailingChars();
//STRIP001 
//STRIP001 				if( sTxt.Len() )
//STRIP001 				{
//STRIP001 					SwGetINetAttr* pNew = new SwGetINetAttr( sTxt, rAttr );
//STRIP001 					rArr.C40_INSERT( SwGetINetAttr, pNew, rArr.Count() );
//STRIP001 				}
//STRIP001 			}
//STRIP001 	}
//STRIP001 	return rArr.Count();
//STRIP001 }


	// ist der Cursor in eine INetAttribut, dann wird das komplett
	// geloescht; inclusive des Hinweistextes (wird beim Drag&Drop gebraucht)
//STRIP001 BOOL SwEditShell::DelINetAttrWithText()
//STRIP001 {
//STRIP001 	BOOL bRet = SelectTxtAttr( RES_TXTATR_INETFMT );
//STRIP001 	if( bRet )
//STRIP001 		DeleteSel( *GetCrsr() );
//STRIP001 	return bRet;
//STRIP001 }


// setzen an den Textzeichenattributen das DontExpand-Flag
//STRIP001 BOOL SwEditShell::DontExpandFmt()
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	if( !IsTableMode() && GetDoc()->DontExpandFmt( *GetCrsr()->GetPoint() ))
//STRIP001 	{
//STRIP001 		bRet = TRUE;
//STRIP001 		CallChgLnk();
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }


//STRIP001 SvNumberFormatter* SwEditShell::GetNumberFormatter()
//STRIP001 {
//STRIP001 	return GetDoc()->GetNumberFormatter();
//STRIP001 }


//STRIP001 void SwEditShell::Summary( SwDoc* pExtDoc, BYTE nLevel, BYTE nPara, BOOL bImpress )
//STRIP001 {
//STRIP001 	GetDoc()->Summary( pExtDoc, nLevel, nPara, bImpress );
//STRIP001 }

//STRIP001 BOOL SwEditShell::RemoveInvisibleContent()
//STRIP001 {
//STRIP001 	StartAllAction();
//STRIP001 	BOOL bRet = GetDoc()->RemoveInvisibleContent();
//STRIP001 	EndAllAction();
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 BOOL SwEditShell::EmbedAllLinks()
//STRIP001 {
//STRIP001 	StartAllAction();
//STRIP001 	BOOL bRet = GetDoc()->EmbedAllLinks();
//STRIP001 	EndAllAction();
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 USHORT SwEditShell::GetLineCount( BOOL bActPos )
//STRIP001 {
//STRIP001 	USHORT nRet = 0;
//STRIP001 	CalcLayout();
//STRIP001 	SwPaM* pPam = GetCrsr();
//STRIP001 	SwNodeIndex& rPtIdx = pPam->GetPoint()->nNode;
//STRIP001 	SwNodeIndex aStart( rPtIdx );
//STRIP001 	SwCntntNode* pCNd;
//STRIP001 	SwCntntFrm *pCntFrm;
//STRIP001 	ULONG nTmpPos;
//STRIP001 
//STRIP001 	if( !bActPos )
//STRIP001 		aStart = 0;
//STRIP001 	else if( rPtIdx > ( nTmpPos = GetDoc()->GetNodes().GetEndOfExtras().GetIndex()) )
//STRIP001 		// BodyBereich => Start ist EndOfIcons + 1
//STRIP001 		aStart = nTmpPos + 1;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if( 0 != ( pCNd = pPam->GetCntntNode() ) &&
//STRIP001 			0 != ( pCntFrm = pCNd->GetFrm() ) )
//STRIP001 		{
//STRIP001 			const SwStartNode *pTmp;
//STRIP001 			if( pCntFrm->IsInFly() )						// Fly
//STRIP001 				pTmp = pCNd->FindFlyStartNode();
//STRIP001 			else if( pCntFrm->IsInFtn() )					// Footnote
//STRIP001 				pTmp = pCNd->FindFootnoteStartNode();
//STRIP001 			else
//STRIP001 			{												// Footer/Header
//STRIP001 				const USHORT nTyp = FRM_HEADER | FRM_FOOTER;
//STRIP001 				SwFrm* pFrm = pCntFrm;
//STRIP001 				while( pFrm && !(pFrm->GetType() & nTyp) )
//STRIP001 					pFrm = pFrm->GetUpper();
//STRIP001 				ASSERT( pFrm, "Wo bin ich?" );
//STRIP001 				if( pFrm && ( pFrm->GetType() & FRM_FOOTER ) )
//STRIP001 					pTmp = pCNd->FindFooterStartNode();
//STRIP001 				else
//STRIP001 					pTmp = pCNd->FindHeaderStartNode();
//STRIP001 			}
//STRIP001 			ASSERT( pTmp, "Missing StartNode" );
//STRIP001 			aStart  = *pTmp;
//STRIP001 		}
//STRIP001 		ASSERT( pCNd && pCntFrm, "Missing Layout-Information" );
//STRIP001 	}
//STRIP001 
//STRIP001 	while( 0 != ( pCNd = GetDoc()->GetNodes().GoNextSection(
//STRIP001 				&aStart, TRUE, FALSE )) && ( !bActPos || aStart <= rPtIdx ) )
//STRIP001 	{
//STRIP001 		if( 0 != ( pCntFrm = pCNd->GetFrm() ) && pCntFrm->IsTxtFrm() )
//STRIP001 		{
//STRIP001 			xub_StrLen nActPos = bActPos && aStart == rPtIdx ?
//STRIP001 				pPam->GetPoint()->nContent.GetIndex() : USHRT_MAX;
//STRIP001 			nRet += ((SwTxtFrm*)pCntFrm)->GetLineCount( nActPos );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 }

//STRIP001 long SwEditShell::CompareDoc( const SwDoc& rDoc )
//STRIP001 {
//STRIP001 	StartAllAction();
//STRIP001 	long nRet = GetDoc()->CompareDoc( rDoc );
//STRIP001 	EndAllAction();
//STRIP001 	return nRet;
//STRIP001 }

//STRIP001 long SwEditShell::MergeDoc( const SwDoc& rDoc )
//STRIP001 {
//STRIP001 	StartAllAction();
//STRIP001 	long nRet = GetDoc()->MergeDoc( rDoc );
//STRIP001 	EndAllAction();
//STRIP001 	return nRet;
//STRIP001 }


//STRIP001 const SwFtnInfo& SwEditShell::GetFtnInfo() const
//STRIP001 {
//STRIP001 	return GetDoc()->GetFtnInfo();
//STRIP001 }

//STRIP001 void SwEditShell::SetFtnInfo(const SwFtnInfo& rInfo)
//STRIP001 {
//STRIP001 	StartAllAction();
//STRIP001 	SET_CURR_SHELL( this );
//STRIP001 	GetDoc()->SetFtnInfo(rInfo);
//STRIP001 	CallChgLnk();
//STRIP001 	EndAllAction();
//STRIP001 }

//STRIP001 const SwEndNoteInfo& SwEditShell::GetEndNoteInfo() const
//STRIP001 {
//STRIP001 	return GetDoc()->GetEndNoteInfo();
//STRIP001 }

//STRIP001 void SwEditShell::SetEndNoteInfo(const SwEndNoteInfo& rInfo)
//STRIP001 {
//STRIP001 	StartAllAction();
//STRIP001 	SET_CURR_SHELL( this );
//STRIP001 	GetDoc()->SetEndNoteInfo(rInfo);
//STRIP001 	EndAllAction();
//STRIP001 }

//STRIP001 const SwLineNumberInfo& SwEditShell::GetLineNumberInfo() const
//STRIP001 {
//STRIP001 	return GetDoc()->GetLineNumberInfo();
//STRIP001 }

//STRIP001 void SwEditShell::SetLineNumberInfo(const SwLineNumberInfo& rInfo)
//STRIP001 {
//STRIP001 	StartAllAction();
//STRIP001 	SET_CURR_SHELL( this );
//STRIP001 	GetDoc()->SetLineNumberInfo(rInfo);
//STRIP001 	AddPaintRect( GetLayout()->Frm() );
//STRIP001 	EndAllAction();
//STRIP001 }

//STRIP001 BOOL SwEditShell::GenerateHTMLDoc( const String& rPath,
//STRIP001 								const SwTxtFmtColl* pSplitColl )
//STRIP001 {
//STRIP001 	SwWait aWait( *GetDoc()->GetDocShell(), TRUE );
//STRIP001 	return GetDoc()->GenerateHTMLDoc( rPath, pSplitColl );
//STRIP001 }

//STRIP001 USHORT SwEditShell::GetLinkUpdMode(BOOL bDocSettings) const
//STRIP001 {
//STRIP001 	return bDocSettings ? GetDoc()->_GetLinkUpdMode(): GetDoc()->GetLinkUpdMode();
//STRIP001 }

//STRIP001 void SwEditShell::SetLinkUpdMode( USHORT nMode )
//STRIP001 {
//STRIP001 	GetDoc()->SetLinkUpdMode( nMode );
//STRIP001 }


// Schnittstelle fuer die TextInputDaten - ( fuer die Texteingabe
// von japanischen/chinesischen Zeichen)
//STRIP001 SwExtTextInput* SwEditShell::CreateExtTextInput()
//STRIP001 {
//STRIP001 	SwExtTextInput* pRet = GetDoc()->CreateExtTextInput( *GetCrsr() );
//STRIP001 	pRet->SetOverwriteCursor( SwCrsrShell::IsOverwriteCrsr() );
//STRIP001 	return pRet;
//STRIP001 }

//STRIP001 String SwEditShell::DeleteExtTextInput( SwExtTextInput* pDel, BOOL bInsText )
//STRIP001 {
//STRIP001 	if( !pDel )
//STRIP001 	{
//STRIP001 		const SwPosition& rPos = *GetCrsr()->GetPoint();
//STRIP001 		pDel = GetDoc()->GetExtTextInput( rPos.nNode.GetNode(),
//STRIP001 										  rPos.nContent.GetIndex() );
//STRIP001 		if( !pDel )
//STRIP001 		{
//STRIP001 			//JP 25.10.2001: under UNIX the cursor is moved before the Input-
//STRIP001 			//				Engine event comes in. So take any - normally there
//STRIP001 			//				exist only one at the time. -- Task 92016
//STRIP001 			pDel = GetDoc()->GetExtTextInput();
//STRIP001 		}
//STRIP001 	}
//STRIP001     String sRet;
//STRIP001 	if( pDel )
//STRIP001 	{
//STRIP001         ::rtl::OUString sTmp;
//STRIP001         SwXTextCursor::getTextFromPam(*pDel, sTmp);
//STRIP001         sRet = sTmp;
//STRIP001         SET_CURR_SHELL( this );
//STRIP001 		StartAllAction();
//STRIP001 		pDel->SetInsText( bInsText );
//STRIP001 		SetOverwriteCrsr( pDel->IsOverwriteCursor() );
//STRIP001     	const SwPosition aPos( *pDel->GetPoint() );
//STRIP001 		GetDoc()->DeleteExtTextInput( pDel );
//STRIP001 
//STRIP001         // In this case, the "replace" function did not set the cursor
//STRIP001         // to the original position. Therefore we have to do this manually.
//STRIP001         if ( ! bInsText && IsOverwriteCrsr() )
//STRIP001             *GetCrsr()->GetPoint() = aPos;
//STRIP001 
//STRIP001 		EndAllAction();
//STRIP001 	}
//STRIP001     return sRet;
//STRIP001 }

//STRIP001 #ifdef USED
//STRIP001 SwExtTextInput* SwEditShell::GetExtTextInput() const
//STRIP001 {
//STRIP001 	const SwPosition& rPos = *GetCrsr()->GetPoint();
//STRIP001 	return GetDoc()->GetExtTextInput( rPos.nNode.GetNode(),
//STRIP001 										 rPos.nContent.GetIndex() );
//STRIP001 }
//STRIP001 #endif

//STRIP001 void SwEditShell::SetExtTextInputData( const CommandExtTextInputData& rData )
//STRIP001 {
//STRIP001 	const SwPosition& rPos = *GetCrsr()->GetPoint();
//STRIP001 	SwExtTextInput* pInput = GetDoc()->GetExtTextInput( rPos.nNode.GetNode()
//STRIP001 												/*, rPos.nContent.GetIndex()*/ );
//STRIP001 	if( pInput )
//STRIP001 	{
//STRIP001 		StartAllAction();
//STRIP001 		SET_CURR_SHELL( this );
//STRIP001 
//STRIP001 		if( !rData.IsOnlyCursorChanged() )
//STRIP001 			pInput->SetInputData( rData );
//STRIP001 		// Cursor positionieren:
//STRIP001 		const SwPosition& rStt = *pInput->Start();
//STRIP001 		xub_StrLen nNewCrsrPos = rStt.nContent.GetIndex() + rData.GetCursorPos();
//STRIP001 
//STRIP001 		// zwar unschoen aber was hilfts
//STRIP001 		ShowCrsr();
//STRIP001 		long nDiff = nNewCrsrPos - rPos.nContent.GetIndex();
//STRIP001 		if( 0 > nDiff )
//STRIP001 			Left( (xub_StrLen)-nDiff, CRSR_SKIP_CHARS );
//STRIP001 		else if( 0 < nDiff )
//STRIP001 			Right( (xub_StrLen)nDiff, CRSR_SKIP_CHARS );
//STRIP001 
//STRIP001 		SetOverwriteCrsr( rData.IsCursorOverwrite() );
//STRIP001 
//STRIP001 		EndAllAction();
//STRIP001 
//STRIP001 		if( !rData.IsCursorVisible() )	// must be called after the EndAction
//STRIP001 			HideCrsr();
//STRIP001 	}
//STRIP001 }


//STRIP001 void SwEditShell::TransliterateText( sal_uInt32 nType )
//STRIP001 {
//STRIP001 	utl::TransliterationWrapper aTrans(
//STRIP001 						::legacy_binfilters::getLegacyProcessServiceFactory(), nType );
//STRIP001 	StartAllAction();
//STRIP001 	SET_CURR_SHELL( this );
//STRIP001 
//STRIP001 	SwPaM* pCrsr = GetCrsr();
//STRIP001 	if( pCrsr->GetNext() != pCrsr )
//STRIP001 	{
//STRIP001 		GetDoc()->StartUndo();
//STRIP001 		FOREACHPAM_START( this )
//STRIP001 
//STRIP001 		if( PCURCRSR->HasMark() )
//STRIP001 			GetDoc()->TransliterateText( *PCURCRSR, aTrans );
//STRIP001 
//STRIP001 		FOREACHPAM_END()
//STRIP001 		GetDoc()->EndUndo();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		GetDoc()->TransliterateText( *pCrsr, aTrans );
//STRIP001 
//STRIP001 	EndAllAction();
//STRIP001 }

}
