# Copyright (C) 2000-2001 The OpenRPG Project
#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: mapper/whiteboard_hander.py
# Author: OpenRPG Team
# Maintainer:
# Version:
#   $Id: whiteboard_handler.py,v 1.17 2003/11/21 11:47:14 digitalxero Exp $
#
# Description: Whiteboard layer handler
#
__version__ = "$Id: whiteboard_handler.py,v 1.17 2003/11/21 11:47:14 digitalxero Exp $"



from base_handler import *

DELETE_ALL_LINES= wxNewId()
LINE_REMOVE = wxNewId()
LINE_TITLE_HACK = wxNewId()
LINE_COLOR = wxNewId()
LINE_WIDTH = wxNewId()

#drawing modes (added by Snowdog 05-09-2003)
DRAW_MODE = wxNewId()
DRAW_FREEFORM = 1
DRAW_POLYLINE = 2
POLYLINE_END_TOLERANCE = 5
LIVE_REFRESH = wxNewId()
LIVE_POLYLINE_DEFAULT = 1

class whiteboard_handler(base_layer_handler):
    def __init__(self, parent, id, canvas):
        self.drawing_mode = DRAW_FREEFORM
        self.line_string = "0,0;"
        self.drawing = false
        self.upperleft = wxPoint(0,0)
        self.lowerright = wxPoint(0,0)

        #polyline drawing vars
        self.polypoints = 0
        self.lastpoint = None


        #self.r_h = RGBHex()
        base_layer_handler.__init__(self, parent, id, canvas)

    def build_ctrls(self):
        base_layer_handler.build_ctrls(self)
        self.color_button = wxButton(self, LINE_COLOR, "Pen Color", style=wxBU_EXACTFIT)
        self.drawmode_ctrl = wxChoice(self, DRAW_MODE, choices = ["Freeform", "Polyline"])
        self.drawmode_ctrl.SetSelection(0) #always start showing "Freeform"
        self.live_refresh = wxCheckBox(self, LIVE_REFRESH, " Live Refresh")
        self.live_refresh.SetValue(LIVE_POLYLINE_DEFAULT)
        self.color_button.SetBackgroundColour(wxBLACK)
        self.color_button.SetForegroundColour(wxWHITE)
        dwidthList=['1','2','3','4','5','6','7','8','9','10']
        self.widthList=wxChoice(self,LINE_WIDTH,size=wxSize(40, 20),choices=dwidthList, name="choice")
	self.widthList.SetSelection(0) #always start showing "1"

        self.sizer.Prepend(20,25,1)
        self.sizer.Prepend(self.color_button, 0, wxEXPAND)
        self.sizer.Prepend(20,25)
        self.sizer.Prepend(self.live_refresh, 0, wxEXPAND)
        self.sizer.Prepend(10,25)
        self.sizer.Prepend(self.drawmode_ctrl, 0, wxEXPAND)
        self.sizer.Prepend(wxStaticText(self, -1, "Drawing Mode: "),0,wxALIGN_CENTER)
        self.sizer.Prepend(10,25)
	self.sizer.Prepend(self.widthList, 0, wxEXPAND)
	self.sizer.Prepend(wxStaticText(self, -1, "Line Width: "),0,wxALIGN_CENTER)

        EVT_BUTTON(self, LINE_COLOR, self.on_pen_color)
        EVT_CHOICE(self, LINE_WIDTH, self.on_pen_width)

    def build_menu(self,label = "Whiteboard"):
        base_layer_handler.build_menu(self,label)
        self.main_menu.AppendSeparator()
        self.main_menu.Append(LINE_COLOR,"&Change Pen Color")
        self.main_menu.Append(DELETE_ALL_LINES,"Delete &All Lines")
        EVT_MENU(self.canvas,LINE_COLOR,self.on_pen_color)
        EVT_MENU(self.canvas,DELETE_ALL_LINES,self.delete_all_lines)

        self.line_menu = wxMenu()
        if wxPlatform == '__WXMSW__':
            self.line_menu.SetTitle(label)
        else:
            self.line_menu.Append(LINE_TITLE_HACK,label)
            self.line_menu.AppendSeparator()

        self.line_menu.Append(LINE_REMOVE,"&Remove")
        EVT_MENU(self.canvas, LINE_REMOVE, self.on_line_menu_item)

    def do_line_menu(self,pos):
        self.canvas.PopupMenu(self.line_menu, pos)

    def on_right_down(self,evt):
        line = 0
        scale = self.canvas.layers['grid'].mapscale
        dc = wxClientDC(self.canvas)
        self.canvas.PrepareDC(dc)
        dc.SetUserScale(scale,scale)
        pos = evt.GetLogicalPosition(dc)
        line_list = self.canvas.layers['whiteboard'].find_line(pos)
        if line_list:
            self.sel_rline = self.canvas.layers['whiteboard'].get_line_by_id(line_list.id)
            if self.sel_rline:
                self.do_line_menu(evt.GetPosition())
                self.canvas.Refresh(false)
        else:
            base_layer_handler.on_right_down(self,evt)
        del dc

    def on_pen_color(self,evt):
        data = wxColourData()
        data.SetChooseFull(true)
        dlg = wxColourDialog(self.canvas, data)
        if dlg.ShowModal() == wxID_OK:
            data = dlg.GetColourData()
            color = data.GetColour()
            self.canvas.layers['whiteboard'].setcolor(color)
            self.color_button.SetBackgroundColour(color)
        dlg.Destroy()

    def on_pen_width(self,evt):
        width = int(self.widthList.GetStringSelection())
        #print width
        self.canvas.layers['whiteboard'].setwidth(width)

    def delete_all_lines(self,evt):
        session = self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM) and (session.use_roles()):
            self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be a GM to use this feature")
            return
        for m in range(len(self.canvas.layers['whiteboard'].lines)):
            self.canvas.layers['whiteboard'].del_line(self.canvas.layers['whiteboard'].lines[0])

    def on_line_menu_item(self,evt):
        id = evt.GetId()
        if id == LINE_REMOVE:
            self.canvas.layers['whiteboard'].del_line(self.sel_rline)
            self.send_map_data



    # Check Draw Mode
    # Queries the GUI to see what mode to draw in
    # 05-09-2003 Snowdog
    def check_draw_mode(self):
#        print str(self.drawmode_ctrl.GetSelection())
        if self.drawmode_ctrl.GetSelection() == 0:
            self.drawing_mode = DRAW_FREEFORM
        elif self.drawmode_ctrl.GetSelection() == 1:
            self.drawing_mode = DRAW_POLYLINE

        #because mode can be changed while a polyline is being created
        #clear the current linestring and reset the polyline data
        self.upperleft.x = self.upperleft.y = 0
        self.lowerright.x = self.lowerright.y = 0
        self.lastpoint = None #becuase the end check function is not called we must force its lastpoint var to None again
        self.polypoints = 0
        self.line_string = "0,0;"



    # Altered on_left_up to toggle between
    # drawing modes freeform vs polyline
    # 05-09-2003  Snowdog
    def on_left_down(self,evt):
        if self.drawing == false: self.check_draw_mode()
        if self.drawing_mode == DRAW_FREEFORM:
            #Freeform mode ignores the inital down click
            pass
        elif self.drawing_mode == DRAW_POLYLINE:
            self.polyline_add_point( evt )



    # Added handling for double clicks within the map
    # 05-09-2003  Snowdog
    def on_left_dclick(self, evt):
        if self.drawing_mode == DRAW_FREEFORM:
            #Freeform mode ignores the double click
            pass
        elif self.drawing_mode == DRAW_POLYLINE:
            self.polyline_last_point( evt )



    # Altered on_left_up to toggle between
    # drawing modes freeform vs polyline
    # 05-09-2003  Snowdog
    def on_left_up(self,evt):
        if self.drawing_mode == DRAW_FREEFORM:
            self.on_freeform_left_up(evt)
        elif self.drawing_mode == DRAW_POLYLINE:
            #Polyline mode relies on the down click
            #not the mouse button release
            pass



    # Altered on_left_up to toggle between
    # drawing modes freeform vs polyline
    # 05-09-2003  Snowdog
    def on_motion(self,evt):
        if self.drawing_mode == DRAW_FREEFORM:
            self.freeform_motion(evt)
        elif self.drawing_mode == DRAW_POLYLINE:
            self.polyline_preview( evt )



    # Polyline Add Point
    # adds a new point to the polyline
    # 05-09-2003  Snowdog
    def polyline_add_point(self, evt):

        scale = self.canvas.layers['grid'].mapscale
        dc = wxClientDC( self.canvas )
        self.canvas.PrepareDC( dc )
        dc.SetUserScale(scale,scale)
        pos = evt.GetLogicalPosition(dc)

        #reset the bounding points
        if pos.x < self.upperleft.x:
            self.upperleft.x = pos.x
        elif pos.x > self.lowerright.x:
            self.lowerright.x = pos.x

        if pos.y < self.upperleft.y:
            self.upperleft.y = pos.y
        elif pos.y > self.lowerright.y:
            self.lowerright.y = pos.y

        #if this point doens't end the line
        #add a new point into the line string
        if not self.polyline_end_check( pos ):
            if self.drawing == true:
                self.polypoints += 1 #add one to the point counter.
                self.line_string += `pos.x` + "," + `pos.y` + ";"
                self.canvas.layers['whiteboard'].draw_working_line(dc,self.line_string)

            else: #start of line...
                self.polypoints += 1 #add one to the point counter.
                self.line_string = `pos.x` + "," + `pos.y` + ";"
                self.upperleft.x = pos.x
                self.upperleft.y = pos.y
                self.lowerright.x = pos.x
                self.lowerright.y = pos.y
                self.drawing = true
        else: #end of line. Send and reset vars for next line
            self.drawing = false

            if self.polypoints < 2:
                #not enough points to form a line. Ignore line
                pass
            else:
                #have enough points to create valid line
                #check to role to make sure user can draw at all....
                session = self.canvas.frame.session
                if (session.my_role() <> session.ROLE_GM) and (session.my_role()<>session.ROLE_PLAYER) and (session.use_roles()):
                    self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be either a player or GM to use this feature")
                    self.canvas.Refresh(false)
                else:
                    #user allowed to draw on whiteboard.. send polyline
                    self.canvas.layers['whiteboard'].add_line(self.line_string,self.upperleft,self.lowerright)

            #resetting variables for next line
            self.upperleft.x = self.upperleft.y = 0
            self.lowerright.x = self.lowerright.y = 0
            self.polypoints = 0
            self.line_string = "0,0;"




    # Polyline Last Point
    # adds a final point to the polyline and ends it
    # 05-09-2003  Snowdog
    def polyline_last_point(self, evt):

        #if we haven't started a line already. Ignore the click
        if self.drawing != true:
            return

        scale = self.canvas.layers['grid'].mapscale
        dc = wxClientDC( self.canvas )
        self.canvas.PrepareDC( dc )
        dc.SetUserScale(scale,scale)
        pos = evt.GetLogicalPosition(dc)

        #reset the bounding points
        if pos.x < self.upperleft.x:
            self.upperleft.x = pos.x
        elif pos.x > self.lowerright.x:
            self.lowerright.x = pos.x

        if pos.y < self.upperleft.y:
            self.upperleft.y = pos.y
        elif pos.y > self.lowerright.y:
            self.lowerright.y = pos.y


        self.polypoints += 1 #add one to the point counter.
        self.line_string += `pos.x` + "," + `pos.y` + ";"
        self.canvas.layers['whiteboard'].draw_working_line(dc,self.line_string)

        #end of line. Send and reset vars for next line
        self.drawing = false

        if self.polypoints < 2:
            #not enough points to form a line. Ignore line
            pass
        else:
            #have enough points to create valid line
            #check to role to make sure user can draw at all....
            session = self.canvas.frame.session
            if (session.my_role() <> session.ROLE_GM) and (session.my_role()<>session.ROLE_PLAYER) and (session.use_roles()):
                self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be either a player or GM to use this feature")
                self.canvas.Refresh(false)
            else:
                #user allowed to draw on whiteboard.. send polyline
                self.canvas.layers['whiteboard'].add_line(self.line_string,self.upperleft,self.lowerright)

        #resetting variables for next line
        self.upperleft.x = self.upperleft.y = 0
        self.lowerright.x = self.lowerright.y = 0
        self.lastpoint = None #becuase the end check function is not called we must force its lastpoint var to None again
        self.polypoints = 0
        self.line_string = "0,0;"




    # Polyline End Check
    # checks to see if a double click has occured
    # a second click on the LAST polyline point
    # (or very close proximity) should cause the
    # polyline even to complete and send
    # 05-09-2003  Snowdog
    def polyline_end_check(self, pos):
        # check to see if the position of the give point is within POLYLINE_END_TOLERANCE
        # if it is then the line has been completed and should be sent to the map just like
        # the original freeform version is. A line with fewer than 2 points should be ignored
        x_in = y_in = 0
        tol = POLYLINE_END_TOLERANCE

        #first point check
        if type(self.lastpoint) == type(None):
            self.lastpoint = wxPoint(pos.x,pos.y)
            return 0 #not end of line


        if ((self.lastpoint.x -tol) <= pos.x <= (self.lastpoint.x)):
            x_in = 1

        if ((self.lastpoint.y -tol) <= pos.y <= (self.lastpoint.y)):
            y_in = 1

        if x_in and y_in:
            #point within tolerance. End line
            self.lastpoint = None
            return 1

        #if we've reached here the point is NOT a terminal point. Reset the lastpoint and return false
        self.lastpoint.x = pos.x
        self.lastpoint.y = pos.y
        return 0



    # Polyline Preview
    # display a temporary/momentary line to the user
    # from the last point to mouse position
    # 05-09-2003  Snowdog
    def polyline_preview(self, evt):
        if self.drawing != true:
            #not enough points to form a line. Ignore line
            return

        if self.live_refresh.GetValue() == 0:
            #not using live redraw
            return

        scale = self.canvas.layers['grid'].mapscale
        dc = wxClientDC( self.canvas )
        self.canvas.PrepareDC( dc )
        dc.SetUserScale(scale,scale)
        pos = evt.GetLogicalPosition(dc)

        #reset the bounding points
        if pos.x < self.upperleft.x:
            self.upperleft.x = pos.x
        elif pos.x > self.lowerright.x:
            self.lowerright.x = pos.x

        if pos.y < self.upperleft.y:
            self.upperleft.y = pos.y
        elif pos.y > self.lowerright.y:
            self.lowerright.y = pos.y

        #redraw the line with a line connected to the cursor
        temp_string = self.line_string
        temp_string += `pos.x` + "," + `pos.y` + ";"
        self.canvas.layers['whiteboard'].draw_working_line(dc,temp_string)
        self.canvas.Refresh(true)



    # moved original on_motion to this function
    # to allow alternate drawing method to be used
    # 05-09-2003  Snowdog
    def freeform_motion(self, evt):
        scale = self.canvas.layers['grid'].mapscale
        dc = wxClientDC( self.canvas )
        self.canvas.PrepareDC( dc )
        dc.SetUserScale(scale,scale)
        pos = evt.GetLogicalPosition(dc)
        if pos.x < self.upperleft.x:
            self.upperleft.x = pos.x
        elif pos.x > self.lowerright.x:
            self.lowerright.x = pos.x

        if pos.y < self.upperleft.y:
            self.upperleft.y = pos.y
        elif pos.y > self.lowerright.y:
            self.lowerright.y = pos.y

        if evt.m_leftDown:
            if self.drawing == true:
                self.line_string += `pos.x` + "," + `pos.y` + ";"
                self.canvas.layers['whiteboard'].draw_working_line(dc,self.line_string)
            else:
                self.line_string = `pos.x` + "," + `pos.y` + ";"
                self.upperleft.x = pos.x
                self.upperleft.y = pos.y
                self.lowerright.x = pos.x
                self.lowerright.y = pos.y
            self.drawing = true
        del dc


    # moved original on_left_up to this function
    # to allow alternate drawing method to be used
    # 05-09-2003  Snowdog
    def on_freeform_left_up(self,evt):
        if self.drawing == true:
            self.drawing = false
            session = self.canvas.frame.session
            if (session.my_role() <> session.ROLE_GM) and (session.my_role()<>session.ROLE_PLAYER) and (session.use_roles()):
                self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be either a player or GM to use this feature")
                self.canvas.Refresh(false)
                return
            #self.id +=1
            self.canvas.layers['whiteboard'].add_line(self.line_string,self.upperleft,self.lowerright)
            self.upperleft.x = self.upperleft.y = 0
            self.lowerright.x = self.lowerright.y = 0


