# Copyright (C) 2000-2001 The OpenRPG Project
#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: mapper/map_prop_dialog.py
# Author: OpenRPG
# Maintainer:
# Version:
#   $Id: map_prop_dialog.py,v 1.9 2004/05/11 03:31:27 markt1964 Exp $
#
# Description: 
#
__version__ = "$Id: map_prop_dialog.py,v 1.9 2004/05/11 03:31:27 markt1964 Exp $"


from orpg.orpg_windows import *
from background import *
from grid import *
from miniatures import *
from whiteboard import *

##-----------------------------
## map prop dialog
##-----------------------------

CTRL_WIDTH = wxNewId()

CTRL_HEIGHT = wxNewId()
CTRL_BG_COLOR = wxNewId()
CTRL_BG_COLOR_VALUE = wxNewId()
CTRL_TEXTURE = wxNewId()
CTRL_TEXTURE_PATH = wxNewId()
CTRL_IMAGE = wxNewId()
CTRL_IMAGE_PATH  = wxNewId()
CTRL_GRID = wxNewId()
CTRL_GRID_SNAP = wxNewId()
CTRL_GRID_COLOR = wxNewId()
CTRL_GRID_MODE_RECT = wxNewId()
CTRL_GRID_MODE_HEX = wxNewId()
CTRL_GRID_LINE_NONE = wxNewId()
CTRL_GRID_LINE_DOTTED = wxNewId()
CTRL_GRID_LINE_SOLID = wxNewId()


class general_map_prop_dialog(wxDialog):
    def __init__(self,parent,size,bg_layer,grid_layer):
        wxDialog.__init__(self,parent,-1,"General Map Properties",wxDefaultPosition,wxSize(425,405))

        self.size = size
        self.bg_layer = bg_layer
        self.grid_layer = grid_layer
        #build controls
        self.ctrls = {  CTRL_WIDTH : orpgTextCtrl(self, CTRL_WIDTH, str(size[0])),
                        CTRL_HEIGHT : orpgTextCtrl(self, CTRL_HEIGHT, str(size[1])),
                        CTRL_BG_COLOR : wxRadioButton(self, CTRL_BG_COLOR, "Color", style=wxRB_GROUP),
                        CTRL_BG_COLOR_VALUE : wxButton(self, CTRL_BG_COLOR_VALUE, "Color"),
                        CTRL_TEXTURE : wxRadioButton(self, CTRL_TEXTURE, "Texture"),
                        CTRL_TEXTURE_PATH: orpgTextCtrl(self, CTRL_TEXTURE_PATH,"http://"),
                        CTRL_IMAGE : wxRadioButton(self, CTRL_IMAGE, "Image"),
                        CTRL_IMAGE_PATH :orpgTextCtrl(self, CTRL_IMAGE_PATH,"http://"),
                        CTRL_GRID : orpgTextCtrl(self, CTRL_GRID),
                        CTRL_GRID_SNAP :wxCheckBox(self, CTRL_GRID_SNAP, " Snap to grid"),
                        CTRL_GRID_COLOR : wxButton(self, CTRL_GRID_COLOR, "Grid Color"),
                        CTRL_GRID_MODE_RECT : wxRadioButton(self, CTRL_GRID_MODE_RECT, "Rectangular", style=wxRB_GROUP),
                        CTRL_GRID_MODE_HEX : wxRadioButton(self, CTRL_GRID_MODE_HEX, "Hexagonal"),
                        CTRL_GRID_LINE_NONE : wxRadioButton(self, CTRL_GRID_LINE_NONE, "No Lines", style=wxRB_GROUP),
                        CTRL_GRID_LINE_DOTTED : wxRadioButton(self, CTRL_GRID_LINE_DOTTED, "Dotted Lines"),
                        CTRL_GRID_LINE_SOLID : wxRadioButton(self, CTRL_GRID_LINE_SOLID, "Solid Lines")
                     }
        # set values of bg controls
        self.ctrls[CTRL_BG_COLOR].SetValue(false)
        self.ctrls[CTRL_TEXTURE].SetValue(false)
        self.ctrls[CTRL_IMAGE].SetValue(false)

        # Begin ted's changes for map bg persistency.
        if bg_layer.bg_color != None:
          self.ctrls[CTRL_BG_COLOR_VALUE].SetBackgroundColour(bg_layer.bg_color)
        if bg_layer.img_path != None:
          self.ctrls[CTRL_TEXTURE_PATH].SetValue(bg_layer.img_path)
          self.ctrls[CTRL_IMAGE_PATH].SetValue(bg_layer.img_path)
        # End ted's changes
        
        if bg_layer.type == BG_COLOR:
            self.ctrls[CTRL_BG_COLOR].SetValue(true)
            # self.ctrls[CTRL_BG_COLOR_VALUE].SetBackgroundColour(bg_layer.bg_color)
        elif bg_layer.type == BG_TEXTURE:
            self.ctrls[CTRL_TEXTURE].SetValue(true)
            # self.ctrls[CTRL_TEXTURE_PATH].SetValue(bg_layer.img_path)
        elif bg_layer.type == BG_IMAGE:
            self.ctrls[CTRL_WIDTH].Enable(false)
            self.ctrls[CTRL_HEIGHT].Enable(false)
            self.ctrls[CTRL_IMAGE].SetValue(true)
            # self.ctrls[CTRL_IMAGE_PATH].SetValue(bg_layer.img_path)

        # set grid layer control values
        self.ctrls[CTRL_GRID].SetValue(str(grid_layer.unit_size))
        self.ctrls[CTRL_GRID_SNAP].SetValue(grid_layer.snap)
        self.ctrls[CTRL_GRID_COLOR].SetBackgroundColour(grid_layer.color)
        self.ctrls[CTRL_GRID_MODE_RECT].SetValue(grid_layer.mode == GRID_RECTANGLE)
        self.ctrls[CTRL_GRID_MODE_HEX].SetValue(grid_layer.mode == GRID_HEXAGON)
        self.ctrls[CTRL_GRID_LINE_NONE].SetValue(grid_layer.line == LINE_NONE)
        self.ctrls[CTRL_GRID_LINE_DOTTED].SetValue(grid_layer.line == LINE_DOTTED)
        self.ctrls[CTRL_GRID_LINE_SOLID].SetValue(grid_layer.line == LINE_SOLID)

        #create sizers
        csize = self.GetClientSizeTuple()
        sizers = {}
        sizers['size'] = wxBoxSizer(wxHORIZONTAL)
        sizers['bg'] = wxFlexGridSizer(3, 2,10,10)
        sizers['grid'] =  wxFlexGridSizer(2, 3,10,10)
        sizers['but'] = wxBoxSizer(wxHORIZONTAL)

        #size
        sizers['size'].Add(wxStaticText(self, -1, "Width: "),0,wxALIGN_CENTER)
        sizers['size'].Add(self.ctrls[CTRL_WIDTH],1,wxEXPAND)
        sizers['size'].Add(wxSize(20,25))
        sizers['size'].Add(wxStaticText(self, -1, "Height: "),0,wxALIGN_CENTER)
        sizers['size'].Add(self.ctrls[CTRL_HEIGHT],1,wxEXPAND)

        #bg
        wxStaticBox(self,-1,"Size",cmpPoint(10,5),wxSize(csize[0]-20,65))
        sizers['size'].SetDimension(100,25,200,25)

        sizers['bg'].AddMany([(self.ctrls[CTRL_BG_COLOR],0,wxEXPAND),
                              (self.ctrls[CTRL_BG_COLOR_VALUE],1,wxEXPAND),
                              (self.ctrls[CTRL_TEXTURE],0,wxEXPAND),
                              (self.ctrls[CTRL_TEXTURE_PATH],1,wxEXPAND),
                              (self.ctrls[CTRL_IMAGE],0,wxEXPAND),
                              (self.ctrls[CTRL_IMAGE_PATH],1,wxEXPAND)
                            ])
        sizers['bg'].AddGrowableCol(1)
        sizers['bg'].SetDimension(20,100,370,100)
        wxStaticBox(self,-1,"Background",cmpPoint(10,80),wxSize(csize[0]-20,140))


        #grid
        sizers['grid'].AddMany([(wxStaticText(self, -1, "Pixels per Square: "),2,wxALIGN_CENTER),
                              (self.ctrls[CTRL_GRID],1,wxEXPAND),
                              (self.ctrls[CTRL_GRID_COLOR],1,wxEXPAND),
                              (self.ctrls[CTRL_GRID_SNAP],2,wxEXPAND),
                              (self.ctrls[CTRL_GRID_MODE_RECT],1,wxEXPAND),
                              (self.ctrls[CTRL_GRID_MODE_HEX],1,wxEXPAND),
                              (self.ctrls[CTRL_GRID_LINE_NONE],1,wxEXPAND),
                              (self.ctrls[CTRL_GRID_LINE_DOTTED],1,wxEXPAND),
                              (self.ctrls[CTRL_GRID_LINE_SOLID],1,wxEXPAND)
                            ])

        sizers['grid'].SetDimension(40,250,350,90)
        wxStaticBox(self,-1,"Grid",cmpPoint(10,230),wxSize(csize[0]-20,115))


        # buttons
        sizers['but'].Add(wxButton(self, wxID_OK, "Apply"), 1, wxEXPAND)
        sizers['but'].Add(wxSize(10,10))
        sizers['but'].Add(wxButton(self, wxID_CANCEL, "Cancel"), 1, wxEXPAND)
        sizers['but'].SetDimension(10,csize[1]-30,csize[0]-20,25)
        self.sizers = sizers
        #event handlers
        EVT_BUTTON(self, wxID_OK, self.on_ok)
        EVT_RADIOBUTTON(self, CTRL_BG_COLOR, self.on_click)
        EVT_RADIOBUTTON(self, CTRL_TEXTURE, self.on_click)
        EVT_RADIOBUTTON(self, CTRL_IMAGE, self.on_click)
        EVT_BUTTON(self, CTRL_BG_COLOR_VALUE, self.on_click)
        EVT_BUTTON(self, CTRL_GRID_COLOR, self.on_click)
        EVT_RADIOBUTTON(self, CTRL_GRID_MODE_RECT, self.on_click)
        EVT_RADIOBUTTON(self, CTRL_GRID_MODE_HEX, self.on_click)
        EVT_RADIOBUTTON(self, CTRL_GRID_LINE_NONE, self.on_click)
        EVT_RADIOBUTTON(self, CTRL_GRID_LINE_DOTTED, self.on_click)
        EVT_RADIOBUTTON(self, CTRL_GRID_LINE_SOLID, self.on_click)

        self.SetSizer(self.sizers['size'])
        self.SetSizer(self.sizers['bg'])
        self.SetSizer(self.sizers['grid'])
        self.SetSizer(self.sizers['but'])
        self.SetSizer(None)

    def on_click(self,evt):
        id = evt.GetId()
        if id == CTRL_BG_COLOR or id == CTRL_TEXTURE:
            self.ctrls[CTRL_WIDTH].Enable(true)
            self.ctrls[CTRL_HEIGHT].Enable(true)
        elif id == CTRL_IMAGE:
            self.ctrls[CTRL_WIDTH].Enable(false)
            self.ctrls[CTRL_HEIGHT].Enable(false)
        elif id == CTRL_BG_COLOR_VALUE:
            data = wxColourData()
            data.SetChooseFull(true)
            dlg = wxColourDialog(self, data)
            if dlg.ShowModal() == wxID_OK:
                data = dlg.GetColourData()
                self.ctrls[CTRL_BG_COLOR_VALUE].SetBackgroundColour(data.GetColour())
            dlg.Destroy()
        elif id == CTRL_GRID_COLOR:
            data = wxColourData()
            data.SetChooseFull(true)
            dlg = wxColourDialog(self, data)
            if dlg.ShowModal() == wxID_OK:
                data = dlg.GetColourData()
                self.ctrls[CTRL_GRID_COLOR].SetBackgroundColour(data.GetColour())
            dlg.Destroy()


    def on_ok(self,evt):
        try:
            self.size = (int(self.ctrls[CTRL_WIDTH].GetValue()),int(self.ctrls[CTRL_HEIGHT].GetValue()))
        except:
            pass
#            dlg = wxMessageDialog(frame, 'Invalid Size',"Error")
#            dlg.ShowModal()
#            dlg.Destroy()

        if self.ctrls[CTRL_BG_COLOR].GetValue() == true:
            self.bg_layer.set_color(self.ctrls[CTRL_BG_COLOR_VALUE].GetBackgroundColour())
        elif self.ctrls[CTRL_TEXTURE].GetValue() == true:
            self.bg_layer.set_texture(self.ctrls[CTRL_TEXTURE_PATH].GetValue())
        elif self.ctrls[CTRL_IMAGE].GetValue() == true:
            self.size = self.bg_layer.set_image(self.ctrls[CTRL_IMAGE_PATH].GetValue(),self.grid_layer.mapscale)
        else:
            self.bg_layer.clear()

        if self.ctrls[CTRL_GRID_MODE_RECT].GetValue() == true:
            grid_mode = GRID_RECTANGLE
        else:
            grid_mode = GRID_HEXAGON

        if self.ctrls[CTRL_GRID_LINE_NONE].GetValue() == true:
            grid_line = LINE_NONE
        elif self.ctrls[CTRL_GRID_LINE_DOTTED].GetValue() == true:
            grid_line = LINE_DOTTED
        else:
            grid_line = LINE_SOLID

        self.grid_layer.set_grid(int(self.ctrls[CTRL_GRID].GetValue()),
                                 self.ctrls[CTRL_GRID_SNAP].GetValue(),
                                 self.ctrls[CTRL_GRID_COLOR].GetBackgroundColour(),
                                 grid_mode,
                                 grid_line)
        
        self.EndModal(wxID_OK)

