/**
 * @file cvss_priv.h
 * \brief Interface to Common Vulnerability Scoring System Version 2
 * 
 *  See details at http://nvd.nist.gov/cvss.cfm
 *  
 */

/*
 * Copyright 2009 Red Hat Inc., Durham, North Carolina.
 * All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Authors:
 *      Maros Barabas <mbarabas@redhat.com>
 */

#ifndef CVSS_PRIV_H_
#define CVSS_PRIV_H_

#include <libxml/xmlreader.h>
#include <libxml/xmlwriter.h>

#include "../common/list.h"
#include "../common/util.h"
#include "../common/elements.h"

/** 
 * @cond INTERNAL
 */
OSCAP_HIDDEN_START;
 /* @endcond */

/**
 * @struct cvss_entry
 * Struct holding CVSS entry data
 */
struct cvss_entry;

/**
 * @name Parse functions
 * Functions for parsing structures from XML. Return value is new structure filled by content of XML file
 * represented by XML reader or import source structure. Structure needs to be freed by the caller.
 * @{
 * */

/**
 * Parse CVSS entry
 * @param reader XML Text Reader representing XML model
 * @return new parsed CVSS entry
 */
struct cvss_entry * cvss_entry_parse(xmlTextReaderPtr reader);

/**
 * Export CVSS entry
 * @param entry CVSS entry
 * @param writer XML Text Writer representing XML model
 */
void cvss_entry_export(const struct cvss_entry * entry, xmlTextWriterPtr writer);

/**
 */
int cvss_map_av_get(const char * string);
/**
 */
int cvss_map_ac_get(const char * string);
/**
 */
int cvss_map_auth_get(const char * string);
/**
 */
int cvss_map_imp_get(const char * string);

/** 
 * @cond INTERNAL
 */
OSCAP_HIDDEN_END;
 /* @endcond */

#endif
