#include <includes.h>
#include <glib.h>
#include "nessus_plugin.h"

static GHashTable* interned_strings = NULL;

static char *
intern_string(char * s)
{
  char *interned;

  if (!interned_strings)
    {
      interned_strings = g_hash_table_new(g_str_hash, g_str_equal);
    }

  interned = g_hash_table_lookup(interned_strings, s);
  if (interned)
    return interned;

  interned = estrdup(s);

  g_hash_table_insert(interned_strings, interned, interned);
  return interned;
}


struct nessus_plugin * nessus_plugin_new(char * id, char * name, char * category, char * copyright, char * description, char * summary, char * family, char * version, char * cve, char * bid, char * xrefs)
{
 struct nessus_plugin * np = malloc(sizeof(*np));

 if ( np == NULL ) abort();
 bzero(np, sizeof(*np));
 np->id = atoi(id);
 np->asc_id = cache_inc(id);
 np->md5sum = NULL;

 np->name = cache_inc(name); 
 np->category = cache_inc(category);
 np->copyright = cache_inc(copyright);

 np->description = intern_string(description);

 np->summary = intern_string(summary);
 np->family  = cache_inc(family);
 np->version = cache_inc(version);
 np->cve     = cache_inc(cve);
 np->bid     = cache_inc(bid);
 np->xrefs   = cache_inc(xrefs);
 np->next    = NULL;
 return np;
}


/* set the md5 sum of the plugin. This function makes a copy of the
 * md5sum  */
void
nessus_plugin_set_md5sum(struct nessus_plugin * plugin, const char * md5sum)
{
  efree(&plugin->md5sum);
  if (md5sum != NULL)
    plugin->md5sum = estrdup(md5sum);
}



struct nessus_plugin * nessus_plugin_get_by_name(struct nessus_plugin * plugins, char * name)
{
 while ( plugins != NULL )
	{
 	if ( strcmp(plugins->name, name) == 0 ) return plugins;
	plugins = plugins->next;
	}

 return NULL;
}


struct nessus_plugin * nessus_plugin_get_by_id(struct nessus_plugin * plugins, int id )
{
 while ( plugins != NULL )
 	{
	if ( plugins->id == id ) return plugins;
	plugins = plugins->next;
	}

  return NULL;
}

char *
nessus_plugin_get_description(struct nessus_plugin * plugin)
{
  return plugin->description;
}

/* Create a duplicate of the plugin */
struct nessus_plugin*
nessus_plugin_duplicate(struct nessus_plugin *plugin)
{
  struct nessus_plugin * copy = nessus_plugin_new(plugin->asc_id,
      plugin->name, plugin->category, plugin->copyright,
      nessus_plugin_get_description(plugin), plugin->summary, plugin->family,
      plugin->version, plugin->cve, plugin->bid, plugin->xrefs);
  copy->enabled = plugin->enabled;
  nessus_plugin_set_md5sum(copy, plugin->md5sum);
  if (plugin->plugin_prefs != NULL)
  {
    copy->plugin_prefs = emalloc(sizeof(struct arglist));
    arg_dup(copy->plugin_prefs, plugin->plugin_prefs);
  }
  return copy;
}


void nessus_plugin_free(struct nessus_plugin * plugins)
{
 /* TBD */
}
