/* OpenVAS Manager
 * $Id$
 * Description: Manage library: Ranges for Nmap 5.51 top 2000 top 100.
 *
 * Authors:
 * Matthew Mundell <matthew.mundell@greenbone.net>
 *
 * Copyright:
 * Copyright (C) 2009,2010 Greenbone Networks GmbH
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "manage.h"
#include "sql.h"

/**
 * @brief Insert a port range.
 */
#define RANGE(type, start, end)                                      \
  sql ("INSERT INTO port_ranges"                                     \
       " (uuid, port_list, type, start, \"end\", comment, exclude)"  \
       " VALUES"                                                     \
       " (make_uuid (), %llu, %i,"                                   \
       "  '" G_STRINGIFY (start) "',"                                \
       "  '" G_STRINGIFY (end) "',"                                  \
       "  '', 0)",                                                   \
       list,                                                         \
       type)

/**
 * @brief Make port ranges for Nmap top 2000 top 100.
 *
 * Caller must lock the db.
 *
 * @param[in]  list  Port list.
 */
void
make_port_ranges_nmap_5_51_top_2000_top_100 (port_list_t list)
{
  sql_begin_immediate ();

  RANGE (PORT_PROTOCOL_TCP, 1, 1);
  RANGE (PORT_PROTOCOL_TCP, 3, 4);
  RANGE (PORT_PROTOCOL_TCP, 6, 7);
  RANGE (PORT_PROTOCOL_TCP, 9, 9);
  RANGE (PORT_PROTOCOL_TCP, 13, 13);
  RANGE (PORT_PROTOCOL_TCP, 17, 17);
  RANGE (PORT_PROTOCOL_TCP, 19, 27);
  RANGE (PORT_PROTOCOL_TCP, 30, 30);
  RANGE (PORT_PROTOCOL_TCP, 32, 33);
  RANGE (PORT_PROTOCOL_TCP, 37, 37);
  RANGE (PORT_PROTOCOL_TCP, 42, 43);
  RANGE (PORT_PROTOCOL_TCP, 49, 49);
  RANGE (PORT_PROTOCOL_TCP, 53, 53);
  RANGE (PORT_PROTOCOL_TCP, 55, 55);
  RANGE (PORT_PROTOCOL_TCP, 57, 57);
  RANGE (PORT_PROTOCOL_TCP, 59, 59);
  RANGE (PORT_PROTOCOL_TCP, 70, 70);
  RANGE (PORT_PROTOCOL_TCP, 77, 77);
  RANGE (PORT_PROTOCOL_TCP, 79, 90);
  RANGE (PORT_PROTOCOL_TCP, 98, 100);
  RANGE (PORT_PROTOCOL_TCP, 102, 102);
  RANGE (PORT_PROTOCOL_TCP, 106, 106);
  RANGE (PORT_PROTOCOL_TCP, 109, 111);
  RANGE (PORT_PROTOCOL_TCP, 113, 113);
  RANGE (PORT_PROTOCOL_TCP, 119, 119);
  RANGE (PORT_PROTOCOL_TCP, 123, 123);
  RANGE (PORT_PROTOCOL_TCP, 125, 125);
  RANGE (PORT_PROTOCOL_TCP, 127, 127);
  RANGE (PORT_PROTOCOL_TCP, 135, 135);
  RANGE (PORT_PROTOCOL_TCP, 139, 139);
  RANGE (PORT_PROTOCOL_TCP, 143, 144);
  RANGE (PORT_PROTOCOL_TCP, 146, 146);
  RANGE (PORT_PROTOCOL_TCP, 157, 157);
  RANGE (PORT_PROTOCOL_TCP, 161, 161);
  RANGE (PORT_PROTOCOL_TCP, 163, 163);
  RANGE (PORT_PROTOCOL_TCP, 179, 179);
  RANGE (PORT_PROTOCOL_TCP, 199, 199);
  RANGE (PORT_PROTOCOL_TCP, 210, 212);
  RANGE (PORT_PROTOCOL_TCP, 220, 220);
  RANGE (PORT_PROTOCOL_TCP, 222, 223);
  RANGE (PORT_PROTOCOL_TCP, 225, 225);
  RANGE (PORT_PROTOCOL_TCP, 250, 252);
  RANGE (PORT_PROTOCOL_TCP, 254, 257);
  RANGE (PORT_PROTOCOL_TCP, 259, 259);
  RANGE (PORT_PROTOCOL_TCP, 264, 264);
  RANGE (PORT_PROTOCOL_TCP, 280, 280);
  RANGE (PORT_PROTOCOL_TCP, 301, 301);
  RANGE (PORT_PROTOCOL_TCP, 306, 306);
  RANGE (PORT_PROTOCOL_TCP, 311, 311);
  RANGE (PORT_PROTOCOL_TCP, 333, 333);
  RANGE (PORT_PROTOCOL_TCP, 340, 340);
  RANGE (PORT_PROTOCOL_TCP, 366, 366);
  RANGE (PORT_PROTOCOL_TCP, 388, 389);
  RANGE (PORT_PROTOCOL_TCP, 406, 407);
  RANGE (PORT_PROTOCOL_TCP, 411, 411);
  RANGE (PORT_PROTOCOL_TCP, 416, 417);
  RANGE (PORT_PROTOCOL_TCP, 419, 419);
  RANGE (PORT_PROTOCOL_TCP, 425, 425);
  RANGE (PORT_PROTOCOL_TCP, 427, 427);
  RANGE (PORT_PROTOCOL_TCP, 441, 445);
  RANGE (PORT_PROTOCOL_TCP, 447, 447);
  RANGE (PORT_PROTOCOL_TCP, 458, 458);
  RANGE (PORT_PROTOCOL_TCP, 464, 465);
  RANGE (PORT_PROTOCOL_TCP, 475, 475);
  RANGE (PORT_PROTOCOL_TCP, 481, 481);
  RANGE (PORT_PROTOCOL_TCP, 497, 497);
  RANGE (PORT_PROTOCOL_TCP, 500, 500);
  RANGE (PORT_PROTOCOL_TCP, 502, 502);
  RANGE (PORT_PROTOCOL_TCP, 512, 515);
  RANGE (PORT_PROTOCOL_TCP, 523, 524);
  RANGE (PORT_PROTOCOL_TCP, 540, 541);
  RANGE (PORT_PROTOCOL_TCP, 543, 545);
  RANGE (PORT_PROTOCOL_TCP, 548, 548);
  RANGE (PORT_PROTOCOL_TCP, 554, 557);
  RANGE (PORT_PROTOCOL_TCP, 563, 563);
  RANGE (PORT_PROTOCOL_TCP, 587, 587);
  RANGE (PORT_PROTOCOL_TCP, 593, 593);
  RANGE (PORT_PROTOCOL_TCP, 600, 600);
  RANGE (PORT_PROTOCOL_TCP, 602, 602);
  RANGE (PORT_PROTOCOL_TCP, 606, 606);
  RANGE (PORT_PROTOCOL_TCP, 610, 610);
  RANGE (PORT_PROTOCOL_TCP, 616, 617);
  RANGE (PORT_PROTOCOL_TCP, 621, 621);
  RANGE (PORT_PROTOCOL_TCP, 623, 623);
  RANGE (PORT_PROTOCOL_TCP, 625, 625);
  RANGE (PORT_PROTOCOL_TCP, 631, 631);
  RANGE (PORT_PROTOCOL_TCP, 636, 636);
  RANGE (PORT_PROTOCOL_TCP, 639, 639);
  RANGE (PORT_PROTOCOL_TCP, 641, 641);
  RANGE (PORT_PROTOCOL_TCP, 646, 646);
  RANGE (PORT_PROTOCOL_TCP, 648, 648);
  RANGE (PORT_PROTOCOL_TCP, 655, 655);
  RANGE (PORT_PROTOCOL_TCP, 657, 657);
  RANGE (PORT_PROTOCOL_TCP, 659, 660);
  RANGE (PORT_PROTOCOL_TCP, 666, 669);
  RANGE (PORT_PROTOCOL_TCP, 674, 674);
  RANGE (PORT_PROTOCOL_TCP, 683, 684);
  RANGE (PORT_PROTOCOL_TCP, 687, 687);
  RANGE (PORT_PROTOCOL_TCP, 690, 691);
  RANGE (PORT_PROTOCOL_TCP, 700, 701);
  RANGE (PORT_PROTOCOL_TCP, 705, 705);
  RANGE (PORT_PROTOCOL_TCP, 709, 711);
  RANGE (PORT_PROTOCOL_TCP, 713, 715);
  RANGE (PORT_PROTOCOL_TCP, 720, 720);
  RANGE (PORT_PROTOCOL_TCP, 722, 722);
  RANGE (PORT_PROTOCOL_TCP, 725, 726);
  RANGE (PORT_PROTOCOL_TCP, 728, 732);
  RANGE (PORT_PROTOCOL_TCP, 740, 740);
  RANGE (PORT_PROTOCOL_TCP, 748, 749);
  RANGE (PORT_PROTOCOL_TCP, 754, 754);
  RANGE (PORT_PROTOCOL_TCP, 757, 758);
  RANGE (PORT_PROTOCOL_TCP, 765, 765);
  RANGE (PORT_PROTOCOL_TCP, 777, 778);
  RANGE (PORT_PROTOCOL_TCP, 780, 780);
  RANGE (PORT_PROTOCOL_TCP, 782, 783);
  RANGE (PORT_PROTOCOL_TCP, 786, 787);
  RANGE (PORT_PROTOCOL_TCP, 790, 790);
  RANGE (PORT_PROTOCOL_TCP, 792, 792);
  RANGE (PORT_PROTOCOL_TCP, 795, 795);
  RANGE (PORT_PROTOCOL_TCP, 800, 803);
  RANGE (PORT_PROTOCOL_TCP, 805, 806);
  RANGE (PORT_PROTOCOL_TCP, 808, 808);
  RANGE (PORT_PROTOCOL_TCP, 822, 823);
  RANGE (PORT_PROTOCOL_TCP, 825, 825);
  RANGE (PORT_PROTOCOL_TCP, 829, 829);
  RANGE (PORT_PROTOCOL_TCP, 839, 840);
  RANGE (PORT_PROTOCOL_TCP, 843, 843);
  RANGE (PORT_PROTOCOL_TCP, 846, 846);
  RANGE (PORT_PROTOCOL_TCP, 856, 856);
  RANGE (PORT_PROTOCOL_TCP, 859, 859);
  RANGE (PORT_PROTOCOL_TCP, 862, 862);
  RANGE (PORT_PROTOCOL_TCP, 864, 864);
  RANGE (PORT_PROTOCOL_TCP, 873, 874);
  RANGE (PORT_PROTOCOL_TCP, 878, 878);
  RANGE (PORT_PROTOCOL_TCP, 880, 880);
  RANGE (PORT_PROTOCOL_TCP, 888, 888);
  RANGE (PORT_PROTOCOL_TCP, 898, 898);
  RANGE (PORT_PROTOCOL_TCP, 900, 905);
  RANGE (PORT_PROTOCOL_TCP, 911, 913);
  RANGE (PORT_PROTOCOL_TCP, 918, 918);
  RANGE (PORT_PROTOCOL_TCP, 921, 922);
  RANGE (PORT_PROTOCOL_TCP, 924, 924);
  RANGE (PORT_PROTOCOL_TCP, 928, 928);
  RANGE (PORT_PROTOCOL_TCP, 930, 931);
  RANGE (PORT_PROTOCOL_TCP, 943, 943);
  RANGE (PORT_PROTOCOL_TCP, 953, 953);
  RANGE (PORT_PROTOCOL_TCP, 969, 969);
  RANGE (PORT_PROTOCOL_TCP, 971, 971);
  RANGE (PORT_PROTOCOL_TCP, 980, 981);
  RANGE (PORT_PROTOCOL_TCP, 987, 987);
  RANGE (PORT_PROTOCOL_TCP, 990, 990);
  RANGE (PORT_PROTOCOL_TCP, 992, 993);
  RANGE (PORT_PROTOCOL_TCP, 995, 996);
  RANGE (PORT_PROTOCOL_TCP, 998, 1002);
  RANGE (PORT_PROTOCOL_TCP, 1004, 1015);
  RANGE (PORT_PROTOCOL_TCP, 1020, 1114);
  RANGE (PORT_PROTOCOL_TCP, 1116, 1119);
  RANGE (PORT_PROTOCOL_TCP, 1121, 1128);
  RANGE (PORT_PROTOCOL_TCP, 1130, 1132);
  RANGE (PORT_PROTOCOL_TCP, 1134, 1138);
  RANGE (PORT_PROTOCOL_TCP, 1141, 1141);
  RANGE (PORT_PROTOCOL_TCP, 1143, 1145);
  RANGE (PORT_PROTOCOL_TCP, 1147, 1154);
  RANGE (PORT_PROTOCOL_TCP, 1156, 1159);
  RANGE (PORT_PROTOCOL_TCP, 1162, 1169);
  RANGE (PORT_PROTOCOL_TCP, 1173, 1176);
  RANGE (PORT_PROTOCOL_TCP, 1179, 1180);
  RANGE (PORT_PROTOCOL_TCP, 1182, 1188);
  RANGE (PORT_PROTOCOL_TCP, 1190, 1192);
  RANGE (PORT_PROTOCOL_TCP, 1194, 1196);
  RANGE (PORT_PROTOCOL_TCP, 1198, 1201);
  RANGE (PORT_PROTOCOL_TCP, 1204, 1204);
  RANGE (PORT_PROTOCOL_TCP, 1207, 1213);
  RANGE (PORT_PROTOCOL_TCP, 1215, 1218);
  RANGE (PORT_PROTOCOL_TCP, 1220, 1223);
  RANGE (PORT_PROTOCOL_TCP, 1228, 1229);
  RANGE (PORT_PROTOCOL_TCP, 1233, 1234);
  RANGE (PORT_PROTOCOL_TCP, 1236, 1236);
  RANGE (PORT_PROTOCOL_TCP, 1239, 1241);
  RANGE (PORT_PROTOCOL_TCP, 1243, 1244);
  RANGE (PORT_PROTOCOL_TCP, 1247, 1251);
  RANGE (PORT_PROTOCOL_TCP, 1259, 1259);
  RANGE (PORT_PROTOCOL_TCP, 1261, 1262);
  RANGE (PORT_PROTOCOL_TCP, 1264, 1264);
  RANGE (PORT_PROTOCOL_TCP, 1268, 1268);
  RANGE (PORT_PROTOCOL_TCP, 1270, 1272);
  RANGE (PORT_PROTOCOL_TCP, 1276, 1277);
  RANGE (PORT_PROTOCOL_TCP, 1279, 1279);
  RANGE (PORT_PROTOCOL_TCP, 1282, 1282);
  RANGE (PORT_PROTOCOL_TCP, 1287, 1287);
  RANGE (PORT_PROTOCOL_TCP, 1290, 1291);
  RANGE (PORT_PROTOCOL_TCP, 1296, 1297);
  RANGE (PORT_PROTOCOL_TCP, 1299, 1303);
  RANGE (PORT_PROTOCOL_TCP, 1305, 1311);
  RANGE (PORT_PROTOCOL_TCP, 1314, 1319);
  RANGE (PORT_PROTOCOL_TCP, 1321, 1322);
  RANGE (PORT_PROTOCOL_TCP, 1324, 1324);
  RANGE (PORT_PROTOCOL_TCP, 1327, 1328);
  RANGE (PORT_PROTOCOL_TCP, 1330, 1331);
  RANGE (PORT_PROTOCOL_TCP, 1334, 1334);
  RANGE (PORT_PROTOCOL_TCP, 1336, 1337);
  RANGE (PORT_PROTOCOL_TCP, 1339, 1340);
  RANGE (PORT_PROTOCOL_TCP, 1347, 1347);
  RANGE (PORT_PROTOCOL_TCP, 1350, 1353);
  RANGE (PORT_PROTOCOL_TCP, 1357, 1357);
  RANGE (PORT_PROTOCOL_TCP, 1413, 1414);
  RANGE (PORT_PROTOCOL_TCP, 1417, 1417);
  RANGE (PORT_PROTOCOL_TCP, 1433, 1434);
  RANGE (PORT_PROTOCOL_TCP, 1443, 1443);
  RANGE (PORT_PROTOCOL_TCP, 1455, 1455);
  RANGE (PORT_PROTOCOL_TCP, 1461, 1461);
  RANGE (PORT_PROTOCOL_TCP, 1494, 1494);
  RANGE (PORT_PROTOCOL_TCP, 1500, 1501);
  RANGE (PORT_PROTOCOL_TCP, 1503, 1503);
  RANGE (PORT_PROTOCOL_TCP, 1516, 1516);
  RANGE (PORT_PROTOCOL_TCP, 1521, 1522);
  RANGE (PORT_PROTOCOL_TCP, 1524, 1526);
  RANGE (PORT_PROTOCOL_TCP, 1533, 1533);
  RANGE (PORT_PROTOCOL_TCP, 1547, 1547);
  RANGE (PORT_PROTOCOL_TCP, 1550, 1550);
  RANGE (PORT_PROTOCOL_TCP, 1556, 1556);
  RANGE (PORT_PROTOCOL_TCP, 1558, 1560);
  RANGE (PORT_PROTOCOL_TCP, 1565, 1566);
  RANGE (PORT_PROTOCOL_TCP, 1569, 1569);
  RANGE (PORT_PROTOCOL_TCP, 1580, 1580);
  RANGE (PORT_PROTOCOL_TCP, 1583, 1584);
  RANGE (PORT_PROTOCOL_TCP, 1592, 1592);
  RANGE (PORT_PROTOCOL_TCP, 1594, 1594);
  RANGE (PORT_PROTOCOL_TCP, 1598, 1598);
  RANGE (PORT_PROTOCOL_TCP, 1600, 1600);
  RANGE (PORT_PROTOCOL_TCP, 1605, 1605);
  RANGE (PORT_PROTOCOL_TCP, 1607, 1607);
  RANGE (PORT_PROTOCOL_TCP, 1615, 1615);
  RANGE (PORT_PROTOCOL_TCP, 1620, 1620);
  RANGE (PORT_PROTOCOL_TCP, 1622, 1622);
  RANGE (PORT_PROTOCOL_TCP, 1632, 1632);
  RANGE (PORT_PROTOCOL_TCP, 1635, 1635);
  RANGE (PORT_PROTOCOL_TCP, 1638, 1638);
  RANGE (PORT_PROTOCOL_TCP, 1641, 1641);
  RANGE (PORT_PROTOCOL_TCP, 1645, 1645);
  RANGE (PORT_PROTOCOL_TCP, 1658, 1658);
  RANGE (PORT_PROTOCOL_TCP, 1666, 1666);
  RANGE (PORT_PROTOCOL_TCP, 1677, 1677);
  RANGE (PORT_PROTOCOL_TCP, 1683, 1683);
  RANGE (PORT_PROTOCOL_TCP, 1687, 1688);
  RANGE (PORT_PROTOCOL_TCP, 1691, 1691);
  RANGE (PORT_PROTOCOL_TCP, 1694, 1694);
  RANGE (PORT_PROTOCOL_TCP, 1699, 1701);
  RANGE (PORT_PROTOCOL_TCP, 1703, 1703);
  RANGE (PORT_PROTOCOL_TCP, 1707, 1709);
  RANGE (PORT_PROTOCOL_TCP, 1711, 1713);
  RANGE (PORT_PROTOCOL_TCP, 1715, 1715);
  RANGE (PORT_PROTOCOL_TCP, 1717, 1723);
  RANGE (PORT_PROTOCOL_TCP, 1730, 1730);
  RANGE (PORT_PROTOCOL_TCP, 1735, 1736);
  RANGE (PORT_PROTOCOL_TCP, 1745, 1745);
  RANGE (PORT_PROTOCOL_TCP, 1750, 1750);
  RANGE (PORT_PROTOCOL_TCP, 1752, 1753);
  RANGE (PORT_PROTOCOL_TCP, 1755, 1755);
  RANGE (PORT_PROTOCOL_TCP, 1761, 1761);
  RANGE (PORT_PROTOCOL_TCP, 1782, 1783);
  RANGE (PORT_PROTOCOL_TCP, 1791, 1792);
  RANGE (PORT_PROTOCOL_TCP, 1799, 1801);
  RANGE (PORT_PROTOCOL_TCP, 1805, 1808);
  RANGE (PORT_PROTOCOL_TCP, 1811, 1812);
  RANGE (PORT_PROTOCOL_TCP, 1823, 1823);
  RANGE (PORT_PROTOCOL_TCP, 1825, 1825);
  RANGE (PORT_PROTOCOL_TCP, 1835, 1835);
  RANGE (PORT_PROTOCOL_TCP, 1839, 1840);
  RANGE (PORT_PROTOCOL_TCP, 1858, 1858);
  RANGE (PORT_PROTOCOL_TCP, 1861, 1864);
  RANGE (PORT_PROTOCOL_TCP, 1871, 1871);
  RANGE (PORT_PROTOCOL_TCP, 1875, 1875);
  RANGE (PORT_PROTOCOL_TCP, 1900, 1901);
  RANGE (PORT_PROTOCOL_TCP, 1911, 1912);
  RANGE (PORT_PROTOCOL_TCP, 1914, 1914);
  RANGE (PORT_PROTOCOL_TCP, 1918, 1918);
  RANGE (PORT_PROTOCOL_TCP, 1924, 1924);
  RANGE (PORT_PROTOCOL_TCP, 1927, 1927);
  RANGE (PORT_PROTOCOL_TCP, 1935, 1935);
  RANGE (PORT_PROTOCOL_TCP, 1947, 1947);
  RANGE (PORT_PROTOCOL_TCP, 1954, 1954);
  RANGE (PORT_PROTOCOL_TCP, 1958, 1958);
  RANGE (PORT_PROTOCOL_TCP, 1971, 1976);
  RANGE (PORT_PROTOCOL_TCP, 1981, 1981);
  RANGE (PORT_PROTOCOL_TCP, 1984, 1984);
  RANGE (PORT_PROTOCOL_TCP, 1998, 2013);
  RANGE (PORT_PROTOCOL_TCP, 2020, 2022);
  RANGE (PORT_PROTOCOL_TCP, 2025, 2025);
  RANGE (PORT_PROTOCOL_TCP, 2030, 2031);
  RANGE (PORT_PROTOCOL_TCP, 2033, 2035);
  RANGE (PORT_PROTOCOL_TCP, 2038, 2038);
  RANGE (PORT_PROTOCOL_TCP, 2040, 2049);
  RANGE (PORT_PROTOCOL_TCP, 2062, 2062);
  RANGE (PORT_PROTOCOL_TCP, 2065, 2065);
  RANGE (PORT_PROTOCOL_TCP, 2067, 2070);
  RANGE (PORT_PROTOCOL_TCP, 2080, 2083);
  RANGE (PORT_PROTOCOL_TCP, 2086, 2087);
  RANGE (PORT_PROTOCOL_TCP, 2095, 2096);
  RANGE (PORT_PROTOCOL_TCP, 2099, 2101);
  RANGE (PORT_PROTOCOL_TCP, 2103, 2107);
  RANGE (PORT_PROTOCOL_TCP, 2111, 2112);
  RANGE (PORT_PROTOCOL_TCP, 2115, 2115);
  RANGE (PORT_PROTOCOL_TCP, 2119, 2119);
  RANGE (PORT_PROTOCOL_TCP, 2121, 2121);
  RANGE (PORT_PROTOCOL_TCP, 2124, 2124);
  RANGE (PORT_PROTOCOL_TCP, 2126, 2126);
  RANGE (PORT_PROTOCOL_TCP, 2134, 2135);
  RANGE (PORT_PROTOCOL_TCP, 2142, 2142);
  RANGE (PORT_PROTOCOL_TCP, 2144, 2144);
  RANGE (PORT_PROTOCOL_TCP, 2148, 2148);
  RANGE (PORT_PROTOCOL_TCP, 2150, 2150);
  RANGE (PORT_PROTOCOL_TCP, 2160, 2161);
  RANGE (PORT_PROTOCOL_TCP, 2170, 2170);
  RANGE (PORT_PROTOCOL_TCP, 2179, 2179);
  RANGE (PORT_PROTOCOL_TCP, 2187, 2187);
  RANGE (PORT_PROTOCOL_TCP, 2190, 2191);
  RANGE (PORT_PROTOCOL_TCP, 2196, 2197);
  RANGE (PORT_PROTOCOL_TCP, 2200, 2201);
  RANGE (PORT_PROTOCOL_TCP, 2203, 2203);
  RANGE (PORT_PROTOCOL_TCP, 2222, 2222);
  RANGE (PORT_PROTOCOL_TCP, 2224, 2224);
  RANGE (PORT_PROTOCOL_TCP, 2232, 2232);
  RANGE (PORT_PROTOCOL_TCP, 2241, 2241);
  RANGE (PORT_PROTOCOL_TCP, 2250, 2251);
  RANGE (PORT_PROTOCOL_TCP, 2253, 2253);
  RANGE (PORT_PROTOCOL_TCP, 2260, 2262);
  RANGE (PORT_PROTOCOL_TCP, 2265, 2265);
  RANGE (PORT_PROTOCOL_TCP, 2269, 2271);
  RANGE (PORT_PROTOCOL_TCP, 2280, 2280);
  RANGE (PORT_PROTOCOL_TCP, 2288, 2288);
  RANGE (PORT_PROTOCOL_TCP, 2291, 2292);
  RANGE (PORT_PROTOCOL_TCP, 2300, 2302);
  RANGE (PORT_PROTOCOL_TCP, 2304, 2304);
  RANGE (PORT_PROTOCOL_TCP, 2312, 2313);
  RANGE (PORT_PROTOCOL_TCP, 2323, 2323);
  RANGE (PORT_PROTOCOL_TCP, 2325, 2326);
  RANGE (PORT_PROTOCOL_TCP, 2330, 2330);
  RANGE (PORT_PROTOCOL_TCP, 2335, 2335);
  RANGE (PORT_PROTOCOL_TCP, 2340, 2340);
  RANGE (PORT_PROTOCOL_TCP, 2366, 2366);
  RANGE (PORT_PROTOCOL_TCP, 2371, 2372);
  RANGE (PORT_PROTOCOL_TCP, 2381, 2383);
  RANGE (PORT_PROTOCOL_TCP, 2391, 2391);
  RANGE (PORT_PROTOCOL_TCP, 2393, 2394);
  RANGE (PORT_PROTOCOL_TCP, 2399, 2399);
  RANGE (PORT_PROTOCOL_TCP, 2401, 2401);
  RANGE (PORT_PROTOCOL_TCP, 2418, 2418);
  RANGE (PORT_PROTOCOL_TCP, 2425, 2425);
  RANGE (PORT_PROTOCOL_TCP, 2433, 2433);
  RANGE (PORT_PROTOCOL_TCP, 2435, 2436);
  RANGE (PORT_PROTOCOL_TCP, 2438, 2439);
  RANGE (PORT_PROTOCOL_TCP, 2449, 2449);
  RANGE (PORT_PROTOCOL_TCP, 2456, 2456);
  RANGE (PORT_PROTOCOL_TCP, 2463, 2463);
  RANGE (PORT_PROTOCOL_TCP, 2472, 2472);
  RANGE (PORT_PROTOCOL_TCP, 2492, 2492);
  RANGE (PORT_PROTOCOL_TCP, 2500, 2501);
  RANGE (PORT_PROTOCOL_TCP, 2505, 2505);
  RANGE (PORT_PROTOCOL_TCP, 2522, 2522);
  RANGE (PORT_PROTOCOL_TCP, 2525, 2525);
  RANGE (PORT_PROTOCOL_TCP, 2531, 2532);
  RANGE (PORT_PROTOCOL_TCP, 2550, 2551);
  RANGE (PORT_PROTOCOL_TCP, 2557, 2558);
  RANGE (PORT_PROTOCOL_TCP, 2567, 2567);
  RANGE (PORT_PROTOCOL_TCP, 2580, 2580);
  RANGE (PORT_PROTOCOL_TCP, 2583, 2584);
  RANGE (PORT_PROTOCOL_TCP, 2598, 2598);
  RANGE (PORT_PROTOCOL_TCP, 2600, 2602);
  RANGE (PORT_PROTOCOL_TCP, 2604, 2608);
  RANGE (PORT_PROTOCOL_TCP, 2622, 2623);
  RANGE (PORT_PROTOCOL_TCP, 2628, 2628);
  RANGE (PORT_PROTOCOL_TCP, 2631, 2631);
  RANGE (PORT_PROTOCOL_TCP, 2638, 2638);
  RANGE (PORT_PROTOCOL_TCP, 2644, 2644);
  RANGE (PORT_PROTOCOL_TCP, 2691, 2691);
  RANGE (PORT_PROTOCOL_TCP, 2700, 2702);
  RANGE (PORT_PROTOCOL_TCP, 2706, 2706);
  RANGE (PORT_PROTOCOL_TCP, 2710, 2712);
  RANGE (PORT_PROTOCOL_TCP, 2717, 2718);
  RANGE (PORT_PROTOCOL_TCP, 2723, 2723);
  RANGE (PORT_PROTOCOL_TCP, 2725, 2725);
  RANGE (PORT_PROTOCOL_TCP, 2728, 2728);
  RANGE (PORT_PROTOCOL_TCP, 2734, 2734);
  RANGE (PORT_PROTOCOL_TCP, 2800, 2800);
  RANGE (PORT_PROTOCOL_TCP, 2804, 2804);
  RANGE (PORT_PROTOCOL_TCP, 2806, 2806);
  RANGE (PORT_PROTOCOL_TCP, 2809, 2809);
  RANGE (PORT_PROTOCOL_TCP, 2811, 2812);
  RANGE (PORT_PROTOCOL_TCP, 2847, 2847);
  RANGE (PORT_PROTOCOL_TCP, 2850, 2850);
  RANGE (PORT_PROTOCOL_TCP, 2869, 2869);
  RANGE (PORT_PROTOCOL_TCP, 2875, 2875);
  RANGE (PORT_PROTOCOL_TCP, 2882, 2882);
  RANGE (PORT_PROTOCOL_TCP, 2888, 2889);
  RANGE (PORT_PROTOCOL_TCP, 2898, 2898);
  RANGE (PORT_PROTOCOL_TCP, 2901, 2903);
  RANGE (PORT_PROTOCOL_TCP, 2908, 2910);
  RANGE (PORT_PROTOCOL_TCP, 2920, 2920);
  RANGE (PORT_PROTOCOL_TCP, 2930, 2930);
  RANGE (PORT_PROTOCOL_TCP, 2957, 2958);
  RANGE (PORT_PROTOCOL_TCP, 2967, 2968);
  RANGE (PORT_PROTOCOL_TCP, 2973, 2973);
  RANGE (PORT_PROTOCOL_TCP, 2984, 2984);
  RANGE (PORT_PROTOCOL_TCP, 2987, 2988);
  RANGE (PORT_PROTOCOL_TCP, 2991, 2991);
  RANGE (PORT_PROTOCOL_TCP, 2997, 2998);
  RANGE (PORT_PROTOCOL_TCP, 3000, 3003);
  RANGE (PORT_PROTOCOL_TCP, 3005, 3007);
  RANGE (PORT_PROTOCOL_TCP, 3011, 3011);
  RANGE (PORT_PROTOCOL_TCP, 3013, 3014);
  RANGE (PORT_PROTOCOL_TCP, 3017, 3017);
  RANGE (PORT_PROTOCOL_TCP, 3023, 3023);
  RANGE (PORT_PROTOCOL_TCP, 3025, 3025);
  RANGE (PORT_PROTOCOL_TCP, 3030, 3031);
  RANGE (PORT_PROTOCOL_TCP, 3050, 3050);
  RANGE (PORT_PROTOCOL_TCP, 3052, 3052);
  RANGE (PORT_PROTOCOL_TCP, 3057, 3057);
  RANGE (PORT_PROTOCOL_TCP, 3062, 3063);
  RANGE (PORT_PROTOCOL_TCP, 3071, 3071);
  RANGE (PORT_PROTOCOL_TCP, 3077, 3077);
  RANGE (PORT_PROTOCOL_TCP, 3080, 3080);
  RANGE (PORT_PROTOCOL_TCP, 3089, 3089);
  RANGE (PORT_PROTOCOL_TCP, 3102, 3103);
  RANGE (PORT_PROTOCOL_TCP, 3118, 3119);
  RANGE (PORT_PROTOCOL_TCP, 3121, 3121);
  RANGE (PORT_PROTOCOL_TCP, 3128, 3128);
  RANGE (PORT_PROTOCOL_TCP, 3146, 3146);
  RANGE (PORT_PROTOCOL_TCP, 3162, 3162);
  RANGE (PORT_PROTOCOL_TCP, 3167, 3168);
  RANGE (PORT_PROTOCOL_TCP, 3190, 3190);
  RANGE (PORT_PROTOCOL_TCP, 3200, 3200);
  RANGE (PORT_PROTOCOL_TCP, 3210, 3211);
  RANGE (PORT_PROTOCOL_TCP, 3220, 3221);
  RANGE (PORT_PROTOCOL_TCP, 3240, 3240);
  RANGE (PORT_PROTOCOL_TCP, 3260, 3261);
  RANGE (PORT_PROTOCOL_TCP, 3263, 3263);
  RANGE (PORT_PROTOCOL_TCP, 3268, 3269);
  RANGE (PORT_PROTOCOL_TCP, 3280, 3281);
  RANGE (PORT_PROTOCOL_TCP, 3283, 3283);
  RANGE (PORT_PROTOCOL_TCP, 3291, 3291);
  RANGE (PORT_PROTOCOL_TCP, 3299, 3301);
  RANGE (PORT_PROTOCOL_TCP, 3304, 3304);
  RANGE (PORT_PROTOCOL_TCP, 3306, 3307);
  RANGE (PORT_PROTOCOL_TCP, 3310, 3311);
  RANGE (PORT_PROTOCOL_TCP, 3319, 3319);
  RANGE (PORT_PROTOCOL_TCP, 3322, 3325);
  RANGE (PORT_PROTOCOL_TCP, 3333, 3334);
  RANGE (PORT_PROTOCOL_TCP, 3351, 3351);
  RANGE (PORT_PROTOCOL_TCP, 3362, 3363);
  RANGE (PORT_PROTOCOL_TCP, 3365, 3365);
  RANGE (PORT_PROTOCOL_TCP, 3367, 3372);
  RANGE (PORT_PROTOCOL_TCP, 3374, 3374);
  RANGE (PORT_PROTOCOL_TCP, 3376, 3376);
  RANGE (PORT_PROTOCOL_TCP, 3388, 3390);
  RANGE (PORT_PROTOCOL_TCP, 3396, 3396);
  RANGE (PORT_PROTOCOL_TCP, 3399, 3400);
  RANGE (PORT_PROTOCOL_TCP, 3404, 3404);
  RANGE (PORT_PROTOCOL_TCP, 3410, 3410);
  RANGE (PORT_PROTOCOL_TCP, 3414, 3415);
  RANGE (PORT_PROTOCOL_TCP, 3419, 3419);
  RANGE (PORT_PROTOCOL_TCP, 3425, 3425);
  RANGE (PORT_PROTOCOL_TCP, 3430, 3430);
  RANGE (PORT_PROTOCOL_TCP, 3439, 3439);
  RANGE (PORT_PROTOCOL_TCP, 3443, 3443);
  RANGE (PORT_PROTOCOL_TCP, 3456, 3456);
  RANGE (PORT_PROTOCOL_TCP, 3476, 3476);
  RANGE (PORT_PROTOCOL_TCP, 3479, 3479);
  RANGE (PORT_PROTOCOL_TCP, 3483, 3483);
  RANGE (PORT_PROTOCOL_TCP, 3485, 3486);
  RANGE (PORT_PROTOCOL_TCP, 3493, 3493);
  RANGE (PORT_PROTOCOL_TCP, 3497, 3497);
  RANGE (PORT_PROTOCOL_TCP, 3503, 3503);
  RANGE (PORT_PROTOCOL_TCP, 3505, 3506);
  RANGE (PORT_PROTOCOL_TCP, 3511, 3511);
  RANGE (PORT_PROTOCOL_TCP, 3513, 3515);
  RANGE (PORT_PROTOCOL_TCP, 3517, 3517);
  RANGE (PORT_PROTOCOL_TCP, 3519, 3520);
  RANGE (PORT_PROTOCOL_TCP, 3526, 3527);
  RANGE (PORT_PROTOCOL_TCP, 3530, 3530);
  RANGE (PORT_PROTOCOL_TCP, 3532, 3532);
  RANGE (PORT_PROTOCOL_TCP, 3546, 3546);
  RANGE (PORT_PROTOCOL_TCP, 3551, 3551);
  RANGE (PORT_PROTOCOL_TCP, 3577, 3577);
  RANGE (PORT_PROTOCOL_TCP, 3580, 3580);
  RANGE (PORT_PROTOCOL_TCP, 3586, 3586);
  RANGE (PORT_PROTOCOL_TCP, 3599, 3600);
  RANGE (PORT_PROTOCOL_TCP, 3602, 3603);
  RANGE (PORT_PROTOCOL_TCP, 3621, 3622);
  RANGE (PORT_PROTOCOL_TCP, 3632, 3632);
  RANGE (PORT_PROTOCOL_TCP, 3636, 3637);
  RANGE (PORT_PROTOCOL_TCP, 3652, 3653);
  RANGE (PORT_PROTOCOL_TCP, 3656, 3656);
  RANGE (PORT_PROTOCOL_TCP, 3658, 3659);
  RANGE (PORT_PROTOCOL_TCP, 3663, 3663);
  RANGE (PORT_PROTOCOL_TCP, 3669, 3670);
  RANGE (PORT_PROTOCOL_TCP, 3672, 3672);
  RANGE (PORT_PROTOCOL_TCP, 3680, 3681);
  RANGE (PORT_PROTOCOL_TCP, 3683, 3684);
  RANGE (PORT_PROTOCOL_TCP, 3689, 3690);
  RANGE (PORT_PROTOCOL_TCP, 3697, 3697);
  RANGE (PORT_PROTOCOL_TCP, 3700, 3700);
  RANGE (PORT_PROTOCOL_TCP, 3703, 3703);
  RANGE (PORT_PROTOCOL_TCP, 3712, 3712);
  RANGE (PORT_PROTOCOL_TCP, 3728, 3728);
  RANGE (PORT_PROTOCOL_TCP, 3731, 3731);
  RANGE (PORT_PROTOCOL_TCP, 3737, 3737);
  RANGE (PORT_PROTOCOL_TCP, 3742, 3742);
  RANGE (PORT_PROTOCOL_TCP, 3749, 3749);
  RANGE (PORT_PROTOCOL_TCP, 3765, 3766);
  RANGE (PORT_PROTOCOL_TCP, 3784, 3784);
  RANGE (PORT_PROTOCOL_TCP, 3787, 3788);
  RANGE (PORT_PROTOCOL_TCP, 3790, 3790);
  RANGE (PORT_PROTOCOL_TCP, 3792, 3793);
  RANGE (PORT_PROTOCOL_TCP, 3795, 3796);
  RANGE (PORT_PROTOCOL_TCP, 3798, 3801);
  RANGE (PORT_PROTOCOL_TCP, 3803, 3803);
  RANGE (PORT_PROTOCOL_TCP, 3806, 3806);
  RANGE (PORT_PROTOCOL_TCP, 3808, 3814);
  RANGE (PORT_PROTOCOL_TCP, 3817, 3817);
  RANGE (PORT_PROTOCOL_TCP, 3820, 3820);
  RANGE (PORT_PROTOCOL_TCP, 3823, 3828);
  RANGE (PORT_PROTOCOL_TCP, 3830, 3831);
  RANGE (PORT_PROTOCOL_TCP, 3837, 3837);
  RANGE (PORT_PROTOCOL_TCP, 3839, 3839);
  RANGE (PORT_PROTOCOL_TCP, 3842, 3842);
  RANGE (PORT_PROTOCOL_TCP, 3846, 3853);
  RANGE (PORT_PROTOCOL_TCP, 3856, 3856);
  RANGE (PORT_PROTOCOL_TCP, 3859, 3860);
  RANGE (PORT_PROTOCOL_TCP, 3863, 3863);
  RANGE (PORT_PROTOCOL_TCP, 3868, 3872);
  RANGE (PORT_PROTOCOL_TCP, 3876, 3876);
  RANGE (PORT_PROTOCOL_TCP, 3878, 3880);
  RANGE (PORT_PROTOCOL_TCP, 3882, 3882);
  RANGE (PORT_PROTOCOL_TCP, 3888, 3890);
  RANGE (PORT_PROTOCOL_TCP, 3897, 3897);
  RANGE (PORT_PROTOCOL_TCP, 3899, 3899);
  RANGE (PORT_PROTOCOL_TCP, 3901, 3902);
  RANGE (PORT_PROTOCOL_TCP, 3904, 3909);
  RANGE (PORT_PROTOCOL_TCP, 3911, 3911);
  RANGE (PORT_PROTOCOL_TCP, 3913, 3916);
  RANGE (PORT_PROTOCOL_TCP, 3918, 3920);
  RANGE (PORT_PROTOCOL_TCP, 3922, 3923);
  RANGE (PORT_PROTOCOL_TCP, 3928, 3931);
  RANGE (PORT_PROTOCOL_TCP, 3935, 3937);
  RANGE (PORT_PROTOCOL_TCP, 3940, 3941);
  RANGE (PORT_PROTOCOL_TCP, 3943, 3946);
  RANGE (PORT_PROTOCOL_TCP, 3948, 3949);
  RANGE (PORT_PROTOCOL_TCP, 3952, 3952);
  RANGE (PORT_PROTOCOL_TCP, 3956, 3957);
  RANGE (PORT_PROTOCOL_TCP, 3961, 3964);
  RANGE (PORT_PROTOCOL_TCP, 3967, 3969);
  RANGE (PORT_PROTOCOL_TCP, 3971, 3972);
  RANGE (PORT_PROTOCOL_TCP, 3975, 3975);
  RANGE (PORT_PROTOCOL_TCP, 3979, 3983);
  RANGE (PORT_PROTOCOL_TCP, 3986, 3986);
  RANGE (PORT_PROTOCOL_TCP, 3989, 4007);
  RANGE (PORT_PROTOCOL_TCP, 4009, 4010);
  RANGE (PORT_PROTOCOL_TCP, 4016, 4016);
  RANGE (PORT_PROTOCOL_TCP, 4020, 4020);
  RANGE (PORT_PROTOCOL_TCP, 4022, 4022);
  RANGE (PORT_PROTOCOL_TCP, 4024, 4025);
  RANGE (PORT_PROTOCOL_TCP, 4029, 4029);
  RANGE (PORT_PROTOCOL_TCP, 4035, 4036);
  RANGE (PORT_PROTOCOL_TCP, 4039, 4040);
  RANGE (PORT_PROTOCOL_TCP, 4045, 4045);
  RANGE (PORT_PROTOCOL_TCP, 4056, 4056);
  RANGE (PORT_PROTOCOL_TCP, 4058, 4058);
  RANGE (PORT_PROTOCOL_TCP, 4065, 4065);
  RANGE (PORT_PROTOCOL_TCP, 4080, 4080);
  RANGE (PORT_PROTOCOL_TCP, 4087, 4087);
  RANGE (PORT_PROTOCOL_TCP, 4090, 4090);
  RANGE (PORT_PROTOCOL_TCP, 4096, 4096);
  RANGE (PORT_PROTOCOL_TCP, 4100, 4101);
  RANGE (PORT_PROTOCOL_TCP, 4111, 4113);
  RANGE (PORT_PROTOCOL_TCP, 4118, 4121);
  RANGE (PORT_PROTOCOL_TCP, 4125, 4126);
  RANGE (PORT_PROTOCOL_TCP, 4129, 4129);
  RANGE (PORT_PROTOCOL_TCP, 4135, 4135);
  RANGE (PORT_PROTOCOL_TCP, 4141, 4141);
  RANGE (PORT_PROTOCOL_TCP, 4143, 4143);
  RANGE (PORT_PROTOCOL_TCP, 4147, 4147);
  RANGE (PORT_PROTOCOL_TCP, 4158, 4158);
  RANGE (PORT_PROTOCOL_TCP, 4161, 4161);
  RANGE (PORT_PROTOCOL_TCP, 4164, 4164);
  RANGE (PORT_PROTOCOL_TCP, 4174, 4174);
  RANGE (PORT_PROTOCOL_TCP, 4190, 4190);
  RANGE (PORT_PROTOCOL_TCP, 4192, 4192);
  RANGE (PORT_PROTOCOL_TCP, 4200, 4200);
  RANGE (PORT_PROTOCOL_TCP, 4206, 4206);
  RANGE (PORT_PROTOCOL_TCP, 4220, 4220);
  RANGE (PORT_PROTOCOL_TCP, 4224, 4224);
  RANGE (PORT_PROTOCOL_TCP, 4234, 4234);
  RANGE (PORT_PROTOCOL_TCP, 4242, 4242);
  RANGE (PORT_PROTOCOL_TCP, 4252, 4252);
  RANGE (PORT_PROTOCOL_TCP, 4262, 4262);
  RANGE (PORT_PROTOCOL_TCP, 4279, 4279);
  RANGE (PORT_PROTOCOL_TCP, 4294, 4294);
  RANGE (PORT_PROTOCOL_TCP, 4297, 4298);
  RANGE (PORT_PROTOCOL_TCP, 4300, 4300);
  RANGE (PORT_PROTOCOL_TCP, 4302, 4302);
  RANGE (PORT_PROTOCOL_TCP, 4321, 4321);
  RANGE (PORT_PROTOCOL_TCP, 4325, 4325);
  RANGE (PORT_PROTOCOL_TCP, 4328, 4328);
  RANGE (PORT_PROTOCOL_TCP, 4333, 4333);
  RANGE (PORT_PROTOCOL_TCP, 4342, 4343);
  RANGE (PORT_PROTOCOL_TCP, 4355, 4358);
  RANGE (PORT_PROTOCOL_TCP, 4369, 4369);
  RANGE (PORT_PROTOCOL_TCP, 4374, 4376);
  RANGE (PORT_PROTOCOL_TCP, 4384, 4384);
  RANGE (PORT_PROTOCOL_TCP, 4388, 4388);
  RANGE (PORT_PROTOCOL_TCP, 4401, 4401);
  RANGE (PORT_PROTOCOL_TCP, 4407, 4407);
  RANGE (PORT_PROTOCOL_TCP, 4414, 4415);
  RANGE (PORT_PROTOCOL_TCP, 4418, 4418);
  RANGE (PORT_PROTOCOL_TCP, 4430, 4430);
  RANGE (PORT_PROTOCOL_TCP, 4433, 4433);
  RANGE (PORT_PROTOCOL_TCP, 4442, 4447);
  RANGE (PORT_PROTOCOL_TCP, 4449, 4449);
  RANGE (PORT_PROTOCOL_TCP, 4454, 4454);
  RANGE (PORT_PROTOCOL_TCP, 4464, 4464);
  RANGE (PORT_PROTOCOL_TCP, 4471, 4471);
  RANGE (PORT_PROTOCOL_TCP, 4476, 4476);
  RANGE (PORT_PROTOCOL_TCP, 4516, 4517);
  RANGE (PORT_PROTOCOL_TCP, 4530, 4530);
  RANGE (PORT_PROTOCOL_TCP, 4534, 4534);
  RANGE (PORT_PROTOCOL_TCP, 4545, 4545);
  RANGE (PORT_PROTOCOL_TCP, 4550, 4550);
  RANGE (PORT_PROTOCOL_TCP, 4555, 4555);
  RANGE (PORT_PROTOCOL_TCP, 4558, 4559);
  RANGE (PORT_PROTOCOL_TCP, 4567, 4567);
  RANGE (PORT_PROTOCOL_TCP, 4570, 4570);
  RANGE (PORT_PROTOCOL_TCP, 4599, 4602);
  RANGE (PORT_PROTOCOL_TCP, 4606, 4606);
  RANGE (PORT_PROTOCOL_TCP, 4609, 4609);
  RANGE (PORT_PROTOCOL_TCP, 4644, 4644);
  RANGE (PORT_PROTOCOL_TCP, 4649, 4649);
  RANGE (PORT_PROTOCOL_TCP, 4658, 4658);
  RANGE (PORT_PROTOCOL_TCP, 4662, 4662);
  RANGE (PORT_PROTOCOL_TCP, 4665, 4665);
  RANGE (PORT_PROTOCOL_TCP, 4687, 4687);
  RANGE (PORT_PROTOCOL_TCP, 4689, 4689);
  RANGE (PORT_PROTOCOL_TCP, 4700, 4700);
  RANGE (PORT_PROTOCOL_TCP, 4712, 4712);
  RANGE (PORT_PROTOCOL_TCP, 4745, 4745);
  RANGE (PORT_PROTOCOL_TCP, 4760, 4760);
  RANGE (PORT_PROTOCOL_TCP, 4767, 4767);
  RANGE (PORT_PROTOCOL_TCP, 4770, 4771);
  RANGE (PORT_PROTOCOL_TCP, 4778, 4778);
  RANGE (PORT_PROTOCOL_TCP, 4793, 4793);
  RANGE (PORT_PROTOCOL_TCP, 4800, 4800);
  RANGE (PORT_PROTOCOL_TCP, 4819, 4819);
  RANGE (PORT_PROTOCOL_TCP, 4848, 4848);
  RANGE (PORT_PROTOCOL_TCP, 4859, 4860);
  RANGE (PORT_PROTOCOL_TCP, 4875, 4877);
  RANGE (PORT_PROTOCOL_TCP, 4881, 4881);
  RANGE (PORT_PROTOCOL_TCP, 4899, 4900);
  RANGE (PORT_PROTOCOL_TCP, 4903, 4903);
  RANGE (PORT_PROTOCOL_TCP, 4912, 4912);
  RANGE (PORT_PROTOCOL_TCP, 4931, 4931);
  RANGE (PORT_PROTOCOL_TCP, 4949, 4949);
  RANGE (PORT_PROTOCOL_TCP, 4998, 5005);
  RANGE (PORT_PROTOCOL_TCP, 5009, 5017);
  RANGE (PORT_PROTOCOL_TCP, 5020, 5021);
  RANGE (PORT_PROTOCOL_TCP, 5023, 5023);
  RANGE (PORT_PROTOCOL_TCP, 5030, 5030);
  RANGE (PORT_PROTOCOL_TCP, 5033, 5033);
  RANGE (PORT_PROTOCOL_TCP, 5040, 5040);
  RANGE (PORT_PROTOCOL_TCP, 5050, 5055);
  RANGE (PORT_PROTOCOL_TCP, 5060, 5061);
  RANGE (PORT_PROTOCOL_TCP, 5063, 5063);
  RANGE (PORT_PROTOCOL_TCP, 5066, 5066);
  RANGE (PORT_PROTOCOL_TCP, 5070, 5070);
  RANGE (PORT_PROTOCOL_TCP, 5074, 5074);
  RANGE (PORT_PROTOCOL_TCP, 5080, 5081);
  RANGE (PORT_PROTOCOL_TCP, 5087, 5088);
  RANGE (PORT_PROTOCOL_TCP, 5090, 5090);
  RANGE (PORT_PROTOCOL_TCP, 5095, 5096);
  RANGE (PORT_PROTOCOL_TCP, 5098, 5098);
  RANGE (PORT_PROTOCOL_TCP, 5100, 5102);
  RANGE (PORT_PROTOCOL_TCP, 5111, 5111);
  RANGE (PORT_PROTOCOL_TCP, 5114, 5114);
  RANGE (PORT_PROTOCOL_TCP, 5120, 5122);
  RANGE (PORT_PROTOCOL_TCP, 5125, 5125);
  RANGE (PORT_PROTOCOL_TCP, 5133, 5133);
  RANGE (PORT_PROTOCOL_TCP, 5137, 5137);
  RANGE (PORT_PROTOCOL_TCP, 5147, 5147);
  RANGE (PORT_PROTOCOL_TCP, 5151, 5152);
  RANGE (PORT_PROTOCOL_TCP, 5190, 5190);
  RANGE (PORT_PROTOCOL_TCP, 5200, 5202);
  RANGE (PORT_PROTOCOL_TCP, 5212, 5212);
  RANGE (PORT_PROTOCOL_TCP, 5214, 5214);
  RANGE (PORT_PROTOCOL_TCP, 5219, 5219);
  RANGE (PORT_PROTOCOL_TCP, 5221, 5223);
  RANGE (PORT_PROTOCOL_TCP, 5225, 5226);
  RANGE (PORT_PROTOCOL_TCP, 5233, 5235);
  RANGE (PORT_PROTOCOL_TCP, 5242, 5242);
  RANGE (PORT_PROTOCOL_TCP, 5250, 5250);
  RANGE (PORT_PROTOCOL_TCP, 5252, 5252);
  RANGE (PORT_PROTOCOL_TCP, 5259, 5259);
  RANGE (PORT_PROTOCOL_TCP, 5261, 5261);
  RANGE (PORT_PROTOCOL_TCP, 5269, 5269);
  RANGE (PORT_PROTOCOL_TCP, 5279, 5280);
  RANGE (PORT_PROTOCOL_TCP, 5291, 5291);
  RANGE (PORT_PROTOCOL_TCP, 5298, 5298);
  RANGE (PORT_PROTOCOL_TCP, 5339, 5339);
  RANGE (PORT_PROTOCOL_TCP, 5347, 5347);
  RANGE (PORT_PROTOCOL_TCP, 5353, 5353);
  RANGE (PORT_PROTOCOL_TCP, 5357, 5357);
  RANGE (PORT_PROTOCOL_TCP, 5370, 5370);
  RANGE (PORT_PROTOCOL_TCP, 5377, 5377);
  RANGE (PORT_PROTOCOL_TCP, 5405, 5405);
  RANGE (PORT_PROTOCOL_TCP, 5414, 5414);
  RANGE (PORT_PROTOCOL_TCP, 5423, 5423);
  RANGE (PORT_PROTOCOL_TCP, 5431, 5433);
  RANGE (PORT_PROTOCOL_TCP, 5440, 5442);
  RANGE (PORT_PROTOCOL_TCP, 5444, 5444);
  RANGE (PORT_PROTOCOL_TCP, 5457, 5458);
  RANGE (PORT_PROTOCOL_TCP, 5473, 5473);
  RANGE (PORT_PROTOCOL_TCP, 5475, 5475);
  RANGE (PORT_PROTOCOL_TCP, 5500, 5502);
  RANGE (PORT_PROTOCOL_TCP, 5510, 5510);
  RANGE (PORT_PROTOCOL_TCP, 5520, 5520);
  RANGE (PORT_PROTOCOL_TCP, 5544, 5544);
  RANGE (PORT_PROTOCOL_TCP, 5550, 5550);
  RANGE (PORT_PROTOCOL_TCP, 5552, 5555);
  RANGE (PORT_PROTOCOL_TCP, 5557, 5557);
  RANGE (PORT_PROTOCOL_TCP, 5560, 5560);
  RANGE (PORT_PROTOCOL_TCP, 5566, 5566);
  RANGE (PORT_PROTOCOL_TCP, 5631, 5631);
  RANGE (PORT_PROTOCOL_TCP, 5633, 5633);
  RANGE (PORT_PROTOCOL_TCP, 5666, 5666);
  RANGE (PORT_PROTOCOL_TCP, 5678, 5680);
  RANGE (PORT_PROTOCOL_TCP, 5718, 5718);
  RANGE (PORT_PROTOCOL_TCP, 5730, 5730);
  RANGE (PORT_PROTOCOL_TCP, 5800, 5803);
  RANGE (PORT_PROTOCOL_TCP, 5807, 5807);
  RANGE (PORT_PROTOCOL_TCP, 5810, 5812);
  RANGE (PORT_PROTOCOL_TCP, 5815, 5815);
  RANGE (PORT_PROTOCOL_TCP, 5818, 5818);
  RANGE (PORT_PROTOCOL_TCP, 5822, 5823);
  RANGE (PORT_PROTOCOL_TCP, 5825, 5825);
  RANGE (PORT_PROTOCOL_TCP, 5850, 5850);
  RANGE (PORT_PROTOCOL_TCP, 5859, 5859);
  RANGE (PORT_PROTOCOL_TCP, 5862, 5862);
  RANGE (PORT_PROTOCOL_TCP, 5868, 5869);
  RANGE (PORT_PROTOCOL_TCP, 5877, 5877);
  RANGE (PORT_PROTOCOL_TCP, 5899, 5907);
  RANGE (PORT_PROTOCOL_TCP, 5909, 5911);
  RANGE (PORT_PROTOCOL_TCP, 5914, 5915);
  RANGE (PORT_PROTOCOL_TCP, 5918, 5918);
  RANGE (PORT_PROTOCOL_TCP, 5922, 5922);
  RANGE (PORT_PROTOCOL_TCP, 5925, 5925);
  RANGE (PORT_PROTOCOL_TCP, 5938, 5938);
  RANGE (PORT_PROTOCOL_TCP, 5940, 5940);
  RANGE (PORT_PROTOCOL_TCP, 5950, 5950);
  RANGE (PORT_PROTOCOL_TCP, 5952, 5952);
  RANGE (PORT_PROTOCOL_TCP, 5959, 5963);
  RANGE (PORT_PROTOCOL_TCP, 5968, 5968);
  RANGE (PORT_PROTOCOL_TCP, 5981, 5981);
  RANGE (PORT_PROTOCOL_TCP, 5987, 5989);
  RANGE (PORT_PROTOCOL_TCP, 5998, 6009);
  RANGE (PORT_PROTOCOL_TCP, 6017, 6017);
  RANGE (PORT_PROTOCOL_TCP, 6025, 6025);
  RANGE (PORT_PROTOCOL_TCP, 6050, 6051);
  RANGE (PORT_PROTOCOL_TCP, 6059, 6060);
  RANGE (PORT_PROTOCOL_TCP, 6068, 6068);
  RANGE (PORT_PROTOCOL_TCP, 6100, 6101);
  RANGE (PORT_PROTOCOL_TCP, 6103, 6103);
  RANGE (PORT_PROTOCOL_TCP, 6106, 6106);
  RANGE (PORT_PROTOCOL_TCP, 6112, 6112);
  RANGE (PORT_PROTOCOL_TCP, 6123, 6123);
  RANGE (PORT_PROTOCOL_TCP, 6129, 6129);
  RANGE (PORT_PROTOCOL_TCP, 6156, 6156);
  RANGE (PORT_PROTOCOL_TCP, 6203, 6203);
  RANGE (PORT_PROTOCOL_TCP, 6222, 6222);
  RANGE (PORT_PROTOCOL_TCP, 6247, 6247);
  RANGE (PORT_PROTOCOL_TCP, 6346, 6346);
  RANGE (PORT_PROTOCOL_TCP, 6389, 6389);
  RANGE (PORT_PROTOCOL_TCP, 6481, 6481);
  RANGE (PORT_PROTOCOL_TCP, 6500, 6500);
  RANGE (PORT_PROTOCOL_TCP, 6502, 6502);
  RANGE (PORT_PROTOCOL_TCP, 6504, 6504);
  RANGE (PORT_PROTOCOL_TCP, 6510, 6510);
  RANGE (PORT_PROTOCOL_TCP, 6520, 6520);
  RANGE (PORT_PROTOCOL_TCP, 6543, 6543);
  RANGE (PORT_PROTOCOL_TCP, 6547, 6547);
  RANGE (PORT_PROTOCOL_TCP, 6550, 6550);
  RANGE (PORT_PROTOCOL_TCP, 6565, 6567);
  RANGE (PORT_PROTOCOL_TCP, 6580, 6580);
  RANGE (PORT_PROTOCOL_TCP, 6600, 6600);
  RANGE (PORT_PROTOCOL_TCP, 6646, 6646);
  RANGE (PORT_PROTOCOL_TCP, 6662, 6662);
  RANGE (PORT_PROTOCOL_TCP, 6666, 6670);
  RANGE (PORT_PROTOCOL_TCP, 6689, 6689);
  RANGE (PORT_PROTOCOL_TCP, 6692, 6692);
  RANGE (PORT_PROTOCOL_TCP, 6699, 6699);
  RANGE (PORT_PROTOCOL_TCP, 6711, 6711);
  RANGE (PORT_PROTOCOL_TCP, 6732, 6732);
  RANGE (PORT_PROTOCOL_TCP, 6779, 6779);
  RANGE (PORT_PROTOCOL_TCP, 6788, 6789);
  RANGE (PORT_PROTOCOL_TCP, 6792, 6792);
  RANGE (PORT_PROTOCOL_TCP, 6839, 6839);
  RANGE (PORT_PROTOCOL_TCP, 6881, 6881);
  RANGE (PORT_PROTOCOL_TCP, 6896, 6896);
  RANGE (PORT_PROTOCOL_TCP, 6901, 6901);
  RANGE (PORT_PROTOCOL_TCP, 6969, 6969);
  RANGE (PORT_PROTOCOL_TCP, 7000, 7004);
  RANGE (PORT_PROTOCOL_TCP, 7007, 7007);
  RANGE (PORT_PROTOCOL_TCP, 7010, 7010);
  RANGE (PORT_PROTOCOL_TCP, 7019, 7019);
  RANGE (PORT_PROTOCOL_TCP, 7024, 7025);
  RANGE (PORT_PROTOCOL_TCP, 7050, 7051);
  RANGE (PORT_PROTOCOL_TCP, 7070, 7070);
  RANGE (PORT_PROTOCOL_TCP, 7080, 7080);
  RANGE (PORT_PROTOCOL_TCP, 7100, 7100);
  RANGE (PORT_PROTOCOL_TCP, 7103, 7103);
  RANGE (PORT_PROTOCOL_TCP, 7106, 7106);
  RANGE (PORT_PROTOCOL_TCP, 7123, 7123);
  RANGE (PORT_PROTOCOL_TCP, 7200, 7201);
  RANGE (PORT_PROTOCOL_TCP, 7241, 7241);
  RANGE (PORT_PROTOCOL_TCP, 7272, 7272);
  RANGE (PORT_PROTOCOL_TCP, 7278, 7278);
  RANGE (PORT_PROTOCOL_TCP, 7281, 7281);
  RANGE (PORT_PROTOCOL_TCP, 7402, 7402);
  RANGE (PORT_PROTOCOL_TCP, 7435, 7435);
  RANGE (PORT_PROTOCOL_TCP, 7438, 7438);
  RANGE (PORT_PROTOCOL_TCP, 7443, 7443);
  RANGE (PORT_PROTOCOL_TCP, 7496, 7496);
  RANGE (PORT_PROTOCOL_TCP, 7512, 7512);
  RANGE (PORT_PROTOCOL_TCP, 7625, 7625);
  RANGE (PORT_PROTOCOL_TCP, 7627, 7627);
  RANGE (PORT_PROTOCOL_TCP, 7676, 7676);
  RANGE (PORT_PROTOCOL_TCP, 7725, 7725);
  RANGE (PORT_PROTOCOL_TCP, 7741, 7741);
  RANGE (PORT_PROTOCOL_TCP, 7744, 7744);
  RANGE (PORT_PROTOCOL_TCP, 7749, 7749);
  RANGE (PORT_PROTOCOL_TCP, 7770, 7770);
  RANGE (PORT_PROTOCOL_TCP, 7777, 7778);
  RANGE (PORT_PROTOCOL_TCP, 7800, 7800);
  RANGE (PORT_PROTOCOL_TCP, 7878, 7878);
  RANGE (PORT_PROTOCOL_TCP, 7900, 7900);
  RANGE (PORT_PROTOCOL_TCP, 7911, 7911);
  RANGE (PORT_PROTOCOL_TCP, 7913, 7913);
  RANGE (PORT_PROTOCOL_TCP, 7920, 7921);
  RANGE (PORT_PROTOCOL_TCP, 7929, 7929);
  RANGE (PORT_PROTOCOL_TCP, 7937, 7938);
  RANGE (PORT_PROTOCOL_TCP, 7999, 8002);
  RANGE (PORT_PROTOCOL_TCP, 8007, 8011);
  RANGE (PORT_PROTOCOL_TCP, 8015, 8016);
  RANGE (PORT_PROTOCOL_TCP, 8019, 8019);
  RANGE (PORT_PROTOCOL_TCP, 8021, 8022);
  RANGE (PORT_PROTOCOL_TCP, 8031, 8031);
  RANGE (PORT_PROTOCOL_TCP, 8042, 8042);
  RANGE (PORT_PROTOCOL_TCP, 8045, 8045);
  RANGE (PORT_PROTOCOL_TCP, 8050, 8050);
  RANGE (PORT_PROTOCOL_TCP, 8080, 8090);
  RANGE (PORT_PROTOCOL_TCP, 8093, 8093);
  RANGE (PORT_PROTOCOL_TCP, 8095, 8095);
  RANGE (PORT_PROTOCOL_TCP, 8097, 8100);
  RANGE (PORT_PROTOCOL_TCP, 8118, 8118);
  RANGE (PORT_PROTOCOL_TCP, 8180, 8181);
  RANGE (PORT_PROTOCOL_TCP, 8189, 8189);
  RANGE (PORT_PROTOCOL_TCP, 8192, 8194);
  RANGE (PORT_PROTOCOL_TCP, 8200, 8200);
  RANGE (PORT_PROTOCOL_TCP, 8222, 8222);
  RANGE (PORT_PROTOCOL_TCP, 8254, 8254);
  RANGE (PORT_PROTOCOL_TCP, 8290, 8294);
  RANGE (PORT_PROTOCOL_TCP, 8300, 8300);
  RANGE (PORT_PROTOCOL_TCP, 8333, 8333);
  RANGE (PORT_PROTOCOL_TCP, 8383, 8383);
  RANGE (PORT_PROTOCOL_TCP, 8385, 8385);
  RANGE (PORT_PROTOCOL_TCP, 8400, 8400);
  RANGE (PORT_PROTOCOL_TCP, 8402, 8402);
  RANGE (PORT_PROTOCOL_TCP, 8443, 8443);
  RANGE (PORT_PROTOCOL_TCP, 8481, 8481);
  RANGE (PORT_PROTOCOL_TCP, 8500, 8500);
  RANGE (PORT_PROTOCOL_TCP, 8540, 8540);
  RANGE (PORT_PROTOCOL_TCP, 8600, 8600);
  RANGE (PORT_PROTOCOL_TCP, 8648, 8649);
  RANGE (PORT_PROTOCOL_TCP, 8651, 8652);
  RANGE (PORT_PROTOCOL_TCP, 8654, 8654);
  RANGE (PORT_PROTOCOL_TCP, 8675, 8676);
  RANGE (PORT_PROTOCOL_TCP, 8686, 8686);
  RANGE (PORT_PROTOCOL_TCP, 8701, 8701);
  RANGE (PORT_PROTOCOL_TCP, 8765, 8766);
  RANGE (PORT_PROTOCOL_TCP, 8800, 8800);
  RANGE (PORT_PROTOCOL_TCP, 8873, 8873);
  RANGE (PORT_PROTOCOL_TCP, 8877, 8877);
  RANGE (PORT_PROTOCOL_TCP, 8888, 8889);
  RANGE (PORT_PROTOCOL_TCP, 8899, 8899);
  RANGE (PORT_PROTOCOL_TCP, 8987, 8987);
  RANGE (PORT_PROTOCOL_TCP, 8994, 8994);
  RANGE (PORT_PROTOCOL_TCP, 8996, 8996);
  RANGE (PORT_PROTOCOL_TCP, 9000, 9003);
  RANGE (PORT_PROTOCOL_TCP, 9009, 9011);
  RANGE (PORT_PROTOCOL_TCP, 9040, 9040);
  RANGE (PORT_PROTOCOL_TCP, 9050, 9050);
  RANGE (PORT_PROTOCOL_TCP, 9071, 9071);
  RANGE (PORT_PROTOCOL_TCP, 9080, 9081);
  RANGE (PORT_PROTOCOL_TCP, 9090, 9091);
  RANGE (PORT_PROTOCOL_TCP, 9098, 9103);
  RANGE (PORT_PROTOCOL_TCP, 9110, 9111);
  RANGE (PORT_PROTOCOL_TCP, 9152, 9152);
  RANGE (PORT_PROTOCOL_TCP, 9191, 9191);
  RANGE (PORT_PROTOCOL_TCP, 9197, 9198);
  RANGE (PORT_PROTOCOL_TCP, 9200, 9200);
  RANGE (PORT_PROTOCOL_TCP, 9207, 9207);
  RANGE (PORT_PROTOCOL_TCP, 9220, 9220);
  RANGE (PORT_PROTOCOL_TCP, 9290, 9290);
  RANGE (PORT_PROTOCOL_TCP, 9409, 9409);
  RANGE (PORT_PROTOCOL_TCP, 9415, 9415);
  RANGE (PORT_PROTOCOL_TCP, 9418, 9418);
  RANGE (PORT_PROTOCOL_TCP, 9443, 9444);
  RANGE (PORT_PROTOCOL_TCP, 9485, 9485);
  RANGE (PORT_PROTOCOL_TCP, 9500, 9503);
  RANGE (PORT_PROTOCOL_TCP, 9535, 9535);
  RANGE (PORT_PROTOCOL_TCP, 9575, 9575);
  RANGE (PORT_PROTOCOL_TCP, 9593, 9595);
  RANGE (PORT_PROTOCOL_TCP, 9600, 9600);
  RANGE (PORT_PROTOCOL_TCP, 9618, 9618);
  RANGE (PORT_PROTOCOL_TCP, 9621, 9621);
  RANGE (PORT_PROTOCOL_TCP, 9643, 9643);
  RANGE (PORT_PROTOCOL_TCP, 9666, 9666);
  RANGE (PORT_PROTOCOL_TCP, 9673, 9673);
  RANGE (PORT_PROTOCOL_TCP, 9815, 9815);
  RANGE (PORT_PROTOCOL_TCP, 9876, 9878);
  RANGE (PORT_PROTOCOL_TCP, 9898, 9898);
  RANGE (PORT_PROTOCOL_TCP, 9900, 9900);
  RANGE (PORT_PROTOCOL_TCP, 9914, 9914);
  RANGE (PORT_PROTOCOL_TCP, 9917, 9917);
  RANGE (PORT_PROTOCOL_TCP, 9929, 9929);
  RANGE (PORT_PROTOCOL_TCP, 9941, 9941);
  RANGE (PORT_PROTOCOL_TCP, 9943, 9944);
  RANGE (PORT_PROTOCOL_TCP, 9968, 9968);
  RANGE (PORT_PROTOCOL_TCP, 9988, 9988);
  RANGE (PORT_PROTOCOL_TCP, 9992, 9992);
  RANGE (PORT_PROTOCOL_TCP, 9998, 10005);
  RANGE (PORT_PROTOCOL_TCP, 10008, 10012);
  RANGE (PORT_PROTOCOL_TCP, 10022, 10025);
  RANGE (PORT_PROTOCOL_TCP, 10034, 10034);
  RANGE (PORT_PROTOCOL_TCP, 10058, 10058);
  RANGE (PORT_PROTOCOL_TCP, 10082, 10083);
  RANGE (PORT_PROTOCOL_TCP, 10160, 10160);
  RANGE (PORT_PROTOCOL_TCP, 10180, 10180);
  RANGE (PORT_PROTOCOL_TCP, 10215, 10215);
  RANGE (PORT_PROTOCOL_TCP, 10243, 10243);
  RANGE (PORT_PROTOCOL_TCP, 10566, 10566);
  RANGE (PORT_PROTOCOL_TCP, 10616, 10617);
  RANGE (PORT_PROTOCOL_TCP, 10621, 10621);
  RANGE (PORT_PROTOCOL_TCP, 10626, 10626);
  RANGE (PORT_PROTOCOL_TCP, 10628, 10629);
  RANGE (PORT_PROTOCOL_TCP, 10778, 10778);
  RANGE (PORT_PROTOCOL_TCP, 10873, 10873);
  RANGE (PORT_PROTOCOL_TCP, 11110, 11111);
  RANGE (PORT_PROTOCOL_TCP, 11967, 11967);
  RANGE (PORT_PROTOCOL_TCP, 12000, 12000);
  RANGE (PORT_PROTOCOL_TCP, 12006, 12006);
  RANGE (PORT_PROTOCOL_TCP, 12021, 12021);
  RANGE (PORT_PROTOCOL_TCP, 12059, 12059);
  RANGE (PORT_PROTOCOL_TCP, 12174, 12174);
  RANGE (PORT_PROTOCOL_TCP, 12215, 12215);
  RANGE (PORT_PROTOCOL_TCP, 12262, 12262);
  RANGE (PORT_PROTOCOL_TCP, 12265, 12265);
  RANGE (PORT_PROTOCOL_TCP, 12345, 12346);
  RANGE (PORT_PROTOCOL_TCP, 12380, 12380);
  RANGE (PORT_PROTOCOL_TCP, 12452, 12452);
  RANGE (PORT_PROTOCOL_TCP, 13456, 13456);
  RANGE (PORT_PROTOCOL_TCP, 13722, 13722);
  RANGE (PORT_PROTOCOL_TCP, 13724, 13724);
  RANGE (PORT_PROTOCOL_TCP, 13782, 13783);
  RANGE (PORT_PROTOCOL_TCP, 14000, 14000);
  RANGE (PORT_PROTOCOL_TCP, 14238, 14238);
  RANGE (PORT_PROTOCOL_TCP, 14441, 14442);
  RANGE (PORT_PROTOCOL_TCP, 15000, 15004);
  RANGE (PORT_PROTOCOL_TCP, 15402, 15402);
  RANGE (PORT_PROTOCOL_TCP, 15660, 15660);
  RANGE (PORT_PROTOCOL_TCP, 15742, 15742);
  RANGE (PORT_PROTOCOL_TCP, 16000, 16001);
  RANGE (PORT_PROTOCOL_TCP, 16012, 16012);
  RANGE (PORT_PROTOCOL_TCP, 16016, 16016);
  RANGE (PORT_PROTOCOL_TCP, 16018, 16018);
  RANGE (PORT_PROTOCOL_TCP, 16080, 16080);
  RANGE (PORT_PROTOCOL_TCP, 16113, 16113);
  RANGE (PORT_PROTOCOL_TCP, 16705, 16705);
  RANGE (PORT_PROTOCOL_TCP, 16800, 16800);
  RANGE (PORT_PROTOCOL_TCP, 16851, 16851);
  RANGE (PORT_PROTOCOL_TCP, 16992, 16993);
  RANGE (PORT_PROTOCOL_TCP, 17595, 17595);
  RANGE (PORT_PROTOCOL_TCP, 17877, 17877);
  RANGE (PORT_PROTOCOL_TCP, 17988, 17988);
  RANGE (PORT_PROTOCOL_TCP, 18000, 18000);
  RANGE (PORT_PROTOCOL_TCP, 18018, 18018);
  RANGE (PORT_PROTOCOL_TCP, 18040, 18040);
  RANGE (PORT_PROTOCOL_TCP, 18101, 18101);
  RANGE (PORT_PROTOCOL_TCP, 18264, 18264);
  RANGE (PORT_PROTOCOL_TCP, 18988, 18988);
  RANGE (PORT_PROTOCOL_TCP, 19101, 19101);
  RANGE (PORT_PROTOCOL_TCP, 19283, 19283);
  RANGE (PORT_PROTOCOL_TCP, 19315, 19315);
  RANGE (PORT_PROTOCOL_TCP, 19350, 19350);
  RANGE (PORT_PROTOCOL_TCP, 19780, 19780);
  RANGE (PORT_PROTOCOL_TCP, 19801, 19801);
  RANGE (PORT_PROTOCOL_TCP, 19842, 19842);
  RANGE (PORT_PROTOCOL_TCP, 19900, 19900);
  RANGE (PORT_PROTOCOL_TCP, 20000, 20000);
  RANGE (PORT_PROTOCOL_TCP, 20002, 20002);
  RANGE (PORT_PROTOCOL_TCP, 20005, 20005);
  RANGE (PORT_PROTOCOL_TCP, 20031, 20031);
  RANGE (PORT_PROTOCOL_TCP, 20221, 20222);
  RANGE (PORT_PROTOCOL_TCP, 20828, 20828);
  RANGE (PORT_PROTOCOL_TCP, 21571, 21571);
  RANGE (PORT_PROTOCOL_TCP, 21792, 21792);
  RANGE (PORT_PROTOCOL_TCP, 22222, 22222);
  RANGE (PORT_PROTOCOL_TCP, 22939, 22939);
  RANGE (PORT_PROTOCOL_TCP, 23052, 23052);
  RANGE (PORT_PROTOCOL_TCP, 23502, 23502);
  RANGE (PORT_PROTOCOL_TCP, 23796, 23796);
  RANGE (PORT_PROTOCOL_TCP, 24444, 24444);
  RANGE (PORT_PROTOCOL_TCP, 24800, 24800);
  RANGE (PORT_PROTOCOL_TCP, 25734, 25735);
  RANGE (PORT_PROTOCOL_TCP, 26000, 26000);
  RANGE (PORT_PROTOCOL_TCP, 26214, 26214);
  RANGE (PORT_PROTOCOL_TCP, 26470, 26470);
  RANGE (PORT_PROTOCOL_TCP, 27000, 27000);
  RANGE (PORT_PROTOCOL_TCP, 27352, 27353);
  RANGE (PORT_PROTOCOL_TCP, 27355, 27357);
  RANGE (PORT_PROTOCOL_TCP, 27715, 27715);
  RANGE (PORT_PROTOCOL_TCP, 28201, 28201);
  RANGE (PORT_PROTOCOL_TCP, 28211, 28211);
  RANGE (PORT_PROTOCOL_TCP, 29672, 29672);
  RANGE (PORT_PROTOCOL_TCP, 29831, 29831);
  RANGE (PORT_PROTOCOL_TCP, 30000, 30000);
  RANGE (PORT_PROTOCOL_TCP, 30005, 30005);
  RANGE (PORT_PROTOCOL_TCP, 30704, 30704);
  RANGE (PORT_PROTOCOL_TCP, 30718, 30718);
  RANGE (PORT_PROTOCOL_TCP, 30951, 30951);
  RANGE (PORT_PROTOCOL_TCP, 31038, 31038);
  RANGE (PORT_PROTOCOL_TCP, 31337, 31337);
  RANGE (PORT_PROTOCOL_TCP, 31727, 31727);
  RANGE (PORT_PROTOCOL_TCP, 32768, 32785);
  RANGE (PORT_PROTOCOL_TCP, 32791, 32792);
  RANGE (PORT_PROTOCOL_TCP, 32803, 32803);
  RANGE (PORT_PROTOCOL_TCP, 32816, 32816);
  RANGE (PORT_PROTOCOL_TCP, 32822, 32822);
  RANGE (PORT_PROTOCOL_TCP, 32835, 32835);
  RANGE (PORT_PROTOCOL_TCP, 33354, 33354);
  RANGE (PORT_PROTOCOL_TCP, 33453, 33453);
  RANGE (PORT_PROTOCOL_TCP, 33554, 33554);
  RANGE (PORT_PROTOCOL_TCP, 33899, 33899);
  RANGE (PORT_PROTOCOL_TCP, 34571, 34573);
  RANGE (PORT_PROTOCOL_TCP, 35500, 35500);
  RANGE (PORT_PROTOCOL_TCP, 35513, 35513);
  RANGE (PORT_PROTOCOL_TCP, 37839, 37839);
  RANGE (PORT_PROTOCOL_TCP, 38037, 38037);
  RANGE (PORT_PROTOCOL_TCP, 38185, 38185);
  RANGE (PORT_PROTOCOL_TCP, 38188, 38188);
  RANGE (PORT_PROTOCOL_TCP, 38292, 38292);
  RANGE (PORT_PROTOCOL_TCP, 39136, 39136);
  RANGE (PORT_PROTOCOL_TCP, 39376, 39376);
  RANGE (PORT_PROTOCOL_TCP, 39659, 39659);
  RANGE (PORT_PROTOCOL_TCP, 40000, 40000);
  RANGE (PORT_PROTOCOL_TCP, 40193, 40193);
  RANGE (PORT_PROTOCOL_TCP, 40811, 40811);
  RANGE (PORT_PROTOCOL_TCP, 40911, 40911);
  RANGE (PORT_PROTOCOL_TCP, 41064, 41064);
  RANGE (PORT_PROTOCOL_TCP, 41511, 41511);
  RANGE (PORT_PROTOCOL_TCP, 41523, 41523);
  RANGE (PORT_PROTOCOL_TCP, 42510, 42510);
  RANGE (PORT_PROTOCOL_TCP, 44176, 44176);
  RANGE (PORT_PROTOCOL_TCP, 44334, 44334);
  RANGE (PORT_PROTOCOL_TCP, 44442, 44443);
  RANGE (PORT_PROTOCOL_TCP, 44501, 44501);
  RANGE (PORT_PROTOCOL_TCP, 44709, 44709);
  RANGE (PORT_PROTOCOL_TCP, 45100, 45100);
  RANGE (PORT_PROTOCOL_TCP, 46200, 46200);
  RANGE (PORT_PROTOCOL_TCP, 46996, 46996);
  RANGE (PORT_PROTOCOL_TCP, 47544, 47544);
  RANGE (PORT_PROTOCOL_TCP, 48080, 48080);
  RANGE (PORT_PROTOCOL_TCP, 49152, 49161);
  RANGE (PORT_PROTOCOL_TCP, 49163, 49165);
  RANGE (PORT_PROTOCOL_TCP, 49167, 49168);
  RANGE (PORT_PROTOCOL_TCP, 49171, 49171);
  RANGE (PORT_PROTOCOL_TCP, 49175, 49176);
  RANGE (PORT_PROTOCOL_TCP, 49186, 49186);
  RANGE (PORT_PROTOCOL_TCP, 49195, 49195);
  RANGE (PORT_PROTOCOL_TCP, 49236, 49236);
  RANGE (PORT_PROTOCOL_TCP, 49400, 49401);
  RANGE (PORT_PROTOCOL_TCP, 49999, 50003);
  RANGE (PORT_PROTOCOL_TCP, 50006, 50006);
  RANGE (PORT_PROTOCOL_TCP, 50050, 50050);
  RANGE (PORT_PROTOCOL_TCP, 50300, 50300);
  RANGE (PORT_PROTOCOL_TCP, 50389, 50389);
  RANGE (PORT_PROTOCOL_TCP, 50500, 50500);
  RANGE (PORT_PROTOCOL_TCP, 50636, 50636);
  RANGE (PORT_PROTOCOL_TCP, 50800, 50800);
  RANGE (PORT_PROTOCOL_TCP, 51103, 51103);
  RANGE (PORT_PROTOCOL_TCP, 51191, 51191);
  RANGE (PORT_PROTOCOL_TCP, 51413, 51413);
  RANGE (PORT_PROTOCOL_TCP, 51493, 51493);
  RANGE (PORT_PROTOCOL_TCP, 52660, 52660);
  RANGE (PORT_PROTOCOL_TCP, 52673, 52673);
  RANGE (PORT_PROTOCOL_TCP, 52710, 52710);
  RANGE (PORT_PROTOCOL_TCP, 52735, 52735);
  RANGE (PORT_PROTOCOL_TCP, 52822, 52822);
  RANGE (PORT_PROTOCOL_TCP, 52847, 52851);
  RANGE (PORT_PROTOCOL_TCP, 52853, 52853);
  RANGE (PORT_PROTOCOL_TCP, 52869, 52869);
  RANGE (PORT_PROTOCOL_TCP, 53211, 53211);
  RANGE (PORT_PROTOCOL_TCP, 53313, 53314);
  RANGE (PORT_PROTOCOL_TCP, 53535, 53535);
  RANGE (PORT_PROTOCOL_TCP, 54045, 54045);
  RANGE (PORT_PROTOCOL_TCP, 54328, 54328);
  RANGE (PORT_PROTOCOL_TCP, 55020, 55020);
  RANGE (PORT_PROTOCOL_TCP, 55055, 55056);
  RANGE (PORT_PROTOCOL_TCP, 55555, 55555);
  RANGE (PORT_PROTOCOL_TCP, 55576, 55576);
  RANGE (PORT_PROTOCOL_TCP, 55600, 55600);
  RANGE (PORT_PROTOCOL_TCP, 56737, 56738);
  RANGE (PORT_PROTOCOL_TCP, 57294, 57294);
  RANGE (PORT_PROTOCOL_TCP, 57665, 57665);
  RANGE (PORT_PROTOCOL_TCP, 57797, 57797);
  RANGE (PORT_PROTOCOL_TCP, 58001, 58002);
  RANGE (PORT_PROTOCOL_TCP, 58080, 58080);
  RANGE (PORT_PROTOCOL_TCP, 58630, 58630);
  RANGE (PORT_PROTOCOL_TCP, 58632, 58632);
  RANGE (PORT_PROTOCOL_TCP, 58838, 58838);
  RANGE (PORT_PROTOCOL_TCP, 59110, 59110);
  RANGE (PORT_PROTOCOL_TCP, 59200, 59202);
  RANGE (PORT_PROTOCOL_TCP, 60020, 60020);
  RANGE (PORT_PROTOCOL_TCP, 60123, 60123);
  RANGE (PORT_PROTOCOL_TCP, 60146, 60146);
  RANGE (PORT_PROTOCOL_TCP, 60443, 60443);
  RANGE (PORT_PROTOCOL_TCP, 60642, 60642);
  RANGE (PORT_PROTOCOL_TCP, 61532, 61532);
  RANGE (PORT_PROTOCOL_TCP, 61613, 61613);
  RANGE (PORT_PROTOCOL_TCP, 61900, 61900);
  RANGE (PORT_PROTOCOL_TCP, 62078, 62078);
  RANGE (PORT_PROTOCOL_TCP, 63331, 63331);
  RANGE (PORT_PROTOCOL_TCP, 64623, 64623);
  RANGE (PORT_PROTOCOL_TCP, 64680, 64680);
  RANGE (PORT_PROTOCOL_TCP, 65000, 65000);
  RANGE (PORT_PROTOCOL_TCP, 65129, 65129);
  RANGE (PORT_PROTOCOL_TCP, 65310, 65310);

  RANGE (PORT_PROTOCOL_UDP, 7, 7);
  RANGE (PORT_PROTOCOL_UDP, 9, 9);
  RANGE (PORT_PROTOCOL_UDP, 17, 17);
  RANGE (PORT_PROTOCOL_UDP, 19, 19);
  RANGE (PORT_PROTOCOL_UDP, 49, 49);
  RANGE (PORT_PROTOCOL_UDP, 53, 53);
  RANGE (PORT_PROTOCOL_UDP, 67, 69);
  RANGE (PORT_PROTOCOL_UDP, 80, 80);
  RANGE (PORT_PROTOCOL_UDP, 88, 88);
  RANGE (PORT_PROTOCOL_UDP, 111, 111);
  RANGE (PORT_PROTOCOL_UDP, 120, 120);
  RANGE (PORT_PROTOCOL_UDP, 123, 123);
  RANGE (PORT_PROTOCOL_UDP, 135, 139);
  RANGE (PORT_PROTOCOL_UDP, 158, 158);
  RANGE (PORT_PROTOCOL_UDP, 161, 162);
  RANGE (PORT_PROTOCOL_UDP, 177, 177);
  RANGE (PORT_PROTOCOL_UDP, 427, 427);
  RANGE (PORT_PROTOCOL_UDP, 443, 443);
  RANGE (PORT_PROTOCOL_UDP, 445, 445);
  RANGE (PORT_PROTOCOL_UDP, 497, 497);
  RANGE (PORT_PROTOCOL_UDP, 500, 500);
  RANGE (PORT_PROTOCOL_UDP, 514, 515);
  RANGE (PORT_PROTOCOL_UDP, 518, 518);
  RANGE (PORT_PROTOCOL_UDP, 520, 520);
  RANGE (PORT_PROTOCOL_UDP, 593, 593);
  RANGE (PORT_PROTOCOL_UDP, 623, 623);
  RANGE (PORT_PROTOCOL_UDP, 626, 626);
  RANGE (PORT_PROTOCOL_UDP, 631, 631);
  RANGE (PORT_PROTOCOL_UDP, 996, 999);
  RANGE (PORT_PROTOCOL_UDP, 1022, 1023);
  RANGE (PORT_PROTOCOL_UDP, 1025, 1030);
  RANGE (PORT_PROTOCOL_UDP, 1433, 1434);
  RANGE (PORT_PROTOCOL_UDP, 1645, 1646);
  RANGE (PORT_PROTOCOL_UDP, 1701, 1701);
  RANGE (PORT_PROTOCOL_UDP, 1718, 1719);
  RANGE (PORT_PROTOCOL_UDP, 1812, 1813);
  RANGE (PORT_PROTOCOL_UDP, 1900, 1900);
  RANGE (PORT_PROTOCOL_UDP, 2000, 2000);
  RANGE (PORT_PROTOCOL_UDP, 2048, 2049);
  RANGE (PORT_PROTOCOL_UDP, 2222, 2223);
  RANGE (PORT_PROTOCOL_UDP, 3283, 3283);
  RANGE (PORT_PROTOCOL_UDP, 3456, 3456);
  RANGE (PORT_PROTOCOL_UDP, 3703, 3703);
  RANGE (PORT_PROTOCOL_UDP, 4444, 4444);
  RANGE (PORT_PROTOCOL_UDP, 4500, 4500);
  RANGE (PORT_PROTOCOL_UDP, 5000, 5000);
  RANGE (PORT_PROTOCOL_UDP, 5060, 5060);
  RANGE (PORT_PROTOCOL_UDP, 5353, 5353);
  RANGE (PORT_PROTOCOL_UDP, 5632, 5632);
  RANGE (PORT_PROTOCOL_UDP, 9200, 9200);
  RANGE (PORT_PROTOCOL_UDP, 10000, 10000);
  RANGE (PORT_PROTOCOL_UDP, 17185, 17185);
  RANGE (PORT_PROTOCOL_UDP, 20031, 20031);
  RANGE (PORT_PROTOCOL_UDP, 30718, 30718);
  RANGE (PORT_PROTOCOL_UDP, 31337, 31337);
  RANGE (PORT_PROTOCOL_UDP, 32768, 32769);
  RANGE (PORT_PROTOCOL_UDP, 32771, 32771);
  RANGE (PORT_PROTOCOL_UDP, 32815, 32815);
  RANGE (PORT_PROTOCOL_UDP, 33281, 33281);
  RANGE (PORT_PROTOCOL_UDP, 49152, 49154);
  RANGE (PORT_PROTOCOL_UDP, 49156, 49156);
  RANGE (PORT_PROTOCOL_UDP, 49181, 49182);
  RANGE (PORT_PROTOCOL_UDP, 49185, 49186);
  RANGE (PORT_PROTOCOL_UDP, 49188, 49188);
  RANGE (PORT_PROTOCOL_UDP, 49190, 49194);
  RANGE (PORT_PROTOCOL_UDP, 49200, 49201);

  sql ("END TRANSACTION");
}
