# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 310-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53600);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 310-1 (xaos)";
 script_name(name);

 desc = "The remote host is missing an update to xaos
announced via advisory DSA 310-1.

XaoS, a program for displaying fractal images, is installed setuid
root on certain architectures in order to use svgalib, which requires
access to the video hardware.  However, it is not designed for secure
setuid execution, and can be exploited to gain root privileges.

In these updated packages, the setuid bit has been removed from the
xaos binary.  Users who require the svgalib functionality should grant
these privileges only to a trusted group.

This vulnerability is exploitable in version 3.0-18 (potato) on i386
and alpha architectures, and in version 3.0-23 (woody) on the i386
architecture only.

For the stable distribution (woody) this problem has been fixed in
version 3.0-23woody1.

For the old stable distribution (potato) this problem has been fixed
in version 3.0-18potato1.

For the unstable distribution (sid) this problem has been fixed in
version 3.1r-4.

We recommend that you update your xaos package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20310-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 310-1 (xaos)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"xaos", ver:"3.0-18potato1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"xaos", ver:"3.0-23woody1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
