###############################################################################
# OpenVAS Vulnerability Test
# $Id: phpMyFAQ_37020.nasl 7518 2010-05-04 08:39:45Z chandra $
#
# phpMyFAQ Search Page Cross Site Scripting Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100348);
 script_bugtraq_id(37020);
 script_version ("1.0-$Revision: 7518 $");
 script_tag(name:"risk_factor", value:"Low");

 script_name("phpMyFAQ Search Page Cross Site Scripting Vulnerability");

desc = "Overview:
phpMyFAQ is prone to a cross-site scripting vulnerability because the
application fails to properly sanitize user-supplied input.

An attacker may leverage this issue to execute arbitrary script code
in the browser of an unsuspecting user in the context of the affected
site. This may allow the attacker to steal cookie-based authentication
credentials and to launch other attacks.

Versions prior to phpMyFAQ 2.5.2 and 2.0.17 are vulnerable.

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/37020
http://www.phpmyfaq.de/
http://www.phpmyfaq.de/advisory_2009-09-01.php

Risk factor : Low";

 script_description(desc);
 script_summary("Determine if phpMyFAQ version is < 2.5.2 or < 2.0.17");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("phpmyfaq_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/phpmyfaq")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_in_range(version: vers, test_version: "2.5", test_version2: "2.5.1") || 
     version_in_range(version: vers, test_version: "2.0", test_version2: "2.0.16")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
