###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_cowon_jetaudio_detect.nasl 5794 2009-11-18 10:19:08Z nov $
#
# COWON Media Center JetAudio Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900976);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("COWON Media Center JetAudio Version Detection");
  desc = "
  Overview: This script detects the installed version of COWON Media
  Center JetAudio and sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of COWON Media Center JetAudio");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\COWON\Jet-Audio")){
  exit(0);
}

jaPath = registry_get_sz(key:"SOFTWARE\COWON\Jet-Audio",
                         item:"InstallPath_Main");
if(jaPath == NULL)
{
  jaPath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion"+
                                   "\App Paths\JetAudio.exe", item:"Path");
  if(jaPath == NULL){
    exit(0);
  }
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:jaPath);
file = ereg_replace(pattern:"[A-Z]:(.*)",  replace:"\1",  string:jaPath +
                                                        "\JetAudio.exe");

jaVer = GetVer(file:file, share:share);
if(jaVer != NULL){
  set_kb_item(name:"JetAudio/Ver", value:jaVer);
  security_note(data:"COWON Media Center JetAudio version " + jaVer +
             " running at location " + jaPath + " was detected on the host");
}
