/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Properties;
import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.blocks.MethodCall;
import org.javagroups.log.Trace;
import org.javagroups.stack.RpcProtocol;
import org.javagroups.util.TimeScheduler;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class STABLE
extends RpcProtocol {
    private static final String PROT_NAME = "STABLE";
    private static final double SUBSET_SIZE = 0.1;
    private static final int GOSSIP_MSG_INTERVAL = 100;
    private static final int GOSSIP_INTERVAL = 10000;
    private Address local_addr;
    private ViewId vid;
    private Vector mbrs;
    private long round;
    private long[] seqnos;
    private boolean[] heard_from;
    private double subset;
    private TimeScheduler sched;
    private Task gossip_task;
    private int max_msgs;
    private long max_wait_time;
    private long num_msgs;
    private Object highest_seqnos_mutex;
    private long highest_seqnos_timeout;

    public String getName() {
        return PROT_NAME;
    }

    public Vector requiredUpServices() {
        Vector<Integer> retval = new Vector<Integer>();
        retval.addElement(new Integer(35));
        return retval;
    }

    public boolean setProperties(Properties props) {
        String str = props.getProperty("subset");
        if (str != null) {
            this.subset = new Float(str).floatValue();
            props.remove("subset");
        }
        if ((str = props.getProperty("max_msgs")) != null) {
            this.max_msgs = new Integer(str);
            this.num_msgs = this.max_msgs;
            if (this.max_msgs <= 1) {
                Trace.fatal("STABLE.setProperties()", "value for 'max_msgs' must be greater than 1 !");
                return false;
            }
            props.remove("max_msgs");
        }
        if ((str = props.getProperty("max_wait_time")) != null) {
            this.max_wait_time = new Long(str);
            props.remove("max_wait_time");
        }
        if ((str = props.getProperty("highest_seqnos_timeout")) != null) {
            this.highest_seqnos_timeout = new Long(str);
            props.remove("highest_seqnos_timeout");
        }
        if (props.size() > 0) {
            System.err.println("STABLE.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    public void start() throws Exception {
        TimeScheduler timer;
        super.start();
        TimeScheduler timeScheduler = timer = this.stack != null ? this.stack.timer : null;
        if (timer == null) {
            throw new Exception("STABLE.start(): timer is null");
        }
        this.sched = timer;
        if (this._corr != null) {
            this._corr.setDeadlockDetection(false);
        }
        this.initialize();
        this.startGossip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        super.stop();
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            if (this.gossip_task != null) {
                this.gossip_task.cancel();
            }
            this.gossip_task = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void gossip(ViewId view_id, long gossip_round, long[] gossip_seqnos, boolean[] heard, Object sender) {
        Object[] params;
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            if (Trace.trace) {
                Trace.info("STABLE.gossip()", "sender=" + sender + ", round=" + gossip_round + ", seqnos=" + Util.array2String(gossip_seqnos) + ", heard=" + Util.array2String(heard));
            }
            if (this.vid == null || view_id == null || !this.vid.equals(view_id)) {
                if (Trace.trace) {
                    Trace.info("STABLE.gossip()", "view ID s are different (" + this.vid + " != " + view_id + "). Discarding gossip received");
                }
                return;
            }
            if (gossip_round < this.round) {
                if (Trace.trace) {
                    Trace.info("STABLE.gossip()", "received a gossip from a previous round (" + gossip_round + "); my round is " + this.round + ". Discarding gossip");
                }
                return;
            }
            if (gossip_seqnos == null || this.seqnos == null || this.seqnos.length != gossip_seqnos.length) {
                if (Trace.trace) {
                    Trace.warn("STABLE.gossip()", "size of seqnos and gossip_seqnos are not equal ! Discarding gossip");
                }
                return;
            }
            if (this.round == gossip_round) {
                this.update(sender, gossip_seqnos, heard);
            } else if (this.round < gossip_round) {
                if (Trace.trace) {
                    Trace.info("STABLE.gossip()", "received a gossip from a higher round (" + gossip_round + "); adopting my round (" + this.round + ") to " + gossip_round);
                }
                this.round = gossip_round;
                this.set(sender, gossip_seqnos, this.heard_from);
            }
            if (Trace.trace) {
                Trace.info("STABLE.gossip()", "heard_from=" + Util.array2String(this.heard_from));
            }
            if (!this.heardFromAll()) {
                return;
            }
            params = new Object[]{this.vid.clone(), new Long(gossip_round), this.seqnos.clone(), this.local_addr};
        }
        MethodCall call = new MethodCall("stability", params);
        this.callRemoteMethods(null, call, 6, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stability(ViewId view_id, long gossip_round, long[] stability_vector, Object sender) {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            if (Trace.trace) {
                Trace.info("STABLE.stability()", "sender=" + sender + ", round=" + gossip_round + ", vector=" + Util.array2String(stability_vector) + ')');
            }
            if (this.vid == null || view_id == null || !this.vid.equals(view_id)) {
                if (Trace.trace) {
                    Trace.info("STABLE.stability()", "view ID s are different (" + this.vid + " != " + view_id + "). Discarding gossip received");
                }
                return;
            }
            if (this.round > gossip_round) {
                return;
            }
            this.round = gossip_round + 1L;
            int i = 0;
            while (i < this.heard_from.length) {
                this.heard_from[i] = false;
                ++i;
            }
        }
        this.heard_from[this.mbrs.indexOf((Object)this.local_addr)] = true;
        this.passUp(new Event(30, stability_vector));
        this.getHighestSeqnos();
    }

    public boolean handleUpEvent(Event evt) {
        switch (evt.getType()) {
            case 1: {
                if (this.upMsg(evt)) break;
                return false;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
        }
        return true;
    }

    public boolean handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: {
                if (this.downViewChange(evt)) break;
                return false;
            }
            case 36: {
                if (this.downGetMsgsReceived(evt)) break;
                return false;
            }
        }
        return true;
    }

    private final void gossipRun() {
        this.num_msgs = this.max_msgs;
        this.sendGossip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void initialize() {
        var1_1 = this;
        synchronized (var1_1) {
            this.seqnos = new long[this.mbrs.size()];
            i = 0;
            while (true) {
                block5: {
                    if (i < this.seqnos.length) break block5;
                    this.heard_from = new boolean[this.mbrs.size()];
                    i = 0;
                    if (true) ** GOTO lbl21
                }
                this.seqnos[i] = -1;
                ++i;
            }
            do {
                this.heard_from[i] = false;
                ++i;
lbl21:
                // 2 sources

            } while (i < this.heard_from.length);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void update(Object sender, long[] gossip_seqnos, boolean[] gossip_heard_from) {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            int index = this.mbrs.indexOf(sender);
            if (index < 0) {
                if (Trace.trace) {
                    Trace.warn("STABLE.update()", "sender " + sender + " not found in mbrs !");
                }
                return;
            }
            int i = 0;
            while (i < gossip_seqnos.length) {
                this.seqnos[i] = Math.min(this.seqnos[i], gossip_seqnos[i]);
                ++i;
            }
            this.heard_from[index] = true;
            i = 0;
            while (i < this.heard_from.length) {
                this.heard_from[i] = this.heard_from[i] | gossip_heard_from[i];
                ++i;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void set(Object sender, long[] gossip_seqnos, boolean[] gossip_heard_from) {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            int index = this.mbrs.indexOf(sender);
            if (index >= 0) {
                this.seqnos = gossip_seqnos;
                this.heard_from = gossip_heard_from;
                return;
            }
            if (Trace.trace) {
                Trace.warn("STABLE.set()", "sender " + sender + " not found in mbrs !");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean heardFromAll() {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            if (this.heard_from == null) {
                return false;
            }
            int i = 0;
            while (i < this.heard_from.length) {
                if (!this.heard_from[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void sendGossip() {
        Object[] params;
        Vector gossip_subset;
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            gossip_subset = Util.pickSubset(this.mbrs, this.subset);
            if (gossip_subset == null || gossip_subset.size() < 1) {
                if (Trace.trace) {
                    Trace.warn("STABLE.sendGossip()", "picked empty subset !");
                }
                return;
            }
            if (Trace.trace) {
                Trace.info("STABLE.sendGossip()", "subset=" + gossip_subset + ", round=" + this.round + ", seqnos=" + Util.array2String(this.seqnos));
            }
            params = new Object[]{this.vid.clone(), new Long(this.round), this.seqnos.clone(), this.heard_from.clone(), this.local_addr};
        }
        MethodCall call = new MethodCall("gossip", params);
        int i = 0;
        while (i < gossip_subset.size()) {
            block9: {
                try {
                    this.callRemoteMethod((Address)gossip_subset.get(i), call, 6, 0L);
                }
                catch (Exception e) {
                    if (!Trace.trace) break block9;
                    Trace.debug("STABLE.sendGossip()", "exception=" + e);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void getHighestSeqnos() {
        Object object = this.highest_seqnos_mutex;
        synchronized (object) {
            this.passUp(new Event(35));
            try {
                this.highest_seqnos_mutex.wait(this.highest_seqnos_timeout);
            }
            catch (InterruptedException e) {
                if (Trace.trace) {
                    Trace.error("STABLE.getHighestSeqnos()", "Interrupted while waiting for highest seqnos from NAKACK");
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void startGossip() {
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            if (this.gossip_task != null) {
                this.gossip_task.cancel();
            }
            this.gossip_task = new Task(new Times(new long[]{10000L}));
            this.sched.add(this.gossip_task);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean upMsg(Event e) {
        Message msg = (Message)e.getArg();
        if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) {
            return true;
        }
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            --this.num_msgs;
            if (this.num_msgs > 0L) {
                return true;
            }
            this.num_msgs = this.max_msgs;
            this.gossip_task.cancel();
            long[] lArray = new long[2];
            lArray[1] = 10000L;
            this.gossip_task = new Task(new Times(lArray));
            this.sched.add(this.gossip_task);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean downViewChange(Event e) {
        View v = (View)e.getArg();
        Vector new_mbrs = v.getMembers();
        STABLE sTABLE = this;
        synchronized (sTABLE) {
            this.vid = v.getVid();
            this.mbrs.clear();
            this.mbrs.addAll(new_mbrs);
            this.initialize();
            return true;
        }
    }

    /*
     * Exception decompiling
     */
    private final boolean downGetMsgsReceived(Event e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [3 : 20->30)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final /* synthetic */ void this() {
        this.local_addr = null;
        this.vid = null;
        this.mbrs = new Vector();
        this.round = 1L;
        this.seqnos = new long[0];
        this.heard_from = new boolean[0];
        this.subset = 0.1;
        this.sched = null;
        this.max_msgs = 100;
        this.max_wait_time = 10000L;
        this.num_msgs = this.max_msgs;
        this.highest_seqnos_mutex = new Object();
        this.highest_seqnos_timeout = 4000L;
    }

    public STABLE() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class Times {
        private int next;
        private long[] times;

        public synchronized long next() {
            if (this.next >= this.times.length) {
                return this.times[this.times.length - 1];
            }
            return this.times[this.next++];
        }

        public long[] times() {
            return this.times;
        }

        public synchronized void reset() {
            this.next = 0;
        }

        private final /* synthetic */ void this() {
            this.next = 0;
        }

        public Times(long[] times) {
            this.this();
            if (times.length == 0) {
                throw new IllegalArgumentException("times");
            }
            this.times = times;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Task
    implements TimeScheduler.Task {
        private Times intervals;
        private boolean cancelled;

        public long nextInterval() {
            return this.intervals.next();
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }

        public void run() {
            STABLE.this.gossipRun();
        }

        private final /* synthetic */ void this() {
            this.cancelled = false;
        }

        public Task(Times intervals) {
            this.this();
            this.intervals = intervals;
        }
    }
}

