
/******************************************************************************
**
**  Copyright (C) 2001  - the shmoo group -
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/******************************************************************************
**
**    The Shmoo Group (TSG)
**
**    File:      filter_tar.c
**    Author:    Brian Wotring
**
**    Date:      March 14, 2002.
**    Project:   osiris
**
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include <sys/stat.h>

#include "utilities.h"
#include "scan_record.h"
#include "filter.h"

osi_bool filter_tar( const char *file_path, FILTER_CONTEXT *context )
{
    char number[5] = "\0";
    int length = 0;

    if( ( file_path != NULL ) && ( context != NULL ) )
    {
	    if( context->file_stats->st_size >= 263 )
        {
            if( context->file_handle == NULL )
            {
                context->file_handle = osi_fopen( file_path, "r", 0 );
            }

            else
            {
                fseek( context->file_handle, 0, SEEK_SET );
            }

            if( context->file_handle != NULL )
            {
                if( fseek( context->file_handle, 257, SEEK_SET ) == 0 )
                {    
                    length = fread( number, 1, 5, context->file_handle );
        
                    if( length == 5 )
                    {
                        if( memcmp( number, "ustar", 5 ) == 0 )
                        {
                            return TRUE;
                        }
                    }
                }
            }
        }
    }

    return FALSE;
}
