
/*****************************************************************************
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
*****************************************************************************/

/*****************************************************************************
**
**  File:    host_brief.c
**  Date:    August 18, 2002
**
**  Author:  Brian Wotring
**
**  Purpose: structure representing a host that can be transported in a message.
**
******************************************************************************/

#include "libosirism.h"
#include "string.h"

void wrap_host_brief( OSI_HOST_BRIEF *host )
{
    if( host != NULL )
    {
        host->enabled          = OSI_HTONLL( host->enabled );
        host->type	           = OSI_HTONLL( host->type );

        host->file_log_enabled  = OSI_HTONLL( host->file_log_enabled );
        host->db_flags 			= OSI_HTONLL( host->db_flags );

        host->notify_enabled   = OSI_HTONLL( host->notify_enabled );
        host->notify_flags     = OSI_HTONLL( host->notify_flags );

        host->schedule_start   = OSI_HTONLL( host->schedule_start );
        host->schedule_period  = OSI_HTONLL( host->schedule_period );
        
        host->config_count   = OSI_HTONLL( host->config_count );
        host->database_count = OSI_HTONLL( host->database_count );

        host->port = OSI_HTONLL( host->port );
    }
}

void unwrap_host_brief( OSI_HOST_BRIEF *host )
{
    if( host != NULL )
    {
        host->enabled          = OSI_NTOHLL( host->enabled );
        host->type  	       = OSI_NTOHLL( host->type );

        host->file_log_enabled  = OSI_NTOHLL( host->file_log_enabled );
        host->db_flags = OSI_NTOHLL( host->db_flags );

        host->notify_enabled   = OSI_NTOHLL( host->notify_enabled );
        host->notify_flags     = OSI_NTOHLL( host->notify_flags );

        host->schedule_start   = OSI_NTOHLL( host->schedule_start );
        host->schedule_period  = OSI_NTOHLL( host->schedule_period );
        
        host->config_count   = OSI_NTOHLL( host->config_count );
        host->database_count = OSI_NTOHLL( host->database_count );    

        host->port = OSI_NTOHLL( host->port );
    }
}

void osi_set_host_brief_defaults( OSI_HOST_BRIEF *host_brief )
{
    if( host_brief != NULL )
    {
        memset( host_brief, 0, sizeof( OSI_HOST_BRIEF ) );
        
        host_brief->enabled = 1;
        host_brief->type = OSI_HOST_TYPE_GENERIC;

        host_brief->file_log_enabled  = 0;
        host_brief->db_flags = (OSI_DB_PURGE | OSI_DB_AUTOACCEPT);

        host_brief->notify_enabled   = 0;
        host_brief->notify_flags     = 0;

        host_brief->schedule_start = 0;
        host_brief->schedule_period = 1440;   /* 24 hours. */

        host_brief->port = DEFAULT_SCAN_AGENT_PORT;
        memset( host_brief->session_key, 0, sizeof( host_brief->session_key ) );
    }
}
